/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.ClassBackUp;
import de.chaoswg.ClassCallback;
import de.chaoswg.ClassPlaceMyWorld3DModelConfig;
import de.chaoswg.ClassPlayerDaten;
import de.chaoswg.ClassPluginConfig;
import de.chaoswg.ClassPluginOBJ;
import de.chaoswg.ToolsAPI;
import de.chaoswg.ToolsGUI;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.CollisionType;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.KeyInput;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class Tools3D {
    private static final String KEY_ATTRIBUTE_STRENGTH = "de.chaoswg.Tools3D.createNewWorld3DModel.strength";
    private static int DEFAULT_ITEM_STRENGTH = 500;
    private static final String PLAYER_ATTRIBUTE_POSSCALE = "de.chaoswg.Tools3D.createNewWorld3DModel.posScale";
    private static final String PLAYER_ATTRIBUTE_SCALE = "de.chaoswg.Tools3D.createNewWorld3DModel.scale";
    private static final String PLAYER_ATTRIBUTE_GRIDSCALE = "de.chaoswg.Tools3D.createNewWorld3DModel.gridScale";
    private static final String PLAYER_ATTRIBUTE_GRIDMODE = "de.chaoswg.Tools3D.createNewWorld3DModel.gridMode";
    private static final String PLAYER_ATTRIBUTE_UPMODE = "de.chaoswg.Tools3D.createNewWorld3DModel.upMod";
    private static final String PLAYER_ATTRIBUTE_HELP = "de.chaoswg.Tools3D.createNewWorld3DModel.help";

    public String getKEY_ATTRIBUTE_STRENGTH() {
        return KEY_ATTRIBUTE_STRENGTH;
    }

    public int getDEFAULT_ITEM_STRENGTH() {
        return DEFAULT_ITEM_STRENGTH;
    }

    public void setDEFAULT_ITEM_STRENGTH(int DEFAULT_ITEM_STRENGTH) {
        Tools3D.DEFAULT_ITEM_STRENGTH = DEFAULT_ITEM_STRENGTH;
    }

    public static World3DModel createNewWorld3DModel(ModelInformation model, ImageInformation texture, float size, Vector3f position, Quaternion rotation, boolean collision) {
        World3DModel world3DModel = new World3DModel(model, texture, position, rotation);
        world3DModel.setScale(size);
        world3DModel.setLightingEnabled(true);
        world3DModel.setNpcCollisionEnabled(collision);
        world3DModel.setHittable(collision);
        world3DModel.setCollisionShape((CollisionShape)(collision ? CollisionShape.createHullCollisionShape() : null));
        world3DModel.setAttribute(KEY_ATTRIBUTE_STRENGTH, (Object)DEFAULT_ITEM_STRENGTH);
        return world3DModel;
    }

    public static Vector3f roundViewDirection(Vector3f viewDirection) {
        Vector3f result = new Vector3f();
        if ((double)viewDirection.x > 0.5) {
            result.x = 1.0f;
        } else if ((double)viewDirection.x <= 0.5 && viewDirection.x > 0.0f || viewDirection.x < 0.0f && (double)viewDirection.x >= -0.5) {
            result.x = 0.0f;
        } else if ((double)viewDirection.x < -0.5) {
            result.x = -1.0f;
        }
        result.y = 1.0f;
        if ((double)viewDirection.z > 0.5) {
            result.z = 1.0f;
        } else if ((double)viewDirection.z <= 0.5 && viewDirection.z > 0.0f || viewDirection.z < 0.0f && (double)viewDirection.z >= -0.5) {
            result.z = 0.0f;
        } else if ((double)viewDirection.z < -0.5) {
            result.z = -1.0f;
        }
        return result;
    }

    public static float[] convertCollisionNormal(Vector3f collisionNormal, boolean standUp) {
        float pitch = collisionNormal.y * 1.5707964f * -1.0f;
        float yaw = 0.0f;
        float roll = 0.0f;
        yaw = (collisionNormal.z - 1.0f) * -1.0f * 1.5707964f;
        if (collisionNormal.x < 0.0f) {
            yaw = (float)Math.PI * 2 - yaw;
        }
        float[] result = new float[]{pitch, yaw, roll};
        if (standUp) {
            result[0] = 0.0f;
        }
        return result;
    }

    public static Vector3f roundGrid(Vector3f targetPosition, int grid, Vector3f collisionNormal) {
        int gzX = (int)targetPosition.getX();
        float rsX = targetPosition.getX() - (float)gzX;
        int gzY = (int)targetPosition.getY();
        float rsY = targetPosition.getY() - (float)gzY;
        int gzZ = (int)targetPosition.getZ();
        float rsZ = targetPosition.getZ() - (float)gzZ;
        float fac = 1.0f / (float)grid;
        if (grid == 1) {
            rsX = rsX >= 0.0f ? 0.5f : -0.5f;
            rsY = rsY >= 0.0f ? 0.5f : -0.5f;
            rsZ = rsZ >= 0.0f ? 0.5f : -0.5f;
            if (collisionNormal.getX() < 0.0f) {
                gzX = (int)((float)gzX + collisionNormal.getX());
            }
            if (collisionNormal.getZ() < 0.0f) {
                gzZ = (int)((float)gzZ + collisionNormal.getZ());
            }
        } else {
            for (int i = 0; i < grid; ++i) {
                float mitte;
                if (rsX >= 0.0f) {
                    if (rsX > fac * (float)i && rsX <= fac * ((float)i + 1.0f)) {
                        mitte = (fac * ((float)i + 1.0f) - fac * (float)i) / 2.0f;
                        rsX = rsX <= fac * (float)i + mitte ? fac * (float)i : fac * ((float)i + 1.0f);
                    }
                    if (rsX >= 1.0f) {
                        ++gzX;
                        rsX -= 1.0f;
                    }
                } else {
                    if (rsX < fac * (float)i * -1.0f && rsX >= fac * ((float)i + 1.0f) * -1.0f) {
                        mitte = (fac * (float)i * -1.0f - fac * ((float)i + 1.0f) * -1.0f) / 2.0f;
                        rsX = rsX >= fac * (float)i * -1.0f - mitte ? fac * (float)i * -1.0f : fac * ((float)i + 1.0f) * -1.0f;
                    }
                    if (rsX >= 1.0f) {
                        --gzX;
                        rsX += 1.0f;
                    }
                }
                if (rsY >= 0.0f) {
                    if (rsY > fac * (float)i && rsY <= fac * ((float)i + 1.0f)) {
                        mitte = (fac * ((float)i + 1.0f) - fac * (float)i) / 2.0f;
                        rsY = rsY <= fac * (float)i + mitte ? fac * (float)i : fac * ((float)i + 1.0f);
                    }
                    if (rsY >= 1.0f) {
                        ++gzY;
                        rsY -= 1.0f;
                    }
                } else {
                    if (rsY < fac * (float)i * -1.0f && rsY >= fac * ((float)i + 1.0f) * -1.0f) {
                        mitte = (fac * (float)i * -1.0f - fac * ((float)i + 1.0f) * -1.0f) / 2.0f;
                        rsY = rsY >= fac * (float)i * -1.0f - mitte ? fac * (float)i * -1.0f : fac * ((float)i + 1.0f) * -1.0f;
                    }
                    if (rsY >= 1.0f) {
                        --gzY;
                        rsY += 1.0f;
                    }
                }
                if (rsZ >= 0.0f) {
                    if (rsZ > fac * (float)i && rsZ <= fac * ((float)i + 1.0f)) {
                        mitte = (fac * ((float)i + 1.0f) - fac * (float)i) / 2.0f;
                        rsZ = rsZ <= fac * (float)i + mitte ? fac * (float)i : fac * ((float)i + 1.0f);
                    }
                    if (!(rsZ >= 1.0f)) continue;
                    ++gzZ;
                    rsZ -= 1.0f;
                    continue;
                }
                if (rsZ < fac * (float)i * -1.0f && rsZ >= fac * ((float)i + 1.0f) * -1.0f) {
                    mitte = (fac * (float)i * -1.0f - fac * ((float)i + 1.0f) * -1.0f) / 2.0f;
                    rsZ = rsZ >= fac * (float)i * -1.0f - mitte ? fac * (float)i * -1.0f : fac * ((float)i + 1.0f) * -1.0f;
                }
                if (!(rsZ >= 1.0f)) continue;
                --gzZ;
                rsZ += 1.0f;
            }
        }
        targetPosition.setX((float)gzX + rsX);
        targetPosition.setY((float)gzY + rsY);
        targetPosition.setZ((float)gzZ + rsZ);
        return targetPosition;
    }

    public static void refreshWorld3DModel(World3DModel model) {
        Tools3D.refreshWorld3DModel(model, false, false);
    }

    public static void refreshWorld3DModel(World3DModel model, boolean collision, boolean interaction) {
        try {
            Method method = World3DModel.class.getDeclaredMethod("updateElement", Boolean.TYPE, Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)model, collision, interaction);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class ClassPlaceMyWorld3DModel
    implements Listener {
        private final Plugin plugin;
        private List<ClassPMWModelOption> option;
        private ClassPluginConfig debug;
        private final HashMap<Long, ClassPlayerDaten> playerDaten;
        private int COLLISION_BITMASK;
        private float triggerDistance;
        private float moveToSpeed;
        private String labTextManuel;
        private String labTextNoManuel;
        private String labTextGrid;
        private String labTextNoGrid;
        private String labTextStandUp;
        private String labTextLayFlat;
        private final ImageInformation imageLocked;
        private final ImageInformation imageUnLocked;
        private final ImageInformation imageGrid;
        private final ImageInformation imageNoGrid;
        private final ImageInformation imageStandUp;
        private final ImageInformation imageLayFlat;
        private final int[] KEY_LIST;
        private int gridKey;
        private int manualKey;
        private int standUpKey;
        private int helpKey;
        private final ClassPlaceMyWorld3DModelConfig placeMyWorld3DModel;
        private ClassCallback.CallbackCRTi onPlacementAbort;
        private ClassCallback.CallbackCRTi onPlacementEnter;
        private Callback onPlacementSave;
        private ClassCallback.CallbackCRTi onChangePosition;

        public void setCollisionBitmask(int COLLISION_BITMASK) {
            this.COLLISION_BITMASK = COLLISION_BITMASK;
        }

        public int getCollisionBitmask() {
            return this.COLLISION_BITMASK;
        }

        public float getTriggerDistance() {
            return this.triggerDistance;
        }

        public void setTriggerDistance(float triggerDistance) {
            this.triggerDistance = triggerDistance;
        }

        public float getMoveToSpeed() {
            return this.moveToSpeed;
        }

        public void setMoveToSpeed(float moveToSpeed) {
            this.moveToSpeed = moveToSpeed;
        }

        public boolean isPlaceWorld3DModel(Player player) {
            return this.playerDaten.get(player.getUID()) != null;
        }

        public ClassPlaceMyWorld3DModel(Plugin plugin, String assets, ClassPMWModelOption[] option, ClassPluginConfig debug) {
            this.plugin = plugin;
            this.option = Arrays.asList(option);
            this.debug = debug;
            this.playerDaten = new HashMap();
            this.COLLISION_BITMASK = CollisionType.getBitmask((int[])new int[]{1, 8, 16, 128});
            this.triggerDistance = 6.0f;
            this.moveToSpeed = 9.0f;
            ToolsAPI tAPI = (ToolsAPI)plugin.getPluginByName("ToolsAPI");
            String name = "icon";
            String phatFile = tAPI.getPath() + System.getProperty("file.separator") + tAPI.getAssetsName() + System.getProperty("file.separator") + name + System.getProperty("file.separator");
            debug.printlnDebug(2, "[" + plugin.getDescription("name") + "] PHAT: " + phatFile);
            String phatResources = "/resources/" + name + "/";
            debug.printlnDebug(2, "[" + plugin.getDescription("name") + "] RESR: " + phatResources);
            this.imageLocked = ToolsAPI.getBild(tAPI, phatResources + "construction_icon_locked.png", phatFile + "construction_icon_locked.png", debug.isDebug(2));
            this.imageUnLocked = ToolsAPI.getBild(tAPI, phatResources + "construction_icon_unlocked.png", phatFile + "construction_icon_unlocked.png", debug.isDebug(2));
            this.imageGrid = ToolsAPI.getBild(tAPI, phatResources + "construction_icon_grid.png", phatFile + "construction_icon_grid.png", debug.isDebug(2));
            this.imageNoGrid = ToolsAPI.getBild(tAPI, phatResources + "construction_icon_nogrid.png", phatFile + "construction_icon_nogrid.png", debug.isDebug(2));
            this.imageStandUp = ToolsAPI.getBild(tAPI, phatResources + "construction_icon_standUp.png", phatFile + "construction_icon_standUp.png", debug.isDebug(2));
            this.imageLayFlat = ToolsAPI.getBild(tAPI, phatResources + "construction_icon_layFlat.png", phatFile + "construction_icon_layFlat.png", debug.isDebug(2));
            this.placeMyWorld3DModel = new ClassPlaceMyWorld3DModelConfig(plugin, assets, this.debug);
            this.gridKey = KeyInput.fromString((String)this.placeMyWorld3DModel.getKey().getGridKey());
            this.manualKey = KeyInput.fromString((String)this.placeMyWorld3DModel.getKey().getManualKey());
            this.standUpKey = KeyInput.fromString((String)this.placeMyWorld3DModel.getKey().getStandUpKey());
            this.helpKey = KeyInput.fromString((String)this.placeMyWorld3DModel.getKey().getHelpKey());
            this.KEY_LIST = new int[]{200, 208, 203, 205, 201, 209, 78, 74, this.manualKey, 80, 75, 77, 71, 72, 73, this.gridKey, this.standUpKey, this.helpKey};
        }

        public void setOnPlacementAbort(ClassCallback.CallbackCRTi onPlacementAbrot) {
            this.onPlacementAbort = onPlacementAbrot;
        }

        public ClassCallback.CallbackCRTi getOnPlacementAbort() {
            return this.onPlacementAbort;
        }

        public void setOnPlacementEnter(ClassCallback.CallbackCRTi onPlacement) {
            this.onPlacementEnter = onPlacement;
        }

        public ClassCallback.CallbackCRTi getOnPlacementEnter() {
            return this.onPlacementEnter;
        }

        public void setOnPlacementSave(Callback onPlacement) {
            this.onPlacementSave = onPlacement;
        }

        public Callback getOnPlacementSave() {
            return this.onPlacementSave;
        }

        public void setOnChangePosition(ClassCallback.CallbackCRTi onChangePosition) {
            this.onChangePosition = onChangePosition;
        }

        public ClassCallback.CallbackCRTi getOnChangePosition() {
            return this.onChangePosition;
        }

        public void placeWorld3DModel(Player player, World3DModel world3DModel, boolean previewForAll, float prevAlpha, ClassPluginOBJ modelInformation) {
            GuiLabel lab;
            Timer timer;
            ClassBackUp backup;
            player.setListenForKeyInput(true);
            this.playerDaten.put(player.getUID(), new ClassPlayerDaten());
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel = world3DModel;
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).previewForAll = previewForAll;
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setScale(player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_SCALE) != null && player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_SCALE) instanceof Float ? ((Float)player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_SCALE)).floatValue() : this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x);
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).backup = backup = new ClassBackUp(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getAlpha(), this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.isTransparencyEnabled(), this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getCollisionShape(), new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()), new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()), new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale()));
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setAlpha(prevAlpha);
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setTransparencyEnabled(true);
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setCollisionShape(null);
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).previewForAll) {
                this.plugin.getServer().getAllPlayers().forEach(p -> p.addWorldElement((WorldElement)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel));
            } else {
                player.addWorldElement((WorldElement)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel);
            }
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale = player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDSCALE) != null && player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDSCALE) instanceof Integer ? (Integer)player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDSCALE) : 2;
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).modelInformation = modelInformation;
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer = timer = new Timer(this.debug.isDebug(4) ? 0.5f : 0.05f, 0.0f, -1, () -> {
                if (player.isSpawned() && this.playerDaten.get(player.getUID()) != null && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null) {
                    player.raycast(this.COLLISION_BITMASK, result -> {
                        if (this.playerDaten.get(player.getUID()) != null) {
                            float fFac;
                            Quaternion targetRotation;
                            Vector3f targetPosition;
                            float noColli = 0.0f;
                            if (result != null && result.hasCollision() && result.getDistance() <= this.triggerDistance) {
                                Vector3f tmp;
                                if (this.debug.isDebug(5) && result != null) {
                                    Object collisionObjekt = result.getCollisionObject();
                                    System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel TIMER CollisionObject[" + collisionObjekt + "] " + (collisionObjekt != null) + " I CollisionType[" + result.getCollisionType() + "] " + result.getElementTypeID() + "]");
                                }
                                targetPosition = new Vector3f(result.getCollisionPoint());
                                targetRotation = new Quaternion().fromAngles(Tools3D.convertCollisionNormal(result.getCollisionNormal(), this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode));
                                if (result.getCollisionNormal().y == 1.0f && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode) {
                                    tmp = Tools3D.roundViewDirection(player.getViewDirection().negate());
                                    targetRotation = new Quaternion().fromAngles(Tools3D.convertCollisionNormal(tmp, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode));
                                } else if (result.getCollisionNormal().y == -1.0f && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode) {
                                    tmp = Tools3D.roundViewDirection(player.getViewDirection().multLocal(1.0f, 1.0f, -1.0f));
                                    targetRotation = new Quaternion().fromAngles(Tools3D.convertCollisionNormal(tmp, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode));
                                } else if (result.getCollisionNormal().y > 0.0f) {
                                    if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode) {
                                        tmp = Tools3D.roundViewDirection(player.getViewDirection().negate());
                                        targetPosition.addLocal(0.0f, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).modelInformation.getTop() * this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().y, 0.0f);
                                        targetRotation = new Quaternion().fromAngles(Tools3D.convertCollisionNormal(tmp, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode));
                                    }
                                } else if (result.getCollisionNormal().y < 0.0f && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode) {
                                    tmp = Tools3D.roundViewDirection(player.getViewDirection().negate());
                                    targetPosition.addLocal(0.0f, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).modelInformation.getButtom() * this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().y * -1.0f, 0.0f);
                                    targetRotation = new Quaternion().fromAngles(Tools3D.convertCollisionNormal(tmp, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode));
                                }
                            } else {
                                noColli = prevAlpha * 0.5f;
                                targetPosition = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)this.triggerDistance).add(0.0f, 1.45f, 0.0f);
                                targetRotation = new Quaternion(player.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, (float)Math.PI, 0.0f));
                            }
                            Vector3f SourcePosition = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition();
                            int iFac = 100;
                            if (this.debug.isDebug(4)) {
                                iFac = 10;
                            }
                            if ((float)((int)(SourcePosition.x * (float)iFac)) / (fFac = (float)iFac) != (float)((int)(targetPosition.x * (float)iFac)) / fFac || (float)((int)(SourcePosition.y * (float)iFac)) / fFac != (float)((int)(targetPosition.y * (float)iFac)) / fFac || (float)((int)(SourcePosition.z * (float)iFac)) / fFac != (float)((int)(targetPosition.z * (float)iFac)) / fFac) {
                                if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode && result != null && result.getCollisionNormal() != null) {
                                    targetPosition = Tools3D.roundGrid(targetPosition, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale, result.getCollisionNormal());
                                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setPosition(targetPosition);
                                    if (this.debug.isDebug(4) && result != null) {
                                        System.out.println("[" + this.plugin.getDescription("name") + "] TIMER             targetPosition[" + String.format("%.5f|%.5f|%.5f", Float.valueOf(targetPosition.x), Float.valueOf(targetPosition.y), Float.valueOf(targetPosition.z)) + "] ");
                                    }
                                }
                                if (this.debug.isDebug(4) && result != null) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] TIMER             CollisionNormal[" + String.format("%.5f|%.5f|%.5f", Float.valueOf(result.getCollisionNormal().x), Float.valueOf(result.getCollisionNormal().y), Float.valueOf(result.getCollisionNormal().z)) + "] ");
                                }
                                if (this.playerDaten.get(player.getUID()) != null && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null && targetRotation != null) {
                                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setRotation(targetRotation);
                                }
                                if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getAlpha() != prevAlpha - noColli) {
                                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setAlpha(prevAlpha - noColli);
                                    Tools3D.refreshWorld3DModel(world3DModel);
                                }
                                if (this.debug.isDebug(5)) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel TIMER setAlpha[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getAlpha() + "] \tModelContain[" + player.getAllWorldElements().contains(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel) + "] ID[" + player.getAllWorldElements().indexOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel) + "] ");
                                }
                                boolean bAbbruch = false;
                                if (this.onChangePosition != null) {
                                    this.onChangePosition.onCall(new OnChangePosition(player, targetPosition, new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation())){

                                        @Override
                                        public void onCall(Object result) {
                                            if (debug.isDebug(0)) {
                                                System.out.println("[" + plugin.getDescription("name") + "] PlaceModel Place Timer ChangePositionCall[" + this.getAbbruch() + "] ");
                                            }
                                        }
                                    });
                                    bAbbruch = ClassCallback.CallbackCRTi.cCRT.getAbbruch();
                                }
                                if (this.debug.isDebug(4)) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel Place Timer ChangePosition Do[" + !bAbbruch + "] \n");
                                }
                                if (!bAbbruch && this.playerDaten.get(player.getUID()) != null && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null) {
                                    if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition().distance(targetPosition) > 0.75f) {
                                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setPosition(targetPosition);
                                    } else {
                                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.moveTo(targetPosition, this.moveToSpeed);
                                    }
                                }
                            }
                        }
                    });
                }
            });
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.start();
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode = false;
            boolean bl = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode = player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDMODE) != null && player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDMODE) instanceof Boolean ? ((Boolean)player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDMODE)).booleanValue() : this.option.contains((Object)ClassPMWModelOption.SET_DFAULT_Grid_ON);
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode = player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_UPMODE) != null && player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_UPMODE) instanceof Boolean ? (Boolean)player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_UPMODE) : !this.option.contains((Object)ClassPMWModelOption.SET_DFAULT_StandUp_OFF);
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoMode = player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_HELP) != null && player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_HELP) instanceof Boolean ? (Boolean)player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_HELP) : false;
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs = player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_POSSCALE) != null && player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_POSSCALE) instanceof Float ? ((Float)player.getAttribute(Tools3D.PLAYER_ATTRIBUTE_POSSCALE)).floatValue() : 0.01f;
            float icoSize = 32.0f;
            float iconSizeFac = 1.125f;
            float textSpalteSize = 1.25f;
            this.labTextManuel = this.placeMyWorld3DModel.getLanguage().getManuel().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getManuel().get("en"));
            this.labTextNoManuel = this.placeMyWorld3DModel.getLanguage().getManuelNot().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getManuelNot().get("en"));
            this.labTextGrid = this.placeMyWorld3DModel.getLanguage().getGrid().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getGrid().get("en"));
            this.labTextNoGrid = this.placeMyWorld3DModel.getLanguage().getGridNot().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getGridNot().get("en"));
            this.labTextStandUp = this.placeMyWorld3DModel.getLanguage().getStandUp().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getStandUp().get("en"));
            this.labTextLayFlat = this.placeMyWorld3DModel.getLanguage().getStandUpNot().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getStandUpNot().get("en"));
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI == null) {
                lab = new GuiLabel(this.placeMyWorld3DModel.getColNorm() + String.format(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode ? this.labTextManuel : this.labTextNoManuel, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode ? String.format("%.2f", Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs)) : String.format("%.3f", Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x))) + this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.manualKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm(), icoSize * iconSizeFac, (float)(player.getScreenResolutionY() / 2), false);
                lab.setPivot(PivotPosition.CenterLeft);
                lab.setFontSize(20);
                player.addGuiElement((GuiElement)lab);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI = lab;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Label NEU ");
                }
            }
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked == null) {
                ToolsGUI.GuiImage icoLocked = new ToolsGUI.GuiImage(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode ? this.imageLocked : this.imageUnLocked, 0.0f, player.getScreenResolutionY() / 2, false, icoSize, icoSize, false);
                icoLocked.setPivot(PivotPosition.CenterLeft);
                player.addGuiElement((GuiElement)icoLocked);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked = icoLocked;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Icon NEU ");
                }
            }
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI == null) {
                lab = new GuiLabel(this.placeMyWorld3DModel.getColNorm() + (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode ? this.labTextStandUp : this.labTextLayFlat) + (this.option.contains((Object)ClassPMWModelOption.ALLOW_CHANGE_StandUp) ? this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.standUpKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm() : ""), icoSize * iconSizeFac, (float)(player.getScreenResolutionY() / 2) - icoSize * 1.25f, false);
                lab.setPivot(PivotPosition.CenterLeft);
                lab.setFontSize(20);
                player.addGuiElement((GuiElement)lab);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI = lab;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Label NEU ");
                }
            }
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon == null) {
                ToolsGUI.GuiImage icoStandUp = new ToolsGUI.GuiImage(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode ? this.imageStandUp : this.imageLayFlat, 0.0f, (float)(player.getScreenResolutionY() / 2) - icoSize * (textSpalteSize * 1.0f), false, icoSize, icoSize, false);
                icoStandUp.setPivot(PivotPosition.CenterLeft);
                player.addGuiElement((GuiElement)icoStandUp);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon = icoStandUp;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Icon NEU ");
                }
            }
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI == null) {
                lab = new GuiLabel(this.placeMyWorld3DModel.getColNorm() + (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode ? String.format(this.labTextGrid, String.format("1/%d", this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale)) : this.labTextNoGrid) + (this.option.contains((Object)ClassPMWModelOption.ALLOW_CHANGE_Grid) ? this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.gridKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm() : ""), icoSize * iconSizeFac, (float)(player.getScreenResolutionY() / 2) - icoSize * 2.5f, false);
                lab.setPivot(PivotPosition.CenterLeft);
                lab.setFontSize(20);
                player.addGuiElement((GuiElement)lab);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI = lab;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Label NEU ");
                }
            }
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon == null) {
                ToolsGUI.GuiImage icoGrid = new ToolsGUI.GuiImage(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode ? this.imageGrid : this.imageNoGrid, 0.0f, (float)(player.getScreenResolutionY() / 2) - icoSize * (textSpalteSize * 2.0f), false, icoSize, icoSize, false);
                icoGrid.setPivot(PivotPosition.CenterLeft);
                player.addGuiElement((GuiElement)icoGrid);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon = icoGrid;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Icon NEU ");
                }
            }
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoGUI == null) {
                lab = new GuiLabel(this.getInfoText(player), 0.0f, (float)(player.getScreenResolutionY() / 2) - icoSize * 3.75f, false);
                lab.setPivot(PivotPosition.TopLeft);
                lab.setFontSize(20);
                player.addGuiElement((GuiElement)lab);
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoGUI = lab;
                if (this.debug.isDebug(3)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Label NEU ");
                }
            }
            if (this.debug.isDebug(1)) {
                System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel ");
            }
            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).KEY_LIST_BACKUP = player.getRegisteredKeys();
            player.registerKeys(this.KEY_LIST);
            if (this.option.contains((Object)ClassPMWModelOption.ABROT_ESC)) {
                player.disableClientsideKeys(new int[]{1});
                player.registerKeys(new int[]{1});
            }
            if (this.option.contains((Object)ClassPMWModelOption.ENTER_Enter)) {
                player.registerKeys(new int[]{28});
            }
        }

        void placementAbort(Player player) {
            boolean bAbbruch = false;
            if (this.playerDaten.get(player.getUID()) != null && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null) {
                if (this.onPlacementAbort != null) {
                    if (this.playerDaten.get(player.getUID()) != null) {
                        this.onPlacementAbort.onCall(new OnAbortPlacement(player, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel){

                            @Override
                            public void onCall(Object result) {
                                if (debug.isDebug(0)) {
                                    System.out.println("[" + plugin.getDescription("name") + "] PlaceModel abortPlacement Abbruch Call[" + this.getAbbruch() + "] ");
                                }
                            }
                        });
                    }
                    bAbbruch = ClassCallback.CallbackCRTi.cCRT.getAbbruch();
                }
                if (this.debug.isDebug(2)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel abortPlacement Abbruch Do[" + bAbbruch + "] ");
                }
                if (!bAbbruch && this.playerDaten.get(player.getUID()) != null) {
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.kill();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked.destroy();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoGUI.destroy();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI.destroy();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI.destroy();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.destroy();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI.destroy();
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.destroy();
                    if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).previewForAll) {
                        this.plugin.getServer().getAllPlayers().forEach(p -> p.removeWorldElement((WorldElement)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel));
                    } else {
                        player.removeWorldElement((WorldElement)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel);
                    }
                    player.unregisterKeys(this.KEY_LIST);
                    if (this.option.contains((Object)ClassPMWModelOption.ABROT_ESC)) {
                        player.enableClientsideKeys(new int[]{1});
                        player.unregisterKeys(new int[]{1});
                    }
                    if (this.option.contains((Object)ClassPMWModelOption.ENTER_Enter)) {
                        player.unregisterKeys(new int[]{28});
                    }
                    player.registerKeys(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).KEY_LIST_BACKUP);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDMODE, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_UPMODE, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDSCALE, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_HELP, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoMode);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_SCALE, (Object)Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x));
                    this.playerDaten.remove(player.getUID());
                }
            }
        }

        void placementEnter(Player player) {
            boolean bAbbruch = false;
            if (this.playerDaten.get(player.getUID()) != null && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null) {
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.pause();
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setAlpha(1.0f);
                if (this.onPlacementEnter != null) {
                    this.onPlacementEnter.onCall(new OnPlacementEnter(player, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel){

                        @Override
                        public void onCall(Object result) {
                            if (debug.isDebug(0)) {
                                System.out.println("[" + plugin.getDescription("name") + "] PlaceModel placementEnter Call[" + this.getAbbruch() + "] ");
                            }
                        }
                    });
                    bAbbruch = ClassCallback.CallbackCRTi.cCRT.getAbbruch();
                }
                if (this.debug.isDebug(2)) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel placementEnter Abbruch Do[" + bAbbruch + "] ");
                }
                if (!bAbbruch) {
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.kill();
                    Tools3D.refreshWorld3DModel(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode = false;
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoGUI.setVisible(false);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI.setVisible(false);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked.setVisible(false);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI.setVisible(false);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.setVisible(false);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI.setVisible(false);
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.setVisible(false);
                    ClassPlayerDaten tempData = this.playerDaten.get(player.getUID());
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDMODE, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_UPMODE, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_GRIDSCALE, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_HELP, (Object)this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoMode);
                    player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_SCALE, (Object)Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x));
                    this.playerDaten.remove(player.getUID());
                    if (this.onPlacementSave != null) {
                        this.onPlacementSave.onCall((Object)new OnPlacementSave(player, tempData.world3DModel){

                            public void onCall(Object result) {
                                if (debug.isDebug(0)) {
                                    System.out.println("[" + plugin.getDescription("name") + "] PlaceModel placementEnter Call[" + this.getAbbruch() + "] ");
                                }
                            }
                        });
                    }
                } else {
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.start();
                }
            }
        }

        private String getInfoText(Player player) {
            String result = this.placeMyWorld3DModel.getColKey() + "[" + ToolsAPI.getKeyInputValue(this.helpKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm() + "\n";
            if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoMode) {
                if (!this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                    result = result + this.placeMyWorld3DModel.getLanguage().getInfoScale().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getInfoScale().get("en"));
                } else if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                    result = result + this.placeMyWorld3DModel.getLanguage().getInfoGrid().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getInfoGrid().get("en"));
                }
                if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode) {
                    result = result + this.placeMyWorld3DModel.getLanguage().getInfoManuel().getOrDefault(player.getLanguage().toLowerCase(), this.placeMyWorld3DModel.getLanguage().getInfoManuel().get("en"));
                }
            }
            return result;
        }

        @EventMethod
        public void onPlayerKeyInput(PlayerKeyEvent event) {
            Player player;
            if (event.isPressed() && this.playerDaten.get((player = event.getPlayer()).getUID()) != null && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null) {
                this.debug.printlnDebug(3, "[" + this.debug.getName() + "] onPlayerKeyInput[" + event.getKeyCode() + "] ");
                float POSITION_STEP = 0.01f;
                float SCALE_STEP = 0.025f;
                String STEP_FORMAT = "%.3f";
                Vector3f pos = null;
                Quaternion rot = null;
                float scale = -1.0f;
                float ROTATION_STEP = 0.19634955f;
                if (!this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode) {
                    if (event.getKeyCode() == 78 && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                        scale = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x + 0.025f;
                    } else if (event.getKeyCode() == 74 && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                        if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x - 0.025f > 0.025f) {
                            scale = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x - 0.025f;
                        } else {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setScale(0.025f);
                            scale = 0.025f;
                        }
                    } else if (event.getKeyCode() == this.manualKey) {
                        if (this.debug.isDebug(1)) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput R-Control isVisible[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI.isVisible() + "] ");
                        }
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked.setVisible(true);
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked.setImage(this.imageLocked);
                        if (this.debug.isDebug(1)) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput           isVisible[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI.isVisible() + "] ");
                        }
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode = true;
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.pause();
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs;
                    }
                } else {
                    Vector3f rVD = Tools3D.roundViewDirection(player.getViewDirection());
                    if (this.debug.isDebug(3)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel ViewDirection[" + String.format("%.5f|%.5f|%.5f", Float.valueOf(player.getViewDirection().x), Float.valueOf(player.getViewDirection().y), Float.valueOf(player.getViewDirection().z)) + "] CardinalDirection[" + player.getCardinalDirection() + "] ");
                    }
                    if (this.debug.isDebug(2)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel rViewDirectio[" + String.format("%.5f|%.5f|%.5f", Float.valueOf(rVD.x), Float.valueOf(rVD.y), Float.valueOf(rVD.z)) + "] CardinalDirection[" + player.getCardinalDirection() + "] ");
                    }
                    if (event.getKeyCode() == 77) {
                        rot = new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.19634955f, 0.0f));
                    } else if (event.getKeyCode() == 75) {
                        rot = new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, -0.19634955f, 0.0f));
                    } else if (event.getKeyCode() == 80) {
                        rot = new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()).multLocal(new Quaternion().fromAngles(0.19634955f, 0.0f, 0.0f));
                    } else if (event.getKeyCode() == 72) {
                        rot = new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()).multLocal(new Quaternion().fromAngles(-0.19634955f, 0.0f, 0.0f));
                    } else if (event.getKeyCode() == 71) {
                        rot = new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, 0.19634955f));
                    } else if (event.getKeyCode() == 73) {
                        rot = new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, -0.19634955f));
                    }
                    if (event.getKeyCode() == 203) {
                        pos = new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()).addLocal(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.z, 0.0f, -this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.x);
                    } else if (event.getKeyCode() == 205) {
                        pos = new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()).addLocal(-this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.z, 0.0f, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.x);
                    } else if (event.getKeyCode() == 200) {
                        pos = new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()).addLocal(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.x, 0.0f, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.z);
                    } else if (event.getKeyCode() == 208) {
                        pos = new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()).addLocal(-this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.x, 0.0f, -this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs * rVD.z);
                    } else if (event.getKeyCode() == 201) {
                        pos = new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()).addLocal(0.0f, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs, 0.0f);
                    } else if (event.getKeyCode() == 209) {
                        pos = new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()).addLocal(0.0f, -this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs, 0.0f);
                    } else if (event.getKeyCode() == 78 && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                        if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs + 0.01f <= 1.0f) {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs = Float.valueOf(String.format("%.3f", Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs + 0.01f)).replace(",", ".")).floatValue();
                            player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_POSSCALE, (Object)Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs));
                        }
                    } else if (event.getKeyCode() == 74 && !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                        if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs - 0.01f >= 0.01f) {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs = Float.valueOf(String.format("%.3f", Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs - 0.01f)).replace(",", ".")).floatValue();
                            player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_POSSCALE, (Object)Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs));
                        }
                    } else if (event.getKeyCode() == this.manualKey) {
                        if (this.debug.isDebug(1)) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput L-Control");
                        }
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUIiconLocked.setImage(this.imageUnLocked);
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode = false;
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).timer.start();
                    }
                }
                if (event.getKeyCode() == this.helpKey) {
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoMode = !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoMode;
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoGUI.setText(this.getInfoText(player));
                } else if (this.option.contains((Object)ClassPMWModelOption.ABROT_ESC) && event.getKeyCode() == 1) {
                    this.placementAbort(player);
                } else if (this.option.contains((Object)ClassPMWModelOption.ENTER_Enter) && event.getKeyCode() == 28) {
                    this.placementEnter(player);
                } else if (this.option.contains((Object)ClassPMWModelOption.ALLOW_CHANGE_Grid) && event.getKeyCode() == this.gridKey) {
                    if (this.debug.isDebug(1)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput L-Control isVisible[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.isVisible() + "] ");
                    }
                    boolean bl = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode = !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode;
                    if (!this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI.isVisible()) {
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI.setVisible(true);
                    }
                    if (!this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.isVisible()) {
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.setVisible(true);
                    }
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI.setText(this.placeMyWorld3DModel.getColNorm() + (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode ? String.format(this.labTextGrid, String.format("1/%d", this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale)) : this.labTextNoGrid) + this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.gridKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm());
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.setImage(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode ? this.imageGrid : this.imageNoGrid);
                    if (this.debug.isDebug(1)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput           isVisible[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUIicon.isVisible() + "] ");
                    }
                } else if (this.option.contains((Object)ClassPMWModelOption.ALLOW_CHANGE_StandUp) && event.getKeyCode() == this.standUpKey) {
                    if (this.debug.isDebug(1)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput " + this.standUpKey + " isVisible[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.isVisible() + "] ");
                    }
                    boolean bl = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode = !this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode;
                    if (!this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI.isVisible()) {
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI.setVisible(true);
                    }
                    if (!this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.isVisible()) {
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.setVisible(true);
                    }
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUI.setText(this.placeMyWorld3DModel.getColNorm() + (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode ? this.labTextStandUp : this.labTextLayFlat) + this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.standUpKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm());
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.setImage(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpMode ? this.imageStandUp : this.imageLayFlat);
                    if (this.debug.isDebug(1)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput           isVisible[" + this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).standUpModeGUIicon.isVisible() + "] ");
                    }
                } else if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode) {
                    int maxGrid = 16;
                    int stepGrid = 2;
                    if (event.getKeyCode() == 78) {
                        if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale < maxGrid) {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale < stepGrid ? stepGrid : (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale += stepGrid);
                        }
                    } else if (event.getKeyCode() == 74 && this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale >= 1) {
                        this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale = this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale <= stepGrid ? 1 : (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale -= stepGrid);
                    }
                    this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridModeGUI.setText(this.placeMyWorld3DModel.getColNorm() + (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridMode ? String.format(this.labTextGrid, String.format("1/%d", this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).gridScale)) : this.labTextNoGrid) + (this.option.contains((Object)ClassPMWModelOption.ALLOW_CHANGE_Grid) ? this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.gridKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm() : ""));
                } else if (this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel != null) {
                    boolean bAbbruch = false;
                    if (this.onChangePosition != null) {
                        this.onChangePosition.onCall(new OnChangePosition(player, new Vector3f(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getPosition()), new Quaternion(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getRotation())){

                            @Override
                            public void onCall(Object result) {
                                if (debug.isDebug(0)) {
                                    System.out.println("[" + plugin.getDescription("name") + "] PlaceModel KeyInput AbbruchCall[" + this.getAbbruch() + "] ");
                                }
                            }
                        });
                        bAbbruch = ClassCallback.CallbackCRTi.cCRT.getAbbruch();
                    }
                    if (this.debug.isDebug(2)) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] PlaceModel KeyInput Abbruch I [" + bAbbruch + "] ");
                    }
                    if (!bAbbruch) {
                        if (rot != null) {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setRotation(rot);
                        }
                        if (pos != null) {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setPosition(pos);
                        }
                        if (scale >= 0.0f) {
                            this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.setScale(scale);
                            player.setAttribute(Tools3D.PLAYER_ATTRIBUTE_SCALE, (Object)Float.valueOf(scale));
                        }
                    }
                }
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelModeGUI.setText(this.placeMyWorld3DModel.getColNorm() + String.format(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode ? this.labTextManuel : this.labTextNoManuel, this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).manuelMode ? String.format("%.2f", Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).POSITION_STEPs)) : String.format("%.3f", Float.valueOf(this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).world3DModel.getScale().x))) + this.placeMyWorld3DModel.getColKey() + " [" + ToolsAPI.getKeyInputValue(this.manualKey).replaceFirst("KEY_", "") + "]" + this.placeMyWorld3DModel.getColNorm());
                this.playerDaten.get((Object)Long.valueOf((long)player.getUID())).infoGUI.setText(this.getInfoText(player));
            }
        }

        abstract class OnChangePosition
        implements ClassCallback.CallbackCRTi {
            private Player player;
            private Vector3f position;
            private Quaternion rotation;

            public Player getPlayer() {
                return this.player;
            }

            public Vector3f getPosition() {
                return this.position;
            }

            public Quaternion getRotation() {
                return this.rotation;
            }

            private OnChangePosition(Player player, Vector3f position, Quaternion rotation) {
                this.player = player;
                this.position = position;
                this.rotation = rotation;
                ClassCallback.CallbackCRT.cancleBol = false;
            }

            public void setAbbruch(boolean cancle) {
                ClassCallback.CallbackCRT.cancleBol = cancle;
            }

            public boolean getAbbruch() {
                return ClassCallback.CallbackCRT.cancleBol;
            }
        }

        abstract class OnPlacementSave
        implements Callback {
            private final Player player;
            private final World3DModel world3DModel;

            public Player getPlayer() {
                return this.player;
            }

            public World3DModel getWorld3DModel() {
                return this.world3DModel;
            }

            public OnPlacementSave(Player player, World3DModel world3DModel) {
                this.player = player;
                this.world3DModel = world3DModel;
                ClassCallback.CallbackCRT.cancleBol = false;
            }

            public void setAbbruch(boolean cancle) {
                ClassCallback.CallbackCRT.cancleBol = cancle;
            }

            public boolean getAbbruch() {
                return ClassCallback.CallbackCRT.cancleBol;
            }
        }

        abstract class OnPlacementEnter
        implements ClassCallback.CallbackCRTi {
            private final Player player;
            private final World3DModel world3DModel;

            public Player getPlayer() {
                return this.player;
            }

            public World3DModel getWorld3DModel() {
                return this.world3DModel;
            }

            public OnPlacementEnter(Player player, World3DModel world3DModel) {
                this.player = player;
                this.world3DModel = world3DModel;
                ClassCallback.CallbackCRT.cancleBol = false;
            }

            public void setAbbruch(boolean cancle) {
                ClassCallback.CallbackCRT.cancleBol = cancle;
            }

            public boolean getAbbruch() {
                return ClassCallback.CallbackCRT.cancleBol;
            }
        }

        abstract class OnAbortPlacement
        implements ClassCallback.CallbackCRTi {
            private final Player player;
            private final World3DModel world3DModel;

            public Player getPlayer() {
                return this.player;
            }

            public World3DModel getWorld3DModel() {
                return this.world3DModel;
            }

            public OnAbortPlacement(Player player, World3DModel world3DModel) {
                this.player = player;
                this.world3DModel = world3DModel;
                ClassCallback.CallbackCRT.cancleBol = false;
            }

            public void setAbbruch(boolean cancle) {
                ClassCallback.CallbackCRT.cancleBol = cancle;
            }

            public boolean getAbbruch() {
                return ClassCallback.CallbackCRT.cancleBol;
            }
        }
    }

    static enum ClassPMWModelOption {
        ABROT_ESC,
        ALLOW_CHANGE_Grid,
        ALLOW_CHANGE_StandUp,
        ENTER_Enter,
        SET_DFAULT_Grid_ON,
        SET_DFAULT_StandUp_OFF;

    }
}

