/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.ClassPlaceMyWorld3DModelKey;
import de.chaoswg.ClassPlaceMyWorld3DModelLanguage;
import de.chaoswg.ClassPluginConfig;
import de.chaoswg.ToolsAPI;
import java.io.File;
import java.io.FileNotFoundException;
import net.risingworld.api.Plugin;
import org.yaml.snakeyaml.DumperOptions;

public class ClassPlaceMyWorld3DModelConfig {
    private Plugin plugin;
    private String assets;
    private ClassPluginConfig debug;
    private ClassPlaceMyWorld3DModelConfig daten;
    private ClassPlaceMyWorld3DModelLanguage Language;
    private ClassPlaceMyWorld3DModelKey Key;
    private String colKey;
    private String colNorm;

    public ClassPlaceMyWorld3DModelLanguage getLanguage() {
        return this.Language;
    }

    public void setLanguage(ClassPlaceMyWorld3DModelLanguage Language) {
        this.Language = Language;
    }

    public ClassPlaceMyWorld3DModelKey getKey() {
        return this.Key;
    }

    public void setKey(ClassPlaceMyWorld3DModelKey Key) {
        this.Key = Key;
    }

    public String getColKey() {
        return this.colKey;
    }

    public void setColKey(String colKey) {
        this.colKey = colKey;
    }

    public String getColNorm() {
        return this.colNorm;
    }

    public void setColNorm(String colNorm) {
        this.colNorm = colNorm;
    }

    ClassPlaceMyWorld3DModelConfig() {
    }

    ClassPlaceMyWorld3DModelConfig(Plugin plugin, String assets, ClassPluginConfig debug) {
        this.Language = new ClassPlaceMyWorld3DModelLanguage(plugin, this.debug);
        this.Key = new ClassPlaceMyWorld3DModelKey(plugin, this.debug);
        this.colKey = "[#ffffc8]";
        this.colNorm = "[#ffffff]";
        this.daten = this;
        this.debug = debug;
        this.plugin = plugin;
        this.assets = assets;
        this.loadConfig();
    }

    void loadConfig() {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setIndent(2);
        options.setWidth(80);
        String configName = "PlaceWorld3DModel";
        File fileCongigPhat = new File(this.plugin.getPluginByName("ToolsAPI").getPath() + System.getProperty("file.separator") + this.assets);
        if (fileCongigPhat.mkdirs()) {
            this.debug.printlnDebug(0, "Erstelle: " + fileCongigPhat.getAbsolutePath());
        }
        String fileCongigFile = this.plugin.getPluginByName("ToolsAPI").getPath() + System.getProperty("file.separator") + this.assets + System.getProperty("file.separator") + configName + ".yml";
        File configFile = new File(fileCongigFile);
        this.debug.printlnDebug(2, "[" + this.plugin.getDescription("name") + "] configFile: " + configFile.getAbsolutePath());
        if (configFile.exists()) {
            this.debug.printlnDebug(0, "[" + this.plugin.getDescription("name") + "] Lade: " + configFile.getAbsolutePath());
            try {
                this.daten = (ClassPlaceMyWorld3DModelConfig)ToolsAPI.loadYAML(configFile, ClassPlaceMyWorld3DModelConfig.class, options);
            }
            catch (FileNotFoundException ex) {
                System.err.println("[" + this.plugin.getDescription("name") + "] ERR load configDaten[] " + ex.getMessage());
            }
            this.setLanguage(this.daten.getLanguage());
            this.setKey(this.daten.getKey());
            this.setColKey(this.daten.getColKey());
            this.setColNorm(this.daten.getColNorm());
        } else {
            this.debug.printlnDebug(0, "[" + this.plugin.getDescription("name") + "] Erstelle: " + configFile.getAbsolutePath());
            ToolsAPI.writeYAMAL(configFile, this.daten, options);
        }
    }
}

