
include("myTime/myTime.lua");
include("string-ext/string-ext.lua");
include("table-ext/table-ext.lua");
include("listeners/commandListener.lua");
include("listeners/playerListener.lua");

function onEnable()
	config = getProperty("config.properties");

	print("Clock loaded successfully!");
end

function setClockFormat(event, format)
	deleteClockLabel(event);
	config:setProperty("clock.format", format);
	config:saveProperty();
	addClockLabel(event);
	runClock(event);
end

function addClockLabel(event)
	local label = Gui:createLabel("",  tonumber(config:getProperty("clock.positionX")), tonumber(config:getProperty("clock.positionY")));
	label:setFontsize(tonumber(config:getProperty("clock.size")));
	label:setVisible(true);
	label:setFontColor(tonumber(config:getProperty("clock.color")));
	label:setPivot(tonumber(config:getProperty("clock.pivot")));
	event.player:setAttribute("clockLabel", label);
	event.player:addGuiElement(label);
end

function runClock(event)
	local label = event.player:getAttribute("clockLabel");
	clockTimer = setTimer(
		function()
			label:setText(getTime(config:getProperty("clock.format")));
		end, 0.5, -1);
end

function deleteClockLabel(event)
	killTimer(clockTimer);
	local label = event.player:getAttribute("clockLabel");
	event.player:removeGuiElement(label);
end

function setPosition(event,x,y,pivot)
	deleteClockLabel(event)
	config:setProperty("clock.positionX", x);
	config:setProperty("clock.positionY", y);
	config:setProperty("clock.pivot", pivot);
	config:saveProperty();
	addClockLabel(event);
	runClock(event);
end

function setColor(event,color)
	deleteClockLabel(event);
	config:setProperty("clock.color", color);
	config:saveProperty();
	addClockLabel(event);
	runClock(event);
end

function setSize(event,size)
	deleteClockLabel(event);
	config:setProperty("clock.size", size);
	config:saveProperty();
	addClockLabel(event);
	runClock(event);
end