
include("command-parser/parse-args.lua");

local function clFormat(event, args)
  if #args >= 1 then
    if args[1] == "12" then
      setClockFormat(event, "%I:%M:%S %p");
    elseif args[1] == "24" then
      setClockFormat(event, "%H:%M:%S");
    elseif args[1] == "custom" then
      local s = "";
      for i = 1, #args do
        if i == 2 then
           s = s ..args[i];
        elseif i >2 then
         s = s.." "..args[i];
        end
      end
      setClockFormat(event, s);
    else
      event.player:sendTextMessage("wrong format use 12, 24 or custom");
    end
  else
    event.player:sendTextMessage("no format");
  end
end

local function clPosition(event, args)
  if #args >= 1 then
    if args[1] == "custom" and #args >= 4 then
      setPosition(event, args[2], args[3], args[4]);
    elseif args[1] == "topcenter" then
      setPosition(event, 0.5, 0.98, 4);
    elseif args[1] == "topleft" then
      setPosition(event, 0.02, 0.96, 0);
    elseif args[1] == "topright" then
      setPosition(event, 0.99, 0.91, 1);
    elseif args[1] == "bottomcenter" then
      setPosition(event, 0.5, 0.02, 4);
    elseif args[1] == "bottomleft" then
      setPosition(event, 0.02, 0.04, 0);
    elseif args[1] == "bottomright" then
      setPosition(event, 0.99, 0.04, 1);
    elseif args[1] == "leftcenter" then
      setPosition(event, 0.01, 0.5, 0);
    elseif args[1] == "rightcenter" then
      setPosition(event, 0.99, 0.5, 1);
    end
  end
end


local function clColor(event,args)
  if #args >= 1 then
    setColor(event,args[1]);
  end
end

local function clSize(event,args)
  if #args >= 1 then
    setSize(event,args[1]);
  end
end

local function onPlayerCommand(event)
  local args, flags = parseArgs(event.command);
  local cmd;

  if #args >= 1 then

    if string.lower(args[1]) == "/cl" then

      event:setCancel(true);

      cmd = string.lower(args[2] or "");

      if cmd == "format" then
        clFormat(event, table.slice(args, 3));

      elseif cmd == "position" then
        clPosition(event,table.slice(args,3));

      elseif cmd == "color" then
        clColor(event,table.slice(args,3));

      elseif cmd == "size" then
        clSize(event, table.slice(args,3));

      else event.player:sendTextMessage("unknown command");

      end
    end
  end
end
addEvent("PlayerCommand", onPlayerCommand);
