/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message;

import java.io.File;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageBuilder;
import org.javacord.api.entity.message.embed.EmbedBuilder;

public interface Messageable {
    default public CompletableFuture<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, String nonce, InputStream stream, String fileName) {
        return new MessageBuilder().append(content == null ? "" : content).setEmbed(embed).setTts(tts).setNonce(nonce).addAttachment(stream, fileName).send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, String nonce, File ... files) {
        MessageBuilder messageBuilder = new MessageBuilder().append(content == null ? "" : content).setEmbed(embed).setTts(tts).setNonce(nonce);
        for (File file : files) {
            messageBuilder.addAttachment(file);
        }
        return messageBuilder.send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, EmbedBuilder embed, boolean tts, String nonce) {
        return new MessageBuilder().append(content == null ? "" : content).setEmbed(embed).setTts(tts).setNonce(nonce).send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, EmbedBuilder embed) {
        return new MessageBuilder().append(content == null ? "" : content).setEmbed(embed).send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content) {
        return new MessageBuilder().append(content == null ? "" : content).send(this);
    }

    default public CompletableFuture<Message> sendMessage(EmbedBuilder embed) {
        return new MessageBuilder().setEmbed(embed).send(this);
    }

    default public CompletableFuture<Message> sendMessage(File ... files) {
        MessageBuilder messageBuilder = new MessageBuilder();
        for (File file : files) {
            messageBuilder.addAttachment(file);
        }
        return messageBuilder.send(this);
    }

    default public CompletableFuture<Message> sendMessage(InputStream stream, String fileName) {
        return new MessageBuilder().addAttachment(stream, fileName).send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, File ... files) {
        MessageBuilder messageBuilder = new MessageBuilder().append(content == null ? "" : content);
        for (File file : files) {
            messageBuilder.addAttachment(file);
        }
        return messageBuilder.send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, InputStream stream, String fileName) {
        return new MessageBuilder().append(content == null ? "" : content).addAttachment(stream, fileName).send(this);
    }

    default public CompletableFuture<Message> sendMessage(EmbedBuilder embed, File ... files) {
        MessageBuilder messageBuilder = new MessageBuilder().setEmbed(embed);
        for (File file : files) {
            messageBuilder.addAttachment(file);
        }
        return messageBuilder.send(this);
    }

    default public CompletableFuture<Message> sendMessage(EmbedBuilder embed, InputStream stream, String fileName) {
        return new MessageBuilder().setEmbed(embed).addAttachment(stream, fileName).send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, EmbedBuilder embed, File ... files) {
        MessageBuilder messageBuilder = new MessageBuilder().append(content == null ? "" : content).setEmbed(embed);
        for (File file : files) {
            messageBuilder.addAttachment(file);
        }
        return messageBuilder.send(this);
    }

    default public CompletableFuture<Message> sendMessage(String content, EmbedBuilder embed, InputStream stream, String fileName) {
        return new MessageBuilder().append(content == null ? "" : content).setEmbed(embed).addAttachment(stream, fileName).send(this);
    }
}

