/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.GroupChannelUpdater;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.channel.VoiceChannel;
import org.javacord.api.entity.user.User;
import org.javacord.api.listener.channel.group.GroupChannelAttachableListenerManager;

public interface GroupChannel
extends TextChannel,
VoiceChannel,
GroupChannelAttachableListenerManager {
    @Override
    default public ChannelType getType() {
        return ChannelType.GROUP_CHANNEL;
    }

    public Collection<User> getMembers();

    public Optional<String> getName();

    public Optional<Icon> getIcon();

    default public boolean isMember(User user) {
        return user.isYourself() || this.getMembers().contains(user);
    }

    default public GroupChannelUpdater createUpdater() {
        return new GroupChannelUpdater(this);
    }

    default public CompletableFuture<Void> updateName(String name) {
        return this.createUpdater().setName(name).update();
    }

    default public Optional<GroupChannel> getCurrentCachedInstance() {
        return this.getApi().getGroupChannelById(this.getId());
    }

    @Override
    default public CompletableFuture<GroupChannel> getLatestInstance() {
        Optional<GroupChannel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture<GroupChannel> result = new CompletableFuture<GroupChannel>();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }
}

