/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.event.user;

import java.util.Map;
import org.javacord.api.entity.DiscordClient;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.user.UserStatus;
import org.javacord.api.event.user.UserChangeStatusEvent;
import org.javacord.core.event.user.UserEventImpl;

public class UserChangeStatusEventImpl
extends UserEventImpl
implements UserChangeStatusEvent {
    private final UserStatus newStatus;
    private final UserStatus oldStatus;
    private final Map<DiscordClient, UserStatus> newClientStatus;
    private final Map<DiscordClient, UserStatus> oldClientStatus;

    public UserChangeStatusEventImpl(User user, UserStatus newStatus, UserStatus oldStatus, Map<DiscordClient, UserStatus> newClientStatus, Map<DiscordClient, UserStatus> oldClientStatus) {
        super(user);
        this.newStatus = newStatus;
        this.oldStatus = oldStatus;
        this.newClientStatus = newClientStatus;
        this.oldClientStatus = oldClientStatus;
    }

    public UserStatus getOldStatus() {
        return this.oldStatus;
    }

    public UserStatus getNewStatus() {
        return this.newStatus;
    }

    public UserStatus getOldStatusOnClient(DiscordClient client) {
        return this.oldClientStatus.getOrDefault(client, UserStatus.OFFLINE);
    }

    public UserStatus getNewStatusOnClient(DiscordClient client) {
        return this.newClientStatus.getOrDefault(client, UserStatus.OFFLINE);
    }
}

