/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.Mentionable;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageDecoration;
import org.javacord.api.entity.message.Messageable;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.message.internal.MessageBuilderDelegate;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.message.embed.EmbedBuilderDelegateImpl;
import org.javacord.core.util.FileContainer;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class MessageBuilderDelegateImpl
implements MessageBuilderDelegate {
    private Messageable messageable = null;
    private final StringBuilder strBuilder = new StringBuilder();
    private EmbedBuilder embed = null;
    private boolean tts = false;
    private String nonce = null;
    private final List<FileContainer> attachments = new ArrayList<FileContainer>();

    public void appendCode(String language, String code) {
        this.strBuilder.append("\n").append(MessageDecoration.CODE_LONG.getPrefix()).append(language).append("\n").append(code).append(MessageDecoration.CODE_LONG.getSuffix());
    }

    public void append(String message, MessageDecoration ... decorations) {
        for (MessageDecoration decoration : decorations) {
            this.strBuilder.append(decoration.getPrefix());
        }
        this.strBuilder.append(message);
        for (int i = decorations.length - 1; i >= 0; --i) {
            this.strBuilder.append(decorations[i].getSuffix());
        }
    }

    public void append(Mentionable entity) {
        this.strBuilder.append(entity.getMentionTag());
    }

    public void append(Object object) {
        this.strBuilder.append(object);
    }

    public void appendNewLine() {
        this.strBuilder.append("\n");
    }

    public void setContent(String content) {
        this.strBuilder.setLength(0);
        this.strBuilder.append(content);
    }

    public void setEmbed(EmbedBuilder embed) {
        this.embed = embed;
    }

    public void setTts(boolean tts) {
        this.tts = tts;
    }

    public void addFile(BufferedImage image, String fileName) {
        this.addAttachment(image, fileName);
    }

    public void addFile(File file) {
        this.addAttachment(file);
    }

    public void addFile(Icon icon) {
        this.addAttachment(icon);
    }

    public void addFile(URL url) {
        this.addAttachment(url);
    }

    public void addFile(byte[] bytes, String fileName) {
        this.addAttachment(bytes, fileName);
    }

    public void addFile(InputStream stream, String fileName) {
        this.addAttachment(stream, fileName);
    }

    public void addFileAsSpoiler(File file) {
        this.addAttachmentAsSpoiler(file);
    }

    public void addFileAsSpoiler(Icon icon) {
        this.addAttachmentAsSpoiler(icon);
    }

    public void addFileAsSpoiler(URL url) {
        this.addAttachmentAsSpoiler(url);
    }

    public void addAttachment(BufferedImage image, String fileName) {
        if (image == null || fileName == null) {
            throw new IllegalArgumentException("image and fileName cannot be null!");
        }
        this.attachments.add(new FileContainer(image, fileName));
    }

    public void addAttachment(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null!");
        }
        this.attachments.add(new FileContainer(file));
    }

    public void addAttachment(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon cannot be null!");
        }
        this.attachments.add(new FileContainer(icon));
    }

    public void addAttachment(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null!");
        }
        this.attachments.add(new FileContainer(url));
    }

    public void addAttachment(byte[] bytes, String fileName) {
        if (bytes == null || fileName == null) {
            throw new IllegalArgumentException("bytes and fileName cannot be null!");
        }
        this.attachments.add(new FileContainer(bytes, fileName));
    }

    public void addAttachment(InputStream stream, String fileName) {
        if (stream == null || fileName == null) {
            throw new IllegalArgumentException("stream and fileName cannot be null!");
        }
        this.attachments.add(new FileContainer(stream, fileName));
    }

    public void addAttachmentAsSpoiler(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file cannot be null!");
        }
        this.attachments.add(new FileContainer(file, true));
    }

    public void addAttachmentAsSpoiler(Icon icon) {
        if (icon == null) {
            throw new IllegalArgumentException("icon cannot be null!");
        }
        this.attachments.add(new FileContainer(icon, true));
    }

    public void addAttachmentAsSpoiler(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null!");
        }
        this.attachments.add(new FileContainer(url, true));
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public StringBuilder getStringBuilder() {
        return this.strBuilder;
    }

    public CompletableFuture<Message> send(User user) {
        return this.send((Messageable)user);
    }

    public CompletableFuture<Message> send(Messageable messageable) {
        if (messageable == null) {
            throw new IllegalStateException("Cannot send message without knowing the receiver");
        }
        if (messageable instanceof TextChannel) {
            return this.send((TextChannel)messageable);
        }
        if (messageable instanceof User) {
            return ((User)messageable).openPrivateChannel().thenCompose(this::send);
        }
        throw new IllegalStateException("Messageable of unknown type");
    }

    public CompletableFuture<Message> send(TextChannel channel) {
        ObjectNode body = JsonNodeFactory.instance.objectNode().put("content", this.toString() == null ? "" : this.toString()).put("tts", this.tts);
        body.putArray("mentions");
        if (this.embed != null) {
            ((EmbedBuilderDelegateImpl)this.embed.getDelegate()).toJsonNode(body.putObject("embed"));
        }
        if (this.nonce != null) {
            body.put("nonce", this.nonce);
        }
        RestRequest<Message> request = new RestRequest(channel.getApi(), RestMethod.POST, RestEndpoint.MESSAGE).setUrlParameters(channel.getIdAsString());
        if (!this.attachments.isEmpty() || this.embed != null && this.embed.requiresAttachments()) {
            CompletableFuture<Message> future = new CompletableFuture<Message>();
            channel.getApi().getThreadPool().getExecutorService().submit(() -> {
                try {
                    MultipartBody.Builder multipartBodyBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("payload_json", body.toString());
                    ArrayList<FileContainer> tempAttachments = new ArrayList<FileContainer>(this.attachments);
                    if (this.embed != null) {
                        tempAttachments.addAll(((EmbedBuilderDelegateImpl)this.embed.getDelegate()).getRequiredAttachments());
                    }
                    Collections.reverse(tempAttachments);
                    for (int i = 0; i < tempAttachments.size(); ++i) {
                        byte[] bytes = ((FileContainer)tempAttachments.get(i)).asByteArray(channel.getApi()).join();
                        String mediaType = URLConnection.guessContentTypeFromName(((FileContainer)tempAttachments.get(i)).getFileTypeOrName());
                        if (mediaType == null) {
                            mediaType = "application/octet-stream";
                        }
                        multipartBodyBuilder.addFormDataPart("file" + i, ((FileContainer)tempAttachments.get(i)).getFileTypeOrName(), RequestBody.create((MediaType)MediaType.parse((String)mediaType), (byte[])bytes));
                    }
                    request.setMultipartBody(multipartBodyBuilder.build());
                    request.execute(result -> ((DiscordApiImpl)channel.getApi()).getOrCreateMessage(channel, result.getJsonBody())).whenComplete((message, throwable) -> {
                        if (throwable != null) {
                            future.completeExceptionally((Throwable)throwable);
                        } else {
                            future.complete((Message)message);
                        }
                    });
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
            });
            return future;
        }
        request.setBody((JsonNode)body);
        return request.execute(result -> ((DiscordApiImpl)channel.getApi()).getOrCreateMessage(channel, result.getJsonBody()));
    }

    public String toString() {
        return this.strBuilder.toString();
    }
}

