/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.node.ObjectNode;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.channel.internal.ServerVoiceChannelUpdaterDelegate;
import org.javacord.core.entity.channel.ServerChannelUpdaterDelegateImpl;

public class ServerVoiceChannelUpdaterDelegateImpl
extends ServerChannelUpdaterDelegateImpl
implements ServerVoiceChannelUpdaterDelegate {
    protected Integer bitrate = null;
    protected Integer userLimit = null;
    protected ChannelCategory category = null;
    protected boolean modifyCategory = false;

    public ServerVoiceChannelUpdaterDelegateImpl(ServerVoiceChannel channel) {
        super((ServerChannel)channel);
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setUserLimit(int userLimit) {
        this.userLimit = userLimit;
    }

    public void removeUserLimit() {
        this.userLimit = 0;
    }

    public void setCategory(ChannelCategory category) {
        this.category = category;
        this.modifyCategory = true;
    }

    public void removeCategory() {
        this.setCategory(null);
    }

    @Override
    protected boolean prepareUpdateBody(ObjectNode body) {
        boolean patchChannel = super.prepareUpdateBody(body);
        if (this.bitrate != null) {
            body.put("bitrate", this.bitrate.intValue());
            patchChannel = true;
        }
        if (this.userLimit != null) {
            body.put("user_limit", this.userLimit.intValue());
            patchChannel = true;
        }
        if (this.modifyCategory) {
            body.put("parent_id", this.category == null ? null : this.category.getIdAsString());
            patchChannel = true;
        }
        return patchChannel;
    }
}

