/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.util.ratelimit;

import org.javacord.api.util.ratelimit.Ratelimiter;

public class LocalRatelimiter
implements Ratelimiter {
    private volatile long nextResetNanos;
    private volatile int remainingQuota;
    private final int amount;
    private final int seconds;

    public LocalRatelimiter(int amount, int seconds) {
        this.amount = amount;
        this.seconds = seconds;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getNextResetNanos() {
        return this.nextResetNanos;
    }

    public int getRemainingQuota() {
        return this.remainingQuota;
    }

    @Override
    public synchronized void requestQuota() throws InterruptedException {
        if (this.remainingQuota <= 0) {
            long sleepTime;
            while ((sleepTime = this.calculateSleepTime()) > 0L) {
                Thread.sleep(sleepTime);
            }
        }
        if (System.nanoTime() > this.nextResetNanos) {
            this.remainingQuota = this.amount;
            this.nextResetNanos = System.nanoTime() + (long)this.seconds * 1000000000L;
        }
        --this.remainingQuota;
    }

    private long calculateSleepTime() {
        return (this.nextResetNanos - System.nanoTime()) / 1000000L;
    }
}

