/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.message;

public enum MessageType {
    NORMAL(0),
    NORMAL_WEBHOOK(0),
    RECIPIENT_ADD(1),
    RECIPIENT_REMOVE(2),
    CALL(3),
    CHANNEL_NAME_CHANGE(4),
    CHANNEL_ICON_CHANGE(5),
    CHANNEL_PINNED_MESSAGE(6),
    SERVER_MEMBER_JOIN(7),
    UNKNOWN(-1);

    final int type;

    private MessageType(int type) {
        this.type = type;
    }

    public static MessageType byType(int type, boolean webhook) {
        switch (type) {
            case 0: {
                return webhook ? NORMAL_WEBHOOK : NORMAL;
            }
            case 1: {
                return RECIPIENT_ADD;
            }
            case 2: {
                return RECIPIENT_REMOVE;
            }
            case 3: {
                return CALL;
            }
            case 4: {
                return CHANNEL_NAME_CHANGE;
            }
            case 5: {
                return CHANNEL_ICON_CHANGE;
            }
            case 6: {
                return CHANNEL_PINNED_MESSAGE;
            }
            case 7: {
                return SERVER_MEMBER_JOIN;
            }
        }
        return UNKNOWN;
    }
}

