/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.api.entity.channel;

import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.permission.PermissionType;
import org.javacord.api.entity.user.User;
import org.javacord.api.listener.channel.VoiceChannelAttachableListenerManager;

public interface VoiceChannel
extends Channel,
VoiceChannelAttachableListenerManager {
    default public boolean canConnect(User user) {
        if (!this.canSee(user)) {
            return false;
        }
        Optional<ServerVoiceChannel> severVoiceChannel = this.asServerVoiceChannel();
        return !severVoiceChannel.isPresent() || severVoiceChannel.get().hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.CONNECT);
    }

    default public boolean canYouConnect() {
        return this.canConnect(this.getApi().getYourself());
    }

    default public boolean canMuteUsers(User user) {
        if (!this.canConnect(user) || this.getType() == ChannelType.PRIVATE_CHANNEL || this.getType() == ChannelType.GROUP_CHANNEL) {
            return false;
        }
        Optional<ServerVoiceChannel> serverVoiceChannel = this.asServerVoiceChannel();
        return !serverVoiceChannel.isPresent() || serverVoiceChannel.get().hasAnyPermission(user, PermissionType.ADMINISTRATOR, PermissionType.MUTE_MEMBERS);
    }

    default public boolean canYouMuteUsers() {
        return this.canMuteUsers(this.getApi().getYourself());
    }

    default public Optional<? extends VoiceChannel> getCurrentCachedInstance() {
        return this.getApi().getVoiceChannelById(this.getId());
    }

    @Override
    default public CompletableFuture<? extends VoiceChannel> getLatestInstance() {
        Optional<? extends VoiceChannel> currentCachedInstance = this.getCurrentCachedInstance();
        if (currentCachedInstance.isPresent()) {
            return CompletableFuture.completedFuture(currentCachedInstance.get());
        }
        CompletableFuture result = new CompletableFuture();
        result.completeExceptionally(new NoSuchElementException());
        return result;
    }
}

