/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Optional;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.message.MessageDeleteEvent;
import org.javacord.core.event.message.MessageDeleteEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class MessageDeleteHandler
extends PacketHandler {
    public MessageDeleteHandler(DiscordApi api) {
        super(api, true, "MESSAGE_DELETE");
    }

    @Override
    public void handle(JsonNode packet) {
        long messageId = packet.get("id").asLong();
        long channelId = packet.get("channel_id").asLong();
        this.api.getTextChannelById(channelId).ifPresent(channel -> {
            MessageDeleteEventImpl event = new MessageDeleteEventImpl(this.api, messageId, (TextChannel)channel);
            this.api.removeMessageFromCache(messageId);
            Optional<Server> optionalServer = channel.asServerChannel().map(ServerChannel::getServer);
            this.api.getEventDispatcher().dispatchMessageDeleteEvent(optionalServer.map(DispatchQueueSelector.class::cast).orElse(this.api), messageId, optionalServer.orElse(null), (TextChannel)channel, (MessageDeleteEvent)event);
            this.api.removeObjectListeners(Message.class, messageId);
        });
    }
}

