/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.guild;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.Region;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.server.DefaultMessageNotificationLevel;
import org.javacord.api.entity.server.ExplicitContentFilterLevel;
import org.javacord.api.entity.server.MultiFactorAuthenticationLevel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.VerificationLevel;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.server.ServerChangeAfkChannelEvent;
import org.javacord.api.event.server.ServerChangeAfkTimeoutEvent;
import org.javacord.api.event.server.ServerChangeDefaultMessageNotificationLevelEvent;
import org.javacord.api.event.server.ServerChangeExplicitContentFilterLevelEvent;
import org.javacord.api.event.server.ServerChangeIconEvent;
import org.javacord.api.event.server.ServerChangeMultiFactorAuthenticationLevelEvent;
import org.javacord.api.event.server.ServerChangeNameEvent;
import org.javacord.api.event.server.ServerChangeOwnerEvent;
import org.javacord.api.event.server.ServerChangeRegionEvent;
import org.javacord.api.event.server.ServerChangeSplashEvent;
import org.javacord.api.event.server.ServerChangeSystemChannelEvent;
import org.javacord.api.event.server.ServerChangeVerificationLevelEvent;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.event.server.ServerChangeAfkChannelEventImpl;
import org.javacord.core.event.server.ServerChangeAfkTimeoutEventImpl;
import org.javacord.core.event.server.ServerChangeDefaultMessageNotificationLevelEventImpl;
import org.javacord.core.event.server.ServerChangeExplicitContentFilterLevelEventImpl;
import org.javacord.core.event.server.ServerChangeIconEventImpl;
import org.javacord.core.event.server.ServerChangeMultiFactorAuthenticationLevelEventImpl;
import org.javacord.core.event.server.ServerChangeNameEventImpl;
import org.javacord.core.event.server.ServerChangeOwnerEventImpl;
import org.javacord.core.event.server.ServerChangeRegionEventImpl;
import org.javacord.core.event.server.ServerChangeSplashEventImpl;
import org.javacord.core.event.server.ServerChangeSystemChannelEventImpl;
import org.javacord.core.event.server.ServerChangeVerificationLevelEventImpl;
import org.javacord.core.event.server.ServerEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;

public class GuildUpdateHandler
extends PacketHandler {
    public GuildUpdateHandler(DiscordApi api) {
        super(api, true, "GUILD_UPDATE");
    }

    @Override
    public void handle(JsonNode packet) {
        if (packet.has("unavailable") && packet.get("unavailable").asBoolean()) {
            return;
        }
        long id = packet.get("id").asLong();
        this.api.getPossiblyUnreadyServerById(id).map(server -> (ServerImpl)server).ifPresent(server -> {
            ServerEventImpl event;
            DefaultMessageNotificationLevel oldDefaultMessageNotificationLevel;
            DefaultMessageNotificationLevel newDefaultMessageNotificationLevel;
            VerificationLevel oldVerificationLevel;
            VerificationLevel newVerificationLevel;
            long newApplicationId;
            long oldApplicationId = server.getApplicationId().orElse(-1L);
            long l = newApplicationId = packet.hasNonNull("application_id") ? packet.get("application_id").asLong() : -1L;
            if (oldApplicationId != newApplicationId) {
                server.setApplicationId(newApplicationId);
            }
            String newName = packet.get("name").asText();
            String oldName = server.getName();
            if (!Objects.deepEquals(oldName, newName)) {
                server.setName(newName);
                ServerChangeNameEventImpl event2 = new ServerChangeNameEventImpl((Server)server, newName, oldName);
                this.api.getEventDispatcher().dispatchServerChangeNameEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeNameEvent)event2);
            }
            String newIconHash = packet.get("icon").asText(null);
            String oldIconHash = server.getIconHash();
            if (!Objects.deepEquals(oldIconHash, newIconHash)) {
                server.setIconHash(newIconHash);
                ServerChangeIconEventImpl event3 = new ServerChangeIconEventImpl((Server)server, newIconHash, oldIconHash);
                this.api.getEventDispatcher().dispatchServerChangeIconEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeIconEvent)event3);
            }
            String newSplashHash = packet.get("splash").asText(null);
            String oldSplashHash = server.getSplashHash();
            if (!Objects.deepEquals(oldSplashHash, newSplashHash)) {
                server.setSplashHash(newSplashHash);
                ServerChangeSplashEventImpl event4 = new ServerChangeSplashEventImpl((Server)server, newSplashHash, oldSplashHash);
                this.api.getEventDispatcher().dispatchServerChangeSplashEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeSplashEvent)event4);
            }
            if ((newVerificationLevel = VerificationLevel.fromId((int)packet.get("verification_level").asInt())) != (oldVerificationLevel = server.getVerificationLevel())) {
                server.setVerificationLevel(newVerificationLevel);
                ServerChangeVerificationLevelEventImpl event5 = new ServerChangeVerificationLevelEventImpl((Server)server, newVerificationLevel, oldVerificationLevel);
                this.api.getEventDispatcher().dispatchServerChangeVerificationLevelEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeVerificationLevelEvent)event5);
            }
            Region newRegion = Region.getRegionByKey((String)packet.get("region").asText());
            Region oldRegion = server.getRegion();
            if (oldRegion != newRegion) {
                server.setRegion(newRegion);
                ServerChangeRegionEventImpl event6 = new ServerChangeRegionEventImpl((Server)server, newRegion, oldRegion);
                this.api.getEventDispatcher().dispatchServerChangeRegionEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeRegionEvent)event6);
            }
            if ((newDefaultMessageNotificationLevel = DefaultMessageNotificationLevel.fromId((int)packet.get("default_message_notifications").asInt())) != (oldDefaultMessageNotificationLevel = server.getDefaultMessageNotificationLevel())) {
                server.setDefaultMessageNotificationLevel(newDefaultMessageNotificationLevel);
                ServerChangeDefaultMessageNotificationLevelEventImpl event7 = new ServerChangeDefaultMessageNotificationLevelEventImpl((Server)server, newDefaultMessageNotificationLevel, oldDefaultMessageNotificationLevel);
                this.api.getEventDispatcher().dispatchServerChangeDefaultMessageNotificationLevelEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeDefaultMessageNotificationLevelEvent)event7);
            }
            long newOwnerId = packet.get("owner_id").asLong();
            User oldOwner = server.getOwner();
            if (!this.api.getCachedUserById(newOwnerId).map(oldOwner::equals).orElse(false).booleanValue()) {
                server.setOwnerId(newOwnerId);
                ServerChangeOwnerEventImpl event8 = new ServerChangeOwnerEventImpl((Server)server, newOwnerId, oldOwner);
                this.api.getEventDispatcher().dispatchServerChangeOwnerEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeOwnerEvent)event8);
            }
            if (packet.has("system_channel_id")) {
                ServerTextChannel newSystemChannel = packet.get("system_channel_id").isNull() ? null : (ServerTextChannel)server.getTextChannelById(packet.get("system_channel_id").asLong()).orElse(null);
                ServerTextChannel oldSystemChannel = server.getSystemChannel().orElse(null);
                if (oldSystemChannel != newSystemChannel) {
                    server.setSystemChannelId(newSystemChannel == null ? -1L : newSystemChannel.getId());
                    event = new ServerChangeSystemChannelEventImpl((Server)server, newSystemChannel, oldSystemChannel);
                    this.api.getEventDispatcher().dispatchServerChangeSystemChannelEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeSystemChannelEvent)event);
                }
            }
            if (packet.has("afk_channel_id")) {
                ServerVoiceChannel newAfkChannel = packet.get("afk_channel_id").isNull() ? null : (ServerVoiceChannel)server.getVoiceChannelById(packet.get("afk_channel_id").asLong()).orElse(null);
                ServerVoiceChannel oldAfkChannel = server.getAfkChannel().orElse(null);
                if (oldAfkChannel != newAfkChannel) {
                    server.setAfkChannelId(newAfkChannel == null ? -1L : newAfkChannel.getId());
                    event = new ServerChangeAfkChannelEventImpl((Server)server, newAfkChannel, oldAfkChannel);
                    this.api.getEventDispatcher().dispatchServerChangeAfkChannelEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeAfkChannelEvent)event);
                }
            }
            int newAfkTimeout = packet.get("afk_timeout").asInt();
            int oldAfkTimeout = server.getAfkTimeoutInSeconds();
            if (oldAfkTimeout != newAfkTimeout) {
                server.setAfkTimeout(newAfkTimeout);
                event = new ServerChangeAfkTimeoutEventImpl((Server)server, newAfkTimeout, oldAfkTimeout);
                this.api.getEventDispatcher().dispatchServerChangeAfkTimeoutEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeAfkTimeoutEvent)event);
            }
            ExplicitContentFilterLevel newExplicitContentFilterLevel = ExplicitContentFilterLevel.fromId((int)packet.get("explicit_content_filter").asInt());
            ExplicitContentFilterLevel oldExplicitContentFilterLevel = server.getExplicitContentFilterLevel();
            if (oldExplicitContentFilterLevel != newExplicitContentFilterLevel) {
                server.setExplicitContentFilterLevel(newExplicitContentFilterLevel);
                ServerChangeExplicitContentFilterLevelEventImpl event9 = new ServerChangeExplicitContentFilterLevelEventImpl((Server)server, newExplicitContentFilterLevel, oldExplicitContentFilterLevel);
                this.api.getEventDispatcher().dispatchServerChangeExplicitContentFilterLevelEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeExplicitContentFilterLevelEvent)event9);
            }
            MultiFactorAuthenticationLevel newMultiFactorAuthenticationLevel = MultiFactorAuthenticationLevel.fromId((int)packet.get("mfa_level").asInt());
            MultiFactorAuthenticationLevel oldMultiFactorAuthenticationLevel = server.getMultiFactorAuthenticationLevel();
            if (oldMultiFactorAuthenticationLevel != newMultiFactorAuthenticationLevel) {
                server.setMultiFactorAuthenticationLevel(newMultiFactorAuthenticationLevel);
                ServerChangeMultiFactorAuthenticationLevelEventImpl event10 = new ServerChangeMultiFactorAuthenticationLevelEventImpl((Server)server, newMultiFactorAuthenticationLevel, oldMultiFactorAuthenticationLevel);
                this.api.getEventDispatcher().dispatchServerChangeMultiFactorAuthenticationLevelEvent((DispatchQueueSelector)server, (Server)server, (ServerChangeMultiFactorAuthenticationLevelEvent)event10);
            }
        });
    }
}

