/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.Categorizable;
import org.javacord.api.entity.channel.ChannelCategory;
import org.javacord.api.entity.channel.ChannelType;
import org.javacord.api.entity.channel.GroupChannel;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.ServerTextChannel;
import org.javacord.api.entity.channel.ServerVoiceChannel;
import org.javacord.api.entity.permission.Permissions;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.user.User;
import org.javacord.api.event.channel.group.GroupChannelChangeNameEvent;
import org.javacord.api.event.channel.server.ServerChannelChangeNameEvent;
import org.javacord.api.event.channel.server.ServerChannelChangeNsfwFlagEvent;
import org.javacord.api.event.channel.server.ServerChannelChangeOverwrittenPermissionsEvent;
import org.javacord.api.event.channel.server.ServerChannelChangePositionEvent;
import org.javacord.api.event.channel.server.text.ServerTextChannelChangeSlowmodeEvent;
import org.javacord.api.event.channel.server.text.ServerTextChannelChangeTopicEvent;
import org.javacord.api.event.channel.server.voice.ServerVoiceChannelChangeBitrateEvent;
import org.javacord.api.event.channel.server.voice.ServerVoiceChannelChangeUserLimitEvent;
import org.javacord.core.entity.channel.ChannelCategoryImpl;
import org.javacord.core.entity.channel.GroupChannelImpl;
import org.javacord.core.entity.channel.ServerChannelImpl;
import org.javacord.core.entity.channel.ServerTextChannelImpl;
import org.javacord.core.entity.channel.ServerVoiceChannelImpl;
import org.javacord.core.entity.permission.PermissionsImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.event.channel.group.GroupChannelChangeNameEventImpl;
import org.javacord.core.event.channel.server.ServerChannelChangeNameEventImpl;
import org.javacord.core.event.channel.server.ServerChannelChangeNsfwFlagEventImpl;
import org.javacord.core.event.channel.server.ServerChannelChangeOverwrittenPermissionsEventImpl;
import org.javacord.core.event.channel.server.ServerChannelChangePositionEventImpl;
import org.javacord.core.event.channel.server.text.ServerTextChannelChangeSlowmodeEventImpl;
import org.javacord.core.event.channel.server.text.ServerTextChannelChangeTopicEventImpl;
import org.javacord.core.event.channel.server.voice.ServerVoiceChannelChangeBitrateEventImpl;
import org.javacord.core.event.channel.server.voice.ServerVoiceChannelChangeUserLimitEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;
import org.javacord.core.util.logging.LoggerUtil;

public class ChannelUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ChannelUpdateHandler.class);

    public ChannelUpdateHandler(DiscordApi api) {
        super(api, true, "CHANNEL_UPDATE");
    }

    @Override
    public void handle(JsonNode packet) {
        ChannelType type = ChannelType.fromId((int)packet.get("type").asInt());
        switch (type) {
            case SERVER_TEXT_CHANNEL: {
                this.handleServerChannel(packet);
                this.handleServerTextChannel(packet);
                break;
            }
            case PRIVATE_CHANNEL: {
                this.handlePrivateChannel(packet);
                break;
            }
            case SERVER_VOICE_CHANNEL: {
                this.handleServerChannel(packet);
                this.handleServerVoiceChannel(packet);
                break;
            }
            case GROUP_CHANNEL: {
                this.handleGroupChannel(packet);
                break;
            }
            case CHANNEL_CATEGORY: {
                this.handleServerChannel(packet);
                this.handleChannelCategory(packet);
                break;
            }
            case SERVER_NEWS_CHANNEL: {
                this.handleServerChannel(packet);
                break;
            }
            case SERVER_STORE_CHANNEL: {
                logger.debug("Received CHANNEL_UPDATE packet for a store channel. These are not supported in this Javacord version and get ignored!");
                break;
            }
            default: {
                logger.warn("Unknown or unexpected channel type. Your Javacord version might be out of date!");
            }
        }
    }

    private void handleServerChannel(JsonNode jsonChannel) {
        int newRawPosition;
        String newName;
        long channelId = jsonChannel.get("id").asLong();
        long guildId = jsonChannel.get("guild_id").asLong();
        ServerImpl server = this.api.getPossiblyUnreadyServerById(guildId).map(ServerImpl.class::cast).orElse(null);
        if (server == null) {
            return;
        }
        ServerChannelImpl channel = server.getChannelById(channelId).map(ServerChannelImpl.class::cast).orElse(null);
        if (channel == null) {
            return;
        }
        String oldName = channel.getName();
        if (!Objects.deepEquals(oldName, newName = jsonChannel.get("name").asText())) {
            channel.setName(newName);
            ServerChannelChangeNameEventImpl event = new ServerChannelChangeNameEventImpl(channel, newName, oldName);
            if (server.isReady()) {
                this.api.getEventDispatcher().dispatchServerChannelChangeNameEvent((DispatchQueueSelector)channel.getServer(), channel.getServer(), channel, (ServerChannelChangeNameEvent)event);
            }
        }
        AtomicBoolean areYouAffected = new AtomicBoolean(false);
        ChannelCategory oldCategory = channel.asCategorizable().flatMap(Categorizable::getCategory).orElse(null);
        ChannelCategory newCategory = jsonChannel.hasNonNull("parent_id") ? (ChannelCategory)channel.getServer().getChannelCategoryById(jsonChannel.get("parent_id").asLong(-1L)).orElse(null) : null;
        int oldRawPosition = channel.getRawPosition();
        if (oldRawPosition != (newRawPosition = jsonChannel.get("position").asInt()) || !Objects.deepEquals(oldCategory, newCategory)) {
            int oldPosition = channel.getPosition();
            if (channel instanceof ServerTextChannelImpl) {
                ((ServerTextChannelImpl)channel).setParentId(newCategory == null ? -1L : newCategory.getId());
            } else if (channel instanceof ServerVoiceChannelImpl) {
                ((ServerVoiceChannelImpl)channel).setParentId(newCategory == null ? -1L : newCategory.getId());
            }
            channel.setPosition(newRawPosition);
            int newPosition = channel.getPosition();
            ServerChannelChangePositionEventImpl event = new ServerChannelChangePositionEventImpl(channel, newPosition, oldPosition, newRawPosition, oldRawPosition, newCategory, oldCategory);
            if (server.isReady()) {
                this.api.getEventDispatcher().dispatchServerChannelChangePositionEvent((DispatchQueueSelector)channel.getServer(), channel.getServer(), channel, (ServerChannelChangePositionEvent)event);
            }
        }
        HashSet<Long> rolesWithOverwrittenPermissions = new HashSet<Long>();
        HashSet<Long> usersWithOverwrittenPermissions = new HashSet<Long>();
        if (jsonChannel.has("permission_overwrites") && !jsonChannel.get("permission_overwrites").isNull()) {
            for (JsonNode permissionOverwriteJson : jsonChannel.get("permission_overwrites")) {
                int deny;
                int allow;
                PermissionsImpl newOverwrittenPermissions;
                Permissions oldOverwrittenPermissions;
                DiscordEntity entity;
                ConcurrentHashMap<Long, Permissions> overwrittenPermissions = null;
                switch (permissionOverwriteJson.get("type").asText()) {
                    case "role": {
                        entity = (DiscordEntity)server.getRoleById(permissionOverwriteJson.get("id").asText()).orElseThrow(() -> new IllegalStateException("Received channel update event with unknown role!"));
                        oldOverwrittenPermissions = channel.getOverwrittenPermissions((Role)entity);
                        overwrittenPermissions = channel.getInternalOverwrittenRolePermissions();
                        rolesWithOverwrittenPermissions.add(entity.getId());
                        break;
                    }
                    case "member": {
                        entity = (DiscordEntity)this.api.getCachedUserById(permissionOverwriteJson.get("id").asText()).orElseThrow(() -> new IllegalStateException("Received channel update event with unknown user!"));
                        oldOverwrittenPermissions = channel.getOverwrittenPermissions((User)entity);
                        overwrittenPermissions = channel.getInternalOverwrittenUserPermissions();
                        usersWithOverwrittenPermissions.add(entity.getId());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Permission overwrite object with unknown type: " + permissionOverwriteJson.toString());
                    }
                }
                if (((Object)(newOverwrittenPermissions = new PermissionsImpl(allow = permissionOverwriteJson.get("allow").asInt(0), deny = permissionOverwriteJson.get("deny").asInt(0)))).equals(oldOverwrittenPermissions)) continue;
                overwrittenPermissions.put(entity.getId(), newOverwrittenPermissions);
                if (!server.isReady()) continue;
                this.dispatchServerChannelChangeOverwrittenPermissionsEvent(channel, newOverwrittenPermissions, oldOverwrittenPermissions, entity);
                areYouAffected.compareAndSet(false, entity instanceof User && ((User)entity).isYourself());
                areYouAffected.compareAndSet(false, entity instanceof Role && ((Role)entity).getUsers().stream().anyMatch(User::isYourself));
            }
        }
        ConcurrentHashMap<Long, Permissions> overwrittenRolePermissions = null;
        ConcurrentHashMap<Long, Permissions> overwrittenUserPermissions = null;
        overwrittenRolePermissions = channel.getInternalOverwrittenRolePermissions();
        overwrittenUserPermissions = channel.getInternalOverwrittenUserPermissions();
        Iterator<Map.Entry<Long, Permissions>> userIt = overwrittenUserPermissions.entrySet().iterator();
        while (userIt.hasNext()) {
            Map.Entry<Long, Permissions> entry = userIt.next();
            if (usersWithOverwrittenPermissions.contains(entry.getKey())) continue;
            this.api.getCachedUserById(entry.getKey()).ifPresent(user -> {
                Permissions oldPermissions = (Permissions)entry.getValue();
                userIt.remove();
                if (server.isReady()) {
                    this.dispatchServerChannelChangeOverwrittenPermissionsEvent(channel, PermissionsImpl.EMPTY_PERMISSIONS, oldPermissions, (DiscordEntity)user);
                    areYouAffected.compareAndSet(false, user.isYourself());
                }
            });
        }
        Iterator<Map.Entry<Long, Permissions>> roleIt = overwrittenRolePermissions.entrySet().iterator();
        while (roleIt.hasNext()) {
            Map.Entry<Long, Permissions> entry = roleIt.next();
            if (rolesWithOverwrittenPermissions.contains(entry.getKey())) continue;
            this.api.getRoleById(entry.getKey()).ifPresent(role -> {
                Permissions oldPermissions = (Permissions)entry.getValue();
                roleIt.remove();
                if (server.isReady()) {
                    this.dispatchServerChannelChangeOverwrittenPermissionsEvent(channel, PermissionsImpl.EMPTY_PERMISSIONS, oldPermissions, (DiscordEntity)role);
                    areYouAffected.compareAndSet(false, role.getUsers().stream().anyMatch(User::isYourself));
                }
            });
        }
        if (areYouAffected.get() && !channel.canYouSee()) {
            this.api.forEachCachedMessageWhere(msg -> msg.getChannel().getId() == channelId, msg -> this.api.removeMessageFromCache(msg.getId()));
        }
    }

    private void handleChannelCategory(JsonNode jsonChannel) {
        long channelCategoryId = jsonChannel.get("id").asLong();
        this.api.getChannelCategoryById(channelCategoryId).map(ChannelCategoryImpl.class::cast).ifPresent(channel -> {
            boolean newNsfwFlag;
            boolean oldNsfwFlag = channel.isNsfw();
            if (oldNsfwFlag != (newNsfwFlag = jsonChannel.get("nsfw").asBoolean())) {
                channel.setNsfwFlag(newNsfwFlag);
                ServerChannelChangeNsfwFlagEventImpl event = new ServerChannelChangeNsfwFlagEventImpl((ServerChannel)channel, newNsfwFlag, oldNsfwFlag);
                this.api.getEventDispatcher().dispatchServerChannelChangeNsfwFlagEvent((DispatchQueueSelector)channel.getServer(), (ChannelCategory)channel, channel.getServer(), null, (ServerChannelChangeNsfwFlagEvent)event);
            }
        });
    }

    private void handleServerTextChannel(JsonNode jsonChannel) {
        long channelId = jsonChannel.get("id").asLong();
        this.api.getTextChannelById(channelId).map(c -> (ServerTextChannelImpl)c).ifPresent(channel -> {
            int newSlowmodeDelay;
            int oldSlowmodeDelay;
            boolean newNsfwFlag;
            boolean oldNsfwFlag;
            String newTopic;
            String oldTopic = channel.getTopic();
            String string = newTopic = jsonChannel.has("topic") && !jsonChannel.get("topic").isNull() ? jsonChannel.get("topic").asText() : "";
            if (!oldTopic.equals(newTopic)) {
                channel.setTopic(newTopic);
                ServerTextChannelChangeTopicEventImpl event = new ServerTextChannelChangeTopicEventImpl((ServerTextChannel)channel, newTopic, oldTopic);
                this.api.getEventDispatcher().dispatchServerTextChannelChangeTopicEvent((DispatchQueueSelector)channel.getServer(), channel.getServer(), (ServerTextChannel)channel, (ServerTextChannelChangeTopicEvent)event);
            }
            if ((oldNsfwFlag = channel.isNsfw()) != (newNsfwFlag = jsonChannel.get("nsfw").asBoolean())) {
                channel.setNsfwFlag(newNsfwFlag);
                ServerChannelChangeNsfwFlagEventImpl event = new ServerChannelChangeNsfwFlagEventImpl((ServerChannel)channel, newNsfwFlag, oldNsfwFlag);
                this.api.getEventDispatcher().dispatchServerChannelChangeNsfwFlagEvent((DispatchQueueSelector)channel.getServer(), null, channel.getServer(), (ServerTextChannel)channel, (ServerChannelChangeNsfwFlagEvent)event);
            }
            if ((oldSlowmodeDelay = channel.getSlowmodeDelayInSeconds()) != (newSlowmodeDelay = jsonChannel.get("rate_limit_per_user").asInt(0))) {
                channel.setSlowmodeDelayInSeconds(newSlowmodeDelay);
                ServerTextChannelChangeSlowmodeEventImpl event = new ServerTextChannelChangeSlowmodeEventImpl((ServerTextChannel)channel, oldSlowmodeDelay, newSlowmodeDelay);
                this.api.getEventDispatcher().dispatchServerTextChannelChangeSlowmodeEvent((DispatchQueueSelector)channel.getServer(), channel.getServer(), (ServerTextChannel)channel, (ServerTextChannelChangeSlowmodeEvent)event);
            }
        });
    }

    private void handleServerVoiceChannel(JsonNode jsonChannel) {
        long channelId = jsonChannel.get("id").asLong();
        this.api.getServerVoiceChannelById(channelId).map(ServerVoiceChannelImpl.class::cast).ifPresent(channel -> {
            int newUserLimit;
            int oldUserLimit;
            int newBitrate;
            int oldBitrate = channel.getBitrate();
            if (oldBitrate != (newBitrate = jsonChannel.get("bitrate").asInt())) {
                channel.setBitrate(newBitrate);
                ServerVoiceChannelChangeBitrateEventImpl event = new ServerVoiceChannelChangeBitrateEventImpl((ServerVoiceChannel)channel, newBitrate, oldBitrate);
                this.api.getEventDispatcher().dispatchServerVoiceChannelChangeBitrateEvent((DispatchQueueSelector)channel.getServer(), channel.getServer(), (ServerVoiceChannel)channel, (ServerVoiceChannelChangeBitrateEvent)event);
            }
            if ((oldUserLimit = channel.getUserLimit().orElse(0).intValue()) != (newUserLimit = jsonChannel.get("user_limit").asInt())) {
                channel.setUserLimit(newUserLimit);
                ServerVoiceChannelChangeUserLimitEventImpl event = new ServerVoiceChannelChangeUserLimitEventImpl((ServerVoiceChannel)channel, newUserLimit, oldUserLimit);
                this.api.getEventDispatcher().dispatchServerVoiceChannelChangeUserLimitEvent((DispatchQueueSelector)channel.getServer(), channel.getServer(), (ServerVoiceChannel)channel, (ServerVoiceChannelChangeUserLimitEvent)event);
            }
        });
    }

    private void handlePrivateChannel(JsonNode channel) {
    }

    private void handleGroupChannel(JsonNode jsonChannel) {
        long channelId = jsonChannel.get("id").asLong();
        this.api.getGroupChannelById(channelId).map(GroupChannelImpl.class::cast).ifPresent(channel -> {
            String newName;
            String oldName = channel.getName().orElseThrow(AssertionError::new);
            if (!Objects.equals(oldName, newName = jsonChannel.get("name").asText())) {
                channel.setName(newName);
                GroupChannelChangeNameEventImpl event = new GroupChannelChangeNameEventImpl((GroupChannel)channel, newName, oldName);
                this.api.getEventDispatcher().dispatchGroupChannelChangeNameEvent((DispatchQueueSelector)this.api, Collections.singleton(channel), channel.getMembers(), (GroupChannelChangeNameEvent)event);
            }
        });
    }

    private void dispatchServerChannelChangeOverwrittenPermissionsEvent(ServerChannel channel, Permissions newPermissions, Permissions oldPermissions, DiscordEntity entity) {
        if (newPermissions.equals(oldPermissions)) {
            return;
        }
        ServerChannelChangeOverwrittenPermissionsEventImpl event = new ServerChannelChangeOverwrittenPermissionsEventImpl(channel, newPermissions, oldPermissions, entity);
        this.api.getEventDispatcher().dispatchServerChannelChangeOverwrittenPermissionsEvent((DispatchQueueSelector)channel.getServer(), entity instanceof Role ? (Role)entity : null, channel.getServer(), channel, entity instanceof User ? (User)entity : null, (ServerChannelChangeOverwrittenPermissionsEvent)event);
    }
}

