/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.webhook;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.webhook.Webhook;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.IconImpl;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class WebhookImpl
implements Webhook {
    private static final Logger logger = LoggerUtil.getLogger(WebhookImpl.class);
    private final DiscordApiImpl api;
    private final long id;
    private final Long serverId;
    private final long channelId;
    private final User user;
    private final String name;
    private final String avatarId;
    private final String token;

    public WebhookImpl(DiscordApi api, JsonNode data) {
        this.api = (DiscordApiImpl)api;
        this.id = Long.parseLong(data.get("id").asText());
        this.serverId = data.has("guild_id") ? Long.valueOf(Long.parseLong(data.get("guild_id").asText())) : null;
        this.channelId = Long.parseLong(data.get("channel_id").asText());
        this.user = data.has("user") ? this.api.getOrCreateUser(data.get("user")) : null;
        this.name = data.has("name") && !data.get("name").isNull() ? data.get("name").asText() : null;
        this.avatarId = data.has("avatar") && !data.get("avatar").isNull() ? data.get("avatar").asText() : null;
        this.token = data.has("token") ? data.get("token").asText() : null;
    }

    public DiscordApi getApi() {
        return this.api;
    }

    public long getId() {
        return this.id;
    }

    public Optional<Long> getServerId() {
        return Optional.ofNullable(this.serverId);
    }

    public Optional<Server> getServer() {
        return this.getServerId().map(this.api::getServerById).filter(Optional::isPresent).map(Optional::get);
    }

    public Optional<TextChannel> getChannel() {
        return this.api.getTextChannelById(this.getChannelId());
    }

    public long getChannelId() {
        return this.channelId;
    }

    public Optional<User> getCreator() {
        return Optional.ofNullable(this.user);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public Optional<Icon> getAvatar() {
        if (this.avatarId != null) {
            String url = "https://cdn.discordapp.com/avatars/" + this.getIdAsString() + "/" + this.avatarId + (this.avatarId.startsWith("a_") ? ".gif" : ".png");
            try {
                return Optional.of(new IconImpl(this.getApi(), new URL(url)));
            }
            catch (MalformedURLException e) {
                logger.warn("Seems like the url of the avatar is malformed! Please contact the developer!", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public Optional<String> getToken() {
        return Optional.ofNullable(this.token);
    }

    public CompletableFuture<Void> delete(String reason) {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.WEBHOOK).setUrlParameters(this.getIdAsString()).setAuditLogReason(reason).execute(result -> null);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("Webhook (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

