/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.emoji.Emoji;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.UncachedMessageUtil;
import org.javacord.api.entity.message.embed.EmbedBuilder;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.message.embed.EmbedBuilderDelegateImpl;
import org.javacord.core.listener.message.InternalUncachedMessageAttachableListenerManager;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class UncachedMessageUtilImpl
implements UncachedMessageUtil,
InternalUncachedMessageAttachableListenerManager {
    private final DiscordApiImpl api;

    public UncachedMessageUtilImpl(DiscordApiImpl api) {
        this.api = api;
    }

    public CompletableFuture<Void> delete(long channelId, long messageId) {
        return this.delete(channelId, messageId, null);
    }

    public CompletableFuture<Void> delete(String channelId, String messageId) {
        return this.delete(channelId, messageId, (String)null);
    }

    public CompletableFuture<Void> delete(long channelId, long messageId, String reason) {
        return new RestRequest(this.api, RestMethod.DELETE, RestEndpoint.MESSAGE_DELETE).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId)).setAuditLogReason(reason).execute(result -> null);
    }

    public CompletableFuture<Void> delete(String channelId, String messageId, String reason) {
        try {
            return this.delete(Long.parseLong(channelId), Long.parseLong(messageId), reason);
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> delete(long channelId, long ... messageIds) {
        Instant twoWeeksAgo = Instant.now().minus(14L, ChronoUnit.DAYS);
        Map<Boolean, List<Long>> messageIdsByAge = Arrays.stream(messageIds).distinct().boxed().collect(Collectors.groupingBy(messageId -> DiscordEntity.getCreationTimestamp((long)messageId).isAfter(twoWeeksAgo)));
        AtomicInteger batchCounter = new AtomicInteger();
        return CompletableFuture.allOf((CompletableFuture[])Stream.concat(messageIdsByAge.getOrDefault(true, Collections.emptyList()).stream().collect(Collectors.groupingBy(messageId -> batchCounter.getAndIncrement() / 100)).values().stream().map(messageIdBatch -> {
            if (messageIdBatch.size() == 1) {
                return Message.delete((DiscordApi)this.api, (long)channelId, (long)((Long)messageIdBatch.get(0)));
            }
            ObjectNode body = JsonNodeFactory.instance.objectNode();
            ArrayNode messages = body.putArray("messages");
            messageIdBatch.stream().map(Long::toUnsignedString).forEach(arg_0 -> ((ArrayNode)messages).add(arg_0));
            return new RestRequest(this.api, RestMethod.POST, RestEndpoint.MESSAGES_BULK_DELETE).setUrlParameters(Long.toUnsignedString(channelId)).setBody((JsonNode)body).execute(result -> null);
        }), messageIdsByAge.getOrDefault(false, Collections.emptyList()).stream().map(messageId -> Message.delete((DiscordApi)this.api, (long)channelId, (long)messageId))).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> delete(String channelId, String ... messageIds) {
        long[] messageLongIds = Arrays.stream(messageIds).filter(s -> {
            try {
                Long.parseLong(s);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }).mapToLong(Long::parseLong).toArray();
        return this.delete(Long.parseLong(channelId), messageLongIds);
    }

    public CompletableFuture<Void> delete(Message ... messages) {
        return CompletableFuture.allOf((CompletableFuture[])Arrays.stream(messages).collect(Collectors.groupingBy(message -> message.getChannel().getId(), Collectors.mapping(DiscordEntity::getId, Collectors.toList()))).entrySet().stream().map(entry -> this.delete((long)((Long)entry.getKey()), ((List)entry.getValue()).stream().mapToLong(Long::longValue).toArray())).toArray(CompletableFuture[]::new));
    }

    public CompletableFuture<Void> delete(Iterable<Message> messages) {
        return this.delete((Message[])StreamSupport.stream(messages.spliterator(), false).toArray(Message[]::new));
    }

    public CompletableFuture<Void> edit(long channelId, long messageId, String content) {
        return this.edit(channelId, messageId, content, true, null, false);
    }

    public CompletableFuture<Void> edit(String channelId, String messageId, String content) {
        return this.edit(channelId, messageId, content, true, null, false);
    }

    public CompletableFuture<Void> edit(long channelId, long messageId, EmbedBuilder embed) {
        return this.edit(channelId, messageId, null, false, embed, true);
    }

    public CompletableFuture<Void> edit(String channelId, String messageId, EmbedBuilder embed) {
        return this.edit(channelId, messageId, null, false, embed, true);
    }

    public CompletableFuture<Void> edit(long channelId, long messageId, String content, EmbedBuilder embed) {
        return this.edit(channelId, messageId, content, true, embed, true);
    }

    public CompletableFuture<Void> edit(String channelId, String messageId, String content, EmbedBuilder embed) {
        return this.edit(channelId, messageId, content, true, embed, true);
    }

    public CompletableFuture<Void> edit(long channelId, long messageId, String content, boolean updateContent, EmbedBuilder embed, boolean updateEmbed) {
        ObjectNode body = JsonNodeFactory.instance.objectNode();
        if (updateContent) {
            if (content == null) {
                body.putNull("content");
            } else {
                body.put("content", content);
            }
        }
        if (updateEmbed) {
            if (embed == null) {
                body.putNull("embed");
            } else {
                ((EmbedBuilderDelegateImpl)embed.getDelegate()).toJsonNode(body.putObject("embed"));
            }
        }
        return new RestRequest(this.api, RestMethod.PATCH, RestEndpoint.MESSAGE).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId)).setBody((JsonNode)body).execute(result -> null);
    }

    public CompletableFuture<Void> edit(String channelId, String messageId, String content, boolean updateContent, EmbedBuilder embed, boolean updateEmbed) {
        try {
            return this.edit(Long.parseLong(channelId), Long.parseLong(messageId), content, true, embed, true);
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> removeContent(long channelId, long messageId) {
        return this.edit(channelId, messageId, null, true, null, false);
    }

    public CompletableFuture<Void> removeContent(String channelId, String messageId) {
        return this.edit(channelId, messageId, null, true, null, false);
    }

    public CompletableFuture<Void> removeEmbed(long channelId, long messageId) {
        return this.edit(channelId, messageId, null, false, null, true);
    }

    public CompletableFuture<Void> removeEmbed(String channelId, String messageId) {
        return this.edit(channelId, messageId, null, false, null, true);
    }

    public CompletableFuture<Void> removeContentAndEmbed(long channelId, long messageId) {
        return this.edit(channelId, messageId, null, true, null, true);
    }

    public CompletableFuture<Void> removeContentAndEmbed(String channelId, String messageId) {
        return this.edit(channelId, messageId, null, true, null, true);
    }

    public CompletableFuture<Void> addReaction(long channelId, long messageId, String unicodeEmoji) {
        return new RestRequest(this.api, RestMethod.PUT, RestEndpoint.REACTION).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId), unicodeEmoji, "@me").execute(result -> null);
    }

    public CompletableFuture<Void> addReaction(String channelId, String messageId, String unicodeEmoji) {
        try {
            return this.addReaction(Long.parseLong(channelId), Long.parseLong(messageId), unicodeEmoji);
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> addReaction(long channelId, long messageId, Emoji emoji) {
        String value = emoji.asUnicodeEmoji().orElseGet(() -> emoji.asCustomEmoji().map(e -> e.getName() + ":" + e.getIdAsString()).orElse("UNKNOWN"));
        return new RestRequest(this.api, RestMethod.PUT, RestEndpoint.REACTION).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId), value, "@me").execute(result -> null);
    }

    public CompletableFuture<Void> addReaction(String channelId, String messageId, Emoji emoji) {
        try {
            return this.addReaction(Long.parseLong(channelId), Long.parseLong(messageId), emoji);
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> removeAllReactions(long channelId, long messageId) {
        return new RestRequest(this.api, RestMethod.DELETE, RestEndpoint.REACTION).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId)).execute(result -> null);
    }

    public CompletableFuture<Void> removeAllReactions(String channelId, String messageId) {
        try {
            return this.removeAllReactions(Long.parseLong(channelId), Long.parseLong(messageId));
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> pin(long channelId, long messageId) {
        return new RestRequest(this.api, RestMethod.PUT, RestEndpoint.PINS).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId)).execute(result -> null);
    }

    public CompletableFuture<Void> pin(String channelId, String messageId) {
        try {
            return this.pin(Long.parseLong(channelId), Long.parseLong(messageId));
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> unpin(long channelId, long messageId) {
        return new RestRequest(this.api, RestMethod.DELETE, RestEndpoint.PINS).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId)).execute(result -> null);
    }

    public CompletableFuture<Void> unpin(String channelId, String messageId) {
        try {
            return this.unpin(Long.parseLong(channelId), Long.parseLong(messageId));
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<List<User>> getUsersWhoReactedWithEmoji(long channelId, long messageId, Emoji emoji) {
        CompletableFuture<List<User>> future = new CompletableFuture<List<User>>();
        this.api.getThreadPool().getExecutorService().submit(() -> {
            try {
                String value = emoji.asUnicodeEmoji().orElseGet(() -> emoji.asCustomEmoji().map(e -> e.getName() + ":" + e.getIdAsString()).orElse("UNKNOWN"));
                ArrayList users = new ArrayList();
                boolean requestMore = true;
                while (requestMore) {
                    RestRequest<List> request = new RestRequest(this.api, RestMethod.GET, RestEndpoint.REACTION).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId), value).addQueryParameter("limit", "100");
                    if (!users.isEmpty()) {
                        request.addQueryParameter("after", ((User)users.get(users.size() - 1)).getIdAsString());
                    }
                    List incompleteUsers = request.execute(result -> {
                        ArrayList<User> paginatedUsers = new ArrayList<User>();
                        for (JsonNode userJson : result.getJsonBody()) {
                            paginatedUsers.add(this.api.getOrCreateUser(userJson));
                        }
                        return Collections.unmodifiableList(paginatedUsers);
                    }).join();
                    users.addAll(incompleteUsers);
                    requestMore = incompleteUsers.size() >= 100;
                }
                future.complete(Collections.unmodifiableList(users));
            }
            catch (Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public CompletableFuture<List<User>> getUsersWhoReactedWithEmoji(String channelId, String messageId, Emoji emoji) {
        try {
            return this.getUsersWhoReactedWithEmoji(Long.parseLong(channelId), Long.parseLong(messageId), emoji);
        }
        catch (NumberFormatException e) {
            CompletableFuture<List<User>> future = new CompletableFuture<List<User>>();
            future.completeExceptionally(e);
            return future;
        }
    }

    public CompletableFuture<Void> removeUserReactionByEmoji(long channelId, long messageId, Emoji emoji, User user) {
        String value = emoji.asUnicodeEmoji().orElseGet(() -> emoji.asCustomEmoji().map(e -> e.getName() + ":" + e.getIdAsString()).orElse("UNKNOWN"));
        return new RestRequest(this.api, RestMethod.DELETE, RestEndpoint.REACTION).setUrlParameters(Long.toUnsignedString(channelId), Long.toUnsignedString(messageId), value, user.isYourself() ? "@me" : user.getIdAsString()).execute(result -> null);
    }

    public CompletableFuture<Void> removeUserReactionByEmoji(String channelId, String messageId, Emoji emoji, User user) {
        try {
            return this.removeUserReactionByEmoji(Long.parseLong(channelId), Long.parseLong(messageId), emoji, user);
        }
        catch (NumberFormatException e) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(e);
            return future;
        }
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }
}

