/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.emoji.CustomEmoji;
import org.javacord.api.entity.emoji.Emoji;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageActivity;
import org.javacord.api.entity.message.MessageAttachment;
import org.javacord.api.entity.message.MessageAuthor;
import org.javacord.api.entity.message.MessageType;
import org.javacord.api.entity.message.Reaction;
import org.javacord.api.entity.message.embed.Embed;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.user.User;
import org.javacord.api.util.DiscordRegexPattern;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.emoji.UnicodeEmojiImpl;
import org.javacord.core.entity.message.MessageActivityImpl;
import org.javacord.core.entity.message.MessageAttachmentImpl;
import org.javacord.core.entity.message.MessageAuthorImpl;
import org.javacord.core.entity.message.ReactionImpl;
import org.javacord.core.entity.message.embed.EmbedImpl;
import org.javacord.core.listener.message.InternalMessageAttachableListenerManager;
import org.javacord.core.util.cache.MessageCacheImpl;

public class MessageImpl
implements Message,
InternalMessageAttachableListenerManager {
    private final DiscordApiImpl api;
    private final TextChannel channel;
    private final long id;
    private volatile String content;
    private final MessageType type;
    private volatile boolean pinned;
    private volatile boolean tts;
    private volatile boolean mentionsEveryone;
    private volatile Instant lastEditTime;
    private final MessageAuthor author;
    private final MessageActivityImpl activity;
    private volatile boolean cacheForever = false;
    private final List<Embed> embeds = new ArrayList<Embed>();
    private final List<Reaction> reactions = new ArrayList<Reaction>();
    private final List<MessageAttachment> attachments = new ArrayList<MessageAttachment>();
    private final List<User> mentions = new ArrayList<User>();
    private final List<Role> roleMentions = new ArrayList<Role>();

    public MessageImpl(DiscordApiImpl api, TextChannel channel, JsonNode data) {
        this.api = api;
        this.channel = channel;
        this.id = data.get("id").asLong();
        this.content = data.get("content").asText();
        this.pinned = data.get("pinned").asBoolean(false);
        this.tts = data.get("tts").asBoolean(false);
        this.mentionsEveryone = data.get("mention_everyone").asBoolean(false);
        this.lastEditTime = data.has("edited_timestamp") && !data.get("edited_timestamp").isNull() ? OffsetDateTime.parse(data.get("edited_timestamp").asText()).toInstant() : null;
        this.type = MessageType.byType((int)data.get("type").asInt(), (boolean)data.has("webhook_id"));
        Long webhookId = data.has("webhook_id") ? Long.valueOf(data.get("webhook_id").asLong()) : null;
        this.author = new MessageAuthorImpl(this, webhookId, data.get("author"));
        MessageCacheImpl cache = (MessageCacheImpl)channel.getMessageCache();
        cache.addMessage(this);
        if (data.has("embeds")) {
            for (JsonNode embedJson : data.get("embeds")) {
                EmbedImpl embed = new EmbedImpl(embedJson);
                this.embeds.add(embed);
            }
        }
        if (data.has("reactions")) {
            for (JsonNode reactionJson : data.get("reactions")) {
                ReactionImpl reaction = new ReactionImpl(this, reactionJson);
                this.reactions.add(reaction);
            }
        }
        if (data.has("attachments")) {
            for (JsonNode attachmentJson : data.get("attachments")) {
                MessageAttachmentImpl attachment = new MessageAttachmentImpl(this, attachmentJson);
                this.attachments.add(attachment);
            }
        }
        if (data.has("mentions")) {
            for (JsonNode mentionJson : data.get("mentions")) {
                User user = api.getOrCreateUser(mentionJson);
                this.mentions.add(user);
            }
        }
        if (data.has("mention_roles") && !data.get("mention_roles").isNull()) {
            this.getServer().ifPresent(server -> {
                for (JsonNode roleMentionJson : data.get("mention_roles")) {
                    server.getRoleById(roleMentionJson.asText()).ifPresent(this.roleMentions::add);
                }
            });
        }
        this.activity = data.has("activity") && !data.get("activity").isNull() ? new MessageActivityImpl(this, data.get("activity")) : null;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setMentionsEveryone(boolean mentionsEveryone) {
        this.mentionsEveryone = mentionsEveryone;
    }

    public void setLastEditTime(Instant lastEditTime) {
        this.lastEditTime = lastEditTime;
    }

    public void setEmbeds(List<Embed> embeds) {
        this.embeds.clear();
        this.embeds.addAll(embeds);
    }

    public void setTts(boolean tts) {
        this.tts = tts;
    }

    public void addReaction(Emoji emoji, boolean you) {
        Optional<Reaction> reaction = this.reactions.stream().filter(r -> emoji.equalsEmoji(r.getEmoji())).findAny();
        reaction.ifPresent(r -> ((ReactionImpl)r).incrementCount(you));
        if (!reaction.isPresent()) {
            this.reactions.add(new ReactionImpl(this, emoji, 1, you));
        }
    }

    public void removeReaction(Emoji emoji, boolean you) {
        Optional<Reaction> reaction = this.reactions.stream().filter(r -> emoji.equalsEmoji(r.getEmoji())).findAny();
        reaction.ifPresent(r -> ((ReactionImpl)r).decrementCount(you));
        this.reactions.removeIf(r -> r.getCount() <= 0);
    }

    public void removeAllReactionsFromCache() {
        this.reactions.clear();
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public String getContent() {
        return this.content;
    }

    public Optional<Instant> getLastEditTimestamp() {
        return Optional.ofNullable(this.lastEditTime);
    }

    public List<MessageAttachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    public List<CustomEmoji> getCustomEmojis() {
        String content = this.getContent();
        ArrayList<CustomEmoji> emojis = new ArrayList<CustomEmoji>();
        Matcher customEmoji = DiscordRegexPattern.CUSTOM_EMOJI.matcher(content);
        while (customEmoji.find()) {
            long id = Long.parseLong(customEmoji.group("id"));
            String name = customEmoji.group("name");
            boolean animated = customEmoji.group(0).charAt(1) == 'a';
            CustomEmoji emoji = ((DiscordApiImpl)this.getApi()).getKnownCustomEmojiOrCreateCustomEmoji(id, name, animated);
            emojis.add(emoji);
        }
        return Collections.unmodifiableList(emojis);
    }

    public MessageType getType() {
        return this.type;
    }

    public TextChannel getChannel() {
        return this.channel;
    }

    public Optional<MessageActivity> getActivity() {
        return Optional.ofNullable(this.activity);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isTts() {
        return this.tts;
    }

    public boolean mentionsEveryone() {
        return this.mentionsEveryone;
    }

    public List<Embed> getEmbeds() {
        return Collections.unmodifiableList(new ArrayList<Embed>(this.embeds));
    }

    public MessageAuthor getAuthor() {
        return this.author;
    }

    public Optional<User> getUserAuthor() {
        return this.author.asUser();
    }

    public boolean isCachedForever() {
        return this.cacheForever;
    }

    public void setCachedForever(boolean cachedForever) {
        this.cacheForever = cachedForever;
        if (cachedForever) {
            ((MessageCacheImpl)this.channel.getMessageCache()).addMessage(this);
            ((MessageCacheImpl)this.channel.getMessageCache()).addCacheForeverMessage(this);
        } else {
            ((MessageCacheImpl)this.channel.getMessageCache()).removeCacheForeverMessage(this);
        }
    }

    public List<Reaction> getReactions() {
        return Collections.unmodifiableList(new ArrayList<Reaction>(this.reactions));
    }

    public List<User> getMentionedUsers() {
        return Collections.unmodifiableList(new ArrayList<User>(this.mentions));
    }

    public List<Role> getMentionedRoles() {
        return Collections.unmodifiableList(new ArrayList<Role>(this.roleMentions));
    }

    public CompletableFuture<Void> addReactions(String ... unicodeEmojis) {
        return this.addReactions((Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> removeReactionByEmoji(User user, String unicodeEmoji) {
        return this.removeReactionByEmoji(user, UnicodeEmojiImpl.fromString(unicodeEmoji));
    }

    public CompletableFuture<Void> removeReactionByEmoji(String unicodeEmoji) {
        return this.removeReactionByEmoji(UnicodeEmojiImpl.fromString(unicodeEmoji));
    }

    public CompletableFuture<Void> removeReactionsByEmoji(User user, String ... unicodeEmojis) {
        return this.removeReactionsByEmoji(user, (Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> removeReactionsByEmoji(String ... unicodeEmojis) {
        return this.removeReactionsByEmoji((Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public CompletableFuture<Void> removeOwnReactionByEmoji(String unicodeEmoji) {
        return this.removeOwnReactionByEmoji(UnicodeEmojiImpl.fromString(unicodeEmoji));
    }

    public CompletableFuture<Void> removeOwnReactionsByEmoji(String ... unicodeEmojis) {
        return this.removeOwnReactionsByEmoji((Emoji[])Arrays.stream(unicodeEmojis).map(UnicodeEmojiImpl::fromString).toArray(Emoji[]::new));
    }

    public int compareTo(Message otherMessage) {
        return Long.compareUnsigned(this.getId(), otherMessage.getId());
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("Message (id: %s, content: %s)", this.getIdAsString(), this.getContent());
    }
}

