/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.Icon;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.GroupChannel;
import org.javacord.api.entity.user.User;
import org.javacord.api.util.cache.MessageCache;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.IconImpl;
import org.javacord.core.entity.channel.InternalTextChannel;
import org.javacord.core.listener.channel.group.InternalGroupChannelAttachableListenerManager;
import org.javacord.core.util.Cleanupable;
import org.javacord.core.util.cache.MessageCacheImpl;
import org.javacord.core.util.logging.LoggerUtil;

public class GroupChannelImpl
implements GroupChannel,
Cleanupable,
InternalTextChannel,
InternalGroupChannelAttachableListenerManager {
    private static final Logger logger = LoggerUtil.getLogger(GroupChannelImpl.class);
    private final DiscordApiImpl api;
    private final long id;
    private volatile String name;
    private volatile String iconId;
    private final List<User> recipients = new ArrayList<User>();
    private final MessageCacheImpl messageCache;

    public GroupChannelImpl(DiscordApiImpl api, JsonNode data) {
        this.api = api;
        for (JsonNode recipientJson : data.get("recipients")) {
            this.recipients.add(api.getOrCreateUser(recipientJson));
        }
        this.messageCache = new MessageCacheImpl(api, api.getDefaultMessageCacheCapacity(), api.getDefaultMessageCacheStorageTimeInSeconds(), api.isDefaultAutomaticMessageCacheCleanupEnabled());
        this.id = Long.parseLong(data.get("id").asText());
        this.name = data.has("name") && !data.get("name").isNull() ? data.get("name").asText() : null;
        this.iconId = data.has("icon") && !data.get("icon").isNull() ? data.get("icon").asText() : null;
        api.addChannelToCache((Channel)this);
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public MessageCache getMessageCache() {
        return this.messageCache;
    }

    public Collection<User> getMembers() {
        return Collections.unmodifiableCollection(this.recipients);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public Optional<Icon> getIcon() {
        if (this.iconId == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(new IconImpl(this.getApi(), new URL("https://cdn.discordapp.com/channel-icons/" + this.getIdAsString() + "/" + this.iconId + ".png")));
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the icon is malformed! Please contact the developer!", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    public void cleanup() {
        this.messageCache.cleanup();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("GroupChannel (id: %s, name: %s)", this.getIdAsString(), this.getName());
    }
}

