/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.Proxy;
import java.net.ProxySelector;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.Dns;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.logging.log4j.Logger;
import org.javacord.api.AccountType;
import org.javacord.api.DiscordApi;
import org.javacord.api.Javacord;
import org.javacord.api.entity.ApplicationInfo;
import org.javacord.api.entity.activity.Activity;
import org.javacord.api.entity.activity.ActivityType;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.emoji.CustomEmoji;
import org.javacord.api.entity.emoji.KnownCustomEmoji;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.MessageSet;
import org.javacord.api.entity.message.UncachedMessageUtil;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.server.invite.Invite;
import org.javacord.api.entity.user.User;
import org.javacord.api.entity.user.UserStatus;
import org.javacord.api.entity.webhook.Webhook;
import org.javacord.api.listener.GloballyAttachableListener;
import org.javacord.api.listener.ObjectAttachableListener;
import org.javacord.api.util.concurrent.ThreadPool;
import org.javacord.api.util.event.ListenerManager;
import org.javacord.api.util.ratelimit.Ratelimiter;
import org.javacord.core.entity.activity.ActivityImpl;
import org.javacord.core.entity.activity.ApplicationInfoImpl;
import org.javacord.core.entity.emoji.CustomEmojiImpl;
import org.javacord.core.entity.emoji.KnownCustomEmojiImpl;
import org.javacord.core.entity.message.MessageImpl;
import org.javacord.core.entity.message.MessageSetImpl;
import org.javacord.core.entity.message.UncachedMessageUtilImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.entity.server.invite.InviteImpl;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.entity.webhook.WebhookImpl;
import org.javacord.core.util.ClassHelper;
import org.javacord.core.util.Cleanupable;
import org.javacord.core.util.concurrent.ThreadPoolImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.event.EventDispatcher;
import org.javacord.core.util.event.ListenerManagerImpl;
import org.javacord.core.util.gateway.DiscordWebSocketAdapter;
import org.javacord.core.util.http.ProxyAuthenticator;
import org.javacord.core.util.http.TrustAllTrustManager;
import org.javacord.core.util.logging.LoggerUtil;
import org.javacord.core.util.ratelimit.RatelimitManager;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class DiscordApiImpl
implements DiscordApi,
DispatchQueueSelector {
    private static final Logger logger = LoggerUtil.getLogger(DiscordApiImpl.class);
    private final ThreadPoolImpl threadPool = new ThreadPoolImpl();
    private final OkHttpClient httpClient;
    private final EventDispatcher eventDispatcher;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final RatelimitManager ratelimitManager = new RatelimitManager(this);
    private final UncachedMessageUtil uncachedMessageUtil = new UncachedMessageUtilImpl(this);
    private volatile DiscordWebSocketAdapter websocketAdapter = null;
    private final AccountType accountType;
    private final String token;
    private volatile boolean disconnectCalled = false;
    private final Object disconnectCalledLock = new Object();
    private volatile UserStatus status = UserStatus.ONLINE;
    private volatile Activity activity;
    private volatile int defaultMessageCacheCapacity = 50;
    private volatile int defaultMessageCacheStorageTimeInSeconds = 43200;
    private boolean defaultAutomaticMessageCacheCleanupEnabled = true;
    private volatile Function<Integer, Integer> reconnectDelayProvider;
    private final int currentShard;
    private final int totalShards;
    private final boolean waitForServersOnStartup;
    private final Ratelimiter globalRatelimiter;
    private final ProxySelector proxySelector;
    private final Proxy proxy;
    private final org.javacord.api.util.auth.Authenticator proxyAuthenticator;
    private final boolean trustAllCertificates;
    private volatile User you;
    private volatile long clientId = -1L;
    private volatile long ownerId = -1L;
    private volatile Long timeOffset = null;
    private final Map<Long, WeakReference<User>> users = Collections.synchronizedMap(new ConcurrentHashMap());
    private final Map<Reference<? extends User>, Long> userIdByRef = Collections.synchronizedMap(new WeakHashMap());
    private final ReferenceQueue<User> usersCleanupQueue = new ReferenceQueue();
    private final ConcurrentHashMap<Long, Channel> channels = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Server> servers = new ConcurrentHashMap();
    private final ConcurrentHashMap<Long, Server> nonReadyServers = new ConcurrentHashMap();
    private final HashSet<Long> unavailableServers = new HashSet();
    private final ConcurrentHashMap<Long, KnownCustomEmoji> customEmojis = new ConcurrentHashMap();
    private final Map<Long, WeakReference<Message>> messages = Collections.synchronizedMap(new ConcurrentHashMap());
    private final Map<Reference<? extends Message>, Long> messageIdByRef = Collections.synchronizedMap(new WeakHashMap());
    private final ReferenceQueue<Message> messagesCleanupQueue = new ReferenceQueue();
    private final Map<Class<? extends GloballyAttachableListener>, Map<GloballyAttachableListener, ListenerManagerImpl<? extends GloballyAttachableListener>>> listeners = Collections.synchronizedMap(new ConcurrentHashMap());
    private final Map<Class<?>, Map<Long, Map<Class<? extends ObjectAttachableListener>, Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>>>>> objectListeners = Collections.synchronizedMap(new ConcurrentHashMap());

    public DiscordApiImpl(String token, Ratelimiter globalRatelimiter, ProxySelector proxySelector, Proxy proxy, org.javacord.api.util.auth.Authenticator proxyAuthenticator, boolean trustAllCertificates) {
        this(AccountType.BOT, token, 0, 1, false, globalRatelimiter, proxySelector, proxy, proxyAuthenticator, trustAllCertificates, null);
    }

    public DiscordApiImpl(AccountType accountType, String token, int currentShard, int totalShards, boolean waitForServersOnStartup, Ratelimiter globalRatelimiter, ProxySelector proxySelector, Proxy proxy, org.javacord.api.util.auth.Authenticator proxyAuthenticator, boolean trustAllCertificates, CompletableFuture<DiscordApi> ready) {
        this(accountType, token, currentShard, totalShards, waitForServersOnStartup, globalRatelimiter, proxySelector, proxy, proxyAuthenticator, trustAllCertificates, ready, null, Collections.emptyMap(), Collections.emptyList());
    }

    private DiscordApiImpl(AccountType accountType, String token, int currentShard, int totalShards, boolean waitForServersOnStartup, Ratelimiter globalRatelimiter, ProxySelector proxySelector, Proxy proxy, org.javacord.api.util.auth.Authenticator proxyAuthenticator, boolean trustAllCertificates, CompletableFuture<DiscordApi> ready, Dns dns) {
        this(accountType, token, currentShard, totalShards, waitForServersOnStartup, globalRatelimiter, proxySelector, proxy, proxyAuthenticator, trustAllCertificates, ready, dns, Collections.emptyMap(), Collections.emptyList());
    }

    public DiscordApiImpl(AccountType accountType, String token, int currentShard, int totalShards, boolean waitForServersOnStartup, Ratelimiter globalRatelimiter, ProxySelector proxySelector, Proxy proxy, org.javacord.api.util.auth.Authenticator proxyAuthenticator, boolean trustAllCertificates, CompletableFuture<DiscordApi> ready, Dns dns, Map<Class<? extends GloballyAttachableListener>, List<Function<DiscordApi, GloballyAttachableListener>>> listenerSourceMap, List<Function<DiscordApi, GloballyAttachableListener>> unspecifiedListeners) {
        this.accountType = accountType;
        this.token = token;
        this.currentShard = currentShard;
        this.totalShards = totalShards;
        this.waitForServersOnStartup = waitForServersOnStartup;
        this.globalRatelimiter = globalRatelimiter;
        this.proxySelector = proxySelector;
        this.proxy = proxy;
        this.proxyAuthenticator = proxyAuthenticator;
        this.trustAllCertificates = trustAllCertificates;
        this.reconnectDelayProvider = x -> (int)Math.round(Math.pow(x.intValue(), 1.5) - 1.0 / (1.0 / (0.1 * (double)x.intValue()) + 1.0) * Math.pow(x.intValue(), 1.5));
        if (proxySelector != null && proxy != null) {
            throw new IllegalStateException("proxy and proxySelector must not be configured both");
        }
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().addInterceptor(chain -> chain.proceed(chain.request().newBuilder().addHeader("User-Agent", Javacord.USER_AGENT).build())).addInterceptor((Interceptor)new HttpLoggingInterceptor(arg_0 -> ((Logger)LoggerUtil.getLogger(OkHttpClient.class)).trace(arg_0)).setLevel(HttpLoggingInterceptor.Level.BODY)).proxyAuthenticator((Authenticator)new ProxyAuthenticator(proxyAuthenticator)).proxy(proxy);
        if (proxySelector != null) {
            httpClientBuilder.proxySelector(proxySelector);
        }
        if (dns != null) {
            httpClientBuilder.dns(dns);
        }
        if (trustAllCertificates) {
            logger.warn("All SSL certificates are trusted when connecting to the Discord API and websocket. This increases the risk of man-in-the-middle attacks!");
            TrustAllTrustManager trustManager = new TrustAllTrustManager();
            httpClientBuilder.sslSocketFactory(trustManager.createSslSocketFactory(), (X509TrustManager)trustManager);
        }
        this.httpClient = httpClientBuilder.build();
        this.eventDispatcher = new EventDispatcher(this);
        if (ready != null) {
            this.getThreadPool().getExecutorService().submit(() -> {
                try {
                    this.websocketAdapter = new DiscordWebSocketAdapter(this);
                    this.websocketAdapter.isReady().whenComplete((readyReceived, throwable) -> {
                        if (readyReceived.booleanValue()) {
                            listenerSourceMap.forEach((clazz, listenerSources) -> listenerSources.forEach(listenerSource -> {
                                Class type = clazz;
                                GloballyAttachableListener listener = (GloballyAttachableListener)listenerSource.apply(this);
                                this.addListener(type, (GloballyAttachableListener)type.cast(listener));
                            }));
                            unspecifiedListeners.stream().map(source -> (GloballyAttachableListener)source.apply(this)).forEach(this::addListener);
                            if (accountType == AccountType.BOT) {
                                this.getApplicationInfo().whenComplete((applicationInfo, exception) -> {
                                    if (exception != null) {
                                        logger.error("Could not access self application info on startup!", exception);
                                    } else {
                                        this.clientId = applicationInfo.getClientId();
                                        this.ownerId = applicationInfo.getOwnerId();
                                    }
                                    ready.complete(this);
                                });
                            } else {
                                ready.complete(this);
                            }
                        } else {
                            this.threadPool.shutdown();
                            ready.completeExceptionally(new IllegalStateException("Websocket closed before READY packet was received!"));
                        }
                    });
                }
                catch (Throwable t) {
                    if (this.websocketAdapter != null) {
                        this.websocketAdapter.disconnect();
                    }
                    ready.completeExceptionally(t);
                }
            });
            this.getThreadPool().getScheduler().scheduleWithFixedDelay(() -> {
                try {
                    Reference<User> userRef = this.usersCleanupQueue.poll();
                    while (userRef != null) {
                        Long userId = this.userIdByRef.remove(userRef);
                        if (userId != null) {
                            this.users.remove(userId, userRef);
                        }
                        userRef = this.usersCleanupQueue.poll();
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to process users cleanup queue!", t);
                }
            }, 30L, 30L, TimeUnit.SECONDS);
            this.getThreadPool().getScheduler().scheduleWithFixedDelay(() -> {
                try {
                    Reference<Message> messageRef = this.messagesCleanupQueue.poll();
                    while (messageRef != null) {
                        Long messageId = this.messageIdByRef.remove(messageRef);
                        if (messageId != null) {
                            this.messages.remove(messageId, messageRef);
                        }
                        messageRef = this.messagesCleanupQueue.poll();
                    }
                }
                catch (Throwable t) {
                    logger.error("Failed to process messages cleanup queue!", t);
                }
            }, 30L, 30L, TimeUnit.SECONDS);
            ready.thenAccept(api -> {
                WeakReference<DiscordApi> discordApiReference = new WeakReference<DiscordApi>((DiscordApi)api);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> Optional.ofNullable((DiscordApi)discordApiReference.get()).ifPresent(DiscordApi::disconnect), String.format("Javacord - Shutdown Disconnector (%s)", api)));
            });
        } else {
            WeakReference<DiscordApiImpl> discordApiReference = new WeakReference<DiscordApiImpl>(this);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> Optional.ofNullable((DiscordApi)discordApiReference.get()).ifPresent(DiscordApi::disconnect), String.format("Javacord - Shutdown Disconnector (%s)", this)));
        }
    }

    public OkHttpClient getHttpClient() {
        if (this.disconnectCalled) {
            throw new IllegalStateException("disconnect was called already");
        }
        return this.httpClient;
    }

    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public RatelimitManager getRatelimitManager() {
        return this.ratelimitManager;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeCache() {
        Map<Long, WeakReference<User>> map = this.users;
        synchronized (map) {
            this.users.values().stream().map(Reference::get).filter(Objects::nonNull).map(Cleanupable.class::cast).forEach(Cleanupable::cleanup);
            this.users.clear();
        }
        this.userIdByRef.clear();
        this.servers.values().stream().map(Cleanupable.class::cast).forEach(Cleanupable::cleanup);
        this.servers.clear();
        this.channels.values().stream().filter(Cleanupable.class::isInstance).map(Cleanupable.class::cast).forEach(Cleanupable::cleanup);
        this.channels.clear();
        this.unavailableServers.clear();
        this.customEmojis.clear();
        this.messages.clear();
        this.messageIdByRef.clear();
        this.timeOffset = null;
    }

    public Collection<Server> getAllServers() {
        ArrayList<Server> allServers = new ArrayList<Server>(this.nonReadyServers.values());
        allServers.addAll(this.servers.values());
        return Collections.unmodifiableList(allServers);
    }

    public Optional<Server> getPossiblyUnreadyServerById(long id) {
        if (this.nonReadyServers.containsKey(id)) {
            return Optional.ofNullable(this.nonReadyServers.get(id));
        }
        return Optional.ofNullable(this.servers.get(id));
    }

    public void addServerToCache(ServerImpl server) {
        this.removeServerFromCache(server.getId());
        this.nonReadyServers.put(server.getId(), server);
        server.addServerReadyConsumer(s -> {
            this.nonReadyServers.remove(s.getId());
            this.removeUnavailableServerFromCache(s.getId());
            this.servers.put(s.getId(), (Server)s);
        });
    }

    public void removeServerFromCache(long serverId) {
        this.servers.computeIfPresent(serverId, (key, server) -> {
            ((Cleanupable)server).cleanup();
            return null;
        });
        this.nonReadyServers.computeIfPresent(serverId, (key, server) -> {
            ((Cleanupable)server).cleanup();
            return null;
        });
    }

    public void addUserToCache(User user) {
        this.users.compute(user.getId(), (key, value) -> {
            Optional.ofNullable(value).map(Reference::get).filter(oldUser -> oldUser != user).map(Cleanupable.class::cast).ifPresent(Cleanupable::cleanup);
            WeakReference<User> result = new WeakReference<User>(user, this.usersCleanupQueue);
            this.userIdByRef.put((Reference<? extends User>)result, (Long)key);
            return result;
        });
    }

    public void addChannelToCache(Channel channel) {
        Channel oldChannel = this.channels.put(channel.getId(), channel);
        if (oldChannel != channel && oldChannel instanceof Cleanupable) {
            ((Cleanupable)oldChannel).cleanup();
        }
    }

    public void removeChannelFromCache(long channelId) {
        this.channels.computeIfPresent(channelId, (key, channel) -> {
            if (channel instanceof Cleanupable) {
                ((Cleanupable)channel).cleanup();
            }
            return null;
        });
    }

    public void addUnavailableServerToCache(long serverId) {
        this.unavailableServers.add(serverId);
    }

    private void removeUnavailableServerFromCache(long serverId) {
        this.unavailableServers.remove(serverId);
    }

    public void setYourself(User yourself) {
        this.you = yourself;
    }

    public Long getTimeOffset() {
        return this.timeOffset;
    }

    public void setTimeOffset(Long timeOffset) {
        this.timeOffset = timeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User getOrCreateUser(JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        Map<Long, WeakReference<User>> map = this.users;
        synchronized (map) {
            return this.getCachedUserById(id).orElseGet(() -> {
                if (!data.has("username")) {
                    throw new IllegalStateException("Couldn't get or created user. Please inform the developer!");
                }
                return new UserImpl(this, data);
            });
        }
    }

    public KnownCustomEmoji getOrCreateKnownCustomEmoji(Server server, JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        return this.customEmojis.computeIfAbsent(id, key -> new KnownCustomEmojiImpl(this, server, data));
    }

    public CustomEmoji getKnownCustomEmojiOrCreateCustomEmoji(JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        CustomEmoji emoji = (CustomEmoji)this.customEmojis.get(id);
        return emoji == null ? new CustomEmojiImpl(this, data) : emoji;
    }

    public CustomEmoji getKnownCustomEmojiOrCreateCustomEmoji(long id, String name, boolean animated) {
        CustomEmoji emoji = (CustomEmoji)this.customEmojis.get(id);
        return emoji == null ? new CustomEmojiImpl(this, id, name, animated) : emoji;
    }

    public void removeCustomEmoji(KnownCustomEmoji emoji) {
        this.customEmojis.remove(emoji.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getOrCreateMessage(TextChannel channel, JsonNode data) {
        long id = Long.parseLong(data.get("id").asText());
        Map<Long, WeakReference<Message>> map = this.messages;
        synchronized (map) {
            return this.getCachedMessageById(id).orElseGet(() -> new MessageImpl(this, channel, data));
        }
    }

    public void addMessageToCache(Message message) {
        this.messages.compute(message.getId(), (key, value) -> {
            if (value == null || value.get() == null) {
                WeakReference<Message> result = new WeakReference<Message>(message, this.messagesCleanupQueue);
                this.messageIdByRef.put((Reference<? extends Message>)result, (Long)key);
                return result;
            }
            return value;
        });
    }

    public void removeMessageFromCache(long messageId) {
        WeakReference<Message> messageRef = this.messages.remove(messageId);
        if (messageRef != null) {
            this.messageIdByRef.remove(messageRef, messageId);
        }
    }

    public <T extends ObjectAttachableListener> ListenerManager<T> addObjectListener(Class<?> objectClass, long objectId, Class<T> listenerClass, T listener) {
        Map listeners = this.objectListeners.computeIfAbsent(objectClass, key -> new ConcurrentHashMap()).computeIfAbsent(objectId, key -> new ConcurrentHashMap()).computeIfAbsent(listenerClass, c -> Collections.synchronizedMap(new LinkedHashMap()));
        return listeners.computeIfAbsent(listener, key -> new ListenerManagerImpl<ObjectAttachableListener>(this, listener, listenerClass, objectClass, objectId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ObjectAttachableListener> void removeObjectListener(Class<?> objectClass, long objectId, Class<T> listenerClass, T listener) {
        Map<Class<?>, Map<Long, Map<Class<? extends ObjectAttachableListener>, Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>>>>> map = this.objectListeners;
        synchronized (map) {
            if (objectClass == null) {
                return;
            }
            Map<Long, Map<Class<? extends ObjectAttachableListener>, Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>>>> objectListener = this.objectListeners.get(objectClass);
            if (objectListener == null) {
                return;
            }
            Map<Class<? extends ObjectAttachableListener>, Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>>> listeners = objectListener.get(objectId);
            if (listeners == null) {
                return;
            }
            Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>> classListeners = listeners.get(listenerClass);
            if (classListeners == null) {
                return;
            }
            ListenerManagerImpl<? extends ObjectAttachableListener> listenerManager = classListeners.get(listener);
            if (listenerManager == null) {
                return;
            }
            classListeners.remove(listener);
            listenerManager.removed();
            if (classListeners.isEmpty()) {
                listeners.remove(listenerClass);
                if (listeners.isEmpty()) {
                    objectListener.remove(objectId);
                    if (objectListener.isEmpty()) {
                        this.objectListeners.remove(objectClass);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObjectListeners(Class<?> objectClass, long objectId) {
        if (objectClass == null) {
            return;
        }
        Map<Class<?>, Map<Long, Map<Class<? extends ObjectAttachableListener>, Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>>>>> map = this.objectListeners;
        synchronized (map) {
            Map<Long, Map<Class<? extends ObjectAttachableListener>, Map<ObjectAttachableListener, ListenerManagerImpl<? extends ObjectAttachableListener>>>> objects = this.objectListeners.get(objectClass);
            if (objects == null) {
                return;
            }
            objects.computeIfPresent(objectId, (id, listeners) -> {
                listeners.values().stream().flatMap(map -> map.values().stream()).forEach(ListenerManagerImpl::removed);
                listeners.clear();
                return null;
            });
            if (objects.isEmpty()) {
                this.objectListeners.remove(objectClass);
            }
        }
    }

    public <T extends ObjectAttachableListener> Map<T, List<Class<T>>> getObjectListeners(Class<?> objectClass, long objectId) {
        return Collections.unmodifiableMap(Optional.ofNullable(objectClass).map(this.objectListeners::get).map(objectListener -> (Map)objectListener.get(objectId)).map(Map::entrySet).map(Collection::stream).map(entryStream -> entryStream.flatMap(entry -> ((Map)entry.getValue()).keySet().stream().map(listener -> new AbstractMap.SimpleEntry<ObjectAttachableListener, Class>((ObjectAttachableListener)listener, (Class)entry.getKey())))).map(entryStream -> entryStream.collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())))).orElseGet(HashMap::new));
    }

    public <T extends ObjectAttachableListener> List<T> getObjectListeners(Class<?> objectClass, long objectId, Class<T> listenerClass) {
        return Collections.unmodifiableList(Optional.ofNullable(objectClass).map(this.objectListeners::get).map(objectListener -> (Map)objectListener.get(objectId)).map(listeners -> (Map)listeners.get(listenerClass)).map(Map::keySet).map(ArrayList::new).orElseGet(ArrayList::new));
    }

    public <T extends GloballyAttachableListener> Map<T, List<Class<T>>> getListeners() {
        return Collections.unmodifiableMap(this.listeners.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).keySet().stream().map(listener -> new AbstractMap.SimpleEntry<GloballyAttachableListener, Class>((GloballyAttachableListener)listener, (Class)entry.getKey()))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList()))));
    }

    public <T extends GloballyAttachableListener> List<T> getListeners(Class<T> listenerClass) {
        return Collections.unmodifiableList(Optional.ofNullable(listenerClass).map(this.listeners::get).map(Map::keySet).map(ArrayList::new).orElseGet(ArrayList::new));
    }

    public String getPrefixedToken() {
        return this.accountType.getTokenPrefix() + this.token;
    }

    public String getToken() {
        return this.token;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public UncachedMessageUtil getUncachedMessageUtil() {
        return this.uncachedMessageUtil;
    }

    public DiscordWebSocketAdapter getWebSocketAdapter() {
        return this.websocketAdapter;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public Optional<Ratelimiter> getGlobalRatelimiter() {
        return Optional.ofNullable(this.globalRatelimiter);
    }

    public void setMessageCacheSize(int capacity, int storageTimeInSeconds) {
        this.defaultMessageCacheCapacity = capacity;
        this.defaultMessageCacheStorageTimeInSeconds = storageTimeInSeconds;
        this.getChannels().stream().filter(channel -> channel instanceof TextChannel).map(channel -> (TextChannel)channel).forEach(channel -> {
            channel.getMessageCache().setCapacity(capacity);
            channel.getMessageCache().setStorageTimeInSeconds(storageTimeInSeconds);
        });
    }

    public int getDefaultMessageCacheCapacity() {
        return this.defaultMessageCacheCapacity;
    }

    public int getDefaultMessageCacheStorageTimeInSeconds() {
        return this.defaultMessageCacheStorageTimeInSeconds;
    }

    public void setAutomaticMessageCacheCleanupEnabled(boolean automaticMessageCacheCleanupEnabled) {
        this.defaultAutomaticMessageCacheCleanupEnabled = automaticMessageCacheCleanupEnabled;
        this.getChannels().stream().filter(TextChannel.class::isInstance).map(TextChannel.class::cast).forEach(channel -> channel.getMessageCache().setAutomaticCleanupEnabled(automaticMessageCacheCleanupEnabled));
    }

    public boolean isDefaultAutomaticMessageCacheCleanupEnabled() {
        return this.defaultAutomaticMessageCacheCleanupEnabled;
    }

    public int getCurrentShard() {
        return this.currentShard;
    }

    public int getTotalShards() {
        return this.totalShards;
    }

    public boolean isWaitingForServersOnStartup() {
        return this.waitForServersOnStartup;
    }

    public Optional<ProxySelector> getProxySelector() {
        return Optional.ofNullable(this.proxySelector);
    }

    public Optional<Proxy> getProxy() {
        return Optional.ofNullable(this.proxy);
    }

    public Optional<org.javacord.api.util.auth.Authenticator> getProxyAuthenticator() {
        return Optional.ofNullable(this.proxyAuthenticator);
    }

    public boolean isTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public void updateStatus(UserStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("The status cannot be null");
        }
        this.status = status;
        this.websocketAdapter.updateStatus();
    }

    public UserStatus getStatus() {
        return this.status;
    }

    private void updateActivity(ActivityType type, String name, String streamingUrl) {
        this.activity = name == null ? null : (streamingUrl == null ? new ActivityImpl(type, name, null) : new ActivityImpl(type, name, streamingUrl));
        this.websocketAdapter.updateStatus();
    }

    public void updateActivity(String name) {
        this.updateActivity(ActivityType.PLAYING, name, null);
    }

    public void updateActivity(ActivityType type, String name) {
        this.updateActivity(type, name, null);
    }

    public void updateActivity(String name, String streamingUrl) {
        this.updateActivity(ActivityType.STREAMING, name, streamingUrl);
    }

    public void unsetActivity() {
        this.updateActivity(null);
    }

    public Optional<Activity> getActivity() {
        return Optional.ofNullable(this.activity);
    }

    public User getYourself() {
        return this.you;
    }

    public long getOwnerId() {
        if (this.accountType != AccountType.BOT) {
            throw new IllegalStateException("Cannot get owner id of non bot accounts");
        }
        return this.ownerId;
    }

    public long getClientId() {
        if (this.accountType != AccountType.BOT) {
            throw new IllegalStateException("Cannot get client id of non bot accounts");
        }
        return this.clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Object object = this.disconnectCalledLock;
        synchronized (object) {
            if (!this.disconnectCalled) {
                if (this.websocketAdapter == null) {
                    this.threadPool.shutdown();
                } else {
                    this.addLostConnectionListener(event -> this.threadPool.shutdown());
                    this.websocketAdapter.disconnect();
                    this.threadPool.getDaemonScheduler().schedule(this.threadPool::shutdown, 1L, TimeUnit.MINUTES);
                }
                this.disconnectCalled = true;
                this.httpClient.dispatcher().executorService().shutdown();
                this.httpClient.connectionPool().evictAll();
            }
        }
    }

    public void setReconnectDelay(Function<Integer, Integer> reconnectDelayProvider) {
        this.reconnectDelayProvider = reconnectDelayProvider;
    }

    public int getReconnectDelay(int attempt) {
        if (attempt < 0) {
            throw new IllegalArgumentException("attempt must be 1 or greater");
        }
        return this.reconnectDelayProvider.apply(attempt);
    }

    public CompletableFuture<ApplicationInfo> getApplicationInfo() {
        return new RestRequest<ApplicationInfo>(this, RestMethod.GET, RestEndpoint.SELF_INFO).execute(result -> new ApplicationInfoImpl(this, result.getJsonBody()));
    }

    public CompletableFuture<Webhook> getWebhookById(long id) {
        return new RestRequest(this, RestMethod.GET, RestEndpoint.WEBHOOK).setUrlParameters(Long.toUnsignedString(id)).execute(result -> new WebhookImpl(this, result.getJsonBody()));
    }

    public Collection<Long> getUnavailableServers() {
        return Collections.unmodifiableCollection(this.unavailableServers);
    }

    public CompletableFuture<Invite> getInviteByCode(String code) {
        return new RestRequest(this, RestMethod.GET, RestEndpoint.INVITE).setUrlParameters(code).addQueryParameter("with_counts", "false").execute(result -> new InviteImpl(this, result.getJsonBody()));
    }

    public CompletableFuture<Invite> getInviteWithMemberCountsByCode(String code) {
        return new RestRequest(this, RestMethod.GET, RestEndpoint.INVITE).setUrlParameters(code).addQueryParameter("with_counts", "true").execute(result -> new InviteImpl(this, result.getJsonBody()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<User> getCachedUsers() {
        Map<Long, WeakReference<User>> map = this.users;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.users.values().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }

    public Optional<User> getCachedUserById(long id) {
        return Optional.ofNullable(this.users.get(id)).map(Reference::get);
    }

    public CompletableFuture<User> getUserById(long id) {
        return this.getCachedUserById(id).map(CompletableFuture::completedFuture).orElseGet(() -> new RestRequest(this, RestMethod.GET, RestEndpoint.USER).setUrlParameters(Long.toUnsignedString(id)).execute(result -> this.getOrCreateUser(result.getJsonBody())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageSet getCachedMessages() {
        Map<Long, WeakReference<Message>> map = this.messages;
        synchronized (map) {
            return new MessageSetImpl(this.messages.values().stream().map(Reference::get).filter(Objects::nonNull).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageSet getCachedMessagesWhere(Predicate<Message> filter) {
        Map<Long, WeakReference<Message>> map = this.messages;
        synchronized (map) {
            return new MessageSetImpl(this.messages.values().stream().map(Reference::get).filter(Objects::nonNull).filter(filter).collect(Collectors.toList()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachCachedMessageWhere(Predicate<Message> filter, Consumer<Message> action) {
        Map<Long, WeakReference<Message>> map = this.messages;
        synchronized (map) {
            this.messages.values().stream().map(Reference::get).filter(Objects::nonNull).filter(filter).forEach(action);
        }
    }

    public Optional<Message> getCachedMessageById(long id) {
        return Optional.ofNullable(this.messages.get(id)).map(Reference::get);
    }

    public Collection<Server> getServers() {
        return Collections.unmodifiableList(new ArrayList<Server>(this.servers.values()));
    }

    public Optional<Server> getServerById(long id) {
        return Optional.ofNullable(this.servers.get(id));
    }

    public Collection<KnownCustomEmoji> getCustomEmojis() {
        return Collections.unmodifiableCollection(this.customEmojis.values());
    }

    public Optional<KnownCustomEmoji> getCustomEmojiById(long id) {
        return Optional.ofNullable(this.customEmojis.get(id));
    }

    public Collection<Channel> getChannels() {
        return Collections.unmodifiableCollection(new ArrayList<Channel>(this.channels.values()));
    }

    public Optional<Channel> getChannelById(long id) {
        return Optional.ofNullable(this.channels.get(id));
    }

    public Collection<ListenerManager<? extends GloballyAttachableListener>> addListener(GloballyAttachableListener listener) {
        return ClassHelper.getInterfacesAsStream(listener.getClass()).filter(GloballyAttachableListener.class::isAssignableFrom).filter(listenerClass -> listenerClass != GloballyAttachableListener.class).map(listenerClass -> listenerClass).map(listenerClass -> this.addListener((Class)listenerClass, (GloballyAttachableListener)listener)).collect(Collectors.toList());
    }

    public <T extends GloballyAttachableListener> ListenerManager<T> addListener(Class<T> listenerClass, T listener) {
        return this.listeners.computeIfAbsent(listenerClass, key -> Collections.synchronizedMap(new LinkedHashMap())).computeIfAbsent(listener, key -> new ListenerManagerImpl<GloballyAttachableListener>(this, listener, listenerClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends GloballyAttachableListener> void removeListener(Class<T> listenerClass, T listener) {
        Map<Class<? extends GloballyAttachableListener>, Map<GloballyAttachableListener, ListenerManagerImpl<? extends GloballyAttachableListener>>> map = this.listeners;
        synchronized (map) {
            Map<GloballyAttachableListener, ListenerManagerImpl<? extends GloballyAttachableListener>> classListeners = this.listeners.get(listenerClass);
            if (classListeners == null) {
                return;
            }
            ListenerManagerImpl<? extends GloballyAttachableListener> listenerManager = classListeners.get(listener);
            if (listenerManager == null) {
                return;
            }
            classListeners.remove(listener);
            listenerManager.removed();
            if (classListeners.isEmpty()) {
                this.listeners.remove(listenerClass);
            }
        }
    }

    public void removeListener(GloballyAttachableListener listener) {
        ClassHelper.getInterfacesAsStream(listener.getClass()).filter(GloballyAttachableListener.class::isAssignableFrom).filter(listenerClass -> listenerClass != GloballyAttachableListener.class).map(listenerClass -> listenerClass).forEach(listenerClass -> this.removeListener((Class)listenerClass, (GloballyAttachableListener)listener));
    }

    protected void finalize() throws Throwable {
        this.disconnect();
        super.finalize();
    }
}

