/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.rest;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.javacord.core.util.rest.RestRequest;

public class RestRequestResult {
    private final RestRequest<?> request;
    private final Response response;
    private final ResponseBody body;
    private final String stringBody;
    private final JsonNode jsonBody;

    public RestRequestResult(RestRequest<?> request, Response response) throws IOException {
        this.request = request;
        this.response = response;
        this.body = response.body();
        if (this.body == null) {
            this.stringBody = null;
            this.jsonBody = NullNode.getInstance();
        } else {
            this.stringBody = this.body.string();
            ObjectMapper mapper = request.getApi().getObjectMapper();
            JsonNode jsonBody = mapper.readTree(this.stringBody);
            this.jsonBody = jsonBody == null ? NullNode.getInstance() : jsonBody;
        }
    }

    public RestRequest<?> getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Optional<ResponseBody> getBody() {
        return Optional.ofNullable(this.body);
    }

    public Optional<String> getStringBody() {
        return Optional.ofNullable(this.stringBody);
    }

    public JsonNode getJsonBody() {
        return this.jsonBody;
    }
}

