/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util.handler.message;

import com.fasterxml.jackson.databind.JsonNode;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.channel.ServerChannel;
import org.javacord.api.entity.channel.TextChannel;
import org.javacord.api.entity.message.Message;
import org.javacord.api.entity.message.embed.Embed;
import org.javacord.api.entity.server.Server;
import org.javacord.api.event.message.CachedMessagePinEvent;
import org.javacord.api.event.message.CachedMessageUnpinEvent;
import org.javacord.api.event.message.MessageEditEvent;
import org.javacord.core.entity.message.MessageImpl;
import org.javacord.core.entity.message.embed.EmbedBuilderDelegateImpl;
import org.javacord.core.entity.message.embed.EmbedImpl;
import org.javacord.core.event.message.CachedMessagePinEventImpl;
import org.javacord.core.event.message.CachedMessageUnpinEventImpl;
import org.javacord.core.event.message.MessageEditEventImpl;
import org.javacord.core.util.event.DispatchQueueSelector;
import org.javacord.core.util.gateway.PacketHandler;
import org.javacord.core.util.logging.LoggerUtil;

public class MessageUpdateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(MessageUpdateHandler.class);
    private final ConcurrentHashMap<Long, Long> lastKnownEditTimestamps = new ConcurrentHashMap();

    public MessageUpdateHandler(DiscordApi api) {
        super(api, true, "MESSAGE_UPDATE");
        long offset = this.api.getTimeOffset() == null ? 0L : this.api.getTimeOffset();
        api.getThreadPool().getScheduler().scheduleAtFixedRate(() -> {
            try {
                this.lastKnownEditTimestamps.entrySet().removeIf(entry -> System.currentTimeMillis() + offset - (Long)entry.getValue() > 5000L);
            }
            catch (Throwable t) {
                logger.error("Failed to clean last known edit timestamps cache!", t);
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    @Override
    public void handle(JsonNode packet) {
        long messageId = packet.get("id").asLong();
        long channelId = packet.get("channel_id").asLong();
        this.api.getTextChannelById(channelId).ifPresent(channel -> {
            Optional<MessageImpl> message = this.api.getCachedMessageById(messageId).map(msg -> (MessageImpl)msg);
            message.ifPresent(msg -> {
                boolean oldPinnedFlag;
                boolean newPinnedFlag = packet.hasNonNull("pinned") ? packet.get("pinned").asBoolean() : msg.isPinned();
                if (newPinnedFlag != (oldPinnedFlag = msg.isPinned())) {
                    msg.setPinned(newPinnedFlag);
                    if (newPinnedFlag) {
                        CachedMessagePinEventImpl event = new CachedMessagePinEventImpl((Message)msg);
                        Optional<Server> optionalServer = msg.getChannel().asServerChannel().map(ServerChannel::getServer);
                        this.api.getEventDispatcher().dispatchCachedMessagePinEvent(optionalServer.map(DispatchQueueSelector.class::cast).orElse(this.api), (Message)msg, optionalServer.orElse(null), msg.getChannel(), (CachedMessagePinEvent)event);
                    } else {
                        CachedMessageUnpinEventImpl event = new CachedMessageUnpinEventImpl((Message)msg);
                        Optional<Server> optionalServer = msg.getChannel().asServerChannel().map(ServerChannel::getServer);
                        this.api.getEventDispatcher().dispatchCachedMessageUnpinEvent(optionalServer.map(DispatchQueueSelector.class::cast).orElse(this.api), (Message)msg, optionalServer.orElse(null), msg.getChannel(), (CachedMessageUnpinEvent)event);
                    }
                }
            });
            MessageEditEventImpl editEvent = null;
            if (packet.has("edited_timestamp") && !packet.get("edited_timestamp").isNull()) {
                long offset;
                message.ifPresent(msg -> {
                    msg.setLastEditTime(OffsetDateTime.parse(packet.get("edited_timestamp").asText()).toInstant());
                    msg.setMentionsEveryone(packet.get("mention_everyone").asBoolean());
                });
                long editTimestamp = OffsetDateTime.parse(packet.get("edited_timestamp").asText()).toInstant().toEpochMilli();
                long lastKnownEditTimestamp = this.lastKnownEditTimestamps.getOrDefault(messageId, 0L);
                this.lastKnownEditTimestamps.put(messageId, editTimestamp);
                boolean isMostLikelyAnEdit = true;
                long l = offset = this.api.getTimeOffset() == null ? 0L : this.api.getTimeOffset();
                if (editTimestamp == lastKnownEditTimestamp) {
                    isMostLikelyAnEdit = false;
                } else if (System.currentTimeMillis() + offset - editTimestamp > 5000L) {
                    isMostLikelyAnEdit = false;
                }
                String oldContent = message.map(Message::getContent).orElse(null);
                List oldEmbeds = message.map(Message::getEmbeds).orElse(null);
                String newContent = null;
                if (packet.has("content")) {
                    String finalNewContent = newContent = packet.get("content").asText();
                    message.ifPresent(msg -> msg.setContent(finalNewContent));
                }
                ArrayList<Embed> newEmbeds = null;
                if (packet.has("embeds")) {
                    newEmbeds = new ArrayList<Embed>();
                    for (JsonNode embedJson : packet.get("embeds")) {
                        EmbedImpl embed = new EmbedImpl(embedJson);
                        newEmbeds.add(embed);
                    }
                    ArrayList<Embed> finalNewEmbeds = newEmbeds;
                    message.ifPresent(msg -> msg.setEmbeds(finalNewEmbeds));
                }
                if (oldContent != null && newContent != null && !oldContent.equals(newContent)) {
                    isMostLikelyAnEdit = true;
                }
                if (oldEmbeds != null && newEmbeds != null) {
                    if (newEmbeds.size() != oldEmbeds.size()) {
                        isMostLikelyAnEdit = true;
                    } else {
                        for (int i = 0; i < newEmbeds.size(); ++i) {
                            if (((EmbedBuilderDelegateImpl)((Embed)newEmbeds.get(i)).toBuilder().getDelegate()).toJsonNode().toString().equals(((EmbedBuilderDelegateImpl)((Embed)oldEmbeds.get(i)).toBuilder().getDelegate()).toJsonNode().toString())) continue;
                            isMostLikelyAnEdit = true;
                        }
                    }
                }
                if (isMostLikelyAnEdit) {
                    editEvent = new MessageEditEventImpl(this.api, messageId, (TextChannel)channel, newContent, (List<Embed>)newEmbeds, oldContent, oldEmbeds);
                }
            }
            if (editEvent != null) {
                this.dispatchEditEvent(editEvent);
            }
        });
    }

    private void dispatchEditEvent(MessageEditEvent event) {
        Optional<Server> optionalServer = event.getChannel().asServerChannel().map(ServerChannel::getServer);
        this.api.getEventDispatcher().dispatchMessageEditEvent(optionalServer.map(DispatchQueueSelector.class::cast).orElse(this.api), event.getMessageId(), optionalServer.orElse(null), event.getChannel(), event);
    }
}

