/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.Logger;
import org.javacord.api.DiscordApi;
import org.javacord.api.Javacord;
import org.javacord.api.entity.Icon;
import org.javacord.core.util.io.FileUtils;
import org.javacord.core.util.logging.LoggerUtil;

public class FileContainer {
    private static final Logger logger = LoggerUtil.getLogger(FileContainer.class);
    private final BufferedImage fileAsBufferedImage;
    private final File fileAsFile;
    private final Icon fileAsIcon;
    private final URL fileAsUrl;
    private final byte[] fileAsByteArray;
    private final InputStream fileAsInputStream;
    private String fileTypeOrName;

    public FileContainer(BufferedImage file, String type) {
        this.fileAsBufferedImage = file;
        this.fileAsFile = null;
        this.fileAsIcon = null;
        this.fileAsUrl = null;
        this.fileAsByteArray = null;
        this.fileAsInputStream = null;
        this.setFileTypeOrName(type);
    }

    public FileContainer(File file) {
        this(file, false);
    }

    public FileContainer(File file, boolean isSpoiler) {
        this.fileAsBufferedImage = null;
        this.fileAsFile = file;
        this.fileAsIcon = null;
        this.fileAsUrl = null;
        this.fileAsByteArray = null;
        this.fileAsInputStream = null;
        this.fileTypeOrName = (isSpoiler ? "SPOILER_" : "") + file.getName();
    }

    public FileContainer(Icon file) {
        this(file, false);
    }

    public FileContainer(Icon file, boolean isSpoiler) {
        this.fileAsBufferedImage = null;
        this.fileAsFile = null;
        this.fileAsIcon = file;
        this.fileAsUrl = null;
        this.fileAsByteArray = null;
        this.fileAsInputStream = null;
        this.fileTypeOrName = (isSpoiler ? "SPOILER_" : "") + file.getUrl().getFile();
    }

    public FileContainer(URL file) {
        this(file, false);
    }

    public FileContainer(URL file, boolean isSpoiler) {
        this.fileAsBufferedImage = null;
        this.fileAsFile = null;
        this.fileAsIcon = null;
        this.fileAsUrl = file;
        this.fileAsByteArray = null;
        this.fileAsInputStream = null;
        this.fileTypeOrName = (isSpoiler ? "SPOILER_" : "") + file.getFile();
    }

    public FileContainer(byte[] file, String type) {
        this.fileAsBufferedImage = null;
        this.fileAsFile = null;
        this.fileAsIcon = null;
        this.fileAsUrl = null;
        this.fileAsByteArray = file;
        this.fileAsInputStream = null;
        this.fileTypeOrName = type;
    }

    public FileContainer(InputStream file, String type) {
        this.fileAsBufferedImage = null;
        this.fileAsFile = null;
        this.fileAsIcon = null;
        this.fileAsUrl = null;
        this.fileAsByteArray = null;
        this.fileAsInputStream = file;
        this.fileTypeOrName = type;
    }

    public void setFileTypeOrName(String type) {
        this.fileTypeOrName = type;
        if (this.fileAsBufferedImage != null && !ImageIO.getImageWritersByFormatName(this.getFileType()).hasNext()) {
            throw new IllegalArgumentException(String.format("No image writer found for format \"%s\"", this.getFileType()));
        }
    }

    public String getFileType() {
        if (this.fileTypeOrName != null && this.fileTypeOrName.contains(".")) {
            return FileUtils.getExtension(this.fileTypeOrName);
        }
        return this.fileTypeOrName;
    }

    public String getFileTypeOrName() {
        return this.fileTypeOrName;
    }

    public CompletableFuture<byte[]> asByteArray(DiscordApi api) {
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        try {
            if (this.fileAsByteArray != null) {
                future.complete(this.fileAsByteArray);
                return future;
            }
            if (this.fileAsBufferedImage != null || this.fileAsFile != null || this.fileAsIcon != null || this.fileAsUrl != null || this.fileAsInputStream != null) {
                ((CompletableFuture)this.asInputStream(api).thenApply(stream -> {
                    try {
                        BufferedInputStream in = new BufferedInputStream((InputStream)stream);
                        Throwable throwable = null;
                        try {
                            byte[] byArray;
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            Throwable throwable2 = null;
                            try {
                                int n;
                                byte[] buf = new byte[1024];
                                while (-1 != (n = ((InputStream)in).read(buf))) {
                                    out.write(buf, 0, n);
                                }
                                byArray = out.toByteArray();
                            }
                            catch (Throwable throwable3) {
                                try {
                                    try {
                                        throwable2 = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        FileContainer.$closeResource(throwable2, out);
                                        throw throwable4;
                                    }
                                }
                                catch (Throwable throwable5) {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                            }
                            FileContainer.$closeResource(throwable2, out);
                            return byArray;
                        }
                        finally {
                            FileContainer.$closeResource(throwable, in);
                        }
                    }
                    catch (IOException e) {
                        throw new CompletionException(e);
                    }
                })).whenComplete((bytes, throwable) -> {
                    if (throwable != null) {
                        future.completeExceptionally((Throwable)throwable);
                    } else {
                        future.complete((byte[])bytes);
                    }
                });
                return future;
            }
            future.completeExceptionally(new IllegalStateException("No file variant is set"));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<InputStream> asInputStream(DiscordApi api) {
        CompletableFuture<InputStream> future = new CompletableFuture<InputStream>();
        try {
            if (this.fileAsBufferedImage != null) {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.fileAsBufferedImage, this.getFileType(), os);
                future.complete(new ByteArrayInputStream(os.toByteArray()));
                return future;
            }
            if (this.fileAsFile != null) {
                future.complete(new FileInputStream(this.fileAsFile));
                return future;
            }
            if (this.fileAsIcon != null || this.fileAsUrl != null) {
                URL url = this.fileAsUrl == null ? this.fileAsIcon.getUrl() : this.fileAsUrl;
                api.getThreadPool().getExecutorService().submit(() -> {
                    try {
                        logger.debug("Trying to download file from {}", (Object)url);
                        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                        conn.setRequestMethod("GET");
                        conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                        conn.setRequestProperty("User-Agent", Javacord.USER_AGENT);
                        future.complete(conn.getInputStream());
                        logger.debug("Downloaded file from {} (content length: {})", (Object)url, (Object)conn.getContentLength());
                    }
                    catch (Throwable t) {
                        future.completeExceptionally(t);
                    }
                });
                return future;
            }
            if (this.fileAsByteArray != null) {
                future.complete(new ByteArrayInputStream(this.fileAsByteArray));
                return future;
            }
            if (this.fileAsInputStream != null) {
                future.complete(this.fileAsInputStream);
                return future;
            }
            future.completeExceptionally(new IllegalStateException("No file variant is set"));
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
        return future;
    }

    public CompletableFuture<BufferedImage> asBufferedImage(DiscordApi api) {
        return ((CompletableFuture)this.asByteArray(api).thenApply(ByteArrayInputStream::new)).thenApply(stream -> {
            try {
                return ImageIO.read(stream);
            }
            catch (IOException e) {
                throw new CompletionException(e);
            }
        });
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }
}

