/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.permission;

import com.fasterxml.jackson.databind.JsonNode;
import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.permission.Permissions;
import org.javacord.api.entity.permission.Role;
import org.javacord.api.entity.server.Server;
import org.javacord.api.entity.user.User;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.permission.PermissionsImpl;
import org.javacord.core.entity.server.ServerImpl;
import org.javacord.core.listener.server.role.InternalRoleAttachableListenerManager;
import org.javacord.core.util.rest.RestEndpoint;
import org.javacord.core.util.rest.RestMethod;
import org.javacord.core.util.rest.RestRequest;

public class RoleImpl
implements Role,
InternalRoleAttachableListenerManager {
    private static final Comparator<Role> ROLE_COMPARATOR = Comparator.comparingInt(Role::getPosition).thenComparing(Comparator.comparing(DiscordEntity::getId).reversed());
    private final DiscordApiImpl api;
    private final ServerImpl server;
    private final long id;
    private volatile String name;
    private volatile int position;
    private volatile int color;
    private volatile boolean hoist;
    private volatile boolean mentionable;
    private volatile PermissionsImpl permissions;
    private final boolean managed;
    private final Collection<User> users = new HashSet<User>();

    public RoleImpl(DiscordApiImpl api, ServerImpl server, JsonNode data) {
        this.api = api;
        this.server = server;
        this.id = data.get("id").asLong();
        this.name = data.get("name").asText();
        this.position = data.get("position").asInt();
        this.color = data.get("color").asInt(0);
        this.hoist = data.get("hoist").asBoolean(false);
        this.mentionable = data.get("mentionable").asBoolean(false);
        this.permissions = new PermissionsImpl(data.get("permissions").asInt(), 0);
        this.managed = data.get("managed").asBoolean(false);
    }

    public void addUserToCache(User user) {
        this.users.add(user);
    }

    public void removeUserFromCache(User user) {
        this.users.remove(user);
    }

    public int getColorAsInt() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setHoist(boolean hoist) {
        this.hoist = hoist;
    }

    public void setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPermissions(PermissionsImpl permissions) {
        this.permissions = permissions;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public Server getServer() {
        return this.server;
    }

    public String getName() {
        return this.name;
    }

    public int getPosition() {
        return this.position;
    }

    public Optional<Color> getColor() {
        return Optional.ofNullable(this.color == 0 ? null : new Color(this.color));
    }

    public boolean isMentionable() {
        return this.mentionable;
    }

    public boolean isDisplayedSeparately() {
        return this.hoist;
    }

    public Collection<User> getUsers() {
        if (this.isEveryoneRole()) {
            return this.getServer().getMembers();
        }
        return Collections.unmodifiableCollection(this.users);
    }

    public Permissions getPermissions() {
        return this.permissions;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public CompletableFuture<Void> delete() {
        return new RestRequest(this.getApi(), RestMethod.DELETE, RestEndpoint.ROLE).setUrlParameters(this.getServer().getIdAsString(), this.getIdAsString()).execute(result -> null);
    }

    public int compareTo(Role role) {
        if (!role.getServer().equals(this.getServer())) {
            throw new IllegalArgumentException("Only roles from the same server can be compared for order");
        }
        return ROLE_COMPARATOR.compare(this, role);
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("Role (id: %s, name: %s, server: %#s)", this.getIdAsString(), this.getName(), this.getServer());
    }
}

