/*
 * Decompiled with CFR 0.152.
 */
package org.javacord.core.entity.channel;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.javacord.api.DiscordApi;
import org.javacord.api.entity.DiscordEntity;
import org.javacord.api.entity.channel.Channel;
import org.javacord.api.entity.channel.PrivateChannel;
import org.javacord.api.entity.user.User;
import org.javacord.api.util.cache.MessageCache;
import org.javacord.core.DiscordApiImpl;
import org.javacord.core.entity.channel.InternalTextChannel;
import org.javacord.core.entity.user.UserImpl;
import org.javacord.core.listener.channel.user.InternalPrivateChannelAttachableListenerManager;
import org.javacord.core.util.Cleanupable;
import org.javacord.core.util.cache.MessageCacheImpl;

public class PrivateChannelImpl
implements PrivateChannel,
Cleanupable,
InternalTextChannel,
InternalPrivateChannelAttachableListenerManager {
    private final DiscordApiImpl api;
    private final long id;
    private final UserImpl recipient;
    private final MessageCacheImpl messageCache;

    public PrivateChannelImpl(DiscordApiImpl api, JsonNode data) {
        this.api = api;
        this.recipient = (UserImpl)api.getOrCreateUser(data.get("recipients").get(0));
        this.messageCache = new MessageCacheImpl(api, api.getDefaultMessageCacheCapacity(), api.getDefaultMessageCacheStorageTimeInSeconds(), api.isDefaultAutomaticMessageCacheCleanupEnabled());
        this.id = Long.parseLong(data.get("id").asText());
        this.recipient.setChannel(this);
        api.addChannelToCache((Channel)this);
    }

    @Override
    public DiscordApi getApi() {
        return this.api;
    }

    @Override
    public long getId() {
        return this.id;
    }

    public User getRecipient() {
        return this.recipient;
    }

    public MessageCache getMessageCache() {
        return this.messageCache;
    }

    @Override
    public void cleanup() {
        this.messageCache.cleanup();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass() && this.getId() == ((DiscordEntity)o).getId();
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public String toString() {
        return String.format("PrivateChannel (id: %s, recipient: %s)", this.getIdAsString(), this.getRecipient());
    }
}

