/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import de.omegazirkel.risingworld.GlobalIntercom;
import de.omegazirkel.risingworld.JavaCordBot;
import de.omegazirkel.risingworld.tools.Colors;
import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.I18n;
import de.omegazirkel.risingworld.tools.Logger;
import de.omegazirkel.risingworld.tools.PluginChangeWatcher;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.npc.NpcDeathEvent;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.events.player.world.PlayerDestroyObjectEvent;
import net.risingworld.api.events.player.world.PlayerRemoveObjectEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.Vector3f;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.json.simple.JSONObject;

public class DiscordWebHook
extends Plugin
implements Listener,
FileChangeListener {
    static final String pluginVersion = "0.15.1";
    static final String pluginName = "DiscordPlugin";
    static final String pluginCMD = "dp";
    static final Logger log = new Logger("[OZ.DP]");
    static final Colors c = Colors.getInstance();
    private static I18n t = null;
    static int logLevel = 0;
    static boolean postChat = false;
    static String webHookChatUrl = "";
    static String joinDiscord = "";
    static boolean overrideAvatar = true;
    static boolean postSupport = false;
    static boolean supportScreenshot = true;
    static String webHookSupportUrl = "";
    static boolean addTeleportCommand = true;
    static boolean postStatus = false;
    static boolean useServerName = false;
    static boolean reportStatusEnabled = false;
    static boolean reportStatusDisabled = false;
    static boolean reportSettingsChanged = true;
    static boolean reportJarChanged = true;
    static String statusUsername = "My Server";
    static String statusEnabledMessage = "My Server is now online";
    static String statusDisabledMessage = "My Server is shutting down";
    static String webHookStatusUrl = "";
    static boolean sendPluginWelcome = false;
    static boolean postTrackedEvents = false;
    static String webHookEventUrl = "";
    static Short trackServerLogLevel = 0;
    static boolean trackMountKill = false;
    static boolean trackNonHostileAnimalKill = false;
    static boolean trackPickupables = false;
    static boolean botEnable = false;
    static boolean botSecure = true;
    static String botToken = "";
    static String botAdmins = "";
    static String botLang = "en";
    static String botChatChannelName = "server-chat";
    static boolean restartAdminOnly = true;
    static boolean allowRestart = false;
    static boolean restartOnUpdate = true;
    static int restartMinimumTime = 86400;
    static boolean restartTimed = false;
    static int forceRestartAfter = 5;
    static boolean allowScreenshots = true;
    static int maxScreenWidth = 1920;
    static boolean colorizeChat = true;
    static boolean showGroup = false;
    static String colorSupport = "[#782d8e]";
    static String colorLocalSelf = "[#ddffdd]";
    static String colorLocalAdmin = "[#db3208]";
    static String colorLocalOther = "[#dddddd]";
    static String colorLocalDiscord = "[#ddddff]";
    public static Map<String, Short> discordCommands = new HashMap<String, Short>();
    static boolean flagRestart = false;
    static Plugin GlobalIntercom = null;
    static JavaCordBot DiscordBot = null;
    static Timer restartTimer = new Timer();
    static TimerTask restartTask = null;
    static TimerTask restartForcedTask = null;

    public String getBotToken() {
        return botToken;
    }

    public String getBotAdmins() {
        return botAdmins;
    }

    public String getBotLanguage() {
        return botLang;
    }

    public boolean getBotSecure() {
        return botSecure;
    }

    public boolean getOverrideAvatar() {
        return overrideAvatar;
    }

    public String getColorSupport() {
        return colorSupport;
    }

    public String getColorText() {
        c.getClass();
        return "[#EEEEEE]";
    }

    public void setFlagRestart(boolean value) {
        flagRestart = value;
    }

    public String getBotChatChannelName() {
        return botChatChannelName;
    }

    public String getColorLocalDiscord() {
        return colorLocalDiscord;
    }

    public String getColorLocalAdmin() {
        return colorLocalAdmin;
    }

    public boolean getShowGroupSetting() {
        return showGroup;
    }

    public void onEnable() {
        t = new I18n((Plugin)this);
        this.registerEventListener(this);
        GlobalIntercom = this.getPluginByName("Omega Zirkel Global Intercom Plugin");
        if (GlobalIntercom != null) {
            log.out("Global Intercom found! ID: " + GlobalIntercom.getID(), 0);
        }
        this.initSettings();
        if (reportStatusEnabled) {
            Server server = this.getServer();
            String username = statusUsername;
            if (useServerName) {
                username = server.getName();
            }
            this.sendDiscordMessage(username, statusEnabledMessage, webHookStatusUrl);
        }
        try {
            File f = new File(this.getPath());
            PluginChangeWatcher.registerFileChangeListener((FileChangeListener)this, (File)f);
        }
        catch (Exception ex) {
            log.out(ex.toString(), 911);
        }
        if (!botEnable) {
            log.out("DiscordBot is disabled", 0);
            return;
        }
        DiscordBot = new JavaCordBot(this);
        DiscordBot.run();
        log.out("DiscordPlugin Plugin is enabled", 10);
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String lang = player.getSystemLanguage();
        String commandLine = event.getCommand();
        Vector3f pos = player.getPosition();
        String[] cmdParts = commandLine.split(" ", 2);
        String command = cmdParts[0];
        if (command.equals("/dp")) {
            String option;
            if (cmdParts.length < 2) {
                StringBuilder stringBuilder = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#FF0000]").append(pluginName).append(":>");
                c.getClass();
                StringBuilder stringBuilder3 = stringBuilder2.append("[#EEEEEE]");
                String string = t.get("MSG_CMD_ERR_ARGUMENTS", lang);
                StringBuilder stringBuilder4 = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder5 = stringBuilder4.append("[#FF0000]").append(command);
                c.getClass();
                String string2 = string.replace("PH_CMD", stringBuilder5.append("[#EEEEEE]").toString());
                StringBuilder stringBuilder6 = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder7 = stringBuilder6.append("[#997d4a]").append("/").append(pluginCMD).append(" help\n");
                c.getClass();
                player.sendTextMessage(stringBuilder3.append(string2.replace("PH_COMMAND_HELP", stringBuilder7.append("[#EEEEEE]").toString())).toString());
                return;
            }
            switch (option = cmdParts[1]) {
                case "restart": {
                    boolean canTriggerRestart;
                    boolean bl = canTriggerRestart = allowRestart && (player.isAdmin() || !restartAdminOnly && player.getTotalPlayTime() > restartMinimumTime && restartMinimumTime > 0);
                    if (canTriggerRestart) {
                        String username = statusUsername;
                        if (useServerName) {
                            Server server = this.getServer();
                            username = server.getName();
                        }
                        String msgDC = t.get("DC_SHUTDOWN", botLang).replace("PH_PLAYER", player.getName());
                        this.sendDiscordMessage(username, msgDC, webHookStatusUrl);
                        this.broadcastMessage("BC_SHUTDOWN", player.getName());
                        flagRestart = true;
                        break;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder8 = stringBuilder.append("[#FF0000]").append(pluginName).append(":>");
                    c.getClass();
                    player.sendTextMessage(stringBuilder8.append("[#EEEEEE]").append(t.get("CMD_RESTART_NOTALLOWED", lang)).toString());
                    break;
                }
                case "info": {
                    String string = t.get("CMD_INFO", lang);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder9 = stringBuilder.append("[#997d4a]").append("/support TEXT");
                    c.getClass();
                    String string3 = string.replace("PH_CMD_SUPPORT", stringBuilder9.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder10 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder11 = stringBuilder10.append("[#997d4a]").append("/").append(pluginCMD).append(" help");
                    c.getClass();
                    String infoMessage = string3.replace("PH_CMD_HELP", stringBuilder11.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder12 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder13 = stringBuilder12.append("[#00FF00]").append(pluginName).append(":> ");
                    c.getClass();
                    player.sendTextMessage(stringBuilder13.append("[#EEEEEE]").append(infoMessage).toString());
                    break;
                }
                case "help": {
                    String string = t.get("CMD_HELP", lang);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder14 = stringBuilder.append("[#997d4a]").append("/support TEXT");
                    c.getClass();
                    String string4 = string.replace("PH_CMD_SUPPORT", stringBuilder14.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder15 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder16 = stringBuilder15.append("[#997d4a]").append("/").append(pluginCMD).append(" help");
                    c.getClass();
                    String string5 = string4.replace("PH_CMD_HELP", stringBuilder16.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder17 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder18 = stringBuilder17.append("[#997d4a]").append("/").append(pluginCMD).append(" restart");
                    c.getClass();
                    String string6 = string5.replace("PH_CMD_RESTART", stringBuilder18.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder19 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder20 = stringBuilder19.append("[#997d4a]").append("/").append(pluginCMD).append(" info");
                    c.getClass();
                    String string7 = string6.replace("PH_CMD_INFO", stringBuilder20.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder21 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder22 = stringBuilder21.append("[#997d4a]").append("/").append(pluginCMD).append(" status");
                    c.getClass();
                    String string8 = string7.replace("PH_CMD_STATUS", stringBuilder22.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder23 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder24 = stringBuilder23.append("[#997d4a]").append("/joinDiscord");
                    c.getClass();
                    String helpMessage = string8.replace("PH_CMD_JOIN", stringBuilder24.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder25 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder26 = stringBuilder25.append("[#00FF00]").append(pluginName).append(":> ");
                    c.getClass();
                    player.sendTextMessage(stringBuilder26.append("[#EEEEEE]").append(helpMessage).toString());
                    break;
                }
                case "status": {
                    String string = t.get("CMD_STATUS", lang);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder27 = stringBuilder.append("[#00FF00]").append(pluginVersion);
                    c.getClass();
                    String string9 = string.replace("PH_VERSION", stringBuilder27.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder28 = new StringBuilder().append(colorLocalSelf).append(player.getLanguage()).append(" / ").append(player.getSystemLanguage());
                    c.getClass();
                    String string10 = string9.replace("PH_LANGUAGE", stringBuilder28.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder29 = new StringBuilder().append(colorLocalOther).append(t.getLanguageUsed(lang));
                    c.getClass();
                    String string11 = string10.replace("PH_USEDLANG", stringBuilder29.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder30 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder31 = stringBuilder30.append("[#00FF00]").append(t.getLanguageAvailable());
                    c.getClass();
                    String statusMessage = string11.replace("PH_LANG_AVAILABLE", stringBuilder31.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder32 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder33 = stringBuilder32.append("[#00FF00]").append(pluginName).append(":> ");
                    c.getClass();
                    player.sendTextMessage(stringBuilder33.append("[#EEEEEE]").append(statusMessage).toString());
                    break;
                }
            }
        } else if (command.equals("/support")) {
            if (cmdParts.length < 2) {
                return;
            }
            String message = cmdParts[1];
            if (postSupport) {
                String supportMessage = "```" + player.getName() + ": " + message;
                if (addTeleportCommand) {
                    supportMessage = supportMessage + "\nTeleport command:> goto " + pos.x + " " + pos.y + " " + pos.z;
                }
                supportMessage = supportMessage + "```";
                if (supportScreenshot || message.contains("+screen")) {
                    int playerResolutionX = player.getScreenResolutionX();
                    float sizeFactor = 1.0f;
                    if (playerResolutionX > maxScreenWidth) {
                        sizeFactor = (float)maxScreenWidth * 1.0f / (float)playerResolutionX * 1.0f;
                    }
                    log.out("Taking screenshot with factor " + sizeFactor, 0);
                    String msgToSend = supportMessage;
                    player.createScreenshot(sizeFactor, bimg -> {
                        ByteArrayOutputStream os = new ByteArrayOutputStream();
                        try {
                            ImageIO.write((RenderedImage)bimg, "jpg", os);
                            this.sendDiscordMessage("SupportTicket", msgToSend, webHookSupportUrl, os.toByteArray());
                            StringBuilder stringBuilder = new StringBuilder();
                            c.getClass();
                            StringBuilder stringBuilder2 = stringBuilder.append("[#00FF00]").append(pluginName).append(":>");
                            c.getClass();
                            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("SUPPORT_SUCCESS", lang)).toString());
                        }
                        catch (Exception e) {
                            log.out(e.toString());
                        }
                    });
                } else {
                    this.sendDiscordMessage("SupportTicket", supportMessage, webHookSupportUrl);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder34 = stringBuilder.append("[#00FF00]").append(pluginName).append(":>");
                    c.getClass();
                    player.sendTextMessage(stringBuilder34.append("[#EEEEEE]").append(t.get("SUPPORT_SUCCESS", lang)).toString());
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder35 = stringBuilder.append("[#FF0000]").append(pluginName).append(":>");
                c.getClass();
                player.sendTextMessage(stringBuilder35.append("[#EEEEEE]").append(t.get("SUPPORT_NOTAVAILABLE", lang)).toString());
            }
        } else if (command.equals("/joinDiscord")) {
            if (joinDiscord.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder36 = stringBuilder.append("[#FF0000]").append(pluginName).append(":>");
                c.getClass();
                player.sendTextMessage(stringBuilder36.append("[#EEEEEE]").append(t.get("CMD_JOINDISCORD_NA", lang)).toString());
            } else {
                player.connectToDiscord("https://discord.gg/" + joinDiscord);
            }
        } else if (command.equals("/ozrestart")) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder37 = stringBuilder.append("[#FF0000]").append(pluginName).append(":>");
            c.getClass();
            StringBuilder stringBuilder38 = stringBuilder37.append("[#EEEEEE]");
            String string = t.get("CMD_ERR_DEPRECATED", lang);
            StringBuilder stringBuilder39 = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder40 = stringBuilder39.append("[#997d4a]").append("/").append(pluginCMD).append(" restart");
            c.getClass();
            player.sendTextMessage(stringBuilder38.append(string.replace("PH_NEWCMD", stringBuilder40.append("[#EEEEEE]").toString())).toString());
        }
    }

    @EventMethod
    public void onPlayerChat(PlayerChatEvent event) {
        String message = event.getChatMessage();
        String noColorText = message.replaceAll("(\\[#[0-9a-fA-F]+\\])", "");
        Boolean processMessage = postChat;
        if (!processMessage.booleanValue()) {
            return;
        }
        if (GlobalIntercom != null) {
            processMessage = !((GlobalIntercom)GlobalIntercom).isGIMessage(event);
            if (noColorText.startsWith("#%")) {
                noColorText = noColorText.substring(2);
            }
        }
        if (processMessage.booleanValue() && noColorText.trim().length() > 0) {
            Player player = event.getPlayer();
            if (allowScreenshots && noColorText.contains("+screen")) {
                int playerResolutionX = player.getScreenResolutionX();
                float sizeFactor = 1.0f;
                if (playerResolutionX > maxScreenWidth) {
                    sizeFactor = (float)maxScreenWidth * 1.0f / (float)playerResolutionX * 1.0f;
                }
                String textToSend = noColorText.replace("+screen", "[screenshot.jpg]");
                log.out("Taking screenshot with factor " + sizeFactor, 0);
                player.createScreenshot(sizeFactor, bimg -> {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bimg, "jpg", os);
                        this.sendDiscordMessage(player.getName(), textToSend, webHookChatUrl, os.toByteArray());
                    }
                    catch (Exception e) {
                        log.out(e.toString());
                    }
                });
            } else {
                if (noColorText.contains("+screen")) {
                    log.out("Screenshot taking not enabled", 0);
                }
                this.sendDiscordMessage(player.getName(), noColorText, webHookChatUrl);
            }
            if (colorizeChat) {
                this.broadcastChatMessage(player, noColorText);
                event.setCancelled(true);
            }
        }
    }

    private void broadcastChatMessage(Player eventPlayer, String noColorText) {
        this.getServer().getAllPlayers().forEach(player -> {
            String color = colorLocalOther;
            if (player.getUID() == eventPlayer.getUID()) {
                color = colorLocalSelf;
            } else if (eventPlayer.isAdmin()) {
                color = colorLocalAdmin;
            }
            String group = "";
            if (showGroup) {
                group = " (" + eventPlayer.getPermissionGroup() + ")";
            }
            StringBuilder stringBuilder = new StringBuilder().append(color).append("[LOCAL] ").append(eventPlayer.getName()).append(group).append(": ");
            c.getClass();
            player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(noColorText).toString());
        });
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (sendPluginWelcome) {
            Player player = event.getPlayer();
            String lang = player.getSystemLanguage();
            player.sendTextMessage(t.get("MSG_PLUGIN_WELCOME", lang));
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        if (postStatus) {
            Player player = event.getPlayer();
            String username = statusUsername;
            if (useServerName) {
                Server server = this.getServer();
                username = server.getName();
            }
            this.sendDiscordMessage(username, t.get("DC_PLAYER_CONNECTED", botLang).replace("PH_PLAYER", player.getName()), webHookStatusUrl);
        }
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        if (postStatus) {
            Player player = event.getPlayer();
            Server server = this.getServer();
            String username = statusUsername;
            if (useServerName) {
                username = server.getName();
            }
            this.sendDiscordMessage(username, t.get("DC_PLAYER_DISCONNECTED", botLang).replace("PH_PLAYER", player.getName()), webHookStatusUrl);
            if (flagRestart) {
                int playersLeft = server.getPlayerCount() - 1;
                if (playersLeft == 0) {
                    this.sendDiscordMessage(username, t.get("RESTART_PLAYER_LAST", botLang), webHookStatusUrl);
                    server.saveAll();
                    server.shutdown();
                } else if (playersLeft > 1) {
                    this.broadcastMessage("BC_PLAYER_REMAIN", playersLeft);
                }
            }
        }
    }

    @EventMethod
    public void onPlayerRemoveObject(PlayerRemoveObjectEvent event) {
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        Vector3f pos = event.getObjectPosition();
        String posMap = (int)pos.x + (pos.x > 0.0f ? "W" : "E") + " " + (int)pos.z + (pos.z > 0.0f ? "N" : "S");
        if (!def.isPickupable() || !trackPickupables) {
            return;
        }
        String msg = t.get("BAT_OBJECT_REMOVE", botLang).replace("PH_PLAYER", event.getPlayer().getName()).replace("PH_OBJECT_NAME", def.getName()).replace("PH_LOCATION", pos.x + " " + pos.y + " " + pos.z).replace("PH_MAP_COORDINATES", posMap);
        log.out(msg, (int)trackServerLogLevel.shortValue());
        this.sendDiscordMessage(statusUsername, msg, webHookEventUrl);
    }

    @EventMethod
    public void onPlayerDestroyObject(PlayerDestroyObjectEvent event) {
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        Vector3f pos = event.getObjectPosition();
        String posMap = (int)pos.x + (pos.x > 0.0f ? "W" : "E") + " " + (int)pos.z + (pos.z > 0.0f ? "N" : "S");
        if (!def.isPickupable() || !trackPickupables) {
            return;
        }
        String msg = t.get("BAT_OBJECT_DESTROY", botLang).replace("PH_PLAYER", event.getPlayer().getName()).replace("PH_OBJECT_NAME", def.getName()).replace("PH_LOCATION", pos.x + " " + pos.y + " " + pos.z).replace("PH_MAP_COORDINATES", posMap);
        log.out(msg, (int)trackServerLogLevel.shortValue());
        this.sendDiscordMessage(statusUsername, msg, webHookEventUrl);
    }

    @EventMethod
    public void onNpcDeath(NpcDeathEvent event) {
        Npc npc = event.getNpc();
        Definitions.NpcDefinition def = npc.getDefinition();
        Vector3f pos = event.getDeathPosition();
        String posString = pos.x + " " + pos.y + " " + pos.z;
        String posMap = (int)pos.x + (pos.x > 0.0f ? "W" : "E") + " " + (int)pos.z + (pos.z > 0.0f ? "N" : "S");
        if (event.getCause() != NpcDeathEvent.Cause.KilledByPlayer) {
            return;
        }
        Player player = (Player)event.getKiller();
        if (npc.getType() == Npc.Type.Mount && trackMountKill) {
            String msg = t.get("BAT_KILL_MOUNT", botLang).replace("PH_PLAYER", player.getName()).replace("PH_NPC_NAME", def.getName()).replace("PH_LOCATION", posString).replace("PH_MAP_COORDINATES", posMap);
            log.out(msg, (int)trackServerLogLevel.shortValue());
            this.sendDiscordMessage(statusUsername, msg, webHookEventUrl);
        } else if (npc.getType() == Npc.Type.Animal && trackNonHostileAnimalKill && !npc.getDefinition().getBehaviour().equalsIgnoreCase("AGGRESSIVE")) {
            String msg = t.get("BAT_KILL_ANIMAL", botLang).replace("PH_PLAYER", player.getName()).replace("PH_NPC_NAME", def.getName()).replace("PH_LOCATION", posString).replace("PH_MAP_COORDINATES", posMap);
            log.out(msg, (int)trackServerLogLevel.shortValue());
            this.sendDiscordMessage(statusUsername, msg, webHookEventUrl);
        }
    }

    public void onDisable() {
        log.out("OmegaZirkel Discord Plugin deactivated", 10);
        if (reportStatusDisabled) {
            Server server = this.getServer();
            String username = statusUsername;
            if (useServerName) {
                username = server.getName();
            }
            this.sendDiscordMessage(username, statusDisabledMessage, webHookStatusUrl);
        }
        if (botEnable) {
            DiscordBot.disconnect();
        }
    }

    private void sendDiscordMessage(String username, String text, String channel, byte[] image) {
        block11: {
            try {
                username = username.replace("@", "").replace("@", "").replace(":", "").replace("`", "");
                if (username.length() < 2) {
                    username = username + "__";
                }
                if (username.length() > 32) {
                    username = username.substring(0, 31);
                }
                JSONObject json = new JSONObject();
                json.put((Object)"content", (Object)text);
                json.put((Object)"username", (Object)username);
                if (overrideAvatar) {
                    String avatar_url = "https://api.adorable.io/avatars/128/" + username.replace(" ", "%20");
                    json.put((Object)"avatar_url", (Object)avatar_url);
                }
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpPost post = new HttpPost(channel);
                StringEntity stringObject = new StringEntity(json.toJSONString(), "UTF-8");
                post.setHeader("Content-type", "application/json; charset=UTF-8");
                post.setEntity((HttpEntity)stringObject);
                HttpResponse response = httpClient.execute((HttpUriRequest)post);
                int status = response.getStatusLine().getStatusCode();
                if (status != 204) {
                    HttpEntity entity = response.getEntity();
                    String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                    log.out("HTTP Status: " + status + "\nResponse: " + responseString + "\nRequest was: " + stringObject, 0);
                }
                if (image == null) break block11;
                try {
                    HttpPost imagePost = new HttpPost(channel);
                    MultipartEntityBuilder builder = MultipartEntityBuilder.create();
                    builder.addTextBody("username", username, ContentType.TEXT_PLAIN);
                    if (overrideAvatar) {
                        builder.addTextBody("avatar_url", "https://api.adorable.io/avatars/128/" + username.replace(" ", "%20"), ContentType.TEXT_PLAIN);
                    }
                    builder.addBinaryBody("file", image, ContentType.APPLICATION_OCTET_STREAM, "screenshot.jpg");
                    HttpEntity multipart = builder.build();
                    imagePost.setEntity(multipart);
                    HttpResponse imageResponse = httpClient.execute((HttpUriRequest)imagePost);
                    int imageStatus = imageResponse.getStatusLine().getStatusCode();
                    if (imageStatus != 204) {
                        HttpEntity entity = imageResponse.getEntity();
                        String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                        log.out("HTTP Status: " + status + "\nResponse: " + responseString + "\nRequest was: " + stringObject, 0);
                    }
                }
                catch (Exception e) {
                    log.out("Exception on sendDiscordMessage: " + e.getMessage(), 100);
                }
            }
            catch (IOException ex) {
                log.out("IOException on sendDiscordMessage: " + ex.getMessage(), 100);
            }
            catch (UnsupportedCharsetException | ParseException ex) {
                log.out("Exception on sendDiscordMessage: " + ex.getMessage(), 100);
            }
        }
    }

    private void sendDiscordMessage(String username, String text, String channel) {
        this.sendDiscordMessage(username, text, channel, null);
    }

    public void sendDiscordStatusMessage(String username, String text) {
        this.sendDiscordMessage(username, text, webHookStatusUrl);
    }

    public void sendDiscordEventMessage(String username, String text) {
        this.sendDiscordMessage(username, text, webHookEventUrl);
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.getPath() + "/settings.properties");
            settings.load(new InputStreamReader((InputStream)in, "UTF8"));
            in.close();
            logLevel = Integer.parseInt(settings.getProperty("logLevel", "0"));
            postChat = settings.getProperty("postChat", "false").contentEquals("true");
            webHookChatUrl = settings.getProperty("webHookChatUrl", "");
            joinDiscord = settings.getProperty("joinDiscord", "");
            overrideAvatar = settings.getProperty("overrideAvatar", "true").contentEquals("true");
            postStatus = settings.getProperty("postStatus", "false").contentEquals("true");
            reportStatusEnabled = settings.getProperty("reportStatusEnabled", "true").contentEquals("true");
            reportStatusDisabled = settings.getProperty("reportStatusDisabled", "true").contentEquals("true");
            reportSettingsChanged = settings.getProperty("reportSettingsChanged", "true").contentEquals("true");
            reportJarChanged = settings.getProperty("reportJarChanged", "true").contentEquals("true");
            webHookStatusUrl = settings.getProperty("webHookStatusUrl", "");
            statusUsername = settings.getProperty("statusUsername", "");
            statusEnabledMessage = settings.getProperty("statusEnabledMessage", "");
            statusDisabledMessage = settings.getProperty("statusDisabledMessage", "");
            useServerName = settings.getProperty("useServerName", "false").contentEquals("true");
            postSupport = settings.getProperty("postSupport", "false").contentEquals("true");
            supportScreenshot = settings.getProperty("supportScreenshot", "true").contentEquals("true");
            addTeleportCommand = settings.getProperty("addTeleportCommand", "true").contentEquals("true");
            webHookSupportUrl = settings.getProperty("webHookSupportUrl", "");
            botChatChannelName = settings.getProperty("botChatChannelName", "server-chat");
            botEnable = settings.getProperty("botEnable", "false").contentEquals("true");
            botSecure = settings.getProperty("botSecure", "true").contentEquals("true");
            botToken = settings.getProperty("botToken", "");
            botLang = settings.getProperty("botLang", "en");
            botAdmins = settings.getProperty("botAdmins", "");
            discordCommands.put("help", Short.parseShort(settings.getProperty("botCMDhelp", "1")));
            discordCommands.put("version", Short.parseShort(settings.getProperty("botCMDversion", "1")));
            discordCommands.put("online", Short.parseShort(settings.getProperty("botCMDonline", "1")));
            discordCommands.put("weather", Short.parseShort(settings.getProperty("botCMDweather", "1")));
            discordCommands.put("time", Short.parseShort(settings.getProperty("botCMDtime", "1")));
            discordCommands.put("banned", Short.parseShort(settings.getProperty("botCMDbanned", "1")));
            discordCommands.put("restart", Short.parseShort(settings.getProperty("botCMDrestart", "2")));
            discordCommands.put("support", Short.parseShort(settings.getProperty("botCMDsupport", "2")));
            discordCommands.put("kick", Short.parseShort(settings.getProperty("botCMDkick", "2")));
            discordCommands.put("ban", Short.parseShort(settings.getProperty("botCMDban", "2")));
            discordCommands.put("group", Short.parseShort(settings.getProperty("botCMDgroup", "2")));
            discordCommands.put("yell", Short.parseShort(settings.getProperty("botCMDyell", "2")));
            discordCommands.put("bc", Short.parseShort(settings.getProperty("botCMDbc", "2")));
            discordCommands.put("unban", Short.parseShort(settings.getProperty("botCMDunban", "2")));
            discordCommands.put("tptp", Short.parseShort(settings.getProperty("botCMDtptp", "2")));
            discordCommands.put("mkadmin", Short.parseShort(settings.getProperty("botCMDmkadmin", "2")));
            discordCommands.put("unadmin", Short.parseShort(settings.getProperty("botCMDunadmin", "2")));
            discordCommands.put("setweather", Short.parseShort(settings.getProperty("botCMDsetweather", "2")));
            discordCommands.put("settime", Short.parseShort(settings.getProperty("botCMDsettime", "2")));
            discordCommands.put("sethealth", Short.parseShort(settings.getProperty("botCMDsethealth", "2")));
            discordCommands.put("sethunger", Short.parseShort(settings.getProperty("botCMDsethunger", "2")));
            discordCommands.put("setthirst", Short.parseShort(settings.getProperty("botCMDsetthirst", "2")));
            postTrackedEvents = settings.getProperty("postTrackedEvents", "false").contentEquals("true");
            webHookEventUrl = settings.getProperty("webHookEventUrl", "");
            trackServerLogLevel = Short.parseShort(settings.getProperty("trackServerLogLevel", "100"));
            trackMountKill = settings.getProperty("trackMountKill", "false").contentEquals("true");
            trackNonHostileAnimalKill = settings.getProperty("trackNonHostileAnimalKill", "false").contentEquals("true");
            trackPickupables = settings.getProperty("trackPickupables", "false").contentEquals("true");
            colorizeChat = settings.getProperty("colorizeChat", "true").contentEquals("true");
            showGroup = settings.getProperty("showGroup", "false").contentEquals("true");
            colorSupport = settings.getProperty("colorSupport", "[#782d8e]");
            colorLocalSelf = settings.getProperty("colorLocalSelf", "[#ddffdd]");
            colorLocalAdmin = settings.getProperty("colorLocalAdmin", "[#db3208]");
            colorLocalOther = settings.getProperty("colorLocalOther", "[#dddddd]");
            colorLocalDiscord = settings.getProperty("colorLocalDiscord", "[#ddddff]");
            allowScreenshots = settings.getProperty("allowScreenshots", "true").contentEquals("true");
            maxScreenWidth = Integer.parseInt(settings.getProperty("maxScreenWidth", "1920"));
            sendPluginWelcome = settings.getProperty("sendPluginWelcome", "false").contentEquals("true");
            restartTimed = settings.getProperty("restartTimed", "false").contentEquals("true");
            allowRestart = settings.getProperty("allowRestart", "false").contentEquals("true");
            restartAdminOnly = settings.getProperty("restartAdminOnly", "false").contentEquals("true");
            restartOnUpdate = settings.getProperty("restartOnUpdate", "false").contentEquals("true");
            restartMinimumTime = Integer.parseInt(settings.getProperty("restartMinimumTime", "86400"));
            forceRestartAfter = Integer.parseInt(settings.getProperty("forceRestartAfter", "0"));
            String restartTimesString = settings.getProperty("restartTimes", "00:00");
            if (restartTimed) {
                String[] restartTimes = restartTimesString.split("\\|");
                this.initRestartSchedule(restartTimes);
            }
            log.out("DiscordPlugin Plugin settings loaded", 10);
            log.out("Will send chat to Discord: " + String.valueOf(postChat), 10);
            log.out("Will send status to Discord: " + String.valueOf(postStatus), 10);
            log.out("Will send support tickets to Discord: " + String.valueOf(postSupport), 10);
            log.out("Sending welcome message on login is: " + String.valueOf(sendPluginWelcome), 10);
        }
        catch (IOException ex) {
            log.out("IOException on initSettings: " + ex.getMessage(), 100);
        }
        catch (NumberFormatException ex) {
            log.out("NumberFormatException on initSettings: " + ex.getMessage(), 100);
        }
        catch (Exception ex) {
            log.out("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    private void initRestartSchedule(String[] times) {
        try {
            Calendar cal = Calendar.getInstance();
            int minHour = 24;
            int minMinute = 60;
            int nextHour = -1;
            int nextMinute = -1;
            for (String time : times) {
                String[] timeParts = time.split(":");
                int hour = Integer.parseInt(timeParts[0]);
                int minute = Integer.parseInt(timeParts[1]);
                if (hour <= minHour) {
                    minHour = hour;
                    if (minute <= minMinute) {
                        minMinute = minute;
                    }
                }
                if (hour == cal.get(11) && minute > cal.get(12) && (nextMinute < 0 || nextMinute > minute)) {
                    log.out("new time found: " + hour + ":" + minute, 10);
                    nextHour = hour;
                    nextMinute = minute;
                    continue;
                }
                if (hour <= cal.get(11) || nextHour >= 0 && nextHour < hour || nextMinute >= 0 && (hour != nextHour || nextMinute <= minute)) continue;
                log.out("new time found: " + hour + ":" + minute, 10);
                nextHour = hour;
                nextMinute = minute;
            }
            if (nextHour < 0) {
                nextHour = minHour;
                nextMinute = minMinute;
            }
            if (nextHour < cal.get(11) || nextHour == cal.get(11) && nextMinute < cal.get(12)) {
                cal.set(5, cal.get(5) + 1);
            }
            cal.set(11, nextHour);
            cal.set(12, nextMinute);
            log.out("Next Server restart time is scheduled on " + nextHour + ":" + nextMinute, 10);
            if (restartTask != null) {
                restartTask.cancel();
            }
            restartTask = new TimerTask(){

                @Override
                public void run() {
                    Server server = DiscordWebHook.this.getServer();
                    int playerNum = server.getAllPlayers().size();
                    if (playerNum > 0) {
                        log.out("Setting restart flag for scheduled server-restart", 10);
                        DiscordWebHook.this.broadcastMessage("RS_SCHEDULE_INFO");
                        flagRestart = true;
                        if (forceRestartAfter > 0) {
                            DiscordWebHook.this.broadcastMessage("RS_SCHEDULE_WARN", forceRestartAfter);
                        }
                    } else {
                        log.out("Restarting server now (scheduled)", 10);
                        server.saveAll();
                        server.shutdown();
                    }
                }
            };
            restartTimer.schedule(restartTask, cal.getTime());
            if (forceRestartAfter > 0) {
                if (restartForcedTask != null) {
                    restartForcedTask.cancel();
                }
                restartForcedTask = new TimerTask(){

                    @Override
                    public void run() {
                        log.out("Force server restart now!", 10);
                        Server server = DiscordWebHook.this.getServer();
                        server.getAllPlayers().forEach(p -> p.kick("Server restart"));
                        server.saveAll();
                        server.shutdown();
                    }
                };
                cal.set(12, nextMinute + forceRestartAfter);
                restartTimer.schedule(restartForcedTask, cal.getTime());
            }
            restartTimer.purge();
        }
        catch (Exception e) {
            log.out(e.getLocalizedMessage(), 999);
        }
    }

    private void broadcastMessage(String i18nIndex, String playerName) {
        this.getServer().getAllPlayers().forEach(player -> {
            try {
                String lang = player.getSystemLanguage();
                StringBuilder stringBuilder = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#808000]").append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get(i18nIndex, lang).replace("PH_PLAYER", playerName)).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void broadcastMessage(String i18nIndex, int number) {
        this.getServer().getAllPlayers().forEach(player -> {
            try {
                String lang = player.getSystemLanguage();
                StringBuilder stringBuilder = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#808000]").append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get(i18nIndex, lang).replace("PH_NUMBER", number + "")).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void broadcastMessage(String i18nIndex) {
        this.broadcastMessage(i18nIndex, "");
    }

    public void onFileCreateEvent(Path file) {
        if (file.toString().endsWith("jar")) {
            log.out(file + " file was changed, set restart flag (or restart if no player online)", 10);
            Server server = this.getServer();
            if (reportJarChanged) {
                String username = statusUsername;
                if (useServerName) {
                    username = server.getName();
                }
                if (restartOnUpdate) {
                    if (server.getPlayerCount() > 0) {
                        this.sendDiscordMessage(username, t.get("UPDATE_FLAG", botLang).replace("PH_FILE", file.getFileName() + ""), webHookStatusUrl);
                        this.broadcastMessage("BC_UPDATE_FLAG");
                    } else {
                        this.sendDiscordMessage(username, t.get("UPDATE_RESTART", botLang).replace("PH_FILE", file.getFileName() + ""), webHookStatusUrl);
                    }
                } else {
                    this.sendDiscordMessage(username, t.get("UPDATE_INFO", botLang).replace("PH_FILE", file.getFileName() + ""), webHookStatusUrl);
                }
            }
            if (restartOnUpdate) {
                if (server.getPlayerCount() > 0) {
                    flagRestart = true;
                } else {
                    server.saveAll();
                    server.shutdown();
                }
            }
        } else {
            log.out("onFileCreateEvent: <" + file + ">", 0);
        }
    }

    public void onFileChangeEvent(Path file) {
        if (file.toString().endsWith("settings.properties")) {
            log.out("Settings file was changed, reloading settings now", 10);
            if (reportSettingsChanged) {
                Server server = this.getServer();
                String username = statusUsername;
                if (useServerName) {
                    username = server.getName();
                }
                this.sendDiscordMessage(username, t.get("UPDATE_SETTINGS", botLang), webHookStatusUrl);
            }
            this.initSettings();
        } else {
            log.out(file.toString() + " was changed", 0);
        }
    }
}

