/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld.tools.db;

import de.omegazirkel.risingworld.tools.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.Database;

public class SQLite {
    private Plugin plugin = null;
    private Logger log = null;
    private Database db = null;

    public SQLite(Plugin plugin) {
        this.plugin = plugin;
        this.log = new Logger("[OZ.SQLite]", 0);
        this.initDatabase();
    }

    public SQLite(Plugin plugin, int logLevel) {
        this.plugin = plugin;
        this.log = new Logger("[OZ.SQLite]", logLevel);
        this.initDatabase();
    }

    private void initDatabase() {
        if (this.db == null) {
            String path = this.plugin.getPath() + "/" + this.plugin.getWorld().getName() + ".db";
            this.db = this.plugin.getSQLiteConnection(path);
            this.log.out("Connected to " + path, 0);
        }
    }

    public Database getRawDatabase() {
        return this.db;
    }

    public ResultSet executeQuery(String query) throws SQLException {
        this.initDatabase();
        try {
            return this.db.executeQuery(query);
        }
        catch (Exception e) {
            this.log.out(e.getMessage(), 911);
            return null;
        }
    }

    public void executeUpdate(String query) {
        this.initDatabase();
        try {
            this.db.executeUpdate(query);
        }
        catch (Exception e) {
            this.log.out(e.getMessage(), 911);
        }
    }

    public void execute(String query) {
        this.initDatabase();
        try {
            this.db.execute(query);
        }
        catch (Exception e) {
            this.log.out(e.getMessage(), 911);
        }
    }

    public void destroy() {
        try {
            this.db.close();
            this.db = null;
        }
        catch (Exception e) {
            this.log.out(e.getMessage(), 911);
        }
    }
}

