/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld.tools;

import de.omegazirkel.risingworld.tools.Logger;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.glassfish.tyrus.client.ClientManager;

@ClientEndpoint
public class WSClientEndpoint {
    private static final Logger log = new Logger("[OZ.Tools]");
    public Session session = null;
    public boolean isConnected = false;
    protected URI endpointURI = null;
    protected MessageHandler messageHandler;
    protected ClientManager client;

    public WSClientEndpoint(URI endpointURI) {
        this.endpointURI = endpointURI;
        this.client = ClientManager.createClient();
        ClientManager.ReconnectHandler reconnectHandler = new ClientManager.ReconnectHandler(){
            private int counter = 0;

            public boolean onDisconnect(CloseReason closeReason) {
                int i = ++this.counter;
                log.out("WebSocket got disconnected: " + closeReason.toString(), 911);
                if (closeReason.getCloseCode() == CloseReason.CloseCodes.CLOSED_ABNORMALLY) {
                    log.out("WebSocket reconnecting... " + i, 0);
                    return true;
                }
                log.out("WebSocket not reconnecting.", 0);
                return false;
            }

            public boolean onConnectFailure(Exception exception) {
                int i = ++this.counter;
                log.out("WebSocket failed to connect: " + exception.getMessage(), 911);
                log.out("WebSocket reconnecting... " + i, 0);
                return true;
            }
        };
        this.client.getProperties().put("org.glassfish.tyrus.client.ClientManager.ReconnectHandler", reconnectHandler);
        this.connect();
    }

    protected void connect() {
        try {
            log.out("WebSocket connecting to " + this.endpointURI, 0);
            this.session = (Session)this.client.asyncConnectToServer((Object)this, this.endpointURI).get();
        }
        catch (InterruptedException | ExecutionException | DeploymentException e) {
            log.out(e.getMessage(), 911);
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        log.out(t.toString(), 911);
    }

    @OnOpen
    public void onOpen(Session session) {
        this.session = session;
        this.isConnected = true;
        log.out("WebSocket connected!", 0);
    }

    @OnClose
    public void onClose(Session session, CloseReason reason) {
        this.session = null;
        this.isConnected = false;
        log.out("WebSocket closed: " + reason.toString(), 911);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        if (this.messageHandler != null) {
            this.messageHandler.handleMessage(message);
        } else {
            log.out("No messageHandler for message: " + message, 0);
        }
    }

    @OnMessage
    public void onBinaryMessage(byte[] buffer) {
        if (this.messageHandler != null) {
            this.messageHandler.handleBinaryMessage(buffer);
        } else {
            log.out("No messageHandler for buffer: " + buffer.length, 0);
        }
    }

    public void setMessageHandler(MessageHandler msgHandler) {
        this.messageHandler = msgHandler;
    }

    public void sendMessage(String message) {
        this.session.getAsyncRemote().sendText(message);
    }

    public void sendBinaryMessage(ByteBuffer buffer) {
        try {
            this.session.getAsyncRemote().sendBinary(ByteBuffer.wrap((byte[])buffer.array().clone())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.out("Error on sendBinaryMessage: " + e.getMessage(), 911);
        }
    }

    public static interface MessageHandler {
        public void handleMessage(String var1);

        public void handleBinaryMessage(byte[] var1);
    }
}

