/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld.tools;

import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginChangeWatcher {
    private static WatchService watcher = null;
    private static final Map<WatchKey, Path> keyPaths = new ConcurrentHashMap<WatchKey, Path>();
    private static final Map<WatchKey, FileChangeListener> keyListener = new ConcurrentHashMap<WatchKey, FileChangeListener>();
    private static volatile Thread processingThread;
    private static final Logger log;

    public static WatchKey registerFileChangeListener(FileChangeListener flc, File dir) {
        PluginChangeWatcher.initListenerThread();
        try {
            Path p = dir.toPath();
            log.out("register " + p);
            WatchKey key = p.register(watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            keyPaths.put(key, p);
            keyListener.put(key, flc);
            return key;
        }
        catch (Exception e) {
            log.out("registerFileChangeListener-> " + e.toString(), 911);
            return null;
        }
    }

    public static void unregisterFileChangeListener(WatchKey key) {
        keyPaths.remove(key);
        keyListener.remove(key);
    }

    public static void initListenerThread() {
        if (processingThread == null) {
            processingThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.currentThread().setName("ChangeWatcher");
                        PluginChangeWatcher.processFileNotifications();
                    }
                    catch (InterruptedException ex) {
                        log.out("processingThread-> " + ex.toString());
                        processingThread = null;
                    }
                    catch (IOException e) {
                        log.out("processingThread-> " + e.toString());
                        processingThread = null;
                    }
                }
            };
            processingThread.start();
        }
    }

    public static void shutDownListener() {
        Thread thr = processingThread;
        if (thr != null) {
            thr.interrupt();
        }
    }

    private static void processFileNotifications() throws InterruptedException, IOException {
        while (true) {
            WatchKey key;
            if (watcher == null) {
                watcher = FileSystems.getDefault().newWatchService();
                log.out("Start WatchUpdates");
            }
            if (keyPaths.containsKey(key = watcher.take()) && keyListener.containsKey(key)) {
                Path dir = keyPaths.get(key);
                FileChangeListener fcl = keyListener.get(key);
                key.pollEvents().forEach(evt -> {
                    Object o;
                    WatchEvent.Kind eventType = evt.kind();
                    if (eventType != StandardWatchEventKinds.OVERFLOW && (o = evt.context()) instanceof Path) {
                        Path path = (Path)o;
                        PluginChangeWatcher.process(dir, path, eventType, fcl);
                    }
                });
            }
            key.reset();
        }
    }

    private static void process(Path dir, Path file, WatchEvent.Kind<?> evtType, FileChangeListener fcl) {
        if (evtType == StandardWatchEventKinds.ENTRY_MODIFY) {
            fcl.onFileChangeEvent(file);
        }
        if (evtType == StandardWatchEventKinds.ENTRY_CREATE && !file.toString().startsWith(".")) {
            fcl.onFileCreateEvent(file);
        }
    }

    static {
        log = new Logger("[OZ.Tools]");
    }
}

