/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.RWGui;
import java.util.ArrayList;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.utils.Vector2i;

public class GuiTableLayout
extends GuiLayout {
    private final int maxNumOfCols;
    private final int maxNumOfRows;
    private final int[] colFlags;
    private final int[] rowFlags;

    public GuiTableLayout(int maxNumOfCols, int maxNumOfRows, int flags) {
        super(flags);
        int i;
        this.maxNumOfCols = maxNumOfCols;
        this.maxNumOfRows = maxNumOfRows;
        this.colFlags = new int[maxNumOfCols];
        for (i = 0; i < maxNumOfCols; ++i) {
            this.colFlags[i] = 0;
        }
        this.rowFlags = new int[maxNumOfRows];
        for (i = 0; i < maxNumOfRows; ++i) {
            this.rowFlags[i] = 8;
        }
    }

    public void setColFlag(int idx, int flag) {
        if (idx >= 0 && idx < this.maxNumOfCols) {
            this.colFlags[idx] = flag;
            if ((flag & 2) != 0 && this.children != null) {
                for (int i = idx; i < this.children.size(); i += this.maxNumOfCols) {
                    if (this.children.get(i) == null) continue;
                    ((GuiElement)((RWGui.Pair)this.children.get(i)).getL()).setPivot(PivotPosition.TopRight);
                }
            }
        }
    }

    public void setRowFlag(int idx, int flag) {
        if (idx >= 0 && idx < this.maxNumOfRows) {
            this.rowFlags[idx] = flag;
        }
    }

    @Override
    public void addChild(GuiElement element, Integer id, Object data) {
        if (this.children == null) {
            this.children = new ArrayList(this.maxNumOfCols * this.maxNumOfRows);
        }
        if (this.children.size() < this.maxNumOfCols * this.maxNumOfRows) {
            if (element == null) {
                this.children.add(null);
            } else {
                int col = this.children.size() % this.maxNumOfCols;
                super.addChild(element, id, data);
                if ((this.colFlags[col] & 2) != 0) {
                    element.setPivot(PivotPosition.TopRight);
                }
            }
        }
    }

    @Override
    void layout(int minWidth, int minHeight, boolean reset) {
        int i;
        int row;
        int col;
        int count;
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        Vector2i[] elemSizes = new Vector2i[this.maxNumOfCols * this.maxNumOfRows];
        int[] colWidths = new int[this.maxNumOfCols];
        int[] rowHeights = new int[this.maxNumOfRows];
        int height = 0;
        int width = 0;
        if (reset) {
            height = 0;
            minHeight = 0;
            width = 0;
            minWidth = 0;
        } else {
            count = 0;
            for (RWGui.Pair item : this.children) {
                if (item != null) {
                    elemSizes[count] = RWGui.getElementSizes((GuiElement)item.getL());
                    col = count % this.maxNumOfCols;
                    row = count / this.maxNumOfCols;
                    if (colWidths[col] < elemSizes[count].x) {
                        colWidths[col] = elemSizes[count].x;
                    }
                    if (rowHeights[row] < elemSizes[count].y) {
                        rowHeights[row] = elemSizes[count].y;
                    }
                }
                if (++count < this.maxNumOfCols * this.maxNumOfRows) continue;
                break;
            }
            ++count;
        }
        count = 0;
        for (RWGui.Pair item : this.children) {
            if (item != null) {
                GuiElement element = (GuiElement)item.getL();
                col = count % this.maxNumOfCols;
                row = count / this.maxNumOfCols;
                if (element instanceof GuiLayout) {
                    ((GuiLayout)element).layout(colWidths[col], rowHeights[row], reset);
                }
                elemSizes[count] = RWGui.getElementSizes(element);
                if (colWidths[col] < elemSizes[count].x) {
                    colWidths[col] = elemSizes[count].x;
                }
                if (rowHeights[row] < elemSizes[count].y) {
                    rowHeights[row] = elemSizes[count].y;
                }
            }
            if (++count < this.maxNumOfCols * this.maxNumOfRows) continue;
            break;
        }
        for (i = 0; i < this.maxNumOfCols; ++i) {
            width += colWidths[i] + this.padding;
        }
        width += this.margin * 2 - this.padding;
        for (i = 0; i < this.maxNumOfRows; ++i) {
            height += rowHeights[i] + this.padding;
        }
        int spacingH = this.padding;
        int spacingW = this.padding;
        count = 0;
        int x = this.margin;
        int y = (height += this.margin * 2 - this.padding) - this.margin;
        for (RWGui.Pair item : this.children) {
            col = count % this.maxNumOfCols;
            row = count / this.maxNumOfCols;
            if (item != null) {
                int elX;
                Vector2i elementSizes = elemSizes[count];
                int n = (this.colFlags[col] & 2) != 0 ? colWidths[col] : (elX = (this.colFlags[col] & 1) != 0 ? (colWidths[col] - elementSizes.x) / 2 : 0);
                int elY = (this.rowFlags[row] & 0x10) != 0 ? -(rowHeights[row] - elementSizes.y) : ((this.colFlags[col] & 8) != 0 ? (elementSizes.y - rowHeights[row]) / 2 : 0);
                ((GuiElement)item.getL()).setPosition((float)(x + elX), (float)(y + elY), false);
            }
            x += colWidths[col] + spacingW;
            if (col == this.maxNumOfCols - 1) {
                x = 0;
                y -= rowHeights[row] + spacingH;
            }
            if (++count < this.maxNumOfCols * this.maxNumOfRows) continue;
            break;
        }
        this.setSize(width, height, false);
    }
}

