/*
 * Decompiled with CFR 0.152.
 */
package com.vistamaresoft.rwgui;

import com.vistamaresoft.rwgui.GuiLayout;
import com.vistamaresoft.rwgui.RWGui;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.utils.Vector2i;

public class GuiHorizontalLayout
extends GuiLayout {
    public GuiHorizontalLayout(int flags) {
        super(flags);
    }

    @Override
    void layout(int minWidth, int minHeight, boolean reset) {
        int height;
        int width;
        if (this.children == null || this.children.isEmpty()) {
            return;
        }
        Vector2i[] elemSizes = new Vector2i[this.children.size()];
        if (reset) {
            minWidth = 0;
            width = 0;
            height = minHeight;
        } else {
            width = 0;
            height = (int)this.getHeight() - this.margin * 2;
        }
        int count = 0;
        for (RWGui.Pair item : this.children) {
            GuiElement element = (GuiElement)item.getL();
            if (element instanceof GuiLayout) {
                ((GuiLayout)element).layout(0, height, reset);
            }
            elemSizes[count] = RWGui.getElementSizes(element);
            if (height < elemSizes[count].y) {
                height = elemSizes[count].y;
            }
            width += elemSizes[count].x + this.padding;
            ++count;
        }
        height += this.margin * 2;
        int spacing = this.padding;
        int x = this.margin;
        if (minWidth > (width += this.margin * 2 - this.padding)) {
            if ((this.flags & 2) != 0) {
                x = minWidth - width;
            } else if ((this.flags & 1) != 0) {
                x = (minWidth - width) / 2;
            } else if ((this.flags & 4) != 0) {
                spacing = (minWidth - width) / (this.children.size() - 1);
            }
            width = minWidth;
        }
        count = 0;
        for (RWGui.Pair item : this.children) {
            Vector2i elementSizes = elemSizes[count];
            int y = (this.flags & 8) != 0 ? (height + elementSizes.y) / 2 : ((this.flags & 0x10) != 0 ? height - this.margin - elementSizes.y : height - this.margin);
            ((GuiElement)item.getL()).setPosition((float)x, (float)y, false);
            x += elementSizes.x + spacing;
            ++count;
        }
        this.setSize(width, height, false);
    }
}

