/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.ClassLockKeyLang;
import de.chaoswg.ClassLockKeys;
import de.chaoswg.ToolsAPI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.AddAdminEvent;
import net.risingworld.api.events.general.RemoveAdminEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.KeyInput;

public class LockKeys
extends Plugin
implements Listener {
    private LockKeys plugin;
    private String UID_ATTRIBUTE_LockKey;
    private String UID_BASIS;
    private String UID_ATTRIBUTE;
    private List<String> sLockKeys;
    private ClassLockKeyLang lang;
    private ClassLockKeys lockKeysLoad;

    public void onEnable() {
        this.plugin = this;
        this.plugin.registerEventListener(this);
        this.UID_BASIS = "de.chaoswg." + this.getDescription("name") + ".";
        this.UID_ATTRIBUTE = "ATTRIBUTE.";
        this.UID_ATTRIBUTE_LockKey = this.UID_BASIS + this.UID_ATTRIBUTE + "F3";
        this.lockKeysLoad = new ClassLockKeys(this.plugin);
        this.lockKeysLoad.setDebug(false);
        this.lockKeysLoad.setVersion(this.plugin.getDescription("version"));
        this.lockKeysLoad.setKEYS(new String[]{"input_f3"});
        this.lockKeysLoad.loadConfig("");
        this.sLockKeys = Arrays.asList(this.lockKeysLoad.getKEYS());
        this.lang = this.lockKeysLoad.getLang();
    }

    public void onDisable() {
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        ArrayList iLockKeys = new ArrayList();
        this.sLockKeys.forEach(key -> player.getOption(key, sKey -> {
            this.lockKeysLoad.printlnDebug(1, "[" + this.getDescription("name") + "] Convert " + key + "#" + sKey);
            iLockKeys.add(KeyInput.fromString((String)sKey));
            player.setAttribute(this.UID_ATTRIBUTE_LockKey, (Object)iLockKeys);
            this.lockKeysLoad.printlnDebug(1, "[" + this.getDescription("name") + "] " + this.sLockKeys.toString() + " # " + iLockKeys.toString());
            List ar = (List)player.getAttribute(this.UID_ATTRIBUTE_LockKey);
            int[] keys = new int[ar.size()];
            int n = 0;
            for (Integer in : ar) {
                keys[n] = in;
            }
            if (!player.isAdmin()) {
                player.disableClientsideKeys(keys);
            }
            player.registerKeys(keys);
        }));
        player.setListenForKeyInput(true);
    }

    @EventMethod
    public void onAddAdmin(AddAdminEvent event) {
        Player player = this.plugin.getServer().getPlayer(event.getPlayerUID());
        List ar = (List)player.getAttribute(this.UID_ATTRIBUTE_LockKey);
        int[] keys = new int[ar.size()];
        int n = 0;
        for (Integer in : ar) {
            keys[n] = in;
        }
        player.enableClientsideKeys(keys);
        player.unregisterKeys(keys);
    }

    @EventMethod
    public void onRemoveAdmin(RemoveAdminEvent event) {
        Player player = this.plugin.getServer().getPlayer(event.getPlayerName());
        List ar = (List)player.getAttribute(this.UID_ATTRIBUTE_LockKey);
        int[] keys = new int[ar.size()];
        int n = 0;
        for (Integer in : ar) {
            keys[n] = in;
        }
        player.disableClientsideKeys(keys);
        player.registerKeys(keys);
    }

    @EventMethod
    public void onKeyInput(PlayerKeyEvent event) {
        Player player = event.getPlayer();
        List iLockKeys = (List)player.getAttribute(this.UID_ATTRIBUTE_LockKey);
        if (event.isPressed() && !event.getPlayer().isAdmin()) {
            this.lockKeysLoad.printlnDebug(2, "[" + this.getDescription("name") + "] " + this.sLockKeys.toString() + " # " + iLockKeys.toString() + " # " + iLockKeys.contains(event.getKeyCode()));
            if (iLockKeys.contains(event.getKeyCode())) {
                player.showStatusMessage(String.format(this.lang.AccessForbidden.get(player.getLanguage()), ToolsAPI.getKeyInputValue((int)event.getKeyCode()).replace("KEY_", "")), 3);
            }
        }
    }
}

