/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.Config;
import de.pbplugins.DebugerLogger;
import de.pbplugins.EventListener;
import de.pbplugins.PlayerEvent;
import de.pbplugins.PlayerEventCommand;
import de.pbplugins.SpezialNPC;
import de.pbplugins.amtAttribute;
import de.pbplugins.amtMember;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;

public class antimounttheft
extends Plugin {
    Database db;
    World world;
    private Config config;
    private SpezialNPC spNPC;
    float time;
    int debug;
    DebugerLogger dl;
    Server server;
    amtMember Member;
    amtAttribute Attribute;

    public void onEnable() {
        this.world = this.getWorld();
        this.Attribute = new amtAttribute(this);
        this.spNPC = new SpezialNPC(this);
        this.registerEventListener(new PlayerEventCommand(this));
        this.registerEventListener(new PlayerEvent(this));
        this.registerEventListener(new EventListener(this));
        System.out.println("[" + this.getDescription("name") + "] Enabled");
        System.out.println("[" + this.getDescription("name") + "] Load Database...");
        this.db = this.getSQLiteConnection(this.getPath() + "/database/" + this.getDescription("name") + "-" + this.world.getName() + ".db");
        this.iniDB();
        System.out.println("[AntiMountTheft] Load config...");
        String[][] sysConfigArray = new String[][]{{"Debug", "0"}, {"DebugLevel", "ALL"}, {"Spezial_Timer(sek)", "3600"}};
        this.config = new Config("System", sysConfigArray, this, 0);
        try {
            this.debug = Integer.parseInt(this.config.getValue("Debug"));
        }
        catch (NumberFormatException e1) {
            this.debug = 0;
        }
        try {
            this.time = Float.parseFloat(this.config.getValue("Spezial_Timer(sek)"));
        }
        catch (NumberFormatException e1) {
            this.time = 3600.0f;
        }
        this.server = this.getServer();
        this.dl = new DebugerLogger(this);
        this.Member = new amtMember(this, this.debug);
        if (this.debug > 0) {
            try {
                this.dl.createLog("log");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.spNPC.setAllSpezialNPC();
    }

    public SpezialNPC SpezialNPC() {
        return this.spNPC;
    }

    public Config Config() {
        return this.config;
    }

    public void onDisable() {
        System.out.println("[" + this.getDescription("name") + "] Disabled");
    }

    public boolean isPlayersNPC(Player player, Npc npc) {
        if (this.debug > 0) {
            this.dl.info("isPlayersNPC: " + String.valueOf(this.Attribute.Player.get.NpcOwned(player).contains(npc.getGlobalID())));
        }
        return this.Attribute.Player.get.NpcOwned(player).contains(npc.getGlobalID());
    }

    public boolean hasNPCaPlayer(Npc npc) {
        boolean pr\u00fcfer = false;
        long uid = -1L;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'AMT' WHERE NpcID=" + npc.getGlobalID() + "; ");){
            if (result != null) {
                uid = result.getLong("Player");
                if (this.debug > 0) {
                    this.dl.info("hasNPCaPlayer: result = -1");
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (uid > -1L) {
            if (this.debug > 0) {
                this.dl.info("hasNPCaPlayer: uid > -1");
            }
            pr\u00fcfer = true;
        }
        if (this.debug > 0) {
            this.dl.info("hasNPCaPlayer: " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public List<Long> getNpcOwners(Npc npc) {
        ArrayList<Long> ids = new ArrayList<Long>();
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'AMT' WHERE NpcID=" + npc.getGlobalID() + "; ");){
            if (result != null) {
                while (result.next()) {
                    ids.add(result.getLong("Player"));
                    if (this.debug <= 0) continue;
                    this.dl.info("hasNPCaPlayer: result = -1");
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ids;
    }

    public boolean addOwnerToNPC(Npc npc, Player player) {
        boolean pr\u00fcfer = false;
        List<Integer> AttList = this.Attribute.Player.get.NpcOwned(player);
        if (this.debug > 0) {
            this.dl.info("[AntiMountTheft]onPlayerMountNpcEvent: Neuer NPC wird eingetragen");
        }
        Connection connection = this.db.getConnection();
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement("INSERT INTO AMT (NpcID, Player) VALUES (?, ?)");
            pstmt.setInt(1, npc.getGlobalID());
            pstmt.setLong(2, player.getUID());
            pstmt.executeUpdate();
            AttList.add(npc.getGlobalID());
            pr\u00fcfer = true;
        }
        catch (SQLException ex) {
            this.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
            this.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
        }
        return pr\u00fcfer;
    }

    public void removeNPC(Npc npc) {
        Player player2;
        Connection connection = this.db.getConnection();
        try {
            PreparedStatement prepLok = connection.prepareStatement("DELETE FROM 'AMT' WHERE NpcID=" + npc.getGlobalID() + "; ");
            prepLok.executeUpdate();
        }
        catch (SQLException ex) {
            this.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
            this.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
        }
        List<Long> members = this.Attribute.NPC.get.NpcMember(npc);
        List<Long> owners = this.getNpcOwners(npc);
        for (long m : members) {
            player2 = this.server.getPlayer(m);
            if (player2 != null) {
                this.Member.removeMemberFromNpc(npc, player2);
                if (!player2.isConnected()) continue;
                player2.sendTextMessage("[#ffa500]NPC " + npc.getName() + " has been released");
                continue;
            }
            this.Member.removeMemberFromNpc(npc, m);
        }
        for (long o : owners) {
            player2 = this.server.getPlayer(o);
            if (player2 == null) continue;
            this.Attribute.Player.get.NpcOwned(player2).remove(npc.getGlobalID());
            if (!player2.isConnected()) continue;
            player2.sendTextMessage("[#ffa500]NPC " + npc.getName() + " has been released");
        }
        this.Attribute.NPC.get.NpcMember(npc).clear();
        this.Attribute.NPC.set.spHasPlayer(npc, false);
        npc.setLocked(false);
        npc.setName("");
    }

    public List<Integer> getNpcIDfromDB(Player player) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'AMT' WHERE Player=" + player.getUID() + "; ");){
            if (result != null) {
                while (result.next()) {
                    ids.add(result.getInt("NpcID"));
                    if (this.debug <= 0) continue;
                    this.dl.info("getNpcIDfromDB: add Player '" + player.getName() + "' NPC ID: " + result.getInt("NpcID"));
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return ids;
    }

    private void iniDB() {
        this.db.execute("CREATE TABLE IF NOT EXISTS AMT (ID INTEGER PRIMARY KEY NOT NULL, NpcID INTEGER, Player BIGINT ); ");
        this.db.execute("CREATE TABLE IF NOT EXISTS Member (ID INTEGER PRIMARY KEY NOT NULL, NpcID INTEGER, Player BIGINT ); ");
        this.db.execute("CREATE TABLE IF NOT EXISTS Spezial (ID INTEGER PRIMARY KEY NOT NULL, NpcID INTEGER, Typ INTEGER, PosX FLOAT, PosY FLOAT, PosZ FLOAT ); ");
    }
}

