/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.antimounttheft;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.risingworld.api.Timer;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class SpezialNPC {
    private final antimounttheft plugin;
    private List<Integer> spNPC;
    private final String Orange = "[#ffa500]";
    private final String Rot = "[#ff0000]";
    private int debug;
    List<String> types = new ArrayList<String>();

    public SpezialNPC(antimounttheft plugin) {
        this.plugin = plugin;
        this.spNPC = new ArrayList<Integer>();
        this.debug = plugin.debug;
        this.types.add("fixpos");
        this.types.add("timed");
        this.types.add("useall");
        this.types.add("other");
    }

    public List<Integer> getList() {
        return this.spNPC;
    }

    public String setTypIntToString(int typ) {
        String typS = null;
        switch (typ) {
            case 1: {
                typS = "fixpos";
                break;
            }
            case 2: {
                typS = "useall";
                break;
            }
            case 3: {
                typS = "timed";
                break;
            }
            case 4: {
                typS = "other";
                break;
            }
        }
        return typS;
    }

    public int setTypStringToInt(String typ) {
        int typI = -1;
        switch (typ) {
            case "fixpos": {
                typI = 1;
                break;
            }
            case "useall": {
                typI = 2;
                break;
            }
            case "timed": {
                typI = 3;
                break;
            }
            case "other": {
                typI = 4;
                break;
            }
        }
        return typI;
    }

    public int getSpezialTypFromDB(Npc npc) {
        int typ = -99;
        try (ResultSet result = this.plugin.db.executeQuery("SELECT * FROM 'Spezial' WHERE NpcID=" + npc.getGlobalID() + "; ");){
            if (result != null) {
                typ = result.getInt("Typ");
            }
        }
        catch (SQLException ex) {
            this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
            this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
        }
        return typ;
    }

    public Vector3f getSpezialPosFromDB(Npc npc) {
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        Vector3f pos = null;
        try (ResultSet result = this.plugin.db.executeQuery("SELECT * FROM 'Spezial' WHERE NpcID=" + npc.getGlobalID() + "; ");){
            if (result != null) {
                posX = result.getFloat("PosX");
                posY = result.getFloat("PosY");
                posZ = result.getFloat("PosZ");
            }
        }
        catch (SQLException ex) {
            this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
            this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
        }
        pos = new Vector3f(posX, posY, posZ);
        return pos;
    }

    public boolean changeTypInDB(Npc npc, int typ) {
        boolean pr\u00fcfer = false;
        if (this.isSpezialNPC(npc)) {
            pr\u00fcfer = true;
            Connection connection = this.plugin.db.getConnection();
            PreparedStatement pstmt = null;
            try {
                pstmt = connection.prepareStatement("UPDATE 'Spezial' SET Typ= ? WHERE NpcID=" + npc.getGlobalID());
                pstmt.setInt(1, typ);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
            }
        }
        return pr\u00fcfer;
    }

    public boolean addSpezialNPC(Npc npc, String type, Player player) {
        boolean pr\u00fcfer = false;
        int typI = -1;
        String typKlein = type.toLowerCase();
        if (npc.getType() == Npc.Type.Mount && this.types.contains(typKlein)) {
            typI = this.setTypStringToInt(type);
        } else if (npc.getType() != Npc.Type.Mount) {
            typI = 4;
        }
        if (typI > 0) {
            Connection connection = this.plugin.db.getConnection();
            PreparedStatement pstmt = null;
            try {
                pstmt = connection.prepareStatement("INSERT INTO 'Spezial' (NpcID, Typ) VALUES (?, ?)");
                pstmt.setInt(1, npc.getGlobalID());
                pstmt.setInt(2, typI);
                pstmt.executeUpdate();
                this.spNPC.add(npc.getGlobalID());
                pr\u00fcfer = true;
            }
            catch (SQLException ex) {
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
            }
            player.sendTextMessage("[#00ff00]Spezial-NPC set!");
            this.plugin.Attribute.Player.set.spOwned(player, npc.getGlobalID());
            this.plugin.Attribute.NPC.set.spTyp(npc, typI);
            if (typI == 1 || typI == 3) {
                this.setNpcPos(npc, player);
            }
        }
        return pr\u00fcfer;
    }

    public void setNpcPos(Npc npc, Player player) {
        if (this.isSpezialNPC(npc)) {
            Connection connection = this.plugin.db.getConnection();
            PreparedStatement pstmt = null;
            try {
                pstmt = connection.prepareStatement("UPDATE 'Spezial' SET PosX= ?, PosY= ?, PosZ= ? WHERE NpcID=" + npc.getGlobalID());
                pstmt.setFloat(1, npc.getPosition().x);
                pstmt.setFloat(2, npc.getPosition().y);
                pstmt.setFloat(3, npc.getPosition().z);
                pstmt.executeUpdate();
                player.sendTextMessage("[#ffa500]Position of this NPC set!");
                this.plugin.Attribute.NPC.set.spPos(npc, npc.getPosition());
                if (this.debug >= 1) {
                    this.plugin.dl.info("spPos = " + this.plugin.Attribute.NPC.get.spPos(npc));
                }
            }
            catch (SQLException ex) {
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
            }
        } else {
            player.sendTextMessage("[#ff0000]NPC is not a Spezial-NPC!");
        }
    }

    public void removeSpezialNPC(Npc npc) {
        if (this.isSpezialNPC(npc)) {
            Connection connection = this.plugin.db.getConnection();
            try {
                PreparedStatement prepLok = connection.prepareStatement("DELETE FROM 'Spezial' WHERE NpcID=" + npc.getGlobalID() + "; ");
                prepLok.executeUpdate();
                this.spNPC.remove(npc.getGlobalID());
                this.plugin.Attribute.NPC.set.spPos(npc, null);
                this.plugin.Attribute.NPC.set.spTimer(npc, null);
                this.plugin.Attribute.NPC.set.spTyp(npc, 0);
            }
            catch (SQLException ex) {
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
                this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
            }
        }
    }

    public void setAllSpezialNPC() {
        try (ResultSet result = this.plugin.db.executeQuery("SELECT * FROM 'Spezial'");){
            if (result != null) {
                while (result.next()) {
                    int id = result.getInt("NpcID");
                    this.spNPC.add(id);
                    if (this.debug <= 0) continue;
                    this.plugin.dl.info("[AntiMountTheft] Add SpezialNPC: " + id);
                }
            }
        }
        catch (SQLException ex) {
            this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getMessage());
            this.plugin.dl.info("[AntiMountTheft SQLite-ERR]" + ex.getErrorCode());
        }
        this.setAllAttribute();
    }

    public boolean isSpezialNPC(Npc npc) {
        return this.spNPC.contains(npc.getGlobalID());
    }

    public void setAllAttribute() {
        for (int id : this.spNPC) {
            Npc npc = this.plugin.world.getNpc(id);
            if (npc == null) continue;
            this.plugin.Attribute.NPC.set.spTyp(npc, this.getSpezialTypFromDB(npc));
            this.plugin.Attribute.NPC.set.spHasPlayer(npc, false);
            this.plugin.Attribute.NPC.set.spTimer(npc, null);
            npc.setInvincible(true);
            if (this.plugin.Attribute.NPC.get.spTyp(npc) != 1) continue;
            this.plugin.Attribute.NPC.set.spPos(npc, this.getSpezialPosFromDB(npc));
            if (this.debug <= 0) continue;
            this.plugin.dl.info("[AntiMountTheft] SpezialNPC (ID: " + id + " set Fixpos: " + this.plugin.Attribute.NPC.get.spPos(npc));
        }
    }

    public Timer getNewSpezialTimer(Npc npc, Player player) {
        Timer spTimer = new Timer(this.plugin.time, 0.0f, 1, () -> {
            Vector3f pos = this.plugin.Attribute.NPC.get.spPos(npc);
            npc.setPosition(pos);
            player.sendTextMessage("[#ff0000]NPC-Time is up!");
            this.plugin.Attribute.NPC.set.spHasPlayer(npc, false);
            this.killTimer(npc);
        });
        return spTimer;
    }

    private void killTimer(Npc npc) {
        this.plugin.Attribute.NPC.get.spTimer(npc).kill();
    }
}

