/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.antimounttheft;
import java.util.List;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.general.ShutdownEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerDismountNpcEvent;
import net.risingworld.api.events.player.PlayerMountNpcEvent;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.events.player.PlayerNpcInventoryAccessEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class PlayerEvent
implements Listener {
    private final antimounttheft plugin;
    private int debug;
    private final String Rot = "[#ff0000]";
    private final String Gr\u00fcn = "[#00ff00]";
    private final String Orange = "[#ffa500]";

    public PlayerEvent(antimounttheft plugin) {
        this.plugin = plugin;
        this.debug = plugin.debug;
    }

    @EventMethod
    public void onPlayerMountNpcEvent(PlayerMountNpcEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        if (!npc.hasAttribute(this.plugin.Attribute.NPC.spTyp)) {
            this.plugin.Attribute.NPC.set.spTyp(npc, -1);
        }
        if (!npc.hasAttribute(this.plugin.Attribute.NPC.spPos)) {
            this.plugin.Attribute.NPC.set.spPos(npc, null);
        }
        if (this.debug > 0) {
            this.plugin.dl.info("[AntiMountTheft] onPlayerMountNpc - isSpezialNPC: " + this.plugin.SpezialNPC().isSpezialNPC(npc));
        }
        if (this.plugin.SpezialNPC().isSpezialNPC(npc)) {
            if (!npc.isInvincible()) {
                npc.setInvincible(true);
            }
            int typ = this.plugin.SpezialNPC().getSpezialTypFromDB(npc);
            this.plugin.Attribute.NPC.set.spTyp(npc, typ);
            if (typ == 1) {
                this.plugin.Attribute.NPC.set.spPos(npc, this.plugin.SpezialNPC().getSpezialPosFromDB(npc));
                if (this.debug > 0) {
                    this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + npc.getGlobalID() + ") Spezial Pos: " + this.plugin.Attribute.NPC.get.spPos(npc));
                }
            }
            if (typ == 3) {
                if (this.plugin.Attribute.NPC.get.spPos(npc) == null) {
                    this.plugin.Attribute.NPC.set.spPos(npc, this.plugin.SpezialNPC().getSpezialPosFromDB(npc));
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + npc.getGlobalID() + ") Spezial Pos: " + this.plugin.Attribute.NPC.get.spPos(npc));
                    }
                }
                if (this.plugin.Attribute.NPC.get.spTimer(npc) == null) {
                    Timer timer = this.plugin.SpezialNPC().getNewSpezialTimer(npc, player);
                    this.plugin.Attribute.NPC.set.spTimer(npc, timer);
                }
            }
            if (player.isAdmin()) {
                this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
                player.sendTextMessage("[#ffa500]You select the Spezial-NPC!");
                player.sendTextMessage("[#ffa500]ID: " + npc.getGlobalID());
                player.sendTextMessage("[#ffa500]Type: " + this.plugin.SpezialNPC().setTypIntToString(this.plugin.Attribute.NPC.get.spTyp(npc)));
            }
        }
        if (!this.plugin.hasNPCaPlayer(npc)) {
            if (this.plugin.addOwnerToNPC(npc, player)) {
                event.setCancelled(false);
                this.plugin.Attribute.Player.set.MountNow(player, npc.getGlobalID());
                this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
                player.sendTextMessage("[#00ff00]This NPC is now your NPC!");
                player.sendTextMessage("[#ffa500]You select the NPC! ID: " + npc.getGlobalID());
                if (this.debug > 0) {
                    this.plugin.dl.info("[AntiMountTheft] MountNow = " + this.plugin.Attribute.Player.get.MountNow(player));
                }
            }
        } else if (this.plugin.isPlayersNPC(player, npc)) {
            if (this.debug > 0) {
                this.plugin.dl.info("[AntiMountTheft] onPlayerMountNpcEvent: isPlayersNPC = true");
            }
            event.setCancelled(false);
            this.plugin.Attribute.Player.set.MountNow(player, npc.getGlobalID());
            this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
            player.sendTextMessage("[#ffa500]You select the NPC! ID: " + npc.getGlobalID());
            if (this.plugin.SpezialNPC().isSpezialNPC(npc)) {
                this.plugin.Attribute.Player.set.spOwned(player, npc.getGlobalID());
            }
        } else if (this.plugin.Member.isNpcMember(player, npc)) {
            if (this.debug > 0) {
                this.plugin.dl.info("[AntiMountTheft] onPlayerMountNpcEvent: isPlayersNPC = true");
            }
            event.setCancelled(false);
            this.plugin.Attribute.Player.set.MountNow(player, -2);
            this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
            player.sendTextMessage("[#ffa500]You select the NPC! ID: " + npc.getGlobalID());
        } else if (this.plugin.Attribute.NPC.get.spTyp(npc) != -1) {
            if (this.plugin.Attribute.Player.get.spOwned(player) == -1 || this.plugin.Attribute.Player.get.spOwned(player) == npc.getGlobalID()) {
                if (!this.plugin.Attribute.NPC.get.spHasPlayer(npc)) {
                    event.setCancelled(false);
                    this.plugin.Attribute.NPC.set.spHasPlayer(npc, true);
                    this.plugin.Attribute.Player.set.MountNow(player, npc.getGlobalID());
                    this.plugin.Attribute.Player.set.spOwned(player, npc.getGlobalID());
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] MountNow = " + this.plugin.Attribute.Player.get.MountNow(player));
                        this.plugin.dl.info("[AntiMountTheft] spOwned = " + this.plugin.Attribute.Player.get.spOwned(player));
                    }
                    if (this.plugin.Attribute.NPC.get.spTyp(npc) == 3 && !this.plugin.Attribute.NPC.get.spTimer(npc).isActive()) {
                        this.plugin.Attribute.NPC.get.spTimer(npc).start();
                    }
                } else {
                    event.setCancelled(true);
                    player.sendTextMessage("[#ff0000]This spezial npc have a player!");
                }
            } else {
                event.setCancelled(true);
                player.sendTextMessage("[#ff0000]You can get only one SpezialNpc!");
            }
        } else if (player.isAdmin()) {
            if (this.plugin.debug > 0) {
                this.plugin.dl.info("[AntiMountTheft] onPlayerMountNpcEvent: Player = Admin");
            }
            event.setCancelled(false);
            this.plugin.Attribute.Player.set.MountNow(player, npc.getGlobalID());
            this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
            player.sendTextMessage("[#ffa500]You select the NPC! ID: " + npc.getGlobalID());
        } else {
            if (this.plugin.debug > 0) {
                this.plugin.dl.info("[AntiMountTheft] onPlayerMountNpcEvent: Event abgebrochen: 'Not your NPC!'");
            }
            event.setCancelled(true);
            player.sendTextMessage("[#ff0000]This is not your NPC!");
        }
        if (this.plugin.debug > 0) {
            this.plugin.dl.info("[AntiMountTheft] onPlayerMountNpcEvent: setCancelled " + event.isCancelled());
        }
    }

    @EventMethod
    public void onPlayerDismountNpcEvent(PlayerDismountNpcEvent event) {
        Player player = event.getPlayer();
        if (this.debug > 0) {
            this.plugin.dl.info("[AntiMountTheft] onPlayerDismountNpcEvent");
        }
        this.plugin.Attribute.Player.set.MountNow(player, -1);
        if (this.debug > 0) {
            this.plugin.dl.info("[AntiMountTheft] onPlayerDismountNpcEvent: MountNow" + this.plugin.Attribute.Player.get.MountNow(player));
        }
    }

    @EventMethod
    public void onPlayerDisconnectEvent(PlayerDisconnectEvent event) {
        Player player = event.getPlayer();
        if (this.debug > 0) {
            this.plugin.dl.info("[AntiMountTheft] spOwned = " + this.plugin.Attribute.Player.get.spOwned(player));
        }
        if (this.plugin.Attribute.Player.get.spOwned(player) != -1) {
            Npc npc;
            if (this.debug > 0) {
                this.plugin.dl.info("[AntiMountTheft] spOwned != -1");
            }
            if ((npc = this.plugin.world.getNpc(this.plugin.Attribute.Player.get.spOwned(player))) != null && this.plugin.SpezialNPC().isSpezialNPC(npc)) {
                if (this.debug > 0) {
                    this.plugin.dl.info("[AntiMountTheft] npc ID = " + npc.getGlobalID() + " " + npc.getName());
                }
                this.plugin.Attribute.NPC.set.spHasPlayer(npc, false);
                if (this.plugin.Attribute.NPC.get.spTyp(npc) == 1) {
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] spTyp = 1");
                    }
                    Vector3f pos = this.plugin.Attribute.NPC.get.spPos(npc);
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] Npc Pos Old: " + npc.getPosition());
                    }
                    npc.setPosition(pos);
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] Npc Pos New: " + npc.getPosition());
                    }
                } else if (this.plugin.Attribute.NPC.get.spTyp(npc) == 2) {
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] spTyp = 2");
                    }
                    Vector3f pos = this.plugin.Attribute.NPC.get.spPos(npc);
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] Npc Pos Old: " + npc.getPosition());
                    }
                    npc.setPosition(pos);
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] Npc Pos New: " + npc.getPosition());
                    }
                    if (this.plugin.Attribute.NPC.get.spTimer(npc) != null) {
                        this.plugin.Attribute.NPC.get.spTimer(npc).kill();
                    }
                }
            }
        }
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        List<Integer> ids = this.plugin.getNpcIDfromDB(player);
        player.setAttribute(this.plugin.Attribute.Player.NpcOwned, ids);
        this.plugin.Attribute.Player.set.MountNow(player, -1);
        this.plugin.Attribute.Player.set.spOwned(player, -1);
        this.plugin.Attribute.Player.set.amtSelect(player, -1);
        if (this.plugin.debug > 0) {
            this.plugin.dl.info("[AntiMountTheft] Player Connect");
            this.plugin.dl.info("[AntiMountTheft] onPlayerConnectEvent: Liste NPCs");
            this.plugin.dl.info("[AntiMountTheft] onPlayerConnectEvent: ---------------------");
            ids.forEach(id -> this.plugin.dl.info("[AntiMountTheft] onPlayerConnectEvent: " + id));
        }
    }

    @EventMethod
    public void onShutdownEvent(ShutdownEvent event) {
        this.plugin.SpezialNPC().getList().forEach(id -> {
            Npc npc = this.plugin.world.getNpc(id.intValue());
            if (npc != null) {
                if (this.plugin.Attribute.NPC.get.spTyp(npc) == 1) {
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + id + ") Old Pos: " + npc.getPosition());
                    }
                    npc.setPosition(this.plugin.Attribute.NPC.get.spPos(npc));
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + id + ") New Pos: " + npc.getPosition());
                    }
                } else if (this.plugin.Attribute.NPC.get.spTyp(npc) == 3) {
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + id + ") Old Pos: " + npc.getPosition());
                    }
                    npc.setPosition(this.plugin.Attribute.NPC.get.spPos(npc));
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + id + ") New Pos: " + npc.getPosition());
                    }
                    if (this.plugin.Attribute.NPC.get.spTimer(npc) != null) {
                        this.plugin.Attribute.NPC.get.spTimer(npc).kill();
                    }
                }
            }
        });
    }

    @EventMethod
    public void onPlayerNpcInteractionEvent(PlayerNpcInteractionEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        if (this.plugin.Attribute.Player.get.amtSelect(player) == -2) {
            if (this.plugin.SpezialNPC().isSpezialNPC(npc)) {
                if (!npc.hasAttribute(this.plugin.Attribute.NPC.spTyp)) {
                    this.plugin.Attribute.NPC.set.spTyp(npc, 0);
                }
                if (!npc.hasAttribute(this.plugin.Attribute.NPC.spPos)) {
                    this.plugin.Attribute.NPC.set.spPos(npc, null);
                }
                if (!npc.isInvincible()) {
                    npc.setInvincible(true);
                }
                int typ = this.plugin.SpezialNPC().getSpezialTypFromDB(npc);
                if (this.plugin.Attribute.NPC.get.spTyp(npc) == 0) {
                    this.plugin.Attribute.NPC.set.spTyp(npc, typ);
                }
                if (typ == 1 && this.plugin.Attribute.NPC.get.spPos(npc) == null) {
                    this.plugin.Attribute.NPC.set.spPos(npc, this.plugin.SpezialNPC().getSpezialPosFromDB(npc));
                    if (this.debug > 0) {
                        this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + npc.getGlobalID() + ") Spezial Pos: " + this.plugin.Attribute.NPC.get.spPos(npc));
                    }
                }
                if (typ == 3) {
                    if (this.plugin.Attribute.NPC.get.spPos(npc) == null) {
                        this.plugin.Attribute.NPC.set.spPos(npc, this.plugin.SpezialNPC().getSpezialPosFromDB(npc));
                        if (this.debug > 0) {
                            this.plugin.dl.info("[AntiMountTheft] NPC (ID: " + npc.getGlobalID() + ") Spezial Pos: " + this.plugin.Attribute.NPC.get.spPos(npc));
                        }
                    }
                    if (this.plugin.Attribute.NPC.get.spTimer(npc) == null) {
                        Timer timer = this.plugin.SpezialNPC().getNewSpezialTimer(npc, player);
                        this.plugin.Attribute.NPC.set.spTimer(npc, timer);
                    }
                }
                if (player.isAdmin()) {
                    this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
                    player.sendTextMessage("[#ffa500]You select the Spezial-NPC!");
                    player.sendTextMessage("[#ffa500]ID: " + npc.getGlobalID());
                    player.sendTextMessage("[#ffa500]Type: " + this.plugin.SpezialNPC().setTypIntToString(this.plugin.Attribute.NPC.get.spTyp(npc)));
                }
            }
            if (!this.plugin.hasNPCaPlayer(npc)) {
                if (this.plugin.addOwnerToNPC(npc, player)) {
                    player.sendTextMessage("[#00ff00]This NPC is now your NPC!");
                    player.sendTextMessage("[#ffa500]You select the NPC! ID: " + npc.getGlobalID());
                    this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
                    event.setCancelled(false);
                }
            } else if (this.plugin.isPlayersNPC(player, npc) || this.plugin.Member.isNpcMember(player, npc) || player.isAdmin()) {
                player.sendTextMessage("[#ffa500]You select the NPC! ID: " + npc.getGlobalID());
                this.plugin.Attribute.Player.set.amtSelect(player, npc.getGlobalID());
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventMethod
    public void onPlayerNpcInventoryAccessEvent(PlayerNpcInventoryAccessEvent event) {
        Npc npc = event.getNpc();
        Player player = event.getPlayer();
        if (this.plugin.hasNPCaPlayer(npc)) {
            if (this.plugin.isPlayersNPC(player, npc) || player.isAdmin()) {
                event.setCancelled(false);
            } else {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(true);
        }
    }
}

