/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.antimounttheft;
import java.util.List;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.npc.NpcDeathEvent;
import net.risingworld.api.events.npc.NpcSpawnEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;

public class EventListener
implements Listener {
    private final antimounttheft plugin;

    public EventListener(antimounttheft plugin) {
        this.plugin = plugin;
    }

    @EventMethod
    public void onNpcDeathEvent(NpcDeathEvent event) {
        Npc npc = event.getNpc();
        NpcDeathEvent.Cause cause = event.getCause();
        if (cause == NpcDeathEvent.Cause.KilledByPlayer) {
            if (this.plugin.hasNPCaPlayer(npc)) {
                Player player = (Player)event.getKiller();
                if (this.plugin.isPlayersNPC(player, npc)) {
                    event.setCancelled(false);
                } else {
                    event.setCancelled(true);
                    if (this.plugin.SpezialNPC().isSpezialNPC(npc)) {
                        npc.setInvincible(true);
                    }
                }
            } else {
                event.setCancelled(false);
            }
        } else if (this.plugin.SpezialNPC().isSpezialNPC(npc)) {
            event.setCancelled(true);
            npc.setInvincible(true);
        } else {
            event.setCancelled(false);
        }
        if (!event.isCancelled() && this.plugin.hasNPCaPlayer(npc)) {
            Player player2;
            List<Long> members = this.plugin.Attribute.NPC.get.NpcMember(npc);
            List<Long> owners = this.plugin.getNpcOwners(npc);
            for (long m : members) {
                player2 = this.plugin.server.getPlayer(m);
                if (player2 != null) {
                    this.plugin.Member.removeMemberFromNpc(npc, player2);
                    player2.sendTextMessage("Your Npc " + npc.getName() + " is died!");
                    continue;
                }
                this.plugin.Member.removeMemberFromNpc(npc, m);
            }
            for (long o : owners) {
                player2 = this.plugin.server.getPlayer(o);
                if (player2 == null) continue;
                this.plugin.Attribute.Player.get.NpcOwned(player2).remove(npc.getGlobalID());
                player2.sendTextMessage("Your Npc " + npc.getName() + " is died!");
            }
        }
    }

    @EventMethod
    public void onNpcSpawnEvent(NpcSpawnEvent event) {
        Npc npc = event.getNpc();
        if (npc.getType() == Npc.Type.Mount) {
            this.plugin.Attribute.NPC.set.spTyp(npc, 0);
            this.plugin.Attribute.NPC.set.spPos(npc, null);
            npc.setAttribute(this.plugin.Attribute.NPC.NpcMember, this.plugin.Member.getNpcForMemberFromDB(npc));
            if (this.plugin.SpezialNPC().isSpezialNPC(npc)) {
                int typ = this.plugin.SpezialNPC().getSpezialTypFromDB(npc);
                this.plugin.Attribute.NPC.set.spTyp(npc, typ);
                if (typ == 1 || typ == 3) {
                    this.plugin.Attribute.NPC.set.spPos(npc, this.plugin.SpezialNPC().getSpezialPosFromDB(npc));
                }
            }
        }
    }
}

