/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.GUI;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeEquippedItemEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerElementHitEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerSelectFileEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiFileBrowser;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.BoundingInformation;
import net.risingworld.api.utils.ChunkLOD;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.CollisionType;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.KeyInput;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.utils.Vector3i;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class _3D {
    static float getSurfaceElevation(Plugin plugin, Vector3f area3fPOS) {
        Vector3i chunkPositionStore = new Vector3i().zero();
        Vector3i blockPositionStore = new Vector3i().zero();
        Utils.ChunkUtils.getChunkAndBlockPosition((Vector3f)area3fPOS, (Vector3i)chunkPositionStore, (Vector3i)blockPositionStore);
        Vector3i chunkPos = chunkPositionStore;
        ChunkLOD chunkLOD = plugin.getWorld().getChunkLOD(chunkPos.x, chunkPos.z);
        if (chunkLOD != null) {
            Vector3i blockPos = blockPositionStore;
            short elevation = chunkLOD.getSurfaceElevation(blockPos.x, blockPos.z);
            return elevation;
        }
        return 0.0f;
    }

    public static World3DModel create3DModel(ModelInformation model, ImageInformation texture, Crosshair cross, boolean LightingEnabled, boolean Interactable, CollisionShape CollisionShape2, float Scale, float TextureScale) {
        World3DModel Model = new World3DModel(model, texture);
        Model.setLightingEnabled(LightingEnabled);
        Model.setInteractable(Interactable);
        Model.setInteractionCrosshair(cross);
        Model.setCollisionShape(CollisionShape2);
        Model.setScale(Scale);
        Model.setTextureScale(TextureScale);
        return Model;
    }

    public static Vector3f getPosDirectMult(Vector3f position, Quaternion rotation, int multie) {
        Vector3f newPosition = new Vector3f(0.0f, 0.0f, 1.0f);
        rotation.multLocal(newPosition);
        newPosition.multLocal((float)multie);
        newPosition.addLocal(position);
        return newPosition;
    }

    public static class World3DGroupModel
    extends World3DModel {
        private final Plugin plugin;

        public World3DGroupModel(Plugin plugin, ModelInformation model, ImageInformation texture) {
            super(model, texture);
            this.plugin = plugin;
        }
    }

    public static class ClassPlaceWorld3DModel
    implements Listener {
        private final Plugin plugin;
        private boolean previewForAll;
        private HashMap<Long, World3DModel> world3DModels;
        private int COLLISION_BITMASK = CollisionType.getBitmask((int[])new int[]{1, 8, 16, 128});
        private int debug = 3;
        private String labTextDafault = "Manuelles Platzieren";
        private ImageInformation imageLocked;
        private Callback onPlacementEnter;
        private Callback onAbortPlacement;
        private Callback onChange;
        private HashMap<Long, ClassBackUp> backups;
        private HashMap<Long, int[]> KEY_LIST_BACKUPs;
        private int[] KEY_LIST = new int[]{200, 208, 203, 205, 201, 209, 78, 74, 1, 29, 157};
        private final HashMap<Long, Boolean> manuelMode;
        private final HashMap<Long, GuiLabel> manuelModeGUI;
        private final HashMap<Long, GUI.GuiImage> manuelModeGUIicon;
        private HashMap<Long, Float> POSITION_STEPs;
        private HashMap<Long, Timer> timers;

        public void setCollisionBitmask(int COLLISION_BITMASK) {
            this.COLLISION_BITMASK = COLLISION_BITMASK;
        }

        public int setCollisionBitmask() {
            return this.COLLISION_BITMASK;
        }

        public void setOnPlacementEnter(Callback onPlacement) {
            this.onPlacementEnter = onPlacement;
        }

        public Callback getOnPlacementEnter() {
            return this.onPlacementEnter;
        }

        public void setOnAbortPlacement(Callback onAbortPlacement) {
            this.onAbortPlacement = onAbortPlacement;
        }

        public Callback getOnAbortPlacement() {
            return this.onAbortPlacement;
        }

        public void setOnChange(Callback onChange) {
            this.onChange = onChange;
        }

        public Callback getOnChange() {
            return this.onChange;
        }

        private byte[] readByteFromInputStream(InputStream inputStream) throws IOException {
            int len;
            ByteArrayOutputStream resultByteBuilder = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                resultByteBuilder.write(buffer, 0, len);
            }
            return resultByteBuilder.toByteArray();
        }

        public ClassPlaceWorld3DModel(Plugin plugin) {
            this.world3DModels = new HashMap();
            this.KEY_LIST_BACKUPs = new HashMap();
            this.backups = new HashMap();
            this.timers = new HashMap();
            this.manuelMode = new HashMap();
            this.manuelModeGUI = new HashMap();
            this.POSITION_STEPs = new HashMap();
            this.manuelModeGUIicon = new HashMap();
            this.plugin = plugin;
            plugin.registerEventListener((Listener)this);
            this.imageLocked = new ImageInformation(plugin, "/resources/construction_icon_locked.png");
        }

        public void placeWorld3DModel(Player player, World3DModel world3DModel, boolean previewForAll, float prevAlpha) {
            this.previewForAll = previewForAll;
            this.world3DModels.put(player.getUID(), world3DModel);
            ClassBackUp backup = new ClassBackUp(world3DModel.getAlpha(), world3DModel.isTransparencyEnabled(), world3DModel.getCollisionShape(), new Vector3f(world3DModel.getPosition()), new Quaternion(world3DModel.getRotation()), new Vector3f(world3DModel.getScale()));
            this.backups.put(player.getUID(), backup);
            world3DModel.setAlpha(prevAlpha);
            world3DModel.setTransparencyEnabled(true);
            world3DModel.setCollisionShape(null);
            if (previewForAll) {
                for (Player p : this.plugin.getServer().getAllPlayers()) {
                    p.addWorldElement((WorldElement)world3DModel);
                }
            } else {
                player.addWorldElement((WorldElement)world3DModel);
            }
            Timer timer = new Timer(0.05f, 0.5f, -1, () -> player.raycast(this.COLLISION_BITMASK, result -> {
                Vector3f targetPosition;
                if (result != null && result.hasCollision() && result.getDistance() <= 6.0f) {
                    targetPosition = result.getCollisionPoint();
                } else {
                    targetPosition = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)6.0f);
                    targetPosition.y = world3DModel.getPosition().y;
                }
                world3DModel.moveTo(targetPosition, 9.0f);
                if (this.onChange != null) {
                    this.onChange.onCall((Object)new OnChange(player, targetPosition, new Quaternion(world3DModel.getRotation())));
                }
            }));
            timer.start();
            if (this.timers.getOrDefault(player.getUID(), null) == null) {
                this.timers.put(player.getUID(), timer);
            }
            this.manuelMode.put(player.getUID(), false);
            float icoSize = 32.0f;
            if (this.manuelModeGUI.getOrDefault(player.getUID(), null) == null) {
                GuiLabel lab = new GuiLabel(this.labTextDafault, icoSize, (float)(player.getScreenResolutionY() / 2), false);
                lab.setPivot(PivotPosition.CenterLeft);
                lab.setFontSize(20);
                lab.setVisible(false);
                player.addGuiElement((GuiElement)lab);
                this.manuelModeGUI.put(player.getUID(), lab);
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Label NEU ");
                }
            }
            if (this.manuelModeGUIicon.getOrDefault(player.getUID(), null) == null) {
                GUI.GuiImage ico = new GUI.GuiImage(this.imageLocked, 0.0f, player.getScreenResolutionY() / 2, false, icoSize, icoSize, false);
                ico.setPivot(PivotPosition.CenterLeft);
                ico.setVisible(false);
                player.addGuiElement((GuiElement)ico);
                this.manuelModeGUIicon.put(player.getUID(), ico);
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel Label NEU ");
                }
            }
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel placeWorld3DModel ");
            }
            this.KEY_LIST_BACKUPs.put(player.getUID(), player.getRegisteredKeys());
            if (this.onPlacementEnter != null) {
                player.registerKeys(this.KEY_LIST);
            } else {
                int[] KEY_LIST_T = CRT.addElement(this.KEY_LIST, 28);
                player.registerKeys(KEY_LIST_T);
            }
            player.disableClientsideKeys(new int[]{1});
        }

        public World3DModel finalPlacement(Player player) {
            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel finalPlace ");
            World3DModel world3DModel = this.world3DModels.get(player.getUID());
            this.world3DModels.remove(player.getUID());
            world3DModel.setAlpha(this.backups.get(player.getUID()).alpha);
            world3DModel.setTransparencyEnabled(this.backups.get(player.getUID()).isTransparencyEnabled);
            world3DModel.setCollisionShape(this.backups.get(player.getUID()).collisionShape);
            this.timers.get(player.getUID()).kill();
            this.timers.remove(player.getUID());
            this.manuelMode.remove(player.getUID());
            player.unregisterKeys(this.KEY_LIST);
            player.registerKeys(this.KEY_LIST_BACKUPs.get(player.getUID()));
            player.enableClientsideKeys(new int[]{1});
            this.manuelModeGUI.get(player.getUID()).setVisible(false);
            this.manuelModeGUIicon.get(player.getUID()).setVisible(false);
            this.manuelMode.put(player.getUID(), false);
            return world3DModel;
        }

        public World3DModel abortPlacement(Player player) {
            World3DModel world3DModel = this.world3DModels.get(player.getUID());
            this.world3DModels.remove(player.getUID());
            if (world3DModel != null) {
                world3DModel.setAlpha(this.backups.get(player.getUID()).alpha);
                world3DModel.setTransparencyEnabled(this.backups.get(player.getUID()).isTransparencyEnabled);
                world3DModel.setCollisionShape(this.backups.get(player.getUID()).collisionShape);
                world3DModel.setPosition(this.backups.get(player.getUID()).position);
                world3DModel.setRotation(this.backups.get(player.getUID()).rotation);
                world3DModel.setScale(((ClassBackUp)this.backups.get((Object)Long.valueOf((long)player.getUID()))).scale.x);
            } else if (this.debug > 1) {
                System.err.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel abortPlacement ERROR Model");
            }
            if (this.timers.getOrDefault(player.getUID(), null) != null) {
                this.timers.get(player.getUID()).kill();
                this.timers.remove(player.getUID());
            }
            if (this.manuelModeGUI.getOrDefault(player.getUID(), null) != null) {
                this.manuelModeGUI.get(player.getUID()).setVisible(false);
            }
            if (this.manuelModeGUIicon.getOrDefault(player.getUID(), null) != null) {
                this.manuelModeGUIicon.get(player.getUID()).setVisible(false);
            }
            if (this.manuelMode.getOrDefault(player.getUID(), null) != null) {
                this.manuelMode.remove(player.getUID());
            }
            if (this.onAbortPlacement != null) {
                this.onAbortPlacement.onCall((Object)new OnAbortPlacement(player, world3DModel));
            }
            player.unregisterKeys(this.KEY_LIST);
            player.registerKeys(this.KEY_LIST_BACKUPs.get(player.getUID()));
            player.enableClientsideKeys(new int[]{1});
            return world3DModel;
        }

        @EventMethod
        public void onPlayerKeyInput(PlayerKeyEvent event) {
            Player player = event.getPlayer();
            if (event.isPressed() && this.world3DModels.get(player.getUID()) != null) {
                float POSITION_STEP = 0.01f;
                String STEP_FORMAT = "%.3f";
                if (!this.manuelMode.get(player.getUID()).booleanValue()) {
                    float ROTATION_STEP = 0.19634955f;
                    if (event.getKeyCode() == 203) {
                        Quaternion rot = new Quaternion(this.world3DModels.get(player.getUID()).getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.19634955f, 0.0f));
                        this.world3DModels.get(player.getUID()).setRotation(rot);
                    } else if (event.getKeyCode() == 205) {
                        Quaternion rot = new Quaternion(this.world3DModels.get(player.getUID()).getRotation()).multLocal(new Quaternion().fromAngles(0.0f, -0.19634955f, 0.0f));
                        this.world3DModels.get(player.getUID()).setRotation(rot);
                    } else if (event.getKeyCode() == 200) {
                        Quaternion rot = new Quaternion(this.world3DModels.get(player.getUID()).getRotation()).multLocal(new Quaternion().fromAngles(0.19634955f, 0.0f, 0.0f));
                        this.world3DModels.get(player.getUID()).setRotation(rot);
                    } else if (event.getKeyCode() == 208) {
                        Quaternion rot = new Quaternion(this.world3DModels.get(player.getUID()).getRotation()).multLocal(new Quaternion().fromAngles(-0.19634955f, 0.0f, 0.0f));
                        this.world3DModels.get(player.getUID()).setRotation(rot);
                    } else if (event.getKeyCode() == 201) {
                        Quaternion rot = new Quaternion(this.world3DModels.get(player.getUID()).getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, 0.19634955f));
                        this.world3DModels.get(player.getUID()).setRotation(rot);
                    } else if (event.getKeyCode() == 209) {
                        Quaternion rot = new Quaternion(this.world3DModels.get(player.getUID()).getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, -0.19634955f));
                        this.world3DModels.get(player.getUID()).setRotation(rot);
                    } else if (event.getKeyCode() == 78) {
                        this.world3DModels.get(player.getUID()).setScale(this.world3DModels.get((Object)Long.valueOf((long)player.getUID())).getScale().x * 1.05f);
                    } else if (event.getKeyCode() == 74) {
                        this.world3DModels.get(player.getUID()).setScale(this.world3DModels.get((Object)Long.valueOf((long)player.getUID())).getScale().x * 0.95f);
                    } else if (event.getKeyCode() == 157) {
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput L-Control isVisible[" + this.manuelModeGUI.get(player.getUID()).isVisible() + "] ");
                        }
                        this.manuelModeGUI.get(player.getUID()).setVisible(true);
                        this.manuelModeGUIicon.get(player.getUID()).setVisible(true);
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput           isVisible[" + this.manuelModeGUI.get(player.getUID()).isVisible() + "] ");
                        }
                        this.manuelMode.put(player.getUID(), true);
                        this.timers.get(player.getUID()).pause();
                        this.POSITION_STEPs.put(player.getUID(), Float.valueOf(0.01f));
                        this.manuelModeGUI.get(player.getUID()).setText(this.labTextDafault + " Step [" + String.valueOf(this.POSITION_STEPs.get(player.getUID())) + "]");
                    }
                } else {
                    if (event.getKeyCode() == 203) {
                        Vector3f pos = new Vector3f(this.world3DModels.get(player.getUID()).getPosition()).addLocal(this.POSITION_STEPs.get(player.getUID()).floatValue(), 0.0f, 0.0f);
                        this.world3DModels.get(player.getUID()).setPosition(pos);
                    } else if (event.getKeyCode() == 205) {
                        Vector3f pos = new Vector3f(this.world3DModels.get(player.getUID()).getPosition()).addLocal(-this.POSITION_STEPs.get(player.getUID()).floatValue(), 0.0f, 0.0f);
                        this.world3DModels.get(player.getUID()).setPosition(pos);
                    } else if (event.getKeyCode() == 200) {
                        Vector3f pos = new Vector3f(this.world3DModels.get(player.getUID()).getPosition()).addLocal(0.0f, 0.0f, this.POSITION_STEPs.get(player.getUID()).floatValue());
                        this.world3DModels.get(player.getUID()).setPosition(pos);
                    } else if (event.getKeyCode() == 208) {
                        Vector3f pos = new Vector3f(this.world3DModels.get(player.getUID()).getPosition()).addLocal(0.0f, 0.0f, -this.POSITION_STEPs.get(player.getUID()).floatValue());
                        this.world3DModels.get(player.getUID()).setPosition(pos);
                    } else if (event.getKeyCode() == 201) {
                        Vector3f pos = new Vector3f(this.world3DModels.get(player.getUID()).getPosition()).addLocal(0.0f, this.POSITION_STEPs.get(player.getUID()).floatValue(), 0.0f);
                        this.world3DModels.get(player.getUID()).setPosition(pos);
                    } else if (event.getKeyCode() == 209) {
                        Vector3f pos = new Vector3f(this.world3DModels.get(player.getUID()).getPosition()).addLocal(0.0f, -this.POSITION_STEPs.get(player.getUID()).floatValue(), 0.0f);
                        this.world3DModels.get(player.getUID()).setPosition(pos);
                    } else if (event.getKeyCode() == 78) {
                        if (this.POSITION_STEPs.get(player.getUID()).floatValue() + 0.01f <= 1.0f) {
                            this.POSITION_STEPs.put(player.getUID(), Float.valueOf(String.format("%.3f", Float.valueOf(this.POSITION_STEPs.get(player.getUID()).floatValue() + 0.01f)).replace(",", ".")));
                        }
                    } else if (event.getKeyCode() == 74) {
                        if (this.POSITION_STEPs.get(player.getUID()).floatValue() - 0.01f >= 0.01f) {
                            this.POSITION_STEPs.put(player.getUID(), Float.valueOf(String.format("%.3f", Float.valueOf(this.POSITION_STEPs.get(player.getUID()).floatValue() - 0.01f)).replace(",", ".")));
                        }
                    } else if (event.getKeyCode() == 157) {
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] ClassPlaceWorld3DModel PlayerKeyInput L-Control");
                        }
                        this.manuelModeGUI.get(player.getUID()).setVisible(false);
                        this.manuelModeGUIicon.get(player.getUID()).setVisible(false);
                        this.manuelMode.put(player.getUID(), false);
                        this.timers.get(player.getUID()).start();
                    }
                    this.manuelModeGUI.get(player.getUID()).setText(this.labTextDafault + " Step [" + String.valueOf(this.POSITION_STEPs.get(player.getUID())) + "]");
                }
                if (event.getKeyCode() == 1) {
                    this.abortPlacement(player);
                } else if (event.getKeyCode() == 28 && this.onPlacementEnter != null) {
                    this.onPlacementEnter.onCall((Object)new OnPlacementEnter(player, this.world3DModels.get(player.getUID())));
                }
                if (this.onChange != null) {
                    this.onChange.onCall((Object)new OnChange(player, new Vector3f(this.world3DModels.get(player.getUID()).getPosition()), new Quaternion(this.world3DModels.get(player.getUID()).getRotation())));
                }
            }
        }

        private static class ClassBackUp {
            private final float alpha;
            private final boolean isTransparencyEnabled;
            private final CollisionShape collisionShape;
            private final Vector3f position;
            private final Quaternion rotation;
            private final Vector3f scale;

            public ClassBackUp(float Alpha, boolean isTransparencyEnabled, CollisionShape collisionShape, Vector3f position, Quaternion rotation, Vector3f scale) {
                this.alpha = Alpha;
                this.isTransparencyEnabled = isTransparencyEnabled;
                this.collisionShape = collisionShape;
                this.position = position;
                this.rotation = rotation;
                this.scale = scale;
            }
        }

        class OnChange {
            private final Player player;
            private final Vector3f position;
            private final Quaternion rotation;

            public Player getPlayer() {
                return this.player;
            }

            public Vector3f getPosition() {
                return this.position;
            }

            public Quaternion getRotation() {
                return this.rotation;
            }

            public OnChange(Player player, Vector3f position, Quaternion rotation) {
                this.player = player;
                this.position = position;
                this.rotation = rotation;
            }
        }

        class OnPlacementEnter {
            private final Player player;
            private final World3DModel world3DModel;

            public Player getPlayer() {
                return this.player;
            }

            public World3DModel getWorld3DModel() {
                return this.world3DModel;
            }

            public OnPlacementEnter(Player player, World3DModel world3DModel) {
                this.player = player;
                this.world3DModel = world3DModel;
            }
        }

        class OnAbortPlacement {
            private final Player player;
            private final World3DModel world3DModel;

            public Player getPlayer() {
                return this.player;
            }

            public World3DModel getWorld3DModel() {
                return this.world3DModel;
            }

            public OnAbortPlacement(Player player, World3DModel world3DModel) {
                this.player = player;
                this.world3DModel = world3DModel;
            }
        }
    }

    public static class StaticModelLoader
    implements Listener {
        private Database database;
        Plugin plugin;
        private ArrayList<World3DModel> world3DModels = new ArrayList();
        private ArrayList<Integer> world3DModels_dbID = new ArrayList();
        private ArrayList<Long> world3DModels_uidFile = new ArrayList();
        private ArrayList<Long> world3DModels_uid = new ArrayList();
        private ArrayList<Long> masterDat = new ArrayList();
        private final String ATTRIBUTE_TIMER = "de.chaoswg._3D.staticmodelloader.timer";
        private final String ATTRIBUTE_MODELPREVIEW = "de.chaoswg._3D.staticmodelloader.modelpreview";
        private final String ATTRIBUTE_STRENGTH = "de.chaoswg._3D.staticmodelloader.strength";
        private final String ATTRIBUTE_FILEBROWSER = "de.chaoswg._3D.staticmodelloader.player.filebrowser";
        private final String ATTRIBUTE_LISTE = "de.chaoswg._3D.staticmodelloader.player.Liste";
        private final String ATTRIBUTE_TransCB = "de.chaoswg._3D.staticmodelloader.player.transparentsChkBox";
        private final String ATTRIBUTE_TransMinMax = "de.chaoswg._3D.staticmodelloader.player.transparentsMinMax";
        private final String ATTRIBUTE_HittCB = "de.chaoswg._3D.staticmodelloader.player.hittableChkBox";
        private final String ATTRIBUTE_CollCB = "de.chaoswg._3D.staticmodelloader.player.collisionChkBox";
        private final String ATTRIBUTE_SELECT_UDI = "de.chaoswg._3D.staticmodelloader.player.Select.UID";
        private final String ATTRIBUTE_FILEBROWSER_BACKGROUND = "de.chaoswg._3D.staticmodelloader.player.filebrowser.background";
        private final String ATTRIBUTE_FILEBROWSER_HEADLINE = "de.chaoswg._3D.staticmodelloader.player.filebrowser.header";
        private final String ATTRIBUTE_PENDING_MODEL = "de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel";
        private final String ATTRIBUTE_PENDING_TEXTURE = "de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture";
        public final String CUSTOMITEM_UUID = "de.chaoswg._3D.staticmodels.3dmodelblueprint";
        private final int DEFAULT_ELEMENT_STRENGTH = 500;
        private final int COLLISION_BITMASK = CollisionType.getBitmask((int[])new int[]{1, 8, 16, 128});
        private int debug;
        private GUI.Font gFont;
        private ArrayList daten;
        private ArrayList daten_id;
        private int keyInputInterAct;
        private float prev3DModelAlpha;
        private boolean showPreview;
        private boolean lockUser;
        private final ClassPlaceWorld3DModel pl;

        public StaticModelLoader(Plugin plugin) {
            this.plugin = plugin;
            this.debug = 0;
            this.keyInputInterAct = -1;
            this.prev3DModelAlpha = 0.66f;
            this.showPreview = true;
            this.lockUser = true;
            this.pl = new ClassPlaceWorld3DModel(plugin);
        }

        public StaticModelLoader(Plugin plugin, int debug) {
            this.plugin = plugin;
            this.debug = debug;
            this.keyInputInterAct = -1;
            this.prev3DModelAlpha = 0.66f;
            this.showPreview = true;
            this.lockUser = true;
            this.pl = new ClassPlaceWorld3DModel(plugin);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onEnable() {
            if (this.debug > 0) {
                System.out.println("[" + this.plugin.getDescription("name") + "] Enabled wFolder[" + this.plugin.getWorld().getWorldFolder() + "] pFolder[" + this.plugin.getPath() + "] ");
            }
            String sDatabase = this.plugin.getWorld().getWorldFolder() + "/WorldModels.db";
            this.database = this.plugin.getSQLiteConnection(sDatabase);
            String sDatabaseBackUp = this.plugin.getWorld().getWorldFolder() + "/WorldModels-BackUp-" + System.currentTimeMillis() + ".db";
            this.database.execute("CREATE TABLE IF NOT EXISTS `models` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `model` VARCHAR(255), `texture` VARCHAR(255), `playeruid` BIGINT, `position` VARCHAR(255), `rotation` VARCHAR(255), `size` REAL, `collision` TINYINT, `playeruidfile` BIGINT, `transparenc` TINYINT, `alpha` FLOAT, `hittable` TINYINT)");
            String Prefix = "";
            if (!CRT.isColumnExists(this.database, "" + Prefix + "models", "playeruidfile")) {
                try {
                    CRT.copyFile(new File(sDatabase), new File(sDatabaseBackUp));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.database.execute("ALTER TABLE " + Prefix + "models ADD playeruidfile BIGINT;");
                this.database.execute("UPDATE " + Prefix + "models SET playeruidfile = playeruid ;");
            }
            if (!CRT.isColumnExists(this.database, "" + Prefix + "models", "transparenc")) {
                this.database.execute("ALTER TABLE " + Prefix + "models ADD transparenc TINYINT;");
                this.database.execute("UPDATE " + Prefix + "models SET transparenc = 0 ;");
            }
            if (!CRT.isColumnExists(this.database, "" + Prefix + "models", "alpha")) {
                this.database.execute("ALTER TABLE " + Prefix + "models ADD alpha FLOAT;");
                this.database.execute("UPDATE " + Prefix + "models SET alpha = 1.0 ;");
            }
            if (!CRT.isColumnExists(this.database, "" + Prefix + "models", "hittable")) {
                this.database.execute("ALTER TABLE " + Prefix + "models ADD hittable TINYINT;");
                this.database.execute("UPDATE " + Prefix + "models SET hittable = 1 ;");
            }
            try (ResultSet result2 = this.database.executeQuery("SELECT * FROM `models`");){
                while (result2.next()) {
                    try {
                        String path = this.plugin.getPath() + "/Models/" + result2.getLong("playeruidfile") + "/";
                        File modelFile = new File(path + result2.getString("model"));
                        File imageFile = new File(path + result2.getString("texture"));
                        if (this.debug > 0) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled Model[" + modelFile.getAbsolutePath() + "]  Textur[" + imageFile.getAbsolutePath() + "] ");
                        }
                        if (!modelFile.exists() || !imageFile.exists()) continue;
                        ModelInformation model = new ModelInformation(path + result2.getString("model"));
                        ImageInformation texture = new ImageInformation(path + result2.getString("texture"));
                        Vector3f position = new Vector3f().fromString(result2.getString("position"));
                        Quaternion rotation = new Quaternion().fromString(result2.getString("rotation"));
                        World3DModel world3DModel = this.createNewWorld3DModel(model, texture, result2.getFloat("size"), position, rotation, result2.getBoolean("collision"));
                        world3DModel.setTransparencyEnabled(result2.getBoolean("transparenc"));
                        world3DModel.setAlpha(result2.getFloat("alpha"));
                        world3DModel.setHittable(result2.getBoolean("hittable"));
                        this.world3DModels.add(world3DModel);
                        this.world3DModels_dbID.add(result2.getInt("ID"));
                        this.world3DModels_uidFile.add(result2.getLong("playeruidfile"));
                        this.world3DModels_uid.add(result2.getLong("playeruid"));
                    }
                    catch (Exception path) {}
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            CustomItem item = new CustomItem("de.chaoswg._3D.staticmodels.3dmodelblueprint", "modelblueprint");
            ModelInformation model = new ModelInformation(this.plugin, "/resources/item.j3o");
            ImageInformation texture = new ImageInformation(this.plugin, "/resources/item_texture4.dds");
            ImageInformation icon = new ImageInformation(this.plugin, "/resources/item_icon4.dds");
            item.setModel(model, texture, 0.01f);
            item.setIcon(icon);
            item.setHand(CustomItem.Hand.None);
            item.setMaxStacksize(1);
            item.setPlayerIdleAnimation(Animation.Idle1);
            item.setLocalizedNames(new String[]{"en=3D-Model Blueprint", "de=3D-Modell Bauplan"});
            item.setSecondaryAction(Animation.Idle1, 0.0f, (player, collision) -> {
                if (player.hasAttribute("de.chaoswg._3D.staticmodelloader.modelpreview")) {
                    this.placeElement(player);
                } else {
                    this.showUploadDialog(player);
                }
            });
            this.pl.setOnAbortPlacement(result -> {
                ClassPlaceWorld3DModel.OnAbortPlacement event = (ClassPlaceWorld3DModel.OnAbortPlacement)result;
                this.chekAbortPlacement(event.getPlayer(), event.getWorld3DModel());
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] onEvent Enter player[" + event.player.getName() + "] ");
                }
            });
            this.pl.setOnPlacementEnter(result -> {
                ClassPlaceWorld3DModel.OnPlacementEnter event = (ClassPlaceWorld3DModel.OnPlacementEnter)result;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] onEvent Enter player[" + event.player.getName() + "] ");
                }
            });
            item.setPrimaryAction(Animation.Idle1, 0.0f, null);
            this.plugin.getServer().registerCustomItem(item);
            CustomRecipe recipe = new CustomRecipe("de.chaoswg._3D.staticmodels.3dmodelblueprint", CustomRecipe.Type.CustomItem, 0, "Miscellaneous", new String[]{"workbench"});
            recipe.setPreviewSize(0.0225f);
            recipe.setIngredients(new String[]{"16x goldingot"});
            recipe.setLocalizedNames(item.getLocalizedNames());
            recipe.setLocalizedDescriptions(new String[]{"en=This item allows you to upload \na custom 3D model from your hard drive \nand place it in the world!", "de=Erm\u00c3\u00b6glicht dir, ein 3D Modell \nvon deiner Festplatte hochzuladen und \nin der Welt zu platzieren!"});
            this.plugin.getServer().registerCustomRecipe(recipe);
            this.gFont = new GUI.Font(this.plugin, this.debug);
            this.daten = new ArrayList();
            this.daten.add("Zeile 2");
            this.daten.add("Zeile 1");
            this.daten.add("Zeile 3");
            this.daten.add("Zeile 4");
            this.daten.add("acdefghijklmnopqrstuvwxyz");
            this.daten.add("abdefghijklmnopqrstuvwxyz");
            this.daten.add("13xiiiiiiiiiiiii");
            this.daten.add("13xmmmmmmmmmmmmm");
            this.daten.add("abcdefghijklmnopqrstuvwxyz");
            this.plugin.registerEventListener((Listener)this);
            File masterDatFile = new File(this.plugin.getPath() + "/MASTER");
            if (masterDatFile.exists()) {
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new FileReader(masterDatFile));
                    String zeile = null;
                    while ((zeile = in.readLine()) != null) {
                        String[] sMasterDat = zeile.split(";");
                        if (sMasterDat.length > 1) {
                            for (String arr : sMasterDat) {
                                this.masterDat.add(Long.parseLong(arr));
                            }
                            System.out.println();
                            continue;
                        }
                        this.masterDat.add(Long.parseLong(zeile));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                System.out.print("MASTE File: ");
                this.masterDat.forEach(uid -> System.out.print(uid + " "));
                System.out.println();
            }
        }

        private World3DModel createNewWorld3DModel(ModelInformation model, ImageInformation texture, float size, Vector3f position, Quaternion rotation, boolean collision) {
            World3DModel world3DModel = new World3DModel(model, texture, position, rotation);
            world3DModel.setScale(size);
            world3DModel.setLightingEnabled(true);
            world3DModel.setNpcCollisionEnabled(collision);
            world3DModel.setHittable(collision);
            world3DModel.setCollisionShape((CollisionShape)(collision ? CollisionShape.createHullCollisionShape() : null));
            world3DModel.setAttribute("de.chaoswg._3D.staticmodelloader.strength", (Object)500);
            return world3DModel;
        }

        public void onDisable() {
            if (this.database != null) {
                this.database.close();
            }
        }

        @EventMethod
        public void onPlayerConnect(PlayerConnectEvent event) {
            Player player = event.getPlayer();
            player.setListenForKeyInput(true);
            player.registerKeys(new int[]{200, 208, 203, 205, 201, 209, 78, 74, 1});
            player.getOption("input_interaction", s -> {
                this.keyInputInterAct = KeyInput.fromString((String)s);
                player.registerKeys(new int[]{this.keyInputInterAct});
            });
            for (World3DModel model : this.world3DModels) {
                player.addWorldElement((WorldElement)model);
            }
            GuiPanel background = new GuiPanel(0.5f, 0.5f, true, 1000.0f, 650.0f, false);
            background.setPivot(PivotPosition.Center);
            background.setColor(0.0f, 0.0f, 0.0f, 0.5f);
            background.setBorderThickness(10.0f, false);
            background.setBorderColor(0.0f, 0.0f, 0.0f, 0.7f);
            background.setVisible(false);
            player.addGuiElement((GuiElement)background);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.background", (Object)background);
            GuiLabel header = new GuiLabel(0.5f, 1.1f, true);
            header.setPivot(PivotPosition.Center);
            header.setFontSize(48);
            header.setFont(Font.Default_Bold);
            header.setFontColor(1.0f, 1.0f, 1.0f, 1.0f);
            background.addChild((GuiElement)header);
            player.addGuiElement((GuiElement)header);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.header", (Object)header);
            GuiFileBrowser fb = new GuiFileBrowser(14, 0.75f, 0.5f, true, 475.0f, 600.0f, false);
            fb.setPivot(PivotPosition.Center);
            fb.setPreviewImageEnabled(false);
            fb.setPreviewImageDimension(256);
            fb.setPreviewImagePosition(640.0f, 300.0f, false);
            background.addChild((GuiElement)fb);
            player.addGuiElement((GuiElement)fb);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser", (Object)fb);
            GUI.GuiListe liste = new GUI.GuiListe(this.plugin, 0.25f, 0.6f, true, 475.0f, 360.0f, false, PivotPosition.CenterTop, PivotPosition.CenterTop);
            liste.setDebug(this.debug);
            liste.onClik = dat -> {
                int t = dat.id;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] onClik id[" + dat.id + "] ");
                }
                String sDat = (String)this.daten.get(dat.id);
                String[] aDat = sDat.split(" - ");
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] onClik dat[" + aDat.length + "] ");
                }
                if (aDat.length > 1 && dat.event.isDoubleClick()) {
                    if (this.debug > 1) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] onClik dat[" + aDat[0] + "|" + aDat[1] + "] ");
                    }
                    if (!player.hasAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel")) {
                        player.setAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID", this.daten_id.get(dat.id));
                        File targetFile = new File(this.plugin.getPath() + "/Models/" + this.daten_id.get(dat.id) + "/" + aDat[0]);
                        this.finalizeUpload(player, targetFile);
                    } else if (!player.hasAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture")) {
                        File targetFileU = new File(this.plugin.getPath() + "/Models/" + player.getUID() + "/" + aDat[1]);
                        File targetFile = new File(this.plugin.getPath() + "/Models/" + this.daten_id.get(dat.id) + "/" + aDat[1]);
                        if (!targetFileU.exists()) {
                            try {
                                CRT.copyFile(targetFile, targetFileU);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        this.finalizeUpload(player, targetFile);
                    }
                }
            };
            liste.loadFonts(this.gFont.getFontSet());
            liste.setFont(Font.Default);
            liste.setFontSize(23);
            liste.setBorderColor(65473);
            liste.setBorderThickness(2.0f, false);
            liste.setColor(65308);
            liste.setListe(event.getPlayer(), this.daten, PivotPosition.TopLeft, liste.getFontSize() * 3);
            liste.addGuiElement(event.getPlayer());
            liste.show(true);
            background.addChild((GuiElement)liste);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.Liste", (Object)liste);
            GUI.GuiChekBox transparentsChkBox = new GUI.GuiChekBox(this.plugin, "Transparenz", 0.015f, 0.925f, true, 190.0f, 20, PivotPosition.CenterLeft, PivotPosition.CenterBottom);
            transparentsChkBox.setColor(28);
            transparentsChkBox.setBorderColor(65473);
            transparentsChkBox.setCheckBoxColor(-1, 28);
            transparentsChkBox.setCallback(result -> {
                GUI.GuiChekBox.callChekBox onEv = (GUI.GuiChekBox.callChekBox)result;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] callChekBox id[" + onEv.id + "] isCheckt[" + onEv.isCheckt + "] ");
                }
            });
            transparentsChkBox.setBorderThickness(2.0f, false);
            transparentsChkBox.loadFonts(this.gFont.getFontSet());
            transparentsChkBox.addGuiElement(event.getPlayer());
            transparentsChkBox.show();
            background.addChild((GuiElement)transparentsChkBox);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox", (Object)transparentsChkBox);
            GUI.GuiMinMax transparentsMinMax = new GUI.GuiMinMax(this.plugin, 0.265f, 0.925f, true, 190.0f, 20, PivotPosition.CenterLeft, PivotPosition.Center);
            transparentsMinMax.setRange(0.0f, 1.0f, 0.05f);
            transparentsMinMax.setValue(1.0f);
            transparentsMinMax.setColor(28);
            transparentsMinMax.setBorderColor(65473);
            transparentsMinMax.setCallback(result -> {
                GUI.GuiMinMax.callMinMax onEv = (GUI.GuiMinMax.callMinMax)result;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] callMinMax id[" + onEv.id + "] value[" + onEv.value + "] ");
                }
            });
            transparentsMinMax.setBorderThickness(2.0f, false);
            transparentsMinMax.loadFonts(this.gFont.getFontSet());
            transparentsMinMax.addGuiElement(event.getPlayer());
            transparentsMinMax.show();
            background.addChild((GuiElement)transparentsMinMax);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsMinMax", (Object)transparentsMinMax);
            GUI.GuiChekBox hittableChkBox = new GUI.GuiChekBox(this.plugin, "Hittable", 0.015f, 0.825f, true, 190.0f, 20, PivotPosition.CenterLeft, PivotPosition.CenterBottom);
            hittableChkBox.setColor(28);
            hittableChkBox.setBorderColor(65473);
            hittableChkBox.setCheckBoxColor(-1, 28);
            hittableChkBox.setCallback(result -> {
                GUI.GuiChekBox.callChekBox onEv = (GUI.GuiChekBox.callChekBox)result;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] callChekBox id[" + onEv.id + "] isCheckt[" + onEv.isCheckt + "] ");
                }
            });
            hittableChkBox.setBorderThickness(2.0f, false);
            hittableChkBox.loadFonts(this.gFont.getFontSet());
            hittableChkBox.addGuiElement(event.getPlayer());
            hittableChkBox.setCheck(true);
            hittableChkBox.show();
            background.addChild((GuiElement)hittableChkBox);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.hittableChkBox", (Object)hittableChkBox);
            GUI.GuiChekBox collisionChkBox = new GUI.GuiChekBox(this.plugin, "Collision", 0.265f, 0.825f, true, 190.0f, 20, PivotPosition.CenterLeft, PivotPosition.CenterBottom);
            collisionChkBox.setColor(28);
            collisionChkBox.setBorderColor(65473);
            collisionChkBox.setCheckBoxColor(-1, 28);
            collisionChkBox.setCallback(result -> {
                GUI.GuiChekBox.callChekBox onEv = (GUI.GuiChekBox.callChekBox)result;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] callChekBox id[" + onEv.id + "] isCheckt[" + onEv.isCheckt + "] ");
                }
            });
            collisionChkBox.setBorderThickness(2.0f, false);
            collisionChkBox.loadFonts(this.gFont.getFontSet());
            collisionChkBox.addGuiElement(event.getPlayer());
            collisionChkBox.setCheck(true);
            collisionChkBox.show();
            background.addChild((GuiElement)collisionChkBox);
            player.setAttribute("de.chaoswg._3D.staticmodelloader.player.collisionChkBox", (Object)collisionChkBox);
        }

        @EventMethod
        public void onPlayerChangeItem(PlayerChangeEquippedItemEvent event) {
            Player player = event.getPlayer();
            if (player.hasAttribute("de.chaoswg._3D.staticmodelloader.modelpreview")) {
                this.abortPlacement(player);
            }
        }

        @EventMethod
        public void onPlayerSelectFileForUpload(PlayerSelectFileEvent event) {
            Player player = event.getPlayer();
            this.hideUploadDialog(player);
            String filename = event.getFilename();
            File targetFile = new File(this.plugin.getPath() + "/Models/" + ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") != null ? ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID")).longValue() : player.getUID()) + "/" + filename);
            if (!targetFile.exists()) {
                event.requestFileUpload(this.plugin.getPath() + "/Models/" + ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") != null ? ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID")).longValue() : player.getUID()), file -> this.finalizeUpload(player, (File)file));
            } else {
                this.finalizeUpload(player, targetFile);
            }
        }

        private void showUploadDialog(Player player) {
            GuiPanel background;
            GuiFileBrowser fb;
            GuiLabel header;
            this.daten = new ArrayList();
            this.daten_id = new ArrayList();
            try (ResultSet result = this.database.executeQuery("SELECT DISTINCT models.model, models.texture, models.playeruidfile FROM models ;");){
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] showUploadDialog res ");
                }
                while (result.next()) {
                    if (this.debug > 1) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] showUploadDialog res.next ");
                    }
                    try {
                        if (this.debug > 1) {
                            System.out.println("[" + this.plugin.getDescription("name") + "] showUploadDialog id[" + result.getInt("playeruidfile") + "] ");
                        }
                        String path = this.plugin.getPath() + "/Models/" + result.getLong("playeruidfile") + "/";
                        File modelFile = new File(path + result.getString("model"));
                        File imageFile = new File(path + result.getString("texture"));
                        if (!modelFile.exists() || !imageFile.exists()) continue;
                        this.daten.add(result.getString("model") + " - " + result.getString("texture"));
                        this.daten_id.add(result.getLong("playeruidfile"));
                    }
                    catch (Exception path) {}
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ((GUI.GuiListe)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Liste"))).setListe(player, this.daten, PivotPosition.TopLeft, ((GUI.GuiListe)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Liste"))).getFontSize() * 3);
            ((GUI.GuiListe)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Liste"))).addGuiElement(player);
            ((GUI.GuiListe)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Liste"))).show(true);
            if (player.hasAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel")) {
                if (!player.hasAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture")) {
                    header = (GuiLabel)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.header");
                    header.setText("-TEXTURE- SELECTION");
                    fb = (GuiFileBrowser)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser");
                    fb.setFileExtensionFilter(new String[]{"jpg", "png", "dds"});
                    fb.setPreviewImageEnabled(true);
                    background = (GuiPanel)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.background");
                    background.setVisible(true);
                    player.setMouseCursorVisible(true);
                    player.disableClientsideKeys(new int[]{1});
                }
            } else {
                header = (GuiLabel)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.header");
                header.setText("-MODEL- SELECTION");
                fb = (GuiFileBrowser)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser");
                fb.setFileExtensionFilter(new String[]{"obj", "fbx", "blend", "j3o"});
                fb.setPreviewImageEnabled(false);
                background = (GuiPanel)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.background");
                background.setVisible(true);
                player.setMouseCursorVisible(true);
                player.disableClientsideKeys(new int[]{1});
            }
        }

        private void hideUploadDialog(Player player) {
            GuiPanel background = (GuiPanel)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.background");
            background.setVisible(false);
            player.setMouseCursorVisible(false);
            player.enableClientsideKeys(new int[]{1});
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] hideUploadDialog player[" + player.getName() + "] background[" + background.isVisible() + "] ");
            }
        }

        private void finalizeUpload(Player player, File file) {
            try {
                String filename = file.getName().toLowerCase();
                if (filename.endsWith("obj") || filename.endsWith("fbx") || filename.endsWith("j3o") || filename.endsWith("blend")) {
                    ModelInformation model = new ModelInformation(file);
                    player.setAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel", (Object)model);
                } else if (filename.endsWith("jpg") || filename.endsWith("png") || filename.endsWith("dds")) {
                    ImageInformation image = new ImageInformation(file);
                    player.setAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture", (Object)image);
                }
                if (player.hasAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel") && player.hasAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture")) {
                    this.hideUploadDialog(player);
                    this.onUploadCompleted(player);
                } else {
                    this.showUploadDialog(player);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel");
                player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture");
                player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID");
                ((GUI.GuiMinMax)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsMinMax"))).setValue(1.0f);
                ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox"))).setCheck(false);
                ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.hittableChkBox"))).setCheck(true);
                ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.collisionChkBox"))).setCheck(true);
                this.hideUploadDialog(player);
            }
        }

        private void onUploadCompleted(Player player) {
            ModelInformation model = (ModelInformation)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel");
            ImageInformation texture = (ImageInformation)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture");
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingmodel");
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.upload.pendingtexture");
            Vector3f position = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)2.0f);
            Quaternion rotation = new Quaternion();
            World3DModel world3DModel = this.createNewWorld3DModel(model, texture, 1.0f, position, rotation, false);
            world3DModel.setAlpha(((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox"))).isCheckt() ? ((GUI.GuiMinMax)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsMinMax"))).getValue() : 1.0f);
            world3DModel.setTransparencyEnabled(((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox"))).isCheckt());
            world3DModel.setHittable(((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.hittableChkBox"))).isCheckt());
            world3DModel.setCollisionShape((CollisionShape)(((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.collisionChkBox"))).isCheckt() ? CollisionShape.createHullCollisionShape() : null));
            BoundingInformation boundingInfo = model.getBoundingInformation();
            if (boundingInfo != null) {
                float max;
                float x = boundingInfo.getXExtent();
                float y = boundingInfo.getYExtent();
                float z = boundingInfo.getZExtent();
                if (x > y) {
                    max = x > z ? x : z;
                } else {
                    float f = max = y > z ? y : z;
                }
                if (max > 0.0f) {
                    world3DModel.setScale(1.0f / max);
                }
            }
            this.pl.placeWorld3DModel(player, world3DModel, this.showPreview, this.prev3DModelAlpha);
            player.disableClientsideKeys(new int[]{1});
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.timer");
            player.setAttribute("de.chaoswg._3D.staticmodelloader.modelpreview", (Object)world3DModel);
        }

        private void placeElement(Player player) {
            World3DModel preview = this.pl.finalPlacement(player);
            if (!this.showPreview) {
                for (Player p : this.plugin.getServer().getAllPlayers()) {
                    if (p.getID() != player.getID()) {
                        p.addWorldElement((WorldElement)preview);
                    }
                    p.playGameSound("place_block", preview.getPosition());
                }
            } else {
                for (Player p : this.plugin.getServer().getAllPlayers()) {
                    p.playGameSound("place_block", preview.getPosition());
                }
            }
            player.showStatusMessage("Model '" + preview.getModel().getFilename() + "' placed!", 2);
            String modelFilename = preview.getModel().getFilename() + "." + preview.getModel().getExtension();
            String textureFilename = preview.getTexture().getFilename() + "." + preview.getTexture().getExtension();
            if ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") != null && this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] placeElement uid[" + (Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") + "|] ");
            }
            if (this.world3DModels.contains(preview)) {
                this.database.executeUpdate("UPDATE `models` SET `model`='" + modelFilename + "', `texture`='" + textureFilename + "', `playeruid`='" + player.getUID() + "', `position`='" + preview.getPosition().toString() + "', `rotation`='" + preview.getRotation().toString() + "', `size`='" + preview.getScale().x + "', `collision`='" + (byte)(preview.hasCollisionShape() ? 1 : 0) + "', `playeruidfile`='" + ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") != null ? ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID")).longValue() : player.getUID()) + "', `transparenc`='" + (byte)(preview.isTransparencyEnabled() ? 1 : 0) + "', `alpha`='" + preview.getAlpha() + "', `hittable`='" + (byte)(preview.isHittable() ? 1 : 0) + "'  WHERE ID = " + this.world3DModels_dbID.get(this.world3DModels.indexOf(preview)) + " ; ");
            } else {
                Connection connection = this.database.getConnection();
                try {
                    PreparedStatement prep = connection.prepareStatement("INSERT INTO `models` (`model`, `texture`, `playeruid`, `position`, `rotation`, `size`, `collision`, `playeruidfile`, `transparenc`, `alpha`, `hittable`) VALUES ('" + modelFilename + "', '" + textureFilename + "', '" + player.getUID() + "', '" + preview.getPosition().toString() + "', '" + preview.getRotation().toString() + "', '" + preview.getScale().y + "', '" + (byte)(preview.hasCollisionShape() ? 1 : 0) + "', '" + ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") != null ? ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID")).longValue() : player.getUID()) + "', '" + (byte)(preview.isTransparencyEnabled() ? 1 : 0) + "', '" + preview.getAlpha() + "', '" + (byte)(preview.isHittable() ? 1 : 0) + "')");
                    prep.executeUpdate();
                    ResultSet result = prep.getGeneratedKeys();
                    this.world3DModels_dbID.add(result.getInt(1));
                    this.world3DModels_uid.add(player.getUID());
                    this.world3DModels_uidFile.add((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID") != null ? ((Long)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID")).longValue() : player.getUID());
                }
                catch (SQLException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] saveModel ERR: " + e.getMessage());
                }
            }
            if (!this.world3DModels.contains(preview)) {
                this.world3DModels.add(preview);
            }
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.timer");
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.modelpreview");
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID");
            ((GUI.GuiMinMax)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsMinMax"))).setValue(1.0f);
            ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox"))).setCheck(false);
            ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.hittableChkBox"))).setCheck(true);
            ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.collisionChkBox"))).setCheck(true);
        }

        private void abortPlacement(Player player) {
            World3DModel preview = this.pl.abortPlacement(player);
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] abortPlacement [" + this.world3DModels.indexOf(preview) + "|] ");
            }
            this.chekAbortPlacement(player, preview);
            ((GUI.GuiMinMax)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsMinMax"))).setValue(1.0f);
            ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox"))).setCheck(false);
            ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.hittableChkBox"))).setCheck(true);
            ((GUI.GuiChekBox)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.collisionChkBox"))).setCheck(true);
        }

        @EventMethod
        public void onPlayerKeyInput(PlayerKeyEvent event) {
            Player player = event.getPlayer();
            if (!(!event.isPressed() || player.hasAttribute("de.chaoswg._3D.staticmodelloader.timer") && player.hasAttribute("de.chaoswg._3D.staticmodelloader.modelpreview"))) {
                if (event.getKeyCode() == 1 && ((GuiPanel)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.filebrowser.background")).isVisible()) {
                    this.hideUploadDialog(player);
                }
                Item.CustomItemAttribute attribute = null;
                if (player.getEquippedItem() != null && player.getEquippedItem().getAttribute() instanceof Item.CustomItemAttribute) {
                    attribute = (Item.CustomItemAttribute)player.getEquippedItem().getAttribute();
                }
                if (event.getKeyCode() == this.keyInputInterAct && attribute != null && attribute.getUUID().equals("de.chaoswg._3D.staticmodels.3dmodelblueprint")) {
                    int collisionType = CollisionType.getBitmask((int[])new int[]{16, 65536});
                    if (this.debug > 1) {
                        System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerKeyInput player[" + player.getName() + "] collisionType[" + collisionType + "] ");
                    }
                    CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
                    player.raycast(collisionType, result -> {
                        if (result != null) {
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerKeyInput player[" + player.getName() + "] elementType[" + result.getElementTypeID() + "] ");
                            }
                            Vector3f contact = result.getCollisionPoint();
                            if (this.debug > 1) {
                                System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerKeyInput player[" + player.getName() + "] Object[" + result.getCollisionObject() + "] elementType[" + result.getElementTypeID() + "] collisionInfo[" + result.getCollisionInfo() + "] ");
                            }
                            this.world3DModels.forEach(wModel -> {
                                if (this.debug > 1) {
                                    System.out.println("[" + this.plugin.getDescription("name") + "] onPlayerKeyInput player[" + player.getName() + "] wModel.getID[" + wModel.getID() + "] ");
                                }
                                if (result.getCollisionInfo() == wModel.getID()) {
                                    clh.obj = wModel;
                                    player.sendTextMessage("Contact at " + contact);
                                }
                            });
                            World3DModel world3DModel = (World3DModel)clh.obj;
                            if (!(this.world3DModels.indexOf(world3DModel) < 0 || player.getUID() != this.world3DModels_uid.get(this.world3DModels.indexOf(world3DModel)).longValue() && this.lockUser && this.masterDat.indexOf(player.getUID()) < 0)) {
                                ((GUI.GuiMinMax)((Object)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsMinMax")))).setValue(world3DModel.getAlpha());
                                ((GUI.GuiChekBox)((Object)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.transparentsChkBox")))).setCheck(world3DModel.isTransparencyEnabled());
                                ((GUI.GuiChekBox)((Object)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.hittableChkBox")))).setCheck(world3DModel.isHittable());
                                ((GUI.GuiChekBox)((Object)((Object)player.getAttribute("de.chaoswg._3D.staticmodelloader.player.collisionChkBox")))).setCheck(world3DModel.hasCollisionShape());
                                player.deleteAttribute("de.chaoswg._3D.staticmodelloader.timer");
                                player.setAttribute("de.chaoswg._3D.staticmodelloader.modelpreview", (Object)world3DModel);
                                player.setAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID", (Object)this.world3DModels_uidFile.get(this.world3DModels.indexOf(world3DModel)));
                                String[] entries = new String[]{"Abbrechen", "Bewegen", "\u00c4ndern"};
                                player.setMouseCursorVisible(true);
                                player.unregisterKeys(new int[]{this.keyInputInterAct});
                                player.disableClientsideKeys(new int[]{1});
                                player.showContextMenu(entries, entry -> {
                                    if (entry.equals(entries[0]) || entry.equals("")) {
                                        player.setMouseCursorVisible(false);
                                        player.registerKeys(new int[]{this.keyInputInterAct});
                                        this.abortPlacement(player);
                                    } else if (entry.equals(entries[1])) {
                                        player.setMouseCursorVisible(false);
                                        player.registerKeys(new int[]{this.keyInputInterAct});
                                        this.pl.placeWorld3DModel(player, world3DModel, this.showPreview, this.prev3DModelAlpha);
                                    } else if (entry.equals(entries[2])) {
                                        player.setMouseCursorVisible(false);
                                        player.registerKeys(new int[]{this.keyInputInterAct});
                                    }
                                });
                            } else {
                                if (world3DModel != null) {
                                    player.showStatusMessage("Model '" + world3DModel.getModel().getFilename() + "' not yours!", 2);
                                }
                                this.abortPlacement(player);
                            }
                        }
                    });
                }
            }
        }

        @EventMethod
        public void onPlayerHitWorldElement(PlayerElementHitEvent event) {
            WorldElement model;
            Definitions.HitDamageDefinition damageDef;
            Player player = event.getPlayer();
            Item equippedItem = player.getEquippedItem();
            if (equippedItem != null && (damageDef = Definitions.getHitDamageDefinition((String)equippedItem.getName())) != null && damageDef.getObjectDamage() > 0 && (model = event.getWorldElement()).hasAttribute("de.chaoswg._3D.staticmodelloader.strength") && (player.getUID() == this.world3DModels_uid.get(this.world3DModels.indexOf((World3DModel)model)).longValue() || !this.lockUser || this.masterDat.indexOf(player.getUID()) >= 0)) {
                int strength = (Integer)model.getAttribute("de.chaoswg._3D.staticmodelloader.strength");
                model.setAttribute("de.chaoswg._3D.staticmodelloader.strength", (Object)(strength -= damageDef.getObjectDamage()));
                if (strength <= 0) {
                    for (Player p : this.plugin.getServer().getAllPlayers()) {
                        p.removeWorldElement(model);
                        p.playGameSound("item_break_stone_medium", model.getPosition());
                    }
                    this.database.executeUpdate("DELETE FROM `models` WHERE `position` = '" + model.getPosition().toString() + "'");
                    this.world3DModels.remove((World3DModel)model);
                }
            }
        }

        @EventMethod
        public void onItemCraft(PlayerCraftItemEvent event) {
            Item.CustomItemAttribute attribute;
            Player player = event.getPlayer();
            Item item = event.getItem();
            if (item != null && item.getAttribute() instanceof Item.CustomItemAttribute && (attribute = (Item.CustomItemAttribute)item.getAttribute()).getUUID().equals("de.chaoswg._3D.staticmodels.3dmodelblueprint") && !player.isAdmin()) {
                event.setCancelled(true);
                player.showStatusMessage("You are not allowed to craft this item!", 4);
            }
        }

        private void chekAbortPlacement(Player player, World3DModel preview) {
            if (this.world3DModels.indexOf(preview) < 0) {
                if (this.showPreview) {
                    for (Player p : this.plugin.getServer().getAllPlayers()) {
                        p.removeWorldElement((WorldElement)preview);
                    }
                } else {
                    player.removeWorldElement((WorldElement)preview);
                }
            } else {
                try (ResultSet result = this.database.executeQuery("SELECT * FROM `models` WHERE `ID` ='" + this.world3DModels_dbID.get(this.world3DModels.indexOf(preview)) + "' ;");){
                    while (result.next()) {
                        try {
                            Vector3f position = new Vector3f().fromString(result.getString("position"));
                            Quaternion rotation = new Quaternion().fromString(result.getString("rotation"));
                            preview.setPosition(position);
                            preview.setRotation(rotation);
                            preview.setAlpha(result.getFloat("alpha"));
                            preview.setTransparencyEnabled(result.getBoolean("transparenc"));
                            preview.setHittable(result.getBoolean("hittable"));
                            preview.setCollisionShape((CollisionShape)(result.getBoolean("collision") ? CollisionShape.createHullCollisionShape() : null));
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.timer");
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.modelpreview");
            player.deleteAttribute("de.chaoswg._3D.staticmodelloader.player.Select.UID");
        }
    }

    public final class World3DMultiModel
    extends World3DModel {
        private final ArrayList<World3DModel> models;
        private int debug;
        private long modelLastTine;
        private ArrayList<ImageInformation> skin;
        private int skinNr;
        private int modelsNr;
        Timer ani;
        float interval;
        float delay;
        int repit;
        Runnable timerRun;

        long getModelLastTime() {
            return this.modelLastTine;
        }

        public int getModelMax() {
            return this.models.size() - 1;
        }

        public int getModelsNr() {
            return this.modelsNr;
        }

        public World3DMultiModel(ArrayList<World3DModel> models) {
            super(models.get(0).getModel(), models.get(0).getTexture());
            this.debug = 3;
            this.skin = null;
            this.skinNr = -1;
            this.interval = 5.0f;
            this.delay = 0.0f;
            this.repit = -1;
            this.timerRun = () -> {
                if (this.modelsNr + 1 >= models.size()) {
                    this.setModel(0);
                } else {
                    this.setModel(this.modelsNr + 1);
                }
                if (this.debug > 4) {
                    System.out.println("[] World3DMultiModel run Liste setModel " + this.modelsNr);
                }
            };
            this.ani = new Timer(this.interval, this.delay, this.repit, this.timerRun);
            if (this.debug > 3) {
                System.out.println("[] Info 0.1 World3DMultiModel");
            }
            this.models = models;
            this.modelsNr = 0;
            this.handleModels();
            this.setModel(this.modelsNr);
        }

        public World3DMultiModel(World3DMultiModel models) {
            super(models.models.get(0).getModel(), models.models.get(0).getTexture());
            this.debug = 3;
            this.skin = null;
            this.skinNr = -1;
            this.interval = 5.0f;
            this.delay = 0.0f;
            this.repit = -1;
            this.timerRun = () -> {
                if (this.modelsNr + 1 >= models.models.size()) {
                    this.setModel(0);
                } else {
                    this.setModel(this.modelsNr + 1);
                }
                if (this.debug > 4) {
                    System.out.println("[] World3DMultiModel run Model setModel " + this.modelsNr);
                }
            };
            this.ani = new Timer(this.interval, this.delay, this.repit, this.timerRun);
            if (this.debug > 3) {
                System.out.println("[] Info 0.2 World3DMultiModel");
            }
            this.models = new ArrayList<World3DModel>(models.models);
            this.modelsNr = 0;
            if (models.skin != null) {
                this.skin = new ArrayList<ImageInformation>(models.skin);
            }
            this.skinNr = models.skinNr;
            this.handleModels();
            this.setModel(this.modelsNr);
        }

        private void handleModels() {
            this.models.forEach(modles -> {
                if (this.debug > 3) {
                    System.out.println("[] Model[" + modles.getModel().getFilename() + "]\tTextur[" + modles.getTexture().getFilename() + "]");
                }
            });
        }

        public void setModel(int modelNr) {
            this.setModel(modelNr, -1);
        }

        public void setModel(int modelNr, int skinNr) {
            if (this.models.size() > 0) {
                if (modelNr < 0) {
                    modelNr = 0;
                }
                if (modelNr >= this.models.size()) {
                    modelNr = this.models.size() - 1;
                } else {
                    this.modelLastTine = System.currentTimeMillis();
                }
                this.modelsNr = modelNr;
                if (this.debug > 3) {
                    System.out.println("[] World3DMultiModel in setModel " + this.modelsNr + "\t" + (Object)((Object)this));
                }
                if (skinNr >= 0) {
                    this.skinNr = skinNr;
                }
                if (this.debug > 3) {
                    System.out.println("[] World3DMultiModel in setModel img[" + this.skin.get(this.skinNr).getFilename() + "] \t" + (Object)((Object)this));
                }
                if (this.skin != null && this.skinNr >= 0) {
                    if (this.skinNr < this.skin.size()) {
                        this.setTexture(this.skin.get(this.skinNr));
                    } else {
                        this.setTexture(this.models.get(modelNr).getTexture());
                    }
                } else {
                    this.setTexture(this.models.get(modelNr).getTexture());
                }
                this.setModel(this.models.get(modelNr).getModel());
                this.setHittable(this.models.get(modelNr).isHittable());
                this.setInteractable(this.models.get(modelNr).isInteractable());
                this.setLightingEnabled(this.models.get(modelNr).isLightingEnabled());
                this.setListenForCollisions(this.models.get(modelNr).isListeningForCollisions());
                this.setInteractionCrosshair(this.models.get(modelNr).getInteractionCrosshair());
                this.setCollisionShape(this.models.get(modelNr).getCollisionShape());
                this.setScale(this.models.get((int)modelNr).getScale().y);
                this.refresh();
            }
        }

        public void setPosition(Vector3f position) {
            super.setPosition(position);
        }

        public void setPosition(float x, float y, float z) {
            super.setPosition(x, y, z);
        }

        void iniSkin(ArrayList<ImageInformation> skin) {
            if (this.skin == null) {
                this.skin = skin;
            }
        }

        int getSkinMax() {
            if (this.skin != null) {
                return this.skin.size();
            }
            return 0;
        }

        int getSkinNr() {
            return this.skinNr;
        }

        ArrayList<ImageInformation> getSkin() {
            return new ArrayList<ImageInformation>(this.skin);
        }
    }
}

