/*
 * Decompiled with CFR 0.152.
 */
package de.chaoswg;

import de.chaoswg.CRT;
import de.chaoswg.SprachAPI;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import net.risingworld.api.Plugin;
import net.risingworld.api.callbacks.Callback;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.gui.PlayerGuiElementClickEvent;
import net.risingworld.api.events.player.gui.PlayerGuiInputEvent;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.GuiTextField;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.ImageInformation;

public class GUI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Dimension getImageDim(String path) {
        Dimension result = null;
        String suffix = CRT.getFileSuffix(path);
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        if (iter.hasNext()) {
            ImageReader reader = iter.next();
            try {
                FileImageInputStream stream = new FileImageInputStream(new File(path));
                reader.setInput(stream);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                result = new Dimension(width, height);
            }
            catch (IOException iOException) {
            }
            finally {
                reader.dispose();
            }
        }
        return result;
    }

    public static float getWidhtFont(String str, float fontSize, HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet, net.risingworld.api.gui.Font selectFont) {
        float fontWidth = 0.0f;
        float findLenge = 0.0f;
        int debug = 0;
        if (debug > 0) {
            System.out.println("trimTo char length[" + str.length() + "] " + str + " font(" + (fontSet != null) + ") charSet(" + (fontSet.get(selectFont) != null) + ") ");
        }
        for (int n = 0; n < str.length(); ++n) {
            Font.ClassFontDimension dim = null;
            if (str.getBytes()[n] >= 0 && fontSet != null && fontSet.get(selectFont) != null) {
                if (debug > 0) {
                    System.out.println("trimTo char#[" + str.getBytes()[n] + "]");
                }
                dim = (Font.ClassFontDimension)fontSet.get(selectFont).get(str.getBytes()[n]);
                fontWidth = fontSize * dim.width / dim.height;
            } else if (debug > 0) {
                System.err.println("trimTo char#[" + str.getBytes()[n] + "]");
            }
            if (selectFont.equals((Object)net.risingworld.api.gui.Font.Handdrawn)) {
                fontWidth /= 3.75f;
            }
            if (debug > 0) {
                System.out.print(" [" + str.getBytes()[n] + "]" + (dim != null ? dim.toString() : "") + "w[" + fontWidth + "] ");
            }
            findLenge += fontWidth;
        }
        return findLenge;
    }

    public static String convertColor(int color) {
        return GUI.convertColor(color, "[#", "]");
    }

    public static String convertColor(int color, String prev, String suff) {
        return prev + String.format("%8s", Integer.toHexString(color & 0xFFFFFFFF)).replaceAll(" ", "").substring(0, 6) + suff;
    }

    public static String phastUmlaut(String input) {
        return input.replace("\u00c4", "\u00c4").replace("\u00e4", "\u00e4").replace("\u00d6", "\u00d6").replace("\u00f6", "\u00f6").replace("\u00dc", "\u00dc").replace("\u00fc", "\u00fc").replace("\u00df", "\u00df");
    }

    public static String rwLabelText(String text, String begin) {
        return GUI.rwLabelText(text, begin, begin);
    }

    public static String rwLabelText(String text, String begin, String end) {
        String ausgabe = null;
        String[] data = text.split("\n");
        if (data.length > 0) {
            int n;
            for (n = 0; n < data.length; ++n) {
                if (!data[n].startsWith(begin)) {
                    data[n] = begin + data[n];
                }
                if (data[n].endsWith(end)) continue;
                data[n] = data[n] + end;
            }
            ausgabe = "";
            for (n = 0; n < data.length; ++n) {
                if (n > 0) {
                    ausgabe = ausgabe + "\n";
                }
                ausgabe = ausgabe + data[n];
            }
        }
        return ausgabe;
    }

    public static float findAbsoluteGuiPositionY(Player player, GuiElement element) {
        GuiElement elem = element;
        float Y = 0.0f;
        float H = 0.0f;
        int debug = 4;
        do {
            if (debug > 2) {
                System.out.print("[GuiListe] findAbsoluteGuiPositionY ID[" + elem.getID() + "] ");
            }
            if (elem.getPivot().equals((Object)PivotPosition.Center) || elem.getPivot().equals((Object)PivotPosition.CenterLeft) || elem.getPivot().equals((Object)PivotPosition.CenterRight)) {
                Y += (elem.isRelativePosition() ? elem.getPositionY() * (float)player.getScreenResolutionY() : elem.getPositionY()) - (elem.isRelativeSize() ? elem.getHeight() / 2.0f * (float)player.getScreenResolutionY() : elem.getHeight() / 2.0f);
                H += elem.getHeight() / 2.0f;
                if (debug > 3) {
                    System.out.print(" CENTER ");
                }
            } else if (elem.getPivot().equals((Object)PivotPosition.CenterTop) || elem.getPivot().equals((Object)PivotPosition.TopLeft) || elem.getPivot().equals((Object)PivotPosition.TopRight)) {
                Y += (elem.isRelativePosition() ? elem.getPositionY() * (float)player.getScreenResolutionY() : elem.getPositionY()) - (elem.isRelativeSize() ? elem.getHeight() * (float)player.getScreenResolutionY() : elem.getHeight());
                H += elem.getHeight();
                if (debug > 3) {
                    System.out.print(" TOP ");
                }
            }
            if (debug <= 2) continue;
            System.out.println(" [" + Y + "]  [" + H + "] ");
        } while ((elem = elem.getParent()) != null);
        return Y;
    }

    static class GuiMinMax
    extends GuiPanel
    implements Listener {
        private final Plugin plugin;
        private final int fontSizeAbs;
        private final int fontSize;
        private final float width;
        private float x;
        private float y;
        private boolean isRelativePosition;
        private int debug = 3;
        private float min = -1.0f;
        private float max = -1.0f;
        private float step = -1.0f;
        private Callback onClik = null;
        private GuiTextField panelText;
        private Player player;
        private HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet;
        private GuiPanel panelUp;
        private GuiPanel panelDown;
        private float value;
        private float colorText;

        private float getFontSize() {
            return this.fontSize;
        }

        public void setCallback(Callback callback) {
            this.onClik = callback;
        }

        public void setValue(float value) {
            this.value = value;
            this.panelText.setText(String.valueOf(value));
        }

        public float getValue() {
            return this.value;
        }

        public void setColorText(float colorText) {
            this.colorText = colorText;
        }

        public float getColorText() {
            return this.colorText;
        }

        GuiMinMax(Plugin plugin, float x, float y, boolean isRelativePosition, float width, int fontSize, PivotPosition pivotPosition, PivotPosition pivotPositionText) {
            super(x, y, isRelativePosition, width, 1.0f, false);
            this.fontSizeAbs = 4;
            this.plugin = plugin;
            this.fontSize = fontSize;
            this.width = width;
            this.x = x;
            this.y = y;
            this.isRelativePosition = isRelativePosition;
            this.makeWindow(pivotPosition, pivotPositionText);
        }

        private void makeWindow(PivotPosition pivotPosition, PivotPosition pivotPositionText) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] makeWindow []  ");
            }
            this.setPivot(pivotPosition);
            this.panelUp = new GuiPanel(1.0f, 1.0f, true, (float)(this.fontSize / 2), (float)(this.fontSize / 2), false);
            this.panelUp.setPivot(PivotPosition.TopRight);
            this.panelUp.setBorderThickness((float)(this.fontSizeAbs / 2), false);
            this.panelUp.setClickable(true);
            this.addChild((GuiElement)this.panelUp);
            this.panelDown = new GuiPanel(1.0f, 0.0f, true, (float)(this.fontSize / 2), (float)(this.fontSize / 2), false);
            this.panelDown.setPivot(PivotPosition.BottomRight);
            this.panelDown.setBorderThickness((float)(this.fontSizeAbs / 2), false);
            this.panelDown.setClickable(true);
            this.addChild((GuiElement)this.panelDown);
            this.panelText = new GuiTextField(this.x, this.y, this.isRelativePosition, 20.0f, (float)(this.fontSize + this.fontSizeAbs * 1), false);
            this.panelText.setListenForInput(true);
            this.panelText.setClickable(true);
            this.panelText.setPivot(pivotPositionText);
            this.panelText.setColor(0);
            if (this.debug > 3) {
                this.panelText.setBorderThickness(1.0f, false);
            } else {
                this.panelText.setBorderThickness(0.0f, false);
            }
            this.panelText.setBackgroundPreset(0);
            this.addChild((GuiElement)this.panelText);
            this.plugin.registerEventListener((Listener)this);
        }

        void setRange(float min, float max, float step) {
            this.min = min;
            this.max = max;
            this.step = step;
        }

        void loadFonts(HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet) {
            this.fontSet = fontSet;
        }

        void addGuiElement(Player player) {
            player.addGuiElement((GuiElement)this);
            player.addGuiElement((GuiElement)this.panelUp);
            player.addGuiElement((GuiElement)this.panelDown);
            player.addGuiElement((GuiElement)this.panelText);
            this.player = player;
        }

        void show() {
            this.setVisible(true);
            if (this.isRelativePosition) {
                this.x *= (float)this.player.getScreenResolutionX();
                this.y *= (float)this.player.getScreenResolutionY();
                this.isRelativePosition = !this.isRelativePosition;
            }
            this.setSize(this.width, this.fontSize + this.fontSizeAbs * 2, false);
            this.panelUp.setColor(this.panelText.getFontColor());
            this.panelUp.setBorderColor(193);
            this.panelUp.setPosition(this.width - (float)(this.fontSizeAbs / 2) - (float)(this.fontSizeAbs / 4), this.getHeight() - (float)(this.fontSizeAbs / 2) - (float)(this.fontSizeAbs / 4), false);
            this.panelDown.setColor(this.panelText.getFontColor());
            this.panelDown.setBorderColor(193);
            this.panelDown.setPosition(this.width - (float)(this.fontSizeAbs / 2) - (float)(this.fontSizeAbs / 4), 0.0f + (float)(this.fontSizeAbs / 2) + (float)(this.fontSizeAbs / 4), false);
            String str = this.panelText.getDefaultText();
            float findLenge = GUI.getWidhtFont(str, this.getFontSize(), this.fontSet, this.panelText.getFont());
            switch (this.panelText.getPivot()) {
                case Center: {
                    this.panelText.setSize(findLenge, (float)(this.fontSize + this.fontSizeAbs * 1), false);
                    this.panelText.setPosition((this.width - (float)(this.fontSizeAbs / 2) - (float)(this.fontSizeAbs / 4)) / 2.0f, (float)((this.fontSize + this.fontSizeAbs * 2) / 2), this.isRelativePosition);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @EventMethod
        public void onGuiMinMaxInputEvent(PlayerGuiInputEvent event) {
            if (event.getGuiElement().equals((Object)this.panelText)) {
                if (this.debug > 2) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] GuiInputEvent [" + event.getGuiElement().getID() + "] Input[" + event.getInput() + "] ");
                }
                CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
                clh.str = event.getInput();
                clh.str = clh.str.replaceAll("[.]", ",");
                clh.str = clh.str.replaceFirst("[.,]", ".");
                clh.str = clh.str.replaceAll("[^0-9.]", "");
                try {
                    this.value = Float.valueOf(clh.str).floatValue();
                    this.panelText.setText(String.valueOf(this.value));
                }
                catch (NumberFormatException e) {
                    System.err.println("[" + this.plugin.getDescription("name") + "] Float.valueOf[] " + e.getMessage());
                    this.panelText.setText(clh.str);
                }
                finally {
                    this.show();
                    if (this.onClik != null) {
                        this.onClik.onCall((Object)new callMinMax(this.getID(), this.value));
                    }
                }
            }
        }

        @EventMethod
        public void onGuiMinMaxClick(PlayerGuiElementClickEvent event) {
            if (this.debug > 3) {
                System.out.println("[" + this.plugin.getDescription("name") + "] GuiMinMaxClick [" + event.getGuiElement().getID() + "]  ");
            }
            if (event.getMouseButton() == 0 && event.getGuiElement().equals((Object)this.panelUp)) {
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] GuiMinMaxClick [" + event.getGuiElement().getID() + "] Up ");
                }
                this.value = this.value + this.step <= this.max ? this.value + this.step : this.max;
                this.panelText.setText(String.valueOf(this.value));
                this.show();
                if (this.onClik != null) {
                    this.onClik.onCall((Object)new callMinMax(this.getID(), this.value));
                }
            } else if (event.getMouseButton() == 0 && event.getGuiElement().equals((Object)this.panelDown)) {
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] GuiMinMaxClick [" + event.getGuiElement().getID() + "] Down ");
                }
                this.value = this.value - this.step >= this.min ? this.value - this.step : this.min;
                this.panelText.setText(String.valueOf(this.value));
                this.show();
                if (this.onClik != null) {
                    this.onClik.onCall((Object)new callMinMax(this.getID(), this.value));
                }
            } else if (event.getMouseButton() == 0 && event.getGuiElement().equals((Object)this.panelText) && this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] GuiMinMaxClick [" + event.getGuiElement().getID() + "] Input ");
            }
        }

        static class callMinMax {
            final int id;
            final float value;

            public callMinMax(int id, float value) {
                this.id = id;
                this.value = value;
            }

            public String toString() {
                return "ID[" + this.id + "] VALUE[" + this.value + "] ";
            }
        }
    }

    public static class GuiChekBox
    extends GuiPanel
    implements Listener {
        private int debug = 3;
        private Plugin plugin;
        private HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet;
        private final int fontSize;
        private final float width;
        private Player player;
        private float x;
        private float y;
        private boolean isRelativePosition;
        private int fontSizeAbs = 4;
        private final String text;
        private GuiPanel panelChekBox;
        private GuiLabel panelText;
        private float panelTextwidth;
        private boolean isCheckt;
        private int colorCheckBoxON = 65408;
        private int colorCheckBoxOFF = 7196;
        private Callback onClik = null;

        public void setCheckBoxColor(int colorCheckBoxON, int colorCheckBoxOFF) {
            this.colorCheckBoxON = colorCheckBoxON;
            this.colorCheckBoxOFF = colorCheckBoxOFF;
            this.setIsChekt();
        }

        public void setCheck(boolean check) {
            this.isCheckt = check;
            this.setIsChekt();
        }

        public boolean isCheckt() {
            return this.isCheckt;
        }

        public void setCallback(Callback callback) {
            this.onClik = callback;
        }

        GuiChekBox(Plugin plugin, String text, float x, float y, boolean isRelativePosition, float width, int fontSize, PivotPosition pivotPosition, PivotPosition pivotPositionText) {
            super(x, y, isRelativePosition, width, 1.0f, false);
            this.plugin = plugin;
            this.fontSize = fontSize;
            this.width = width;
            this.x = x;
            this.y = y;
            this.isRelativePosition = isRelativePosition;
            this.text = text;
            this.makeWindow(pivotPosition, pivotPositionText);
        }

        private void makeWindow(PivotPosition pivotPosition, PivotPosition pivotPositionText) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] makeWindow []  ");
            }
            this.setPivot(pivotPosition);
            this.setClickable(true);
            this.panelChekBox = new GuiPanel(this.x + (float)this.fontSizeAbs, this.y + (float)this.fontSizeAbs, false, (float)this.fontSize, (float)this.fontSize, false);
            this.panelChekBox.setClickable(true);
            this.panelChekBox.setColor(this.colorCheckBoxOFF);
            this.panelChekBox.setBorderColor(this.colorCheckBoxON);
            this.panelChekBox.setBorderThickness(2.0f, false);
            this.addChild((GuiElement)this.panelChekBox);
            this.panelText = new GuiLabel(this.text, this.x, this.y, this.isRelativePosition);
            this.panelText.setClickable(true);
            this.panelText.loadFonts(this.fontSet);
            this.panelText.setFontSize(this.fontSize);
            this.panelText.setPivot(pivotPositionText);
            if (this.debug > 3) {
                this.panelText.setBorderColor(-16711743);
                this.panelText.setBorderThickness(1.0f, false);
            }
            this.addChild((GuiElement)this.panelText);
            this.plugin.registerEventListener((Listener)this);
        }

        void addGuiElement(Player player) {
            player.addGuiElement((GuiElement)this);
            player.addGuiElement((GuiElement)this.panelChekBox);
            player.addGuiElement((GuiElement)this.panelText);
            this.player = player;
        }

        void show() {
            this.setVisible(true);
            if (this.isRelativePosition) {
                this.x *= (float)this.player.getScreenResolutionX();
                this.y *= (float)this.player.getScreenResolutionY();
                this.isRelativePosition = !this.isRelativePosition;
            }
            this.setSize(this.width, this.fontSize + this.fontSizeAbs * 2, false);
            this.panelTextwidth = this.width - (float)this.fontSize + (float)(this.fontSizeAbs * 3);
            switch (this.panelText.getPivot()) {
                case BottomLeft: {
                    this.panelText.setPosition(this.fontSize + this.fontSizeAbs * 3, this.fontSizeAbs, this.isRelativePosition);
                    break;
                }
                case CenterBottom: {
                    this.panelText.setPosition(this.panelTextwidth / 2.0f + (float)((this.fontSize + this.fontSizeAbs * 3) / 2), this.fontSizeAbs, this.isRelativePosition);
                    break;
                }
                case BottomRight: {
                    this.panelText.setPosition(this.width - (float)(this.fontSizeAbs * 1), this.fontSizeAbs, this.isRelativePosition);
                }
            }
            this.panelText.trimTo(this.player, this.panelTextwidth, " ");
        }

        void hide() {
            this.setVisible(false);
        }

        void loadFonts(HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet) {
            this.fontSet = fontSet;
        }

        @EventMethod
        public void onChekBoxClick(PlayerGuiElementClickEvent event) {
            if (event.getGuiElement().equals((Object)this) || event.getGuiElement().equals((Object)this.panelChekBox) || event.getGuiElement().equals((Object)this.panelText)) {
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] onGuiCheckBoxClick [" + event.getGuiElement().getID() + "]  ");
                }
                this.isCheckt = !this.isCheckt;
                this.setIsChekt();
                if (this.onClik != null) {
                    this.onClik.onCall((Object)new callChekBox(this.getID(), this.isCheckt));
                }
            }
        }

        private void setIsChekt() {
            if (this.isCheckt) {
                this.panelChekBox.setColor(this.colorCheckBoxON);
                this.panelChekBox.setBorderColor(this.colorCheckBoxOFF);
            } else {
                this.panelChekBox.setColor(this.colorCheckBoxOFF);
                this.panelChekBox.setBorderColor(this.colorCheckBoxON);
            }
        }

        class callChekBox {
            int id;
            boolean isCheckt;

            callChekBox(int GuiID, boolean isCheckt) {
                this.isCheckt = isCheckt;
                this.id = GuiID;
            }

            public String toString() {
                return "ID[" + this.id + "] isCheckt[" + this.isCheckt + "] ";
            }
        }
    }

    public static class GuiListeSuche
    extends GuiPanel
    implements Listener {
        private int size;
        private HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet;
        private float width;
        private Player player;
        private final Plugin plugin;
        private int debug = 1;
        private final float height;
        private final boolean rootRelativesize;
        private static GuiListe liste;
        private Callback<String> textCallBack;
        private Boolean sort;
        private GuiTextField input;
        private net.risingworld.api.gui.Font font;
        private Callback<GuiListe.onGuiListe> onClik = null;
        private float textFieldAbs;
        private int fontColor = -1;
        private int myColor = 0xFFFF1C;
        private int myBorderColor;
        private float borderThikness = 1.0f;
        private boolean borderThiknessRelative = false;
        private int selectID;
        private float borderThiknessList = 1.0f;
        private boolean borderThiknessRelativeList = false;
        private float borderThiknessListAktiv = 2.0f;
        private boolean borderThiknessRelativeListAktiv = false;
        private int borderColorList = -2139062017;
        private int borderColorListAktiv = -1;

        public void setOnClik(Callback<GuiListe.onGuiListe> onClik) {
            this.onClik = onClik;
        }

        public void setDebug(int debug) {
            this.debug = debug;
        }

        public int getDebug() {
            return this.debug;
        }

        public GuiListeSuche(Plugin plugin, float x, float y, boolean relativeposition, float width, float height, boolean relativesize) {
            super(x, y, relativeposition, width, height, relativesize);
            this.plugin = plugin;
            this.width = width;
            this.height = height;
            this.rootRelativesize = relativesize;
            this.textFieldAbs = 8.0f;
            this.selectID = -1;
            this.makeWindow();
        }

        private void makeWindow() {
            this.setClickable(true);
            this.plugin.registerEventListener((Listener)this);
        }

        public void addGuiElement(Player player) {
            player.addGuiElement((GuiElement)this);
            this.player = player;
        }

        public void setFontSize(Player player, int size) {
            this.size = size;
            this.player = player;
            this.setSize(this.isRelativeSize() ? this.width * (float)player.getScreenResolutionX() : this.width, this.isRelativeSize() ? this.height * (float)player.getScreenResolutionY() : this.height, false);
        }

        public float getFontSize() {
            return this.size;
        }

        public void setFont(net.risingworld.api.gui.Font font) {
            this.font = font;
        }

        public void setFontColor(int fontColor) {
            this.fontColor = fontColor;
        }

        public void setColor(int color) {
            super.setColor(color);
            this.myColor = color;
        }

        public void setBorderColor(int color) {
            super.setBorderColor(color);
            this.myBorderColor = color;
        }

        public void setBorderThickness(float thickness, boolean relative) {
            super.setBorderThickness(thickness, relative);
            this.borderThikness = thickness;
            this.borderThiknessRelative = relative;
        }

        public void setSelectedUserID(int selectedUserID) {
            this.selectID = selectedUserID;
        }

        public int getSelectedUserID() {
            return this.selectID;
        }

        public void setBorderThicknessList(float thickness, boolean relative) {
            this.borderThiknessList = thickness;
            this.borderThiknessRelativeList = relative;
        }

        public void setBorderThicknessListAktiv(float thickness, boolean relative) {
            this.borderThiknessListAktiv = thickness;
            this.borderThiknessRelativeListAktiv = relative;
        }

        public void setBorderColorList(int color) {
            super.setBorderColor(0);
            this.borderColorList = color;
        }

        public void setBorderColorListAktiv(int color) {
            super.setBorderColor(0);
            this.borderColorListAktiv = color;
        }

        public void loadFonts(HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet) {
            this.fontSet = fontSet;
        }

        public void setListe(Player player, ArrayList<String> daten, PivotPosition pivotPosition, float minHight) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] setListeSuche daten[" + daten.toString() + "] ");
            }
            this.loadListe(player, daten, pivotPosition, minHight);
        }

        public void setListe(Player player, ArrayList<String> daten, PivotPosition pivotPosition, float minHight, Boolean sort) {
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] setListeSuche daten[" + daten.toString() + "] ");
            }
            this.sort = sort;
            this.loadListe(player, daten, pivotPosition, minHight);
        }

        private void loadListe(Player player, ArrayList<String> daten, PivotPosition pivotPosition, float minHight) {
            float llH;
            this.player = player;
            this.textCallBack = str -> {
                if (this.debug > 1) {
                    System.out.println("[GuiListeSuche] makeWindow [" + str + "] CalBack ");
                }
            };
            this.input = new GuiTextField(0.5f, 1.0f, true, this.rootRelativesize ? this.width * (float)player.getScreenResolutionX() : this.width, (float)this.size + this.textFieldAbs, false);
            this.input.setListenForInput(true);
            this.input.setColor(0);
            this.input.setBorderColor(this.myBorderColor);
            this.input.setBorderThickness(this.borderThikness > 0.0f ? this.borderThikness : 1.0f, this.borderThiknessRelative);
            this.input.setPivot(PivotPosition.CenterTop);
            this.input.setFontColor(this.fontColor);
            this.addChild((GuiElement)this.input);
            player.addGuiElement((GuiElement)this.input);
            float llX = this.isRelativePosition() ? this.getPositionX() * (float)player.getScreenResolutionX() : this.getPositionX();
            float llY = this.isRelativePosition() ? this.getPositionY() * (float)player.getScreenResolutionY() : this.getPositionY();
            float llB = this.rootRelativesize ? this.width * (float)player.getScreenResolutionX() : this.width;
            float f = llH = this.rootRelativesize ? this.height * (float)player.getScreenResolutionY() : this.height;
            if (this.debug > 1) {
                System.out.println("[" + this.plugin.getDescription("name") + "] loadListeSuche size[" + llX + "|" + llY + "-" + llB + "|" + llH + "] ");
            }
            liste = new GuiListe(this.plugin, llB / 2.0f, llH - ((float)this.size + this.textFieldAbs), false, llB, llH - ((float)this.size + this.textFieldAbs), false, PivotPosition.CenterTop, PivotPosition.CenterTop);
            liste.setDebug(this.debug);
            GuiListeSuche.liste.onClik = this.onClik == null ? dat -> {
                this.selectID = dat.id;
                if (this.debug > 1) {
                    System.out.println("[" + this.plugin.getDescription("name") + "] onClik-Callback id[" + dat.id + "] selectID[" + this.selectID + "] ");
                }
            } : this.onClik;
            liste.loadFonts(this.fontSet);
            liste.setFont(this.font);
            liste.setFontSize((int)this.getFontSize());
            liste.setFontColor(this.fontColor);
            liste.setColor(this.myColor);
            liste.setBorderColor(this.myBorderColor);
            liste.setBorderThickness(this.borderThikness, this.borderThiknessRelative);
            liste.setBorderColorList(this.borderColorList);
            liste.setBorderThicknessList(this.borderThiknessList, this.borderThiknessRelativeList);
            liste.setBorderColorListAktiv(this.borderColorListAktiv);
            liste.setBorderThicknessListAktiv(this.borderThiknessListAktiv, this.borderThiknessRelativeListAktiv);
            GuiListeSuche.liste.setSelectedUserID(this.selectID);
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] loadListeSuche daten[" + daten.toString() + "] ");
            }
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] loadListeSuche player[" + player.getName() + "] ");
            }
            if (this.debug > 2) {
                System.out.println("[" + this.plugin.getDescription("name") + "] loadListeSuche liste[" + ((Object)((Object)liste)).toString() + "] ");
            }
            this.addChild((GuiElement)liste);
            liste.setListe(player, daten, pivotPosition, minHight);
            liste.addGuiElement(player);
            liste.show(this.sort);
        }

        @EventMethod
        public void onPlayerGuiInputEvent(PlayerGuiInputEvent event) {
            if (event.getGuiElement().equals((Object)this.input) && this.debug > 1) {
                System.out.println("[GuiListeSuche] GuiInputEvent [" + event.getGuiElement().getID() + "] Input[" + event.getInput() + "] ");
                CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
                clh.str = event.getInput();
                GuiListeSuche.liste.filter = str -> {
                    if (clh.str.equals("")) {
                        return true;
                    }
                    return str.toLowerCase().contains(clh.str.toLowerCase());
                };
                liste.show(this.sort);
            }
        }

        @EventMethod
        public void onGuiListeClick(PlayerGuiElementClickEvent event) {
            if (event.getGuiElement().equals((Object)this) && this.debug > 1) {
                System.out.println("[GuiListeSuche] GuiClickEvent [" + event.getGuiElement().getID() + "] Input ");
            }
        }

        public void destroy() {
            if (liste != null) {
                liste.destroy();
            }
        }
    }

    public static class GuiLabel
    extends net.risingworld.api.gui.GuiLabel {
        private String orgText;
        private int debug = 1;
        private int id = -1;
        private HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet;

        public GuiLabel(float x, float y, boolean relativeposition) {
            super(x, y, relativeposition);
        }

        public GuiLabel(String text, float x, float y, boolean relativeposition) {
            super(text, x, y, relativeposition);
            this.orgText = text;
        }

        private void loadFonts(HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet) {
            this.fontSet = fontSet;
        }

        public void setTextOrg(String text) {
            this.orgText = text;
        }

        public String getTextOrg() {
            return this.orgText;
        }

        public void trimTo(Player player, float maxAbsoluteWidth) {
            this.trimTo(player, maxAbsoluteWidth, "");
        }

        public void trimTo(Player player, float maxAbsoluteWidth, String araund) {
            boolean trimmEnd = false;
            float findLenge = 0.0f;
            int findMax = 100;
            String orgTextTmp = this.orgText;
            do {
                --findMax;
                if (this.debug > 4) {
                    System.out.println("[" + this.getFont() + "] [" + (this.isRelativeSize() ? this.getWidth() * (float)player.getScreenResolutionX() : this.getWidth()) + "] ");
                }
                findLenge = GUI.getWidhtFont(araund + orgTextTmp + araund, this.getFontSize(), this.fontSet, this.getFont());
                if (this.debug > 4) {
                    System.out.println(". width[" + findLenge + "] " + (findLenge < maxAbsoluteWidth));
                }
                if (!(findLenge > maxAbsoluteWidth)) continue;
                if (trimmEnd) {
                    if (orgTextTmp.endsWith("...") && orgTextTmp.length() > 4) {
                        orgTextTmp = orgTextTmp.substring(0, orgTextTmp.length() - 4) + "...";
                        continue;
                    }
                    if (orgTextTmp.length() <= 3) continue;
                    orgTextTmp = orgTextTmp.substring(0, orgTextTmp.length() - 3) + "...";
                    continue;
                }
                if (orgTextTmp.equals("...") && orgTextTmp.length() > 5) {
                    orgTextTmp = orgTextTmp.substring(0, orgTextTmp.length() / 2 - 1) + "..." + orgTextTmp.substring(orgTextTmp.length() / 2 + 4);
                    continue;
                }
                if (orgTextTmp.length() <= 4) continue;
                orgTextTmp = orgTextTmp.substring(0, orgTextTmp.length() / 2 - 1) + "..." + orgTextTmp.substring(orgTextTmp.length() / 2 + 3);
            } while (findLenge > maxAbsoluteWidth && findMax >= 0);
            if (this.debug > 3) {
                System.out.println(" [" + orgTextTmp + "] ");
            }
            this.setText(araund + orgTextTmp + araund);
        }
    }

    public static final class Font {
        int debug;
        private HashMap<net.risingworld.api.gui.Font, ClassCharSet> fontSet;

        void setDebug(int debug) {
            this.debug = debug;
        }

        int getDebug() {
            return this.debug;
        }

        public HashMap<net.risingworld.api.gui.Font, ClassCharSet> getFontSet() {
            return new HashMap<net.risingworld.api.gui.Font, ClassCharSet>(this.fontSet);
        }

        public Font() {
            this.debug = 1;
        }

        public Font(Plugin plugin) {
            this.debug = 1;
            this.loadDaten(plugin);
        }

        public Font(Plugin plugin, int debug) {
            this.debug = debug;
            this.loadDaten(plugin);
        }

        public void loadDaten(Plugin plugin) {
            this.fontSet = new HashMap();
            InputStream inputStream = null;
            net.risingworld.api.gui.Font[] aFont = net.risingworld.api.gui.Font.values();
            File sJiwGui = new File(plugin.getPath() + "../../lib/jiw-gui.jar");
            String sFontFile = null;
            for (net.risingworld.api.gui.Font font : aFont) {
                if (this.debug > 1) {
                    System.out.println("[" + plugin.getDescription("name") + "] GuiLabel Font loadDaten[" + font + "] ");
                }
                switch (font) {
                    case Console: {
                        sFontFile = "Console.fnt";
                        break;
                    }
                    case Default: {
                        sFontFile = "Default.fnt";
                        break;
                    }
                    case Default_Bold: {
                        sFontFile = "Default_b.fnt";
                        break;
                    }
                    case Default_Bold_Italic: {
                        sFontFile = "Default_bi.fnt";
                        break;
                    }
                    case Default_Italic: {
                        sFontFile = "Default_i.fnt";
                        break;
                    }
                    case DefaultMono: {
                        sFontFile = "DefaultMono.fnt";
                        break;
                    }
                    case DefaultMono_Bold: {
                        sFontFile = "DefaultMono_b.fnt";
                        break;
                    }
                    case DefaultMono_Bold_Italic: {
                        sFontFile = "DefaultMono_bi.fnt";
                        break;
                    }
                    case DefaultMono_Italic: {
                        sFontFile = "DefaultMono_i.fnt";
                        break;
                    }
                    case Handdrawn: {
                        sFontFile = "Handdrawn_0.fnt";
                        break;
                    }
                    default: {
                        sFontFile = "Default.fnt";
                    }
                }
                String sJiwGuiFont = "de/jiw/gui/resources/Fonts/" + sFontFile;
                try {
                    URL jarfile = new URL("jar", "", "file:" + sJiwGui.getAbsolutePath() + "!/" + sJiwGuiFont);
                    URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{jarfile});
                    inputStream = classLoader.getResourceAsStream(sJiwGuiFont);
                }
                catch (MalformedURLException e) {
                    System.err.println("[" + plugin.getDescription("name") + "] ERR load File[] " + e.getMessage());
                }
                try {
                    ClassCharSet data = this.readFontFromInputStream(inputStream);
                    this.fontSet.put(font, data);
                }
                catch (IOException e) {
                    System.err.println("[" + plugin.getDescription("name") + "] ERR load File[] " + e.getMessage());
                }
            }
        }

        private ClassCharSet readFontFromInputStream(InputStream inputStream) throws IOException {
            ClassCharSet result = new ClassCharSet();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (this.debug > 4) {
                        System.out.println("[readFromInputStream] GuiLabel loadDaten BufferedReader[" + line + "] ");
                    }
                    String[] data = line.split(" ");
                    int id = -1;
                    float lineHeight = -1.0f;
                    float base = -1.0f;
                    float w = -1.0f;
                    float h = -1.0f;
                    block24: for (String dat : data) {
                        String[] da = dat.split("=");
                        switch (da[0].toLowerCase()) {
                            case "lineHeight": {
                                if (this.debug > 5) {
                                    System.out.println("[readFromInputStream] GuiLabel loadDaten             id[" + da[1] + "] ");
                                }
                                lineHeight = Float.valueOf(da[1]).floatValue();
                                continue block24;
                            }
                            case "base": {
                                if (this.debug > 5) {
                                    System.out.println("[readFromInputStream] GuiLabel loadDaten             id[" + da[1] + "] ");
                                }
                                base = Float.valueOf(da[1]).floatValue();
                                continue block24;
                            }
                            case "id": {
                                if (this.debug > 5) {
                                    System.out.println("[readFromInputStream] GuiLabel loadDaten             id[" + da[1] + "] ");
                                }
                                id = Integer.valueOf(da[1]);
                                continue block24;
                            }
                            case "width": {
                                if (this.debug > 5) {
                                    System.out.println("[readFromInputStream] GuiLabel loadDaten          width[" + da[1] + "] ");
                                }
                                w = Float.valueOf(da[1]).floatValue();
                                continue block24;
                            }
                            case "height": {
                                if (this.debug > 5) {
                                    System.out.println("[readFromInputStream] GuiLabel loadDaten         height[" + da[1] + "] ");
                                }
                                h = Float.valueOf(da[1]).floatValue();
                                continue block24;
                            }
                        }
                    }
                    result.addID(id, w, h, lineHeight, base);
                }
            }
            return result;
        }

        private String readFromInputStream(InputStream inputStream) throws IOException {
            StringBuilder resultStringBuilder = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = br.readLine()) != null) {
                    if (this.debug > 1) {
                        System.out.println("[readFromInputStream] GuiLabel loadDaten BufferedReader[" + line + "] ");
                    }
                    resultStringBuilder.append(line).append("\n");
                }
            }
            return resultStringBuilder.toString();
        }

        public float getWidth(String str, PivotPosition pivot) {
            return -1.0f;
        }

        public class ClassCharSet
        extends HashMap<Integer, ClassFontDimension> {
            public void addID(int id, float width, float height, float lineHeight, float base) {
                Dimension dim = new Dimension();
                dim.setSize(width, height);
                this.put(id, new ClassFontDimension(width, height, lineHeight, base));
            }
        }

        public class ClassFontDimension {
            float width;
            float height;
            private final float lineHeight;
            private final float base;

            public ClassFontDimension(float width, float height, float lineHeight, float base) {
                this.width = width;
                this.height = height;
                this.lineHeight = lineHeight;
                this.base = base;
            }

            public String toString() {
                return "(" + String.valueOf(this.width) + "|" + String.valueOf(this.height) + ")";
            }
        }
    }

    public static class GuiListe
    extends GuiPanel
    implements Listener {
        private Plugin plugin;
        private int debug;
        private GuiPanel textPanel;
        private Player player;
        private int labPageMax;
        private GuiPanel scroolBar;
        private GuiPanel scroolBarUpPanel;
        private GuiImage scroolBarUpIcon = null;
        private GuiPanel scroolBarDownPanel;
        private GuiImage scroolBarDownIcon = null;
        private GuiPanel scroolBarPushPanel;
        private float scoolBarPanellMaxHight;
        private float scoolBarPanellStep;
        private HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet;
        private GuiPanel scroolBarUp;
        private GuiPanel scroolBarDown;
        private GuiPanel scroolBarPush;
        private int scroolColor;
        private int labSelectID;
        private float textPanelMinHight;
        private float textPanelMaxHigh;
        private ImageInformation logoUpIcon;
        private ImageInformation logoDownIcon;
        private boolean isIcon;
        private SprachAPI sAPI;
        private int scroolBorderColor;
        private ClassLabPos labPos;
        private ArrayList<String> daten;
        private ArrayList<GuiLabel> labList;
        private int labPageScrool;
        public Callback<onGuiListe> onClik = null;
        private net.risingworld.api.gui.Font mainFont = net.risingworld.api.gui.Font.Default;
        private int size = 24;
        private int color = -1;
        private float borderThikness = 1.0f;
        private boolean borderThiknessRelative = false;
        private float borderThiknessAktiv = 2.0f;
        private boolean borderThiknessRelativeAktiv = false;
        private int borderColorList = -2139062017;
        private int borderColorListAktiv = -1;
        public Predicate<? super String> filter = str -> true;
        Boolean sortAufsteigen = null;
        public Comparator<? super String> sort = (o1, o2) -> {
            if (this.sortAufsteigen != null) {
                if (!this.sortAufsteigen.booleanValue()) {
                    return o1.compareTo((String)o2);
                }
                return o2.compareTo((String)o1);
            }
            return 0;
        };

        public int getLabPageMax() {
            return this.labPageMax;
        }

        public int getSelectID() {
            return this.labSelectID;
        }

        public void setScroolColor(int color) {
            this.scroolColor = color;
        }

        public int getScroolColor() {
            return this.scroolColor;
        }

        public void setScroolBorderColor(int color) {
            this.scroolBorderColor = color;
        }

        public int getScroolBorderColor() {
            return this.scroolBorderColor;
        }

        public void setDebug(int debug) {
            this.debug = debug;
        }

        public int getDebug() {
            return this.debug;
        }

        public void setLabScroolPos(int labScroolPos) {
            this.labPageScrool = labScroolPos;
        }

        public int getLabScroolPos() {
            return this.labPageScrool;
        }

        public net.risingworld.api.gui.Font getFont() {
            return this.mainFont;
        }

        public void setFont(net.risingworld.api.gui.Font font) {
            this.mainFont = font;
        }

        public int getFontSize() {
            return this.size;
        }

        public void setFontSize(int size) {
            this.size = size;
        }

        public int getFontColor() {
            return this.color;
        }

        public void setFontColor(int color) {
            this.color = color;
        }

        GuiListe(Plugin plugin) {
            this.scroolBar = null;
            this.scroolBarUp = null;
            this.scroolBarPush = null;
            this.scroolBarDown = null;
            this.scroolBarUpPanel = null;
            this.scroolBarPushPanel = null;
            this.scroolBarDownPanel = null;
            this.scroolBorderColor = -1;
            this.scroolColor = -1;
            this.plugin = plugin;
            this.debug = 1;
            this.labPageScrool = 0;
            this.labSelectID = -1;
            this.labPageMax = 0;
            this.daten = new ArrayList();
            this.makeWindow(null, null);
        }

        GuiListe(Plugin plugin, float x, float y, boolean relativeposition, float width, float height, boolean relaticesize) {
            super(x, y, relativeposition, width, height, relaticesize);
            this.scroolBar = null;
            this.scroolBarUp = null;
            this.scroolBarPush = null;
            this.scroolBarDown = null;
            this.scroolBarUpPanel = null;
            this.scroolBarPushPanel = null;
            this.scroolBarDownPanel = null;
            this.scroolBorderColor = -1;
            this.scroolColor = -1;
            this.plugin = plugin;
            this.debug = 1;
            this.labPageScrool = 0;
            this.labSelectID = -1;
            this.labPageMax = 0;
            this.daten = new ArrayList();
            this.makeWindow(null, null);
        }

        GuiListe(Plugin plugin, float x, float y, boolean relativeposition, float width, float height, boolean relaticesize, PivotPosition pivotPosition) {
            super(x, y, relativeposition, width, height, relaticesize);
            this.scroolBar = null;
            this.scroolBarUp = null;
            this.scroolBarPush = null;
            this.scroolBarDown = null;
            this.scroolBarUpPanel = null;
            this.scroolBarPushPanel = null;
            this.scroolBarDownPanel = null;
            this.scroolBorderColor = -1;
            this.scroolColor = -1;
            this.plugin = plugin;
            this.debug = 1;
            this.labPageScrool = 0;
            this.labSelectID = -1;
            this.labPageMax = 0;
            this.daten = new ArrayList();
            this.makeWindow(pivotPosition, null);
        }

        GuiListe(Plugin plugin, float x, float y, boolean relativeposition, float width, float height, boolean relaticesize, PivotPosition pivotPosition, PivotPosition pivotPositionPanel) {
            super(x, y, relativeposition, width, height, relaticesize);
            this.scroolBar = null;
            this.scroolBarUp = null;
            this.scroolBarPush = null;
            this.scroolBarDown = null;
            this.scroolBarUpPanel = null;
            this.scroolBarPushPanel = null;
            this.scroolBarDownPanel = null;
            this.scroolBorderColor = -1;
            this.scroolColor = -1;
            this.plugin = plugin;
            this.debug = 1;
            this.labPageScrool = 0;
            this.labSelectID = -1;
            this.labPageMax = 0;
            this.daten = new ArrayList();
            this.makeWindow(pivotPosition, pivotPositionPanel);
        }

        GuiListe(Plugin plugin, float x, float y, boolean relativeposition, float width, float height, boolean relaticesize, PivotPosition pivotPosition, int debug) {
            super(x, y, relativeposition, width, height, relaticesize);
            this.labSelectID = -1;
            this.scroolBar = null;
            this.scroolBarUp = null;
            this.scroolBarPush = null;
            this.scroolBarDown = null;
            this.scroolBarUpPanel = null;
            this.scroolBarPushPanel = null;
            this.scroolBarDownPanel = null;
            this.scroolBorderColor = -1;
            this.scroolColor = -1;
            this.plugin = plugin;
            this.labPageMax = 0;
            this.debug = debug;
            this.labPageScrool = 0;
            this.daten = new ArrayList();
            this.makeWindow(pivotPosition, null);
        }

        private void setSelectedUserID(int selectID) {
            this.labSelectID = selectID;
        }

        public void setBorderThicknessList(float thickness, boolean relative) {
            this.borderThikness = thickness;
            this.borderThiknessRelative = relative;
        }

        public void setBorderThicknessListAktiv(float thickness, boolean relative) {
            this.borderThiknessAktiv = thickness;
            this.borderThiknessRelativeAktiv = relative;
        }

        public void setBorderColorList(int color) {
            super.setBorderColor(0);
            this.borderColorList = color;
        }

        public void setBorderColorListAktiv(int color) {
            super.setBorderColor(0);
            this.borderColorListAktiv = color;
        }

        private void makeWindow(PivotPosition pivotPosition, PivotPosition pivotPositionPanel) {
            this.plugin.registerEventListener((Listener)this);
            if (this.debug > 0) {
                System.out.println("[GuiListe] makeWindow width[" + this.getWidth() + "] height[" + this.getHeight() + "] rSize[" + this.isRelativeSize() + "] ");
            }
            if (pivotPosition != null) {
                this.setPivot(pivotPosition);
            } else {
                this.setPivot(PivotPosition.Center);
            }
            PivotPosition usePivotPositionPanel = pivotPositionPanel != null ? pivotPositionPanel : PivotPosition.Center;
            float hight = 0.0f;
            switch (usePivotPositionPanel) {
                case Center: 
                case CenterLeft: 
                case CenterRight: {
                    hight = 0.5f;
                    break;
                }
                case CenterTop: 
                case TopLeft: 
                case TopRight: {
                    hight = 1.0f;
                    break;
                }
                case BottomLeft: 
                case BottomRight: 
                case CenterBottom: {
                    hight = 0.0f;
                    break;
                }
            }
            this.textPanel = new GuiPanel(0.5f, hight, true, 1.0f, 1.0f, true);
            if (this.debug > 2) {
                this.textPanel.setColor(128);
                this.textPanel.setBorderColor(0xFF00C0);
                this.textPanel.setBorderThickness(1.0f, false);
            } else {
                this.textPanel.setColor(0);
                this.textPanel.setBorderColor(0);
                this.textPanel.setBorderThickness(0.0f, false);
            }
            this.textPanel.setPivot(usePivotPositionPanel);
            this.addChild((GuiElement)this.textPanel);
            this.sAPI = (SprachAPI)this.plugin.getPluginByName("SprachAPI");
            this.logoUpIcon = new ImageInformation(this.sAPI.logoUpIcon.getData());
            this.logoDownIcon = new ImageInformation(this.sAPI.logoDownIcon.getData());
            this.isIcon = true;
        }

        void loadFonts(HashMap<net.risingworld.api.gui.Font, Font.ClassCharSet> fontSet) {
            this.fontSet = fontSet;
        }

        void setListe(Player player, ArrayList<String> daten) {
            this.setListe(player, daten, null);
        }

        void setListe(Player player, ArrayList<String> daten, PivotPosition pivotPosition) {
            this.loadListe(player, daten, pivotPosition, -1.0f);
        }

        void setListe(Player player, ArrayList<String> daten, PivotPosition pivotPosition, float minHight) {
            this.loadListe(player, daten, pivotPosition, minHight);
        }

        private void loadListe(Player player, ArrayList<String> daten) {
            this.loadListe(player, daten, this.getPivot(), -1.0f);
        }

        private void loadListe(Player player, ArrayList<String> daten, PivotPosition pivotPosition, float minHight) {
            if (this.labList != null) {
                this.labList.forEach(lab -> {
                    player.removeGuiElement((GuiElement)lab);
                    this.textPanel.removeChild((GuiElement)lab);
                });
            }
            this.labList = new ArrayList();
            this.scroolBar = null;
            this.daten = daten;
            this.player = player;
            this.labPos = new ClassLabPos();
            this.textPanelMinHight = minHight;
            this.labPos.h = this.getFontSize();
            this.labPos.a = 5.0f;
            PivotPosition usePivotPosition = pivotPosition != null ? pivotPosition : PivotPosition.CenterTop;
            float maxHigh = this.isRelativeSize() ? this.getHeight() * (float)player.getScreenResolutionY() : this.getHeight();
            float maxWidth = this.isRelativeSize() ? this.getWidth() * (float)player.getScreenResolutionX() : this.getWidth();
            this.textPanelMaxHigh = maxHigh;
            switch (usePivotPosition) {
                case Center: 
                case CenterBottom: 
                case CenterTop: {
                    this.labPos.x = 0.0f + maxWidth / 2.0f;
                    break;
                }
                case BottomLeft: 
                case CenterLeft: 
                case TopLeft: {
                    this.labPos.x = this.labPos.a;
                    break;
                }
                case BottomRight: 
                case CenterRight: 
                case TopRight: {
                    this.labPos.x = maxWidth - this.labPos.a;
                    break;
                }
            }
            this.labPos.y = maxHigh - this.labPos.a;
            if (this.debug > 1) {
                System.out.println("[GuiListe] loadListe pageNr[" + this.labPos + "] maxHigh[" + maxHigh + "] UsePivot[" + usePivotPosition + "] ");
            }
            CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
            clh.b = true;
            this.daten.forEach(eintrag -> {
                GuiLabel lab = new GuiLabel("^_^", this.labPos.x, this.labPos.y, false);
                lab.loadFonts(this.fontSet);
                lab.setPivot(usePivotPosition);
                lab.setBorderColor(this.borderColorList);
                if (this.debug > 2 && this.borderThikness <= 0.0f) {
                    lab.setBorderThickness(1.0f, false);
                    lab.setBorderColor(-16777024);
                } else {
                    lab.setBorderThickness(this.borderThikness, this.borderThiknessRelative);
                }
                lab.setClickable(true);
                lab.setFont(this.getFont());
                lab.setFontSize(this.getFontSize());
                lab.setFontColor(this.getFontColor());
                if (this.debug > 2) {
                    System.out.println("[GuiListe] loadListe Y[" + this.labPos.y + "] FontSize[" + lab.getFontSize() + "] maxF[" + clh.f + "]");
                }
                ClassLabPos classLabPos = this.labPos;
                classLabPos.y = classLabPos.y - (this.labPos.h + this.labPos.a);
                if (this.labPos.y > 0.0f) {
                    clh.f = maxHigh - this.labPos.y;
                    if (this.debug > 3) {
                        lab.setBorderColor(65472);
                    }
                    this.labList.add(lab);
                    this.textPanel.addChild((GuiElement)lab);
                } else {
                    clh.b = false;
                }
                Thread.yield();
            });
            this.labPageMax = (int)Math.ceil((float)this.daten.size() / (float)this.labList.size()) - 1;
            if (clh.b.booleanValue()) {
                this.textPanel.setSize(maxWidth, clh.f, false);
                if (this.debug > 1) {
                    System.out.println("[GuiListe] loadListe noSCROOL ");
                }
            } else if (this.labList.size() > 0) {
                float scrollB = this.labList.get(0).getFontSize();
                this.scroolBar = new GuiPanel(1.0f, 0.0f, true, scrollB, maxHigh, false);
                if (this.debug > 2) {
                    this.scroolBar.setColor(128);
                    this.scroolBar.setBorderThickness(1.0f, false);
                    this.scroolBar.setBorderColor(-16777024);
                } else {
                    this.scroolBar.setColor(0);
                    this.scroolBar.setBorderThickness(this.getBorderThickness(), this.isRelativeBorderThickness());
                    this.scroolBar.setBorderColor(this.getBorderColor());
                }
                this.scroolBar.setPivot(PivotPosition.BottomRight);
                this.scroolBar.setClickable(true);
                this.addChild((GuiElement)this.scroolBar);
                this.scroolBarUpPanel = new GuiPanel(1.0f, 1.0f, true, this.scroolBar.getWidth(), this.scroolBar.getWidth(), false);
                if (this.debug > 2) {
                    this.scroolBarUpPanel.setColor(128);
                    this.scroolBarUpPanel.setBorderThickness(1.0f, false);
                    this.scroolBarUpPanel.setBorderColor(0xFFFFC0);
                } else {
                    this.scroolBarUpPanel.setColor(0);
                    this.scroolBarUpPanel.setBorderThickness(0.0f, false);
                    this.scroolBarUpPanel.setBorderColor(0);
                }
                this.scroolBarUpPanel.setPivot(PivotPosition.TopRight);
                this.scroolBarUp = new GuiPanel(0.5f, 0.5f, true, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, false);
                this.scroolBarUp.setColor(this.scroolColor > 0 ? this.scroolColor : this.getBorderColor());
                this.scroolBarUp.setBorderThickness(this.scroolBar.getBorderThickness(), this.scroolBar.isRelativeBorderThickness());
                this.scroolBarUp.setBorderColor(this.scroolBorderColor > 0 ? this.scroolBorderColor : 255);
                this.scroolBarUp.setPivot(PivotPosition.Center);
                this.scroolBarUp.setClickable(true);
                this.scroolBarUpIcon = new GuiImage(this.logoUpIcon, 0.5f, 0.5f, true, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, false);
                this.scroolBarUpIcon.setPivot(PivotPosition.Center);
                this.scroolBarUpIcon.setClickable(true);
                this.scroolBarUpPanel.addChild((GuiElement)this.scroolBarUpIcon);
                this.scroolBarUpPanel.addChild((GuiElement)this.scroolBarUp);
                this.scroolBar.addChild((GuiElement)this.scroolBarUpPanel);
                this.scroolBarDownPanel = new GuiPanel(1.0f, 0.0f, true, this.scroolBar.getWidth(), this.scroolBar.getWidth(), false);
                if (this.debug > 2) {
                    this.scroolBarDownPanel.setColor(128);
                    this.scroolBarDownPanel.setBorderThickness(1.0f, false);
                    this.scroolBarDownPanel.setBorderColor(0xFFFFC0);
                } else {
                    this.scroolBarDownPanel.setColor(0);
                    this.scroolBarDownPanel.setBorderThickness(0.0f, false);
                    this.scroolBarDownPanel.setBorderColor(0);
                }
                this.scroolBarDownPanel.setPivot(PivotPosition.BottomRight);
                this.scroolBar.addChild((GuiElement)this.scroolBarDownPanel);
                this.scroolBarDown = new GuiPanel(0.5f, 0.5f, true, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, false);
                this.scroolBarDown.setColor(this.scroolColor > 0 ? this.scroolColor : this.getBorderColor());
                this.scroolBarDown.setBorderThickness(this.scroolBar.getBorderThickness(), this.scroolBar.isRelativeBorderThickness());
                this.scroolBarDown.setBorderColor(this.scroolBorderColor > 0 ? this.scroolBorderColor : 255);
                this.scroolBarDown.setPivot(PivotPosition.Center);
                this.scroolBarDown.setClickable(true);
                this.scroolBarDownIcon = new GuiImage(this.logoDownIcon, 0.5f, 0.5f, true, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, this.scroolBar.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, false);
                this.scroolBarDownIcon.setPivot(PivotPosition.Center);
                this.scroolBarDownIcon.setClickable(true);
                this.scroolBarDownPanel.addChild((GuiElement)this.scroolBarDownIcon);
                this.scroolBarDownPanel.addChild((GuiElement)this.scroolBarDown);
                if (this.debug > 0) {
                    System.out.println("[GuiListe] show isIcon:" + this.isIcon + " scroolBarUpIcon:" + (this.scroolBarUpIcon != null) + " scroolBarDownIcon:" + (this.scroolBarDownIcon != null) + " scroolBarUp:" + (this.scroolBarUp != null) + " scroolBarDown:" + (this.scroolBarDown != null) + "");
                }
                if (this.isIcon) {
                    if (this.scroolBarUpIcon != null) {
                        this.scroolBarUpIcon.setVisible(true);
                    }
                    if (this.scroolBarDownIcon != null) {
                        this.scroolBarDownIcon.setVisible(true);
                    }
                    if (this.scroolBarUp != null) {
                        this.scroolBarUp.setVisible(false);
                    }
                    if (this.scroolBarDown != null) {
                        this.scroolBarDown.setVisible(false);
                    }
                } else {
                    if (this.scroolBarUpIcon != null) {
                        this.scroolBarUpIcon.setVisible(false);
                    }
                    if (this.scroolBarDownIcon != null) {
                        this.scroolBarDownIcon.setVisible(false);
                    }
                    if (this.scroolBarUp != null) {
                        this.scroolBarUp.setVisible(true);
                    }
                    if (this.scroolBarDown != null) {
                        this.scroolBarDown.setVisible(true);
                    }
                }
                if (this.debug > 1) {
                    System.out.println("[GuiListe] loadListe maxPage[" + (this.labPageMax + 1) + "] scrollPos[" + this.labPageScrool + "] ");
                }
                this.scoolBarPanellMaxHight = maxHigh - this.scroolBar.getWidth() * 2.0f;
                this.scoolBarPanellStep = this.scoolBarPanellMaxHight / (float)(this.daten.size() - this.labList.size() + (this.labList.size() - ((this.labPageMax + 1) * this.labList.size() - this.daten.size())));
                if (this.debug > 1) {
                    System.out.println("[GuiListe] loadListe maxPage[" + (this.labPageMax + 1) * this.labList.size() + "] daten[" + this.daten.size() + "] [" + (this.labList.size() - ((this.labPageMax + 1) * this.labList.size() - this.daten.size())) + "] ");
                }
                float scoolBarPanellPage = this.scoolBarPanellMaxHight / (float)(this.labPageMax + 1);
                if (this.debug > 1) {
                    System.out.println("[GuiListe] loadListe PanellHight[" + this.scoolBarPanellMaxHight + "] scrollPos[" + this.labPageScrool + "] ");
                }
                this.scroolBarPushPanel = new GuiPanel(0.0f, this.scroolBar.getWidth() + this.scoolBarPanellMaxHight - this.scoolBarPanellStep * (float)this.labPageScrool, false, this.scroolBar.getWidth(), scoolBarPanellPage, false);
                this.scroolBarPushPanel.setVisible(false);
                if (this.debug > 2) {
                    this.scroolBarPushPanel.setColor(128);
                    this.scroolBarPushPanel.setBorderThickness(1.0f, false);
                    this.scroolBarPushPanel.setBorderColor(-16711744);
                } else {
                    this.scroolBarPushPanel.setColor(0);
                    this.scroolBarPushPanel.setBorderThickness(0.0f, false);
                    this.scroolBarPushPanel.setBorderColor(0);
                }
                this.scroolBarPushPanel.setPivot(PivotPosition.TopLeft);
                this.scroolBar.addChild((GuiElement)this.scroolBarPushPanel);
                this.scroolBarPush = new GuiPanel(0.5f, 0.5f, true, this.scroolBarPushPanel.getWidth() - this.scroolBar.getBorderThickness() * 2.0f, this.scroolBarPushPanel.getHeight() - this.scroolBarPushPanel.getBorderThickness() * 2.0f, false);
                this.scroolBarPush.setColor(this.scroolColor > 0 ? this.scroolColor : this.getBorderColor());
                this.scroolBarPush.setBorderThickness(this.scroolBar.getBorderThickness(), this.scroolBar.isRelativeBorderThickness());
                this.scroolBarPush.setBorderColor(this.scroolBorderColor > 0 ? this.scroolBorderColor : 255);
                this.scroolBarPush.setPivot(PivotPosition.Center);
                this.scroolBarPushPanel.addChild((GuiElement)this.scroolBarPush);
                this.textPanel.setSize(maxWidth - this.scroolBar.getWidth(), clh.f, false);
                switch (usePivotPosition) {
                    case Center: 
                    case CenterLeft: 
                    case CenterRight: {
                        this.textPanel.setPosition(maxWidth / 2.0f - this.scroolBar.getWidth() / 2.0f, maxHigh / 2.0f, false);
                        break;
                    }
                    case CenterTop: 
                    case TopLeft: 
                    case TopRight: {
                        this.textPanel.setPosition(maxWidth / 2.0f - this.scroolBar.getWidth() / 2.0f, maxHigh / 1.0f, false);
                        break;
                    }
                    case BottomLeft: 
                    case BottomRight: 
                    case CenterBottom: {
                        this.textPanel.setPosition(maxWidth / 2.0f - this.scroolBar.getWidth() / 2.0f, maxHigh / 0.0f, false);
                        break;
                    }
                }
            } else if (this.debug > 1) {
                System.out.println("[GuiListe] loadListe nicht gefunden !!!");
            }
            this.labPos.y = clh.f - this.labPos.a;
            switch (usePivotPosition) {
                case Center: 
                case CenterBottom: 
                case CenterTop: {
                    this.labPos.x = maxWidth / 2.0f - (this.scroolBar != null ? this.scroolBar.getWidth() / 2.0f : 0.0f);
                    if (this.debug <= 1) break;
                    System.out.println("[GuiListe] loadListe CENTERpX[" + this.labPos.x + "] ");
                    break;
                }
                case BottomLeft: 
                case CenterLeft: 
                case TopLeft: {
                    this.labPos.x = this.labPos.a;
                    if (this.debug <= 1) break;
                    System.out.println("[GuiListe] loadListe LEFTpX[" + this.labPos.x + "] ");
                    break;
                }
                case BottomRight: 
                case CenterRight: 
                case TopRight: {
                    this.labPos.x = maxWidth / 1.0f - (this.scroolBar != null ? this.scroolBar.getWidth() / 1.0f : 0.0f) - this.labPos.a;
                    if (this.debug <= 1) break;
                    System.out.println("[GuiListe] loadListe RIGHTpX[" + this.labPos.x + "] ");
                    break;
                }
            }
            this.labList.forEach(lab -> {
                lab.setPosition(this.labPos.x, this.labPos.y, false);
                ClassLabPos classLabPos = this.labPos;
                classLabPos.y = classLabPos.y - (this.labPos.h + this.labPos.a);
                Thread.yield();
            });
        }

        void addGuiElement(Player player) {
            this.setVisible(false);
            player.addGuiElement((GuiElement)this);
            player.addGuiElement((GuiElement)this.textPanel);
            this.labList.forEach(lab -> {
                if (this.debug > 1) {
                    System.out.println("[addGuiElement] Lab [" + lab.getTextOrg() + "] Player[" + (player != null ? player.getName() : "NULL") + "] ");
                }
                player.addGuiElement((GuiElement)lab);
            });
            if (this.scroolBar != null) {
                player.addGuiElement((GuiElement)this.scroolBar);
                player.addGuiElement((GuiElement)this.scroolBarUpPanel);
                player.addGuiElement((GuiElement)this.scroolBarUp);
                player.addGuiElement((GuiElement)this.scroolBarUpIcon);
                player.addGuiElement((GuiElement)this.scroolBarDownPanel);
                player.addGuiElement((GuiElement)this.scroolBarDown);
                player.addGuiElement((GuiElement)this.scroolBarDownIcon);
                player.addGuiElement((GuiElement)this.scroolBarPushPanel);
                player.addGuiElement((GuiElement)this.scroolBarPush);
            }
        }

        public void show(Boolean sortAufsteigen) {
            this.sortAufsteigen = sortAufsteigen;
            this.show();
        }

        public void show() {
            CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
            if (this.labPageScrool > this.daten.size() - this.labList.size()) {
                this.labPageScrool = this.daten.size() - this.labList.size();
            }
            if (this.labPageScrool < 0) {
                this.labPageScrool = 0;
            }
            clh.n = this.labPageScrool;
            clh.f = 0.0f;
            if (this.debug > 2) {
                System.out.println("[GuiListe] show pageNr[" + this.labPageScrool + "] pageMax[" + this.labPageMax + "] listMax[" + this.labList.size() + "] datenMax[" + this.daten.size() + "] " + (this.scroolBar != null ? "[" + (this.scroolBar.getWidth() + this.scoolBarPanellMaxHight - this.scoolBarPanellStep * (float)this.labPageScrool) + "] " : ""));
            }
            ArrayList datenLokal = new ArrayList(this.daten.stream().filter(this.filter).sorted(this.sort).collect(Collectors.toList()));
            if (this.scroolBar != null) {
                this.scroolBarPushPanel.setPosition(0.0f, this.scroolBar.getWidth() + this.scoolBarPanellMaxHight - this.scoolBarPanellStep * (float)this.labPageScrool, false);
            }
            this.labList.forEach(lab -> {
                Object str = null;
                if (clh.n < datenLokal.size()) {
                    lab.setTextOrg((String)datenLokal.get(clh.n));
                    ((GuiLabel)lab).id = clh.n;
                    lab.trimTo(this.player, (this.textPanel.isRelativeSize() ? this.textPanel.getWidth() * (float)this.player.getScreenResolutionX() : this.textPanel.getWidth()) - this.labPos.a * 2.0f, " ");
                    clh.f = (this.textPanel.isRelativeSize() ? this.textPanel.getHeight() * (float)this.player.getScreenResolutionY() : this.textPanel.getHeight()) - lab.getPositionY() + lab.getHeight();
                } else {
                    lab.setText("");
                    ((GuiLabel)lab).id = -1;
                }
                if (this.labSelectID == this.daten.indexOf(lab.getTextOrg())) {
                    lab.setBorderThickness(this.borderThiknessAktiv, this.borderThiknessRelativeAktiv);
                    lab.setBorderColor(this.borderColorListAktiv);
                    if (this.debug > 3) {
                        System.out.print("[GuiListe] show HALLO ");
                    }
                } else {
                    lab.setBorderThickness(this.borderThikness, this.borderThiknessRelative);
                    lab.setBorderColor(this.borderColorList);
                }
                if (this.debug > 3) {
                    System.out.println("[GuiListe] show n[" + clh.n + "] lab[" + lab.getText() + "] [" + this.labSelectID + "|" + this.daten.indexOf(lab.getTextOrg()) + "] ");
                }
                ++clh.n;
            });
            if (this.textPanelMinHight >= 0.0f && this.debug > 3) {
                System.out.println("[GuiListe] show select[" + this.labSelectID + "|" + (this.labSelectID >= 0 ? this.daten.get(this.labSelectID) : "") + "] newHigh[" + clh.f + "] ");
            }
            this.setVisible(true);
        }

        public void hide() {
            this.setVisible(false);
        }

        @EventMethod
        public void onGuiListeClick(PlayerGuiElementClickEvent event) {
            if (this.debug > 0) {
                System.out.println("[GuiListe] GuiListeClick [" + event.getGuiElement().getID() + "] pageMax[" + this.labPageMax + "] listMax[" + this.labList.size() + "] datenMax[" + this.daten.size() + "] MousButton[" + event.getMouseButton() + "] scrol[" + this.labList.size() + "] isDoubleKlick[" + event.isDoubleClick() + "] ");
            }
            if ((event.getGuiElement() == this.scroolBarUp || event.getGuiElement() == this.scroolBarUpIcon) && event.getMouseButton() == 0 && event.isDoubleClick()) {
                this.labPageScrool = 0;
                this.show();
            } else if ((event.getGuiElement() == this.scroolBarDown || event.getGuiElement() == this.scroolBarDownIcon) && event.getMouseButton() == 0 && event.isDoubleClick()) {
                this.labPageScrool = this.daten.size() - this.labList.size();
                this.show();
            } else if ((event.getGuiElement() == this.scroolBarUp || event.getGuiElement() == this.scroolBarUpIcon) && event.getMouseButton() == 1) {
                --this.labPageScrool;
                this.show();
            } else if ((event.getGuiElement() == this.scroolBarDown || event.getGuiElement() == this.scroolBarDownIcon) && event.getMouseButton() == 1) {
                ++this.labPageScrool;
                this.show();
            } else if ((event.getGuiElement() == this.scroolBarUp || event.getGuiElement() == this.scroolBarUpIcon) && event.getMouseButton() == 0) {
                this.labPageScrool -= this.labList.size();
                this.show();
            } else if ((event.getGuiElement() == this.scroolBarDown || event.getGuiElement() == this.scroolBarDownIcon) && event.getMouseButton() == 0) {
                this.labPageScrool += this.labList.size();
                this.show();
            }
            CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
            clh.b = false;
            clh.n = this.labSelectID;
            if (this.debug > 4) {
                System.out.println("[GuiListe] GuiListeClick  Border NEU ");
            }
            this.labList.forEach(lab -> {
                if (event.getGuiElement().equals((Object)lab)) {
                    clh.b = true;
                    this.labSelectID = ((GuiLabel)lab).id;
                    clh.obj = lab;
                }
            });
            if (clh.b.booleanValue()) {
                onGuiListe call = new onGuiListe(event, this.labSelectID, clh.n);
                if (this.debug > 1) {
                    System.out.println("[GuiListe] onGuiListeClick Cancle" + call.cancle + "] ");
                }
                this.onClik.onCall((Object)call);
                if (!call.cancle) {
                    this.labList.forEach(lab -> {
                        if (event.getGuiElement().equals((Object)lab)) {
                            lab.setBorderThickness(this.borderThiknessAktiv, this.borderThiknessRelativeAktiv);
                            lab.setBorderColor(this.borderColorListAktiv);
                        } else {
                            lab.setBorderThickness(this.borderThikness, this.borderThiknessRelative);
                            lab.setBorderColor(this.borderColorList);
                        }
                    });
                }
            }
        }

        public void refrech() {
            if (this.debug > 1) {
                System.out.println("[GuiListe] refrech");
            }
        }

        public static class onGuiListe {
            PlayerGuiElementClickEvent event;
            public final int id;
            private final int lId;
            private boolean cancle;

            public onGuiListe(PlayerGuiElementClickEvent event, int id, int lId) {
                this.event = event;
                this.id = id;
                this.lId = lId;
                this.cancle = false;
            }

            public String toString() {
                return "ID[" + this.id + "] EVENT[" + this.event.toString() + "] ";
            }

            public void cancleSelect(boolean cancle) {
                this.cancle = cancle;
                System.out.println("[onGuiListe] cancleSelect Cancle[" + cancle + "] ");
            }
        }

        private static class ClassLabPos {
            private float x = 0.0f;
            private float y = 0.0f;
            private float h = 0.0f;
            private float a = 0.0f;
        }
    }

    public static class ShortcutClass {
        String strColor;
        int keyCode;
        private char seperate = (char)38;

        void setSeperate(char ch) {
            this.seperate = ch;
        }

        char getSeperate() {
            return this.seperate;
        }

        ShortcutClass convert(String formString, String colorON, String colorOFF) {
            this.strColor = colorOFF + formString.substring(0, formString.indexOf(this.seperate)) + colorON + formString.substring(formString.indexOf(this.seperate) + 1, formString.indexOf(this.seperate) + 2) + colorOFF + formString.substring(formString.indexOf(this.seperate) + 2);
            this.keyCode = CRT.getKeyInputValue("KEY_" + formString.substring(formString.indexOf(this.seperate) + 1, formString.indexOf(this.seperate) + 2).toUpperCase());
            return this;
        }
    }

    public static class GuiLabelSrvInfo
    extends GuiPanel {
        private float OffsetWidth = -1.0f;
        private Player player;
        private PivotPosition pivotL;
        private int InfoColor2 = -1061109505;
        private HashMap<String, ClassText> logoLabText;
        private String showSequence;
        private HashMap<String, net.risingworld.api.gui.GuiLabel> logoLabGuiLabel;
        private float _20h = 0.018f;
        private int debug = 1;
        private float OffsetHeight = -1.0f;
        private float OffsetCreativeWidth = -1.0f;
        private float OffsetCreativeHeight = -1.0f;
        private String name = "";
        private int port;

        public void setOffsetWidth(float OffsetWidth) {
            this.OffsetWidth = OffsetWidth;
        }

        public void setOffsetHeight(float OffsetHeight) {
            this.OffsetHeight = OffsetHeight;
        }

        public void setOffsetCreativeWidth(float OffsetCreativeWidth) {
            this.OffsetCreativeWidth = OffsetCreativeWidth;
        }

        public void setOffsetCreativeHeight(float OffsetCreativeHeight) {
            this.OffsetCreativeHeight = OffsetCreativeHeight;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPlayer(Player player) {
            this.player = player;
        }

        public GuiLabelSrvInfo(String text, float x, float y, boolean relativeposition) {
            super(x, y, relativeposition, x + 0.01f, y + 0.01f, relativeposition);
        }

        private void setPivotInvert(PivotPosition pivot, Player player, boolean invert) {
            this.pivotL = pivot;
            float X = 0.0f;
            float Y = 0.0f;
            CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
            String[] showStep = this.showSequence.replace(" ", "").split(",");
            if (this.debug > 0) {
                System.out.println("[] GuiLabelSrvInfo setLabels \t   showStep:" + showStep.length);
            }
            float yMem = -1.0f;
            for (int n = showStep.length - 1; n >= 0; --n) {
                String sEintrag = showStep[n];
                if (this.debug > 1) {
                    System.out.println("[] GuiLabelSrvInfo setPivot \tEintrag:" + sEintrag + " ");
                }
                if (this.logoLabGuiLabel.get(sEintrag) == null) continue;
                if (this.debug > 2) {
                    System.out.println("[] GuiLabelSrvInfo setPivot \tEintrag:" + sEintrag + " LabelPos[" + this.logoLabGuiLabel.get(sEintrag).getPositionX() + "|" + this.logoLabGuiLabel.get(sEintrag).getPositionY() + "] H\u00f6he" + this.getHeight() + "~" + clh.f + " # " + (float)this.logoLabText.get((Object)sEintrag).size * this._20h / 20.0f + " => " + (float)this.logoLabText.get((Object)sEintrag).size * this._20h / 20.0f / this.getHeight());
                }
                float x = 0.0f;
                float y = 0.0f;
                if (pivot == PivotPosition.Center || pivot == PivotPosition.CenterBottom || pivot == PivotPosition.CenterRight || pivot == PivotPosition.CenterTop) {
                    if (yMem < 0.0f && pivot != PivotPosition.CenterBottom) {
                        yMem = (float)this.logoLabText.get((Object)sEintrag).size * this._20h / 20.0f / this.getHeight();
                    }
                    x = 0.5f;
                    float f = y = yMem > 0.0f ? yMem : 0.0f;
                }
                if (pivot == PivotPosition.CenterRight || pivot == PivotPosition.BottomRight || pivot == PivotPosition.TopRight) {
                    if (yMem < 0.0f && pivot == PivotPosition.TopRight) {
                        yMem = (float)this.logoLabText.get((Object)sEintrag).size * this._20h / 20.0f / this.getHeight();
                    }
                    y = yMem > 0.0f ? yMem : 0.0f;
                    x = 1.0f;
                }
                if (pivot == PivotPosition.TopLeft) {
                    if (yMem < 0.0f && pivot == PivotPosition.TopLeft) {
                        yMem = (float)this.logoLabText.get((Object)sEintrag).size * this._20h / 20.0f / this.getHeight();
                    }
                    y = yMem > 0.0f ? yMem : 0.0f;
                }
                this.logoLabGuiLabel.get(sEintrag).setPosition(x, y + clh.f, true);
                this.logoLabGuiLabel.get(sEintrag).setPivot(pivot);
                clh.f += (float)this.logoLabText.get((Object)sEintrag).size * this._20h / 20.0f / this.getHeight();
            }
            if (null != pivot) {
                switch (pivot) {
                    case BottomLeft: {
                        X = 0.0f + (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.0f + (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.052586105f);
                        break;
                    }
                    case BottomRight: {
                        X = 1.0f - (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.0f + (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f) + (invert ^ player.isCreativeModeEnabled() ? 0.0f : (this.OffsetCreativeHeight > 0.0f ? this.OffsetCreativeHeight : 0.09708204f));
                        break;
                    }
                    case Center: {
                        X = 0.5f;
                        Y = 0.5f;
                        break;
                    }
                    case CenterBottom: {
                        X = 0.5f;
                        Y = 0.0f + (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f);
                        break;
                    }
                    case CenterLeft: {
                        X = 0.0f + (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.5f;
                        break;
                    }
                    case CenterRight: {
                        X = 1.0f - (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.5f;
                        break;
                    }
                    case CenterTop: {
                        X = 0.5f;
                        Y = 1.0f - (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f);
                        break;
                    }
                    case TopLeft: {
                        X = 0.0f + (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 1.0f - (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f);
                        break;
                    }
                    case TopRight: {
                        X = 1.0f - (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 1.0f - (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.11326238f) - (invert ^ player.isCreativeModeEnabled() ? 0.12944272f : 0.0f);
                        break;
                    }
                }
            }
            super.setPosition(X, Y, true);
            super.setPivot(pivot);
        }

        public void setPivot(PivotPosition pivot) {
            this.setPivotInvert(pivot, this.player, false);
        }

        void setPivotInChangeGamemode(PivotPosition pivot, Player player) {
            this.setPivotInvert(pivot, player, true);
        }

        public void refresh() {
            super.refresh();
        }

        public GuiElement getGuiElement() {
            return this;
        }

        public void setLabels(Player player, HashMap<String, ClassText> logoLabText, String showSequence) {
            this.player = player;
            this.logoLabText = logoLabText;
            this.showSequence = showSequence;
            this.logoLabGuiLabel = new HashMap();
            CRT.ClassLambadHelper clh = new CRT.ClassLambadHelper();
            clh.n = 0;
            clh.f = 0.0f;
            clh.obj = Float.valueOf(this._20h);
            String[] showStep = showSequence.replace(" ", "").split(",");
            if (this.debug > 1) {
                System.out.println("[] GuiLabelSrvInfo setLabels \t   showStep:" + showStep.length);
            }
            for (String sEintrag : showStep) {
                if (this.debug > 2) {
                    System.out.println("[] GuiLabelSrvInfo setLabels \tEintrag[" + clh.n + "]:" + sEintrag + " " + (logoLabText.get(sEintrag) != null));
                }
                if (logoLabText.get(sEintrag) == null) continue;
                if (this.debug > 3) {
                    System.out.println("[] GuiLabelSrvInfo setLabels \t   Text:" + logoLabText.get((Object)sEintrag).text);
                }
                if (logoLabText.get((Object)sEintrag).text.equals("")) continue;
                if (this.debug > 4) {
                    System.out.println("[] GuiLabelSrvInfo Eintrag Akzeptiert:" + sEintrag + " " + (logoLabText.get(sEintrag) != null));
                }
                if (this.debug > 4) {
                    System.out.println("[] GuiLabelSrvInfo               Text:" + logoLabText.get((Object)sEintrag).text);
                }
                if (this.debug > 4) {
                    System.out.println("[] GuiLabelSrvInfo setLabels \t   showStep/X:" + (1.0f - (float)clh.n * (1.0f / (float)(showStep.length - 1))));
                }
                String eintrag2 = "";
                if (!(sEintrag.equals("NAME") || sEintrag.equals("I1") || sEintrag.equals("I2") || sEintrag.equals("I3"))) {
                    eintrag2 = GUI.convertColor(logoLabText.get(sEintrag).color1) + sEintrag + ": ";
                }
                net.risingworld.api.gui.GuiLabel lab = new net.risingworld.api.gui.GuiLabel(eintrag2 + GUI.convertColor(logoLabText.get(sEintrag).color) + logoLabText.get((Object)sEintrag).text, 0.0f, clh.f, true);
                clh.f += (float)logoLabText.get((Object)sEintrag).size * ((Float)clh.obj).floatValue() / 20.0f;
                lab.setFontSize(logoLabText.get((Object)sEintrag).size);
                lab.setFont(logoLabText.get((Object)sEintrag).font);
                this.logoLabGuiLabel.put(sEintrag, lab);
                ++clh.n;
            }
            this.setAlpha(0.0f);
            this.setSize(0.2f, clh.f, true);
            this.setBorderThickness(0.0f, false);
            player.addGuiElement(this.getGuiElement());
            this.logoLabGuiLabel.forEach((eintrag, label) -> {
                if (this.debug > 2) {
                    System.out.println("[] GuiLabelSrvInfo setLabels \tEintrag:" + eintrag + " \tWidth" + label.getWidth());
                }
                this.addChild((GuiElement)label);
                player.addGuiElement((GuiElement)label);
            });
        }

        static class ClassText {
            String text;
            net.risingworld.api.gui.Font font;
            int size;
            private int color;
            private int color1;

            public ClassText() {
                this.text = "";
                this.font = net.risingworld.api.gui.Font.Default;
                this.size = 18;
                this.color = -1048321;
                this.color1 = -4194049;
            }

            public ClassText(int size, String text, net.risingworld.api.gui.Font font, int color, int color1) {
                this.size = size;
                this.font = font;
                this.text = text;
                this.color = color;
                this.color1 = color1;
            }
        }
    }

    public static class GuiImage
    extends net.risingworld.api.gui.GuiImage {
        private float OffsetWidth = -1.0f;
        private float OffsetHeight = -1.0f;
        private float OffsetCreativeWidth = -1.0f;
        private float OffsetCreativeHeight = -1.0f;

        public void setOffsetWidth(float OffsetWidth) {
            this.OffsetWidth = OffsetWidth;
        }

        public void setOffsetHeight(float OffsetHeight) {
            this.OffsetHeight = OffsetHeight;
        }

        public void setOffsetCreativeWidth(float OffsetCreativeWidth) {
            this.OffsetCreativeWidth = OffsetCreativeWidth;
        }

        public void setOffsetCreativeHeight(float OffsetCreativeHeight) {
            this.OffsetCreativeHeight = OffsetCreativeHeight;
        }

        public GuiImage(ImageInformation logo, float X, float Y, boolean relativeposition, float B, float H, boolean relativesize) {
            super(logo, X, Y, relativeposition, B, H, relativesize);
        }

        GuiElement getGuiElement() {
            return this;
        }

        public void setPivot(PivotPosition pivot, Player player) {
            this.setPivotInvert(pivot, player, false);
        }

        void setPivotInChangeGamemode(PivotPosition pivot, Player player) {
            this.setPivotInvert(pivot, player, true);
        }

        private void setPivotInvert(PivotPosition pivot, Player player, boolean invert) {
            float X = 0.0f;
            float Y = 0.0f;
            if (null != pivot) {
                switch (pivot) {
                    case BottomLeft: {
                        X = 0.0f + (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.0f + (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.052586105f);
                        break;
                    }
                    case BottomRight: {
                        X = 1.0f - (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.0f + (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f) + (invert ^ player.isCreativeModeEnabled() ? 0.0f : (this.OffsetCreativeHeight > 0.0f ? this.OffsetCreativeHeight : 0.09708204f));
                        break;
                    }
                    case Center: {
                        X = 0.5f;
                        Y = 0.5f;
                        break;
                    }
                    case CenterBottom: {
                        X = 0.5f;
                        Y = 0.0f + (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f);
                        break;
                    }
                    case CenterLeft: {
                        X = 0.0f + (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.5f;
                        break;
                    }
                    case CenterRight: {
                        X = 1.0f - (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 0.5f;
                        break;
                    }
                    case CenterTop: {
                        X = 0.5f;
                        Y = 1.0f - (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f);
                        break;
                    }
                    case TopLeft: {
                        X = 0.0f + (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 1.0f - (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.0f);
                        break;
                    }
                    case TopRight: {
                        X = 1.0f - (this.OffsetWidth > 0.0f ? this.OffsetWidth : 0.0f);
                        Y = 1.0f - (this.OffsetHeight > 0.0f ? this.OffsetHeight : 0.10517221f) - (invert ^ player.isCreativeModeEnabled() ? 0.0f : 0.09708204f);
                        break;
                    }
                }
            }
            super.setPosition(X, Y, true);
            super.setPivot(pivot);
        }
    }
}

