/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins.plot.Events;

import de.pbplugins.plot.Plot;
import java.util.ArrayList;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChestAccessEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDropItemEvent;
import net.risingworld.api.events.player.PlayerEnterAreaEvent;
import net.risingworld.api.events.player.PlayerEnterVehicleEvent;
import net.risingworld.api.events.player.PlayerHitNpcEvent;
import net.risingworld.api.events.player.PlayerLeaveAreaEvent;
import net.risingworld.api.events.player.PlayerMountNpcEvent;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.events.player.PlayerNpcInventoryAccessEvent;
import net.risingworld.api.events.player.PlayerObjectInteractionEvent;
import net.risingworld.api.events.player.PlayerPickupItemEvent;
import net.risingworld.api.events.player.PlayerStartFishingEvent;
import net.risingworld.api.events.player.PlayerStartFlyingEvent;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Sign;
import net.risingworld.api.utils.Area;
import net.risingworld.api.utils.Definitions;

public class PlotListenerPlayer
implements Listener {
    private final Plot plugin;
    private final boolean fly;
    private final String Rot = "[#ff0000]";
    private final String Gr\u00fcn = "[#00ff00]";
    private final String Orange = "[#ffa500]";

    public PlotListenerPlayer(Plot plugin) {
        this.plugin = plugin;
        this.fly = plugin.config.PlayerFlyOnPlot;
    }

    @EventMethod
    public void onPlayerChestAccessEvent(PlayerChestAccessEvent event) {
        Player player = event.getPlayer();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, event.getObjectPosition()));
    }

    @EventMethod
    public void onPlayerDropItemEvent(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, event.getPosition()));
    }

    @EventMethod
    public void onPlayerEnterAreaEvent(PlayerEnterAreaEvent event) {
        Player player = event.getPlayer();
        Area area = event.getArea();
        if (this.plugin.Plot.PlotList.isPlot(area) && this.plugin.Attribute.getArea.hasMsgWelcome(area)) {
            player.sendTextMessage(this.plugin.Attribute.getArea.MsgWelcome(area));
        }
    }

    @EventMethod
    public void onPlayerEnterVehicleEvent(PlayerEnterVehicleEvent event) {
        Player player = event.getPlayer();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player));
    }

    @EventMethod
    public void onPlayerHitNpcEvent(PlayerHitNpcEvent event) {
        Player player = event.getPlayer();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, event.getDamagePosition()));
    }

    @EventMethod
    public void onPlayerLeaveAreaEvent(PlayerLeaveAreaEvent event) {
        Player player = event.getPlayer();
        Area area = event.getArea();
        if (this.plugin.config.FlyProtection && player.isFlying() && !player.isAdmin()) {
            event.setCancelled(true);
            player.sendTextMessage("[#ff0000]You must land before you can leave the property.");
        }
        if (!event.isCancelled() && this.plugin.Plot.PlotList.isPlot(area) && this.plugin.Attribute.getArea.hasMsgLeave(area)) {
            player.sendTextMessage(this.plugin.Attribute.getArea.MsgLeave(area));
        }
    }

    @EventMethod
    public void onPlayerMountNpcEvent(PlayerMountNpcEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        if (!this.plugin.AntiMountTheft) {
            event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, npc.getPosition()));
        }
    }

    @EventMethod
    public void onPlayerNpcInteractionEvent(PlayerNpcInteractionEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, npc.getPosition()));
    }

    @EventMethod
    public void onPlayerNpcInventoryAccessEvent(PlayerNpcInventoryAccessEvent event) {
        Player player = event.getPlayer();
        Npc npc = event.getNpc();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, npc.getPosition()));
    }

    @EventMethod
    public void onPlayerObjectInteractionEvent(PlayerObjectInteractionEvent event) {
        Player player = event.getPlayer();
        Definitions.ObjectDefinition def = event.getObjectDefinition();
        if (def.isSign()) {
            Sign sign = this.plugin.world.getSign(event.getObjectInfoID());
            if (this.plugin.AktiveSign) {
                event.setCancelled(false);
            } else {
                event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, event.getObjectPosition()));
            }
        } else {
            event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, event.getObjectPosition()));
        }
    }

    @EventMethod
    public void onPlayerPickupItemEvent(PlayerPickupItemEvent event) {
    }

    @EventMethod
    public void onPlayerStartFishingEvent(PlayerStartFishingEvent event) {
        Player player = event.getPlayer();
        event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, event.getFishingPosition()));
    }

    @EventMethod
    public void onPlayerStartFlyingEvent(PlayerStartFlyingEvent event) {
        Player player = event.getPlayer();
        Area area = this.plugin.Plot.getPlotByPos(player.getPosition());
        if (this.plugin.config.FlyProtection && this.fly) {
            if (area != null) {
                event.setCancelled(this.plugin.Permission.hasPlayerPermission(player, player.getPosition()));
            } else {
                event.setCancelled(true);
            }
        } else {
            event.setCancelled(false);
        }
    }

    @EventMethod
    public void onPlayerConnectEvent(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        ArrayList LWA = new ArrayList();
        player.setAttribute(this.plugin.Attribute.player.WA, LWA);
        player.setAttribute(this.plugin.Attribute.player.waBereich, (Object)"null");
        if (this.plugin.Permission.isNewPlayer(player)) {
            player.sendTextMessage("[#ffa500]This server has a plot plugin");
            player.sendTextMessage("[#ffa500]Type in the Chat: [#ff0000]/plot show fornew");
            player.sendTextMessage("[#ffa500]Go to a yellow marked plot and write: [#ff0000]/plot get");
            player.sendTextMessage("[#ff0000](You musst stend in a Plot to write Plot-Commands)");
        }
    }
}

