/*
 * Decompiled with CFR 0.152.
 */
package de.pbplugins;

import de.pbplugins.iConomyStartErrorListener;
import de.pbplugins.icClassText;
import de.pbplugins.icConfig;
import de.pbplugins.icDebugerLogger;
import de.pbplugins.icListener;
import de.pbplugins.icListenerGuiInfo;
import de.pbplugins.icListenerGuiSendMoney;
import de.pbplugins.icTax;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.database.Database;
import net.risingworld.api.database.WorldDatabase;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.Crosshair;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.worldelements.World3DModel;

public class iConomy
extends Plugin {
    public Plugin plugin;
    int debug = 0;
    icConfig sysConfig;
    World world;
    Server server;
    public Connection connection;
    public PreparedStatement pstmt = null;
    WorldDatabase worldDB;
    String rot = "[#ff0000]";
    String gr\u00fcn = "[#00ff00]";
    String orange = "[#ffa500]";
    public Database db;
    icClassText textDaten;
    private icListenerGuiInfo icGUI;
    private icListenerGuiSendMoney icSMgui;
    icDebugerLogger log;
    private icTax tex;
    public World3DModel DerKoffer = null;

    public icClassText getTextDaten() {
        return this.textDaten;
    }

    public icTax TexSystem() {
        return this.tex;
    }

    public icListenerGuiInfo BankGUI() {
        return this.icGUI;
    }

    public icListenerGuiSendMoney SendMoneyGui() {
        return this.icSMgui;
    }

    public void onEnable() {
        this.plugin = this;
        this.server = this.getServer();
        this.world = this.getWorld();
        this.log = new icDebugerLogger(this);
        System.out.println(this.plugin.getDescription("name") + " " + this.plugin.getDescription("version"));
        if (this.plugin.getPluginByName("SprachAPI") != null) {
            System.out.println("[" + this.plugin.getDescription("name") + "] Enabled");
            this.worldDB = this.getWorldDatabase();
            this.registerEventListener(new icListener(this));
            String[][] sysConfigArray = new String[][]{{"Debug", "0"}, {"DebugLevel", "ALL"}, {"Start_Cash", "1000"}, {"Start_Bank", "1000"}, {"BankMin", "true"}, {"Currency", "$"}, {"Start_BankMin", "-500"}, {"Money_is_lost_at_death", "false"}, {"Cases_Despawn_Time_Sek", "900"}, {"Killer_gets_money", "false"}, {"Command_getmax_OnlyAdmin", "true"}, {"Tax_%", "19"}, {"GUI_Money_Time(sek)", "4"}, {"AuthorDebug", "false"}};
            this.sysConfig = new icConfig("System", sysConfigArray, this, this.debug);
            try {
                this.debug = Integer.parseInt(this.sysConfig.getValue("Debug"));
            }
            catch (NumberFormatException e1) {
                this.debug = 0;
            }
            if (this.debug >= 1) {
                try {
                    this.log.createLog("Log");
                }
                catch (IOException ex) {
                    System.err.println(ex.getMessage());
                }
            }
            this.icGUI = new icListenerGuiInfo(this);
            this.icSMgui = new icListenerGuiSendMoney(this);
            this.registerEventListener(this.icGUI);
            this.registerEventListener(this.icSMgui);
            this.db = this.getSQLiteConnection(this.getPath() + "/database/" + this.getDescription("name") + "-" + this.world.getName() + ".db");
            System.out.println("Initalisiere Datenbank...");
            this.connection = this.db.getConnection();
            this.iniDB();
            System.out.println("[iConomy] Fertig!");
            this.textDaten = new icClassText();
            this.textDaten.setDebug(this.debug);
            this.textDaten.INI(this);
            if (this.debug >= 1) {
                this.log.info("Plugin geladen!");
                this.log.info("--------ServerInfos---------");
                this.log.info("Welt = '" + this.world.getName() + "'");
                this.log.info("Server-Name = '" + this.server.getName() + "'");
                this.log.info("Server-IP = '" + this.server.getIP() + "'");
                this.log.info("Server-Version = '" + this.server.getVersion() + "'");
                this.log.info("Server-Port = '" + this.server.getPort() + "'");
                this.log.info("------------------------------");
                this.log.info("AuthorDebug = '" + this.sysConfig.getValue("AuthorDebug") + "'");
            }
            this.initializeModel();
        } else {
            this.registerEventListener(new iConomyStartErrorListener(this));
        }
    }

    public void onDisable() {
        System.out.println("[iConomy] Desabled");
        if (this.db != null) {
            this.db.close();
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                System.err.println("[iConomy SQLite-ERR] Connection can not close!");
                System.err.println(ex.getMessage());
            }
        }
    }

    public String formatFloatToString(float f) {
        DecimalFormatSymbols forcedDecimals = new DecimalFormatSymbols();
        forcedDecimals.setDecimalSeparator(',');
        forcedDecimals.setGroupingSeparator('.');
        String str_formatter = "#,##0.00";
        DecimalFormat forcedFormatter = new DecimalFormat(str_formatter, forcedDecimals);
        forcedFormatter.setGroupingSize(3);
        String str_formatiert = forcedFormatter.format(f);
        return str_formatiert;
    }

    public String getCashString(long UID) {
        String cashS = null;
        long suche = 0L;
        if (this.debug >= 1) {
            this.log.info("[getCashString] db = " + this.db);
        }
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID='" + UID + "'; ");){
            if (result != null) {
                while (result.next()) {
                    suche = result.getLong("UID");
                    cashS = this.formatFloatToString(Math.round(result.getFloat("Cash")));
                    if (this.debug < 1) continue;
                    this.log.info("[getCashString] suche = " + suche);
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[getCashString] [SQLite-ERR]: " + ex.getMessage());
            } else {
                System.err.println("[" + this.plugin.getDescription("name") + "] [SQLite-ERR]: " + ex.getMessage());
            }
        }
        catch (NullPointerException ex) {
            if (this.debug >= 1) {
                this.log.warning("[getCashString] result = null");
            }
            System.err.println("[" + this.plugin.getDescription("name") + "-ERR]: " + ex.getMessage());
        }
        if (this.debug >= 1) {
            this.log.info("UID = " + UID);
        }
        if (suche != UID) {
            cashS = "0,00";
            if (this.debug >= 1) {
                this.log.warning("[getCashString] UID not found in the database!");
            }
        }
        return cashS;
    }

    public float getCashFloat(long UID) {
        float cash = 0.0f;
        long uid = 0L;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    cash = (float)Math.round(result.getFloat("Cash") * 100.0f) / 100.0f;
                    if (this.debug < 1) continue;
                    this.log.info("[getCashFloat] cash = " + cash);
                    this.log.info("[getCashFloat] uid = " + uid);
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[getCashFloat] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (uid != UID) {
            cash = 0.0f;
            if (this.debug >= 1) {
                this.log.warning("[getCashFloat] UID not found in the database!");
            }
        }
        return cash;
    }

    public boolean setCash(long UID, float money) {
        boolean pr\u00fcfer = false;
        float money_neu = (float)Math.round(money * 100.0f) / 100.0f;
        try {
            this.pstmt = this.connection.prepareStatement("UPDATE Money SET Cash=? WHERE UID=" + UID + ";");
            if (this.debug >= 1) {
                this.log.info("[setCash] pstmt = " + this.pstmt.toString());
            }
            this.pstmt.setFloat(1, money_neu);
            this.pstmt.executeUpdate();
            if (this.debug >= 1) {
                this.log.info("[setCash] pstmt.executeUpdate()");
            }
            this.pstmt.close();
            if (this.debug >= 1) {
                this.log.info("[setCash] pstmt.close()");
            }
            pr\u00fcfer = true;
            try {
                this.server.getPlayer(UID).sendTextMessage(this.orange + this.textDaten.getText(this.server.getPlayer(UID), "method_setCash_t1") + this.formatFloatToString(money) + " " + this.getCurrency() + this.textDaten.getText(this.server.getPlayer(UID), "method_setCash_t2"));
                this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Cash: " + this.orange + this.getCashString(this.server.getPlayer(UID).getUID())});
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[setCash] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (this.debug >= 1) {
            this.log.info("[setCash] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public boolean takeCash(long UID, float amounth) {
        float AltCash = (float)Math.round(this.getCashFloat(UID) * 100.0f) / 100.0f;
        long uid = 0L;
        boolean pr\u00fcfer = false;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[takeCash] [SQLite-ERR] " + ex.getMessage());
            } else {
                System.err.println(ex.getMessage());
            }
            pr\u00fcfer = false;
        }
        if (uid == UID) {
            if (this.debug >= 1) {
                this.log.info("[takeCash] uid == UID");
            }
            float NeuCash = (float)Math.round((AltCash - amounth) * 100.0f) / 100.0f;
            if (this.debug >= 1) {
                this.log.info("[takeCash] AltCash = " + String.valueOf(AltCash));
                this.log.info("[takeCash] amounth = " + String.valueOf(amounth) + " (-)");
                this.log.info("[takeCash] NeuCash = " + String.valueOf(NeuCash));
            }
            if (NeuCash >= 0.0f) {
                try {
                    this.pstmt = this.connection.prepareStatement("UPDATE Money SET Cash=? WHERE UID=" + UID + ";");
                    this.pstmt.setFloat(1, NeuCash);
                    this.pstmt.executeUpdate();
                    this.pstmt.close();
                    pr\u00fcfer = true;
                    try {
                        this.server.getPlayer(UID).sendTextMessage(this.rot + "Cash: -" + this.formatFloatToString(amounth) + " " + this.getCurrency());
                        this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Cash: " + this.rot + this.getCashString(this.server.getPlayer(UID).getUID())});
                    }
                    catch (NullPointerException ex) {
                    }
                }
                catch (SQLException ex) {
                    if (this.debug >= 1) {
                        this.log.severe("[takeCash] [SQLite-ERR] " + ex.getMessage());
                    } else {
                        System.err.println(ex.getMessage());
                    }
                    pr\u00fcfer = false;
                }
            } else {
                pr\u00fcfer = false;
            }
        }
        if (this.debug >= 1) {
            this.log.info("[takeCash] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public boolean giveCash(long UID, float amounth) {
        float AltCash = this.getCashFloat(UID);
        long uid = 0L;
        boolean pr\u00fcfer = false;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    if (this.debug < 1) continue;
                    this.log.info("[giveCash] uid = " + String.valueOf(uid));
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[giveCash] [SQLite-ERR] " + ex.getMessage());
            } else {
                System.err.println(ex.getMessage());
            }
            pr\u00fcfer = false;
        }
        if (uid == UID) {
            float NeuCash = (float)Math.round((AltCash + amounth) * 100.0f) / 100.0f;
            if (this.debug >= 1) {
                this.log.info("[giveCash] AltCash = " + String.valueOf(AltCash));
                this.log.info("[giveCash] amounth = " + String.valueOf(amounth) + " (+)");
                this.log.info("[giveCash] NeuCash = " + String.valueOf(NeuCash));
            }
            try {
                this.pstmt = this.connection.prepareStatement("UPDATE Money SET Cash=? WHERE UID=" + UID + ";");
                this.pstmt.setFloat(1, NeuCash);
                this.pstmt.executeUpdate();
                this.pstmt.close();
                pr\u00fcfer = true;
                try {
                    this.server.getPlayer(UID).sendTextMessage(this.gr\u00fcn + "Cash: +" + this.formatFloatToString(amounth) + " " + this.getCurrency());
                    this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Cash: " + this.gr\u00fcn + this.getCashString(this.server.getPlayer(UID).getUID())});
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                if (this.debug >= 1) {
                    this.log.info("[giveCash] Player '" + this.server.getPlayer(UID) + "' is connected!");
                }
            }
            catch (SQLException ex) {
                if (this.debug >= 1) {
                    this.log.severe("[giveCash] [SQLite-ERR] " + ex.getMessage());
                } else {
                    System.err.println(ex.getMessage());
                }
                pr\u00fcfer = false;
            }
        }
        if (this.debug >= 1) {
            this.log.info("[giveCash] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public String getBankString(long UID) {
        String bank = null;
        long uid = 0L;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    bank = this.formatFloatToString((float)Math.round(result.getFloat("Bank") * 100.0f) / 100.0f);
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[getBankString] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (uid != UID) {
            bank = "0";
        }
        return bank;
    }

    public float getBankFloat(long UID) {
        float bank = 0.0f;
        long uid = 0L;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    bank = result.getFloat("Bank");
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[getBankFloat] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (uid != UID) {
            bank = 0.0f;
        }
        float bank_neu = (float)Math.round(bank * 100.0f) / 100.0f;
        return bank_neu;
    }

    public boolean setBank(long UID, float money) {
        boolean pr\u00fcfer = false;
        float money_neu = (float)Math.round(money * 100.0f) / 100.0f;
        try {
            this.pstmt = this.connection.prepareStatement("UPDATE Money SET Bank=? WHERE UID=" + UID + ";");
            this.pstmt.setFloat(1, money_neu);
            this.pstmt.executeUpdate();
            this.pstmt.close();
            pr\u00fcfer = true;
            try {
                this.server.getPlayer(UID).sendTextMessage(this.orange + this.textDaten.getText(this.server.getPlayer(UID), "method_setBank_t1") + this.formatFloatToString(money) + " " + this.getCurrency() + this.textDaten.getText(this.server.getPlayer(UID), "method_setBank_t2"));
                this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Bank: " + this.orange + this.formatFloatToString(money)});
            }
            catch (NullPointerException nullPointerException) {}
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[setBank] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (this.debug >= 1) {
            this.log.info("[setBank] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public boolean takeBank(long UID, float amounth) {
        boolean pr\u00fcfer;
        block35: {
            float AltBank = this.getBankFloat(UID);
            float BankMin = 0.0f;
            long uid = 0L;
            pr\u00fcfer = false;
            try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
                if (result != null) {
                    while (result.next()) {
                        uid = result.getLong("UID");
                        BankMin = result.getFloat("BankMin");
                    }
                }
            }
            catch (SQLException ex) {
                if (this.debug >= 1) {
                    this.log.severe("[takeBank] [SQLite-ERR] " + ex.getMessage());
                } else {
                    System.err.println(ex.getMessage());
                }
                pr\u00fcfer = false;
            }
            if (uid == UID) {
                float NeuBank = AltBank - amounth;
                if (this.debug >= 1) {
                    this.log.info("[takeBank] AltBank = " + String.valueOf(AltBank));
                    this.log.info("[takeBank] amounth  = " + String.valueOf(amounth) + " (-)");
                    this.log.info("[takeBank] NeueBank = " + String.valueOf(NeuBank));
                }
                if (this.sysConfig.getValue("BankMin").equals("true")) {
                    if (NeuBank >= BankMin) {
                        try {
                            this.pstmt = this.connection.prepareStatement("UPDATE Money SET Bank=? WHERE UID=" + UID + ";");
                            this.pstmt.setFloat(1, NeuBank);
                            this.pstmt.executeUpdate();
                            this.pstmt.close();
                            pr\u00fcfer = true;
                            try {
                                this.server.getPlayer(UID).sendTextMessage(this.rot + "Bank: -" + this.formatFloatToString(amounth) + " " + this.getCurrency());
                                this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Bank: " + this.rot + this.getBankString(this.server.getPlayer(UID).getUID())});
                            }
                            catch (NullPointerException ex) {
                                // empty catch block
                            }
                            if (this.debug >= 1) {
                                this.log.info("[takeBank] Player '" + this.server.getPlayer(UID) + "' is connected!");
                            }
                        }
                        catch (SQLException ex) {
                            if (this.debug >= 1) {
                                this.log.severe("[takeBank] [SQLite-ERR] " + ex.getMessage());
                                break block35;
                            }
                            System.err.println(ex.getMessage());
                        }
                    } else {
                        pr\u00fcfer = false;
                    }
                } else {
                    try {
                        this.pstmt = this.connection.prepareStatement("UPDATE Money SET Bank=? WHERE UID=" + UID + ";");
                        this.pstmt.setFloat(1, NeuBank);
                        this.pstmt.executeUpdate();
                        this.pstmt.close();
                        pr\u00fcfer = true;
                    }
                    catch (SQLException ex) {
                        if (this.debug >= 1) {
                            this.log.severe("[takeBank] [SQLite-ERR] " + ex.getMessage());
                        }
                        System.err.println(ex.getMessage());
                    }
                }
            }
        }
        if (this.debug >= 1) {
            this.log.info("[takeBank] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public boolean giveBank(long UID, float amounth) {
        float AltBank = this.getBankFloat(UID);
        long uid = 0L;
        boolean pr\u00fcfer = false;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[giveBank] [SQLite-ERR] " + ex.getMessage());
            } else {
                System.err.println(ex.getMessage());
            }
            pr\u00fcfer = false;
        }
        if (uid == UID) {
            float NeuBank = AltBank + amounth;
            if (this.debug >= 1) {
                this.log.info("[giveBank] AltBank = " + String.valueOf(AltBank));
                this.log.info("[giveBank] amounth  = " + String.valueOf(amounth) + " (+)");
                this.log.info("[giveBank] NeueBank = " + String.valueOf(NeuBank));
            }
            try {
                this.pstmt = this.connection.prepareStatement("UPDATE Money SET Bank=? WHERE UID=" + UID + ";");
                this.pstmt.setFloat(1, NeuBank);
                this.pstmt.executeUpdate();
                this.pstmt.close();
                pr\u00fcfer = true;
                try {
                    this.server.getPlayer(UID).sendTextMessage(this.gr\u00fcn + "Bank: +" + this.formatFloatToString(amounth) + " " + this.getCurrency());
                    this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Bank: " + this.gr\u00fcn + this.getBankString(UID)});
                }
                catch (NullPointerException ex) {}
            }
            catch (SQLException ex) {
                if (this.debug >= 1) {
                    this.log.severe("[giveBank] [SQLite-ERR] " + ex.getMessage());
                } else {
                    System.err.println(ex.getMessage());
                }
                pr\u00fcfer = false;
            }
        }
        if (this.debug >= 1) {
            this.log.info("[giveBank] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public boolean BankToCash(long UID, float amounth) {
        boolean ok = false;
        if (this.takeBank(UID, amounth)) {
            this.giveCash(UID, amounth);
            ok = true;
            try {
                this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Cash: " + this.gr\u00fcn + this.getCashString(UID), "Bank: " + this.rot + this.getBankString(UID)});
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.debug >= 1) {
            this.log.info("[BankToCash] ok = " + String.valueOf(ok));
        }
        return ok;
    }

    public boolean CashToBank(long UID, float amounth) {
        boolean ok = false;
        if (this.takeCash(UID, amounth)) {
            this.giveBank(UID, amounth);
            ok = true;
            try {
                this.icGUI.guiShow(this.server.getPlayer(UID), new String[]{"Cash: " + this.rot + this.getCashString(this.server.getPlayer(UID).getUID()), "Bank: " + this.gr\u00fcn + this.getBankString(this.server.getPlayer(UID).getUID())});
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.debug >= 1) {
            this.log.info("[CashToBank] ok = " + String.valueOf(ok));
        }
        return ok;
    }

    public boolean setBankMin(long UID, float money) {
        long uid = 0L;
        boolean pr\u00fcfer = false;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    if (this.debug < 1) continue;
                    this.log.info("[setBankMin] uid = " + String.valueOf(uid));
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[setBankMin] [SQLite-ERR] " + ex.getMessage());
            } else {
                System.err.println(ex.getMessage());
            }
            pr\u00fcfer = false;
        }
        if (uid == UID) {
            try {
                this.pstmt = this.connection.prepareStatement("UPDATE Money SET BankMin=? WHERE UID=" + UID + ";");
                this.pstmt.setFloat(1, money);
                this.pstmt.executeUpdate();
                this.pstmt.close();
                pr\u00fcfer = true;
                try {
                    this.server.getPlayer(UID).sendTextMessage(this.orange + this.textDaten.getText(this.server.getPlayer(UID), "method_setBankMin_t1") + this.formatFloatToString(money) + " " + this.getCurrency() + this.textDaten.getText(this.server.getPlayer(UID), "method_setBankMin_t2"));
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                if (this.server.getPlayer(UID).isConnected() && this.debug >= 1) {
                    this.log.info("[setBankMin] Player '" + this.server.getPlayer(UID) + "' is connected!");
                }
            }
            catch (SQLException ex) {
                if (this.debug >= 1) {
                    this.log.severe("[setBankMin] [SQLite-ERR] " + ex.getMessage());
                } else {
                    System.err.println(ex.getMessage());
                }
                pr\u00fcfer = false;
            }
        }
        if (this.debug >= 1) {
            this.log.info("[setBankMin] pr\u00fcfer = " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public float getBankMinFloat(long UID) {
        float BankMin = 0.0f;
        long uid = 0L;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    BankMin = result.getFloat("BankMin");
                    if (this.debug < 1) continue;
                    this.log.info("[getBankMinFloat] BankMin = " + this.formatFloatToString(BankMin) + " " + this.getCurrency());
                    this.log.info("[getBankMinFloat] uid = " + String.valueOf(uid));
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[getBankMinFloat] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (this.debug >= 1) {
            this.log.info("[getBankMinFloat] UID = " + String.valueOf(UID));
        }
        if (uid != UID) {
            BankMin = 0.0f;
        }
        float BankMin_neu = (float)Math.round(BankMin * 100.0f) / 100.0f;
        return BankMin_neu;
    }

    public String getBankMinString(long UID) {
        long uid = 0L;
        String BankMin_neu = null;
        try (ResultSet result = this.db.executeQuery("SELECT * FROM 'Money' WHERE UID=" + UID + "; ");){
            if (result != null) {
                while (result.next()) {
                    uid = result.getLong("UID");
                    float BankMin = (float)Math.round(result.getFloat("BankMin") * 100.0f) / 100.0f;
                    BankMin_neu = this.formatFloatToString(BankMin);
                    if (this.debug < 1) continue;
                    this.log.info("[getBankMinString] BankMin = " + BankMin);
                    this.log.info("[getBankMinString] uid = " + String.valueOf(uid));
                }
            }
        }
        catch (SQLException ex) {
            if (this.debug >= 1) {
                this.log.severe("[getBankMinString] [SQLite-ERR] " + ex.getMessage());
            }
            System.err.println(ex.getMessage());
        }
        if (this.debug >= 1) {
            this.log.info("[getBankMinString] UID = " + String.valueOf(UID));
        }
        if (uid != UID) {
            BankMin_neu = "0";
        }
        return BankMin_neu;
    }

    public boolean enoughCash(long UID, float amounth) {
        boolean pr\u00fcfer = false;
        if (this.getCashFloat(UID) >= amounth) {
            pr\u00fcfer = true;
        }
        if (this.debug >= 1) {
            this.log.info("[enoughCash] Cash: " + this.getCashString(UID));
            this.log.info("[enoughCash] Amounth: " + this.formatFloatToString(amounth));
            this.log.info("[enoughCash] pr\u00fcfer: " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public boolean enoughBank(long UID, float amounth) {
        boolean pr\u00fcfer = false;
        if (this.getBankFloat(UID) >= amounth) {
            pr\u00fcfer = true;
        }
        if (this.debug >= 1) {
            this.log.info("[enoughBank] Bank: " + this.getBankString(UID));
            this.log.info("[enoughBank] Amounth: " + this.formatFloatToString(amounth));
            this.log.info("[enoughBank] pr\u00fcfer: " + String.valueOf(pr\u00fcfer));
        }
        return pr\u00fcfer;
    }

    public void setBankMin(String value) {
        this.sysConfig.setValue("BankMin", value);
        if (this.debug >= 1) {
            this.log.info("[setBankMin] value = " + value);
            this.log.config("[Config] New BankMin value: " + this.sysConfig.getValue("BankMin"));
        }
    }

    public String getCurrency() {
        return this.sysConfig.getValue("Currency");
    }

    public void iniDB() {
        this.db.execute("CREATE TABLE IF NOT EXISTS Money (ID INTEGER PRIMARY KEY NOT NULL, UID BIGINT,Cash FLOAT, Bank FLOAT, BankMin FLOAT ); ");
        if (this.debug >= 1) {
            this.log.info("[iniDB] OK");
        }
    }

    public String UIDtoPlayername(long uid) {
        String name = null;
        try (ResultSet result = this.plugin.getWorldDatabase().executeQuery("SELECT * FROM `Player` WHERE `UID` = '" + uid + "'");){
            if (result != null) {
                while (result.next()) {
                    name = result.getString("Name");
                }
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return name;
    }

    private void initializeModel() {
        ModelInformation model = new ModelInformation(this.plugin, "/resources/Koffer.02.obj");
        ImageInformation texture = new ImageInformation(this.plugin, "/resources/Koffer.02.TEX.png");
        this.DerKoffer = new World3DModel(model, texture);
        this.DerKoffer.setLightingEnabled(true);
        this.DerKoffer.setInteractionCrosshair(Crosshair.Pickup);
        this.DerKoffer.setCollisionShape(CollisionShape.createHullCollisionShape());
        this.DerKoffer.setScale(0.3f);
        this.DerKoffer.setInteractable(true);
    }
}

