/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import de.omegazirkel.risingworld.tools.Colors;
import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.I18n;
import de.omegazirkel.risingworld.tools.Logger;
import de.omegazirkel.risingworld.tools.PluginChangeWatcher;
import de.omegazirkel.risingworld.tools.WSClientEndpoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerGenerateMapTileEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Utils;

public class RisingMaps
extends Plugin
implements Listener,
WSClientEndpoint.MessageHandler,
FileChangeListener {
    static final String pluginVersion = "0.3.0";
    static final String pluginName = "RisingMaps";
    static final String pluginCMD = "rm";
    static final Logger log = new Logger("[OZ.RM]");
    static final Colors c = Colors.getInstance();
    private static I18n t = null;
    static int logLevel = 0;
    static boolean restartOnUpdate = true;
    static boolean sendPluginWelcome = false;
    static String tileRoot = "";
    static String webURL = "";
    static boolean enableWebSocket = false;
    static URI wsURI = null;
    static boolean wsSendTiles = false;
    static WSClientEndpoint ws;
    static boolean flagRestart;
    static String mapId;

    static {
        flagRestart = false;
        mapId = null;
    }

    public void onEnable() {
        t = t != null ? t : new I18n((Plugin)this);
        this.registerEventListener(this);
        this.initSettings();
        this.initWebSocketClient();
        try {
            File f = new File(this.getPath());
            PluginChangeWatcher.registerFileChangeListener((FileChangeListener)this, (File)f);
        }
        catch (Exception ex) {
            log.out(ex.toString(), 911);
        }
        log.out("RisingMaps Plugin is enabled", 10);
    }

    public void onDisable() {
        log.out("RisingMaps Plugin is disabled", 10);
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (sendPluginWelcome) {
            Player player = event.getPlayer();
            String lang = player.getSystemLanguage();
            player.sendTextMessage(t.get("MSG_PLUGIN_WELCOME", lang));
        }
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Server server = this.getServer();
        if (flagRestart) {
            int playersLeft = server.getPlayerCount() - 1;
            if (playersLeft == 0) {
                log.out("Last player left the server, shutdown now due to flagRestart is set", 100);
                server.shutdown();
            } else if (playersLeft > 1) {
                this.broadcastMessage("BC_PLAYER_REMAIN", playersLeft);
            }
        }
    }

    @EventMethod
    public void onPlayerGenerateMapTile(PlayerGenerateMapTileEvent event) {
        Player player = event.getPlayer();
        int tileX = event.getX();
        int tileY = event.getY();
        File destinationFile = new File(String.valueOf(tileRoot) + "mt_" + tileX + "_" + tileY);
        String compareHash = Utils.FileUtils.getMd5((File)destinationFile);
        player.requestMapTileRaw(tileX, tileY, compareHash, tile -> {
            if (tile != null) {
                if (wsSendTiles && enableWebSocket && RisingMaps.ws.isConnected) {
                    try {
                        ByteBuffer bb = ByteBuffer.allocate(9 + ((byte[])tile).length);
                        Byte code = 1;
                        bb.put(code).putInt(tileX).putInt(tileY).put((byte[])tile);
                        ws.sendBinaryMessage(bb);
                    }
                    catch (Exception e) {
                        log.out(e.getMessage());
                    }
                } else {
                    Utils.FileUtils.writeBytesToFile((byte[])tile, (File)destinationFile);
                }
            }
        });
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        block15: {
            String option;
            Player player = event.getPlayer();
            String command = event.getCommand();
            String lang = event.getPlayer().getSystemLanguage();
            String[] cmd = command.split(" ");
            if (!cmd[0].equals("/rm")) break block15;
            if (cmd.length < 2) {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#EEEEEE]");
                String string = t.get("MSG_CMD_ERR_ARGUMENTS", lang);
                c.getClass();
                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf("[#FF0000]")).append(command);
                c.getClass();
                String string2 = string.replace("PH_CMD", stringBuilder3.append("[#EEEEEE]").toString());
                c.getClass();
                StringBuilder stringBuilder4 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" help\n");
                c.getClass();
                player.sendTextMessage(stringBuilder2.append(string2.replace("PH_COMMAND_HELP", stringBuilder4.append("[#EEEEEE]").toString())).toString());
                return;
            }
            switch (option = cmd[1]) {
                case "info": {
                    String infoMessage = t.get("CMD_INFO", lang);
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + infoMessage);
                    break;
                }
                case "help": {
                    String string = t.get("MSG_CMD_INFO", lang);
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" help");
                    c.getClass();
                    String string3 = string.replace("PH_CMD_HELP", stringBuilder.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder5 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" info");
                    c.getClass();
                    String string4 = string3.replace("PH_CMD_INFO", stringBuilder5.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder6 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" status");
                    c.getClass();
                    String helpMessage = string4.replace("PH_CMD_STATUS", stringBuilder6.append("[#EEEEEE]").toString());
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + helpMessage);
                    break;
                }
                case "status": {
                    c.getClass();
                    String wsStatus = String.valueOf("[#FF0000]") + t.get("STATE_DISCONNECTED", lang);
                    if (ws != null && RisingMaps.ws.isConnected) {
                        c.getClass();
                        wsStatus = String.valueOf("[#00FF00]") + t.get("STATE_CONNECTED", lang);
                    }
                    String string = t.get("MSG_CMD_STATUS", lang);
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#00FF00]")).append(pluginVersion);
                    c.getClass();
                    String string5 = string.replace("PH_VERSION", stringBuilder.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder7 = new StringBuilder(String.valueOf("[#478c59]")).append(player.getLanguage()).append(" / ").append(player.getSystemLanguage());
                    c.getClass();
                    String string6 = string5.replace("PH_LANGUAGE", stringBuilder7.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder8 = new StringBuilder(String.valueOf("[#0099ff]")).append(t.getLanguageUsed(lang));
                    c.getClass();
                    String string7 = string6.replace("PH_USEDLANG", stringBuilder8.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder9 = new StringBuilder(String.valueOf("[#00FF00]")).append(t.getLanguageAvailable());
                    c.getClass();
                    String string8 = string7.replace("PH_LANG_AVAILABLE", stringBuilder9.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder10 = new StringBuilder(String.valueOf(wsStatus));
                    c.getClass();
                    String string9 = string8.replace("PH_STATE_WS", stringBuilder10.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder11 = new StringBuilder(String.valueOf("[#0099ff]")).append(webURL);
                    c.getClass();
                    String statusMessage = string9.replace("PH_MAP_URL", stringBuilder11.append("[#EEEEEE]").toString());
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + statusMessage);
                    break;
                }
                default: {
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":> ");
                    c.getClass();
                    player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_CMD_ERR_UNKNOWN_OPTION", lang).replace("PH_OPTION", option)).toString());
                }
            }
        }
    }

    private void initWebSocketClient() {
        try {
            if (enableWebSocket) {
                ws = new WSClientEndpoint(wsURI);
                ws.setMessageHandler((WSClientEndpoint.MessageHandler)this);
            }
        }
        catch (Exception e) {
            log.out(e.getMessage(), 911);
            e.printStackTrace();
        }
    }

    public void handleMessage(String message) {
        log.out(message);
    }

    public void handleBinaryMessage(byte[] data) {
        ByteBuffer bb = ByteBuffer.wrap(data);
        Byte code = bb.get();
        log.out("Code from Server: " + code);
        switch (code) {
            case 0: {
                byte[] byteArr = new byte[bb.remaining()];
                bb.get(byteArr, bb.position(), bb.remaining());
                String msg = Arrays.toString(byteArr);
                log.out("Message from Server: " + msg);
                break;
            }
            case 2: {
                try {
                    ByteBuffer rawData = bb.slice();
                    mapId = new String(rawData.array(), 1, rawData.array().length - 1, StandardCharsets.UTF_8);
                    log.out("Your MapId is: " + mapId);
                }
                catch (Exception e) {
                    log.out("handleBinaryMessage->Error: " + e.getMessage(), 911);
                }
                break;
            }
        }
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(new InputStreamReader((InputStream)in, "UTF8"));
            in.close();
            logLevel = Integer.parseInt(settings.getProperty("logLevel", "0"));
            sendPluginWelcome = settings.getProperty("sendPluginWelcome", "true").contentEquals("true");
            tileRoot = settings.getProperty("tileRoot", String.valueOf(this.getPath()) + "/tiles/");
            webURL = settings.getProperty("webURL", "");
            enableWebSocket = settings.getProperty("enableWebSocket", "false").contentEquals("true");
            wsURI = new URI(settings.getProperty("wsURI", "wss://rmws.omega-zirkel.de/rmp"));
            wsSendTiles = settings.getProperty("wsSendTiles", "false").contentEquals("true");
            restartOnUpdate = settings.getProperty("restartOnUpdate").contentEquals("true");
            log.out("RisingMaps Plugin settings loaded", 10);
        }
        catch (Exception ex) {
            log.out("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    private void broadcastMessage(String i18nIndex, int playerCount) {
        this.getServer().getAllPlayers().forEach(player -> {
            try {
                String lang = player.getSystemLanguage();
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#808000]")).append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get(i18nIndex, lang).replace("PH_PLAYERS", String.valueOf(playerCount))).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void onFileChangeEvent(Path file) {
        if (file.toString().endsWith("jar")) {
            if (restartOnUpdate) {
                Server server = this.getServer();
                if (server.getPlayerCount() > 0) {
                    flagRestart = true;
                    this.broadcastMessage("BC_UPDATE_FLAG", server.getPlayerCount());
                } else {
                    log.out("onFileCreateEvent: <" + file + "> changed, restarting now (no players online)", 100);
                }
            } else {
                log.out("onFileCreateEvent: <" + file + "> changed but restartOnUpdate is false", 0);
            }
        } else {
            log.out("onFileCreateEvent: <" + file + ">", 0);
        }
    }

    public void onFileCreateEvent(Path file) {
        if (file.toString().endsWith("settings.properties")) {
            this.initSettings();
        } else {
            log.out(String.valueOf(file.toString()) + " was changed", 0);
        }
    }
}

