/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import de.omegazirkel.risingworld.GpsGUI;
import de.omegazirkel.risingworld.Waypoint;
import de.omegazirkel.risingworld.tools.Colors;
import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.I18n;
import de.omegazirkel.risingworld.tools.Logger;
import de.omegazirkel.risingworld.tools.PluginChangeWatcher;
import de.omegazirkel.risingworld.tools.db.SQLite;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangePositionEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class GPS
extends Plugin
implements Listener,
FileChangeListener {
    static final String pluginVersion = "1.7.1";
    static final String pluginName = "GPS";
    static final String pluginCMD = "gps";
    static final Logger log = new Logger("[OZ.GPS]");
    static final Colors c = Colors.getInstance();
    static I18n t = null;
    static SQLite db = null;
    static final float gpsXPosDef = 0.5f;
    static final float gpsHintYPos = -0.25f;
    static int logLevel = 0;
    static boolean restartOnUpdate = true;
    static boolean sendPluginWelcome = false;
    static boolean allowTpToWp = false;
    static boolean allowTpToSpawn = false;
    static boolean allowTpToServerSpawn = false;
    static boolean coordNativeFormat = false;
    static float gpsYPos = 0.1f;
    static int wpDispLen = 8;
    static int wpHdgPrecis = 5;
    public static int wpMaxIndex = 15;
    static final String key_gpsShow = "de.oz.gpsShow";
    static final String key_gpsGUIcurrWp = "de.oz.gpsGUIcurrWp";
    static final String key_gpsHomeShow = "de.oz.gpsHomeShow";
    static final String key_gpsLabel = "de.oz.gpsLabel";
    static final String key_gpsHint = "de.oz.gpsHint";
    static final String key_gpsTargetList = "de.oz.gpsTargetList";
    static final String key_gpsWpList = "de.oz.gpsWpList";
    static final String key_gpsWpShow = "de.oz.gpsWpShow";
    static final double RAD2DEG = 57.29577951308232;
    public static final int HOME_WP = 0;
    public static final int MIN_WP = 0;
    public static final int MIN_WP_PROPER = 1;
    public static final int TARGET_ID = -1;
    static final float TARGET_MIN_DIST = 9.0f;
    static final int FONT_SIZE = 18;
    static final int HINT_SIZE = 13;
    static boolean flagRestart = false;

    public void onEnable() {
        this.registerEventListener(this);
        this.initSettings();
        t = t != null ? t : new I18n((Plugin)this, logLevel);
        db = db != null ? db : new SQLite((Plugin)this, logLevel);
        this.initDatabase();
        try {
            File f = new File(this.getPath());
            PluginChangeWatcher.registerFileChangeListener((FileChangeListener)this, (File)f);
        }
        catch (Exception ex) {
            log.out(ex.toString(), 911);
        }
        log.out("GPS Plugin is enabled", 10);
    }

    public void onDisable() {
        db.destroy();
        log.out("GPS Plugin is disabled", 10);
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        this.initPlayer(event.getPlayer());
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (sendPluginWelcome) {
            Player player = event.getPlayer();
            String lang = player.getSystemLanguage();
            player.sendTextMessage(t.get("MSG_PLUGIN_WELCOME", lang));
        }
        this.setGpsText(event.getPlayer());
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Server server = this.getServer();
        if (flagRestart) {
            int playersLeft = server.getPlayerCount() - 1;
            if (playersLeft == 0) {
                log.out("Last player left the server, shutdown now due to flagRestart is set", 100);
                server.shutdown();
            } else if (playersLeft > 1) {
                this.broadcastMessage("BC_PLAYER_REMAIN", playersLeft);
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        Player player = event.getPlayer();
        String command = event.getCommand();
        String lang = event.getPlayer().getSystemLanguage();
        String[] cmd = command.split(" ");
        if (cmd[0].equals("/sethome")) {
            this.setHome(player);
        }
        if (cmd[0].equals("/home")) {
            this.teleportToWp(player, 0);
        }
        if (cmd[0].equals("/gps")) {
            String option;
            if (cmd.length < 2) {
                this.mainGui(player);
                return;
            }
            switch (option = cmd[1]) {
                case "spawn": {
                    this.teleportToPlayerSpawn(player);
                    break;
                }
                case "serverspawn": {
                    this.teleportToServerSpawn(player);
                    break;
                }
                case "info": {
                    String infoMessage = t.get("CMD_INFO", lang);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    player.sendTextMessage(stringBuilder.append("[#00FF00]").append(pluginName).append(":> ").append(infoMessage).toString());
                    break;
                }
                case "help": {
                    String string = t.get("CMD_HELP", lang);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder2 = stringBuilder.append("[#997d4a]").append("/sethome");
                    c.getClass();
                    String string2 = string.replace("PH_CMD_SETHOME", stringBuilder2.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder3 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder4 = stringBuilder3.append("[#997d4a]").append("/home");
                    c.getClass();
                    String string3 = string2.replace("PH_CMD_TPHOME", stringBuilder4.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder5 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder6 = stringBuilder5.append("[#997d4a]").append("/").append(pluginCMD).append(" spawn");
                    c.getClass();
                    String string4 = string3.replace("PH_CMD_SPAWN", stringBuilder6.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder7 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder8 = stringBuilder7.append("[#997d4a]").append("/").append(pluginCMD).append(" serverspawn");
                    c.getClass();
                    String string5 = string4.replace("PH_CMD_SRVSPAWN", stringBuilder8.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder9 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder10 = stringBuilder9.append("[#997d4a]").append("/").append(pluginCMD).append(" help");
                    c.getClass();
                    String string6 = string5.replace("PH_CMD_HELP", stringBuilder10.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder11 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder12 = stringBuilder11.append("[#997d4a]").append("/").append(pluginCMD).append(" info");
                    c.getClass();
                    String string7 = string6.replace("PH_CMD_INFO", stringBuilder12.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder13 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder14 = stringBuilder13.append("[#997d4a]").append("/").append(pluginCMD).append(" status");
                    c.getClass();
                    String helpMessage = string7.replace("PH_CMD_STATUS", stringBuilder14.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder15 = new StringBuilder();
                    c.getClass();
                    player.sendTextMessage(stringBuilder15.append("[#00FF00]").append(pluginName).append(":> ").append(helpMessage).toString());
                    break;
                }
                case "status": {
                    String string = t.get("CMD_STATUS", lang);
                    StringBuilder stringBuilder = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder16 = stringBuilder.append("[#00FF00]").append(pluginVersion);
                    c.getClass();
                    String string8 = string.replace("PH_VERSION", stringBuilder16.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder17 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder18 = stringBuilder17.append("[#478c59]").append(player.getLanguage()).append(" / ").append(player.getSystemLanguage());
                    c.getClass();
                    String string9 = string8.replace("PH_LANGUAGE", stringBuilder18.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder19 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder20 = stringBuilder19.append("[#0099ff]").append(t.getLanguageUsed(lang));
                    c.getClass();
                    String string10 = string9.replace("PH_USEDLANG", stringBuilder20.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder21 = new StringBuilder();
                    c.getClass();
                    StringBuilder stringBuilder22 = stringBuilder21.append("[#00FF00]").append(t.getLanguageAvailable());
                    c.getClass();
                    String statusMessage = string10.replace("PH_LANG_AVAILABLE", stringBuilder22.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder23 = new StringBuilder();
                    c.getClass();
                    player.sendTextMessage(stringBuilder23.append("[#00FF00]").append(pluginName).append(":> ").append(statusMessage).toString());
                    break;
                }
                default: {
                    try {
                        Integer index = Integer.parseInt(option);
                        this.teleportToWp(player, index);
                        break;
                    }
                    catch (NumberFormatException e) {
                        StringBuilder stringBuilder = new StringBuilder();
                        c.getClass();
                        StringBuilder stringBuilder24 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
                        c.getClass();
                        player.sendTextMessage(stringBuilder24.append("[#EEEEEE]").append(t.get("MSG_CMD_ERR_UNKNOWN_OPTION", lang).replace("PH_OPTION", option)).toString());
                    }
                }
            }
        }
    }

    private void initDatabase() {
        db.execute("CREATE TABLE IF NOT EXISTS `waypoints` (`player_id`   INTEGER  NOT NULL DEFAULT ( 0 ),`wp_name`     CHAR(64) NOT NULL DEFAULT ('[NoName]'),`wp_id`       INTEGER  NOT NULL,`wp_x`        INTEGER  NOT NULL DEFAULT ( 0 ),`wp_y`        INTEGER  NOT NULL DEFAULT ( 0 ),`wp_z`        INTEGER  NOT NULL DEFAULT ( 0 ),UNIQUE (player_id, wp_id) ON CONFLICT REPLACE);");
    }

    private void loadPlayer(Player player) {
        Waypoint[] waypoints = new Waypoint[wpMaxIndex + 1];
        player.setAttribute(key_gpsWpList, (Object)waypoints);
        try (ResultSet result = db.executeQuery("SELECT * FROM `waypoints` WHERE `player_id` = '" + player.getDbID() + "' ORDER BY `wp_id`;");){
            while (result.next()) {
                int wpIdx = result.getInt("wp_id");
                if (wpIdx < 0 || wpIdx > wpMaxIndex) continue;
                waypoints[result.getInt((String)"wp_id")] = new Waypoint(result.getInt("wp_id"), result.getString("wp_name"), result.getFloat("wp_x"), result.getFloat("wp_y"), result.getFloat("wp_z"));
            }
        }
        catch (SQLException e) {
            log.out(e.getMessage(), 999);
        }
    }

    public void setWp(Player player, int wpIndex, String wpName) {
        this.setWp(player, wpIndex, player.getPosition(), wpName);
    }

    public void setWp(Player player, int wpIdx, Vector3f pos, String wpName) {
        Waypoint wp;
        if (wpIdx < 0 || wpIdx > wpMaxIndex) {
            return;
        }
        int playerId = player.getDbID();
        String lang = player.getSystemLanguage();
        db.executeUpdate("INSERT OR REPLACE INTO waypoints (player_id,wp_name,wp_id,wp_x,wp_y,wp_z) VALUES ('" + playerId + "','" + wpName + "'," + wpIdx + "," + pos.x + "," + pos.y + "," + pos.z + ");");
        ((Waypoint[])player.getAttribute((String)key_gpsWpList))[wpIdx] = wp = new Waypoint(wpIdx, wpName, pos.x, pos.y, pos.z);
        if (wpIdx == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("[#00FF00]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("GPS_003", lang)).toString());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder3 = stringBuilder.append("[#00FF00]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder3.append("[#EEEEEE]").append(t.get("GPS_004", lang).replace("PH_INDEX", wpIdx + "").replace("PH_WP_NAME", wpName + "")).toString());
        }
    }

    public void deleteWp(Player player, int wpIdx) {
        String lang = player.getSystemLanguage();
        if (wpIdx < 0 || wpIdx > wpMaxIndex) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("GPS_001", lang).replace("PH_MIN", "0").replace("PH_MAX", wpMaxIndex + "")).toString());
            return;
        }
        int playerId = player.getDbID();
        db.executeUpdate("DELETE FROM waypoints WHERE player_id = '" + playerId + "' AND wp_id=" + wpIdx + ";");
        ((Waypoint[])player.getAttribute((String)key_gpsWpList))[wpIdx] = null;
        if (wpIdx == 0) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder3 = stringBuilder.append("[#808000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder3.append("[#EEEEEE]").append(t.get("GPS_005", lang)).toString());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder4 = stringBuilder.append("[#808000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder4.append("[#EEEEEE]").append(t.get("GPS_006", lang).replace("PH_INDEX", wpIdx + "")).toString());
        }
    }

    public void setHome(Player player) {
        String lang = player.getSystemLanguage();
        this.setWp(player, 0, t.get("GPS_007", lang));
    }

    @EventMethod
    public void onPlayerChangePosition(PlayerChangePositionEvent event) {
        this.setGpsText(event.getPlayer());
    }

    public void mainGui(Player player) {
        int currWp = 0;
        if (player.hasAttribute(key_gpsGUIcurrWp)) {
            currWp = (Integer)player.getAttribute(key_gpsGUIcurrWp);
        }
        GpsGUI gui = new GpsGUI(this, player, gpsYPos, currWp);
        gui.show(player);
    }

    public void setGPSShow(Player player, boolean show) {
        player.setAttribute(key_gpsShow, (Object)show);
        GuiLabel labelgpsInfo = (GuiLabel)player.getAttribute(key_gpsLabel);
        if (labelgpsInfo != null) {
            labelgpsInfo.setVisible(show);
        }
        this.setGpsText(player);
    }

    public void setShowHome(Player player) {
        player.setAttribute(key_gpsHomeShow, (Object)((Boolean)player.getAttribute(key_gpsHomeShow) == false ? 1 : 0));
        this.setGpsText(player);
    }

    public void setShowWp(Player player, Integer index) {
        String lang = player.getSystemLanguage();
        if (index == null || index < -1 || index > wpMaxIndex) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("GPS_001", lang).replace("PH_MIN", "0").replace("PH_MAX", wpMaxIndex + "")).toString());
            return;
        }
        if (index == -1 && player.getAttribute(key_gpsTargetList) == null || index > 0 && ((Waypoint[])player.getAttribute(key_gpsWpList))[index] == null) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder3 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder3.append("[#EEEEEE]").append(t.get("GPS_002", lang).replace("PH_INDEX", index + "")).toString());
            return;
        }
        player.setAttribute(key_gpsWpShow, (Object)index);
        this.setGpsText(player);
    }

    public void addTarget(Player player, String name, float x, float y, float z) {
        ArrayList<Waypoint> targets = (ArrayList<Waypoint>)player.getAttribute(key_gpsTargetList);
        if (targets == null) {
            targets = new ArrayList<Waypoint>();
            player.setAttribute(key_gpsTargetList, targets);
        }
        Waypoint wp = new Waypoint(-1, name, x, y, z);
        targets.add(wp);
        this.setShowWp(player, -1);
    }

    public void teleportToWp(Player player, Integer index) {
        String lang = player.getSystemLanguage();
        if (index == null || index < 0 || index > wpMaxIndex) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("GPS_001", lang).replace("PH_MIN", "0").replace("PH_MAX", wpMaxIndex + "")).toString());
            return;
        }
        if (index > 0 && !allowTpToWp) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder3 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder3.append("[#EEEEEE]").append(t.get("GPS_000", lang)).toString());
            return;
        }
        Waypoint wp = ((Waypoint[])player.getAttribute(key_gpsWpList))[index];
        if (wp == null) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder4 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder4.append("[#EEEEEE]").append(t.get("GPS_002", lang).replace("PH_INDEX", index + "")).toString());
            return;
        }
        player.setPosition(wp.pos.x, wp.pos.y, wp.pos.z);
        this.setGpsText(player);
    }

    void teleportToServerSpawn(Player player) {
        String lang = player.getSystemLanguage();
        Server server = this.getServer();
        if (!allowTpToServerSpawn) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("GPS_TP_DEFAULT_DISABLED", lang)).toString());
            return;
        }
        player.setPosition(server.getDefaultSpawnPosition());
        StringBuilder stringBuilder = new StringBuilder();
        c.getClass();
        StringBuilder stringBuilder3 = stringBuilder.append("[#00FF00]").append(pluginName).append(":> ");
        c.getClass();
        player.sendTextMessage(stringBuilder3.append("[#EEEEEE]").append(t.get("GPS_TP_DEFAULT_OK", lang)).toString());
    }

    void teleportToPlayerSpawn(Player player) {
        String lang = player.getSystemLanguage();
        if (!allowTpToSpawn) {
            StringBuilder stringBuilder = new StringBuilder();
            c.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("[#FF0000]").append(pluginName).append(":> ");
            c.getClass();
            player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get("GPS_TP_SPAWN_DISABLED", lang)).toString());
            return;
        }
        player.setPosition(player.getRespawnPosition());
        StringBuilder stringBuilder = new StringBuilder();
        c.getClass();
        StringBuilder stringBuilder3 = stringBuilder.append("[#00FF00]").append(pluginName).append(":> ");
        c.getClass();
        player.sendTextMessage(stringBuilder3.append("[#EEEEEE]").append(t.get("GPS_TP_SPAWN_OK", lang)).toString());
    }

    void setGpsText(Player player) {
        if (player == null) {
            return;
        }
        if (player.getAttribute(key_gpsLabel) == null) {
            return;
        }
        GuiLabel labelgpsInfo = (GuiLabel)player.getAttribute(key_gpsLabel);
        if (labelgpsInfo == null) {
            return;
        }
        String lang = player.getSystemLanguage();
        Vector3f playerPos = player.getPosition();
        List targets = (List)player.getAttribute(key_gpsTargetList);
        if (targets != null && !targets.isEmpty()) {
            Waypoint wp = (Waypoint)targets.get(0);
            float dist = (playerPos.x - wp.pos.x) * (playerPos.x - wp.pos.x) + (playerPos.z - wp.pos.z) * (playerPos.z - wp.pos.z);
            if (dist < 9.0f) {
                targets.remove(0);
                if (targets.isEmpty()) {
                    player.setAttribute(key_gpsTargetList, null);
                    player.setAttribute(key_gpsWpShow, (Object)0);
                }
            }
        }
        if (((Boolean)player.getAttribute(key_gpsShow)).booleanValue()) {
            Waypoint home;
            int hdg;
            Vector3f playerRot = player.getViewDirection();
            double rotX = playerRot.x;
            double rotZ = playerRot.z;
            double scale = Math.sqrt(rotX * rotX + rotZ * rotZ);
            double heading = scale < 1.0E-5 ? 0.0 : Math.acos(rotZ / scale) * 57.29577951308232;
            if (rotX > 0.0) {
                heading = 360.0 - heading;
            }
            if ((hdg = (int)Math.floor(heading + 0.5)) == 0) {
                hdg = 360;
            }
            int posW = (int)playerPos.x;
            int posE = -posW;
            int posN = (int)playerPos.z;
            int posH = (int)playerPos.y;
            String latDir = "";
            String longDir = "";
            if (!coordNativeFormat) {
                latDir = t.get("GPS_012", lang);
                if (posN < 0) {
                    posN = -posN;
                    latDir = t.get("GPS_014", lang);
                }
                longDir = t.get("GPS_013", lang);
                if (posE < 0) {
                    posE = -posE;
                    longDir = t.get("GPS_015", lang);
                }
            }
            String text = "";
            Waypoint[] wps = (Waypoint[])player.getAttribute(key_gpsWpList);
            if (((Boolean)player.getAttribute(key_gpsHomeShow)).booleanValue() && wps != null && (home = wps[0]) != null) {
                text = home.toString(heading, playerPos) + " | ";
            }
            text = text + String.format("%03d\u00b0", hdg) + (!coordNativeFormat ? " (" + posN + latDir + "," + posE + longDir + ") h" + posH : " (" + posW + "," + posH + "," + posN + ")");
            int wpToShow = (Integer)player.getAttribute(key_gpsWpShow);
            Waypoint wp = null;
            if (wpToShow == -1) {
                if (targets != null && !targets.isEmpty()) {
                    wp = (Waypoint)targets.get(0);
                }
            } else if (wpToShow > 0) {
                wp = ((Waypoint[])player.getAttribute(key_gpsWpList))[wpToShow];
            }
            if (wp != null) {
                text = text + " | " + wp.toString(heading, playerPos);
            }
            labelgpsInfo.setText(text);
        } else {
            labelgpsInfo.setText("");
        }
    }

    private void initPlayer(Player player) {
        if (player.getAttribute(key_gpsLabel) == null) {
            String lang = player.getSystemLanguage();
            GuiLabel info = new GuiLabel("", 0.5f, gpsYPos, true);
            info.setColor(127);
            info.setFont(Font.DefaultMono);
            info.setFontColor(-1);
            info.setFontSize(18);
            info.setPivot(PivotPosition.Center);
            GuiLabel hint = new GuiLabel(t.get("GPS_009", lang).replace("PH_CMD", "/gps"), 0.5f, -0.25f, true);
            hint.setPivot(PivotPosition.Center);
            hint.setFontSize(13);
            info.addChild((GuiElement)hint);
            player.setAttribute(key_gpsShow, (Object)true);
            player.setAttribute(key_gpsHomeShow, (Object)false);
            player.setAttribute(key_gpsWpShow, (Object)0);
            this.loadPlayer(player);
            player.addGuiElement((GuiElement)info);
            player.addGuiElement((GuiElement)hint);
            player.setAttribute(key_gpsLabel, (Object)info);
        }
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(this.getPath() + "/settings.properties");
            settings.load(new InputStreamReader((InputStream)in, "UTF8"));
            in.close();
            allowTpToWp = settings.getProperty("allowTpToWp", "false").contentEquals("true");
            allowTpToSpawn = settings.getProperty("allowTpToSpawn", "false").contentEquals("true");
            allowTpToServerSpawn = settings.getProperty("allowTpToServerSpawn", "false").contentEquals("true");
            coordNativeFormat = settings.getProperty("coordNativeFormat", "false").contentEquals("true");
            gpsYPos = Float.parseFloat(settings.getProperty("gpsYPos", "0.1"));
            wpDispLen = Integer.parseInt(settings.getProperty("wpDispLength", "8"));
            wpHdgPrecis = Integer.parseInt(settings.getProperty("wpHdgPrecis", "5"));
            wpMaxIndex = Integer.parseInt(settings.getProperty("wpMaxIndex", "15"));
            logLevel = Integer.parseInt(settings.getProperty("logLevel", "0"));
            sendPluginWelcome = settings.getProperty("sendPluginWelcome", "false").contentEquals("true");
            restartOnUpdate = settings.getProperty("restartOnUpdate", "false").contentEquals("true");
            log.out("GPS Plugin settings loaded", 10);
        }
        catch (Exception ex) {
            log.out("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    private void broadcastMessage(String i18nIndex, int playerCount) {
        this.getServer().getAllPlayers().forEach(player -> {
            try {
                String lang = player.getSystemLanguage();
                StringBuilder stringBuilder = new StringBuilder();
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#808000]").append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder2.append("[#EEEEEE]").append(t.get(i18nIndex, lang).replace("PH_PLAYERS", playerCount + "")).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void onFileChangeEvent(Path file) {
        if (file.toString().endsWith("jar")) {
            if (restartOnUpdate) {
                Server server = this.getServer();
                if (server.getPlayerCount() > 0) {
                    flagRestart = true;
                    this.broadcastMessage("BC_UPDATE_FLAG", server.getPlayerCount());
                } else {
                    log.out("onFileCreateEvent: <" + file + "> changed, restarting now (no players online)", 100);
                }
            } else {
                log.out("onFileCreateEvent: <" + file + "> changed but restartOnUpdate is false", 0);
            }
        } else {
            log.out("onFileCreateEvent: <" + file + ">", 0);
        }
    }

    public void onFileCreateEvent(Path file) {
        if (file.toString().endsWith("settings.properties")) {
            this.initSettings();
        } else {
            log.out(file.toString() + " was changed", 0);
        }
    }
}

