/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import de.omegazirkel.risingworld.PNBGui;
import de.omegazirkel.risingworld.tools.Colors;
import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.I18n;
import de.omegazirkel.risingworld.tools.Logger;
import de.omegazirkel.risingworld.tools.PluginChangeWatcher;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Properties;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;

public class PNB
extends Plugin
implements Listener,
FileChangeListener {
    static final String pluginVersion = "0.7.0";
    static final String pluginName = "Planks 'n Beams";
    static final String pluginCMD = "pnb";
    static final Logger log = new Logger("[OZ.PNB]");
    static final Colors c = Colors.getInstance();
    public static I18n t = null;
    public static final int NUM_OF_QUICKSLOTS = 5;
    public static final int NUM_OF_INVSLOTS = 32;
    public static final short ORE_ID = 309;
    public static final short LUMBER_ID = 265;
    public static final short PLANK_ID = 760;
    public static final short BEAM_ID = 761;
    public static final short WINDOW1_ID = 771;
    public static final short WINDOW2_ID = 772;
    public static final short WINDOW3_ID = 773;
    public static final short WINDOW4_ID = 774;
    public static final short PLANKTRI_ID = 763;
    public static final short LOG_ID = 762;
    public static final short IRONINGOT_ID = 310;
    public static final short COPPERINGOT_ID = 311;
    public static final short DIRT_VAR = 1;
    public static final short STONE_VAR = 3;
    public static final short GRAVEL_VAR = 4;
    public static final short SNOW_VAR = 8;
    public static final short SAND_VAR = 9;
    public static final short DRYEARTH_VAR = 10;
    public static final short SANDSTONE_VAR = 11;
    public static final short COAL_VAR = 15;
    public static final short HELLSTONE_VAR = 16;
    protected static final Inventory.SlotType[] slotTypeValues = Inventory.SlotType.values();
    public static final short[] resourceId = new short[]{309, 309, 309, 265, 311, 310, 309, 309, 309, 309, 309};
    public static final short[] resourceVar;
    public static final short firstVariation = 21;
    public static final short lastVariation = 221;
    public static final short[] resourcePerVariation;
    public static final int ERR_SUCCESS = 0;
    public static final int ERR_INVALID_PARAM = -1;
    public static final int ERR_NO_RESOURCES = -2;
    public static final int ERR_GENERIC = -3;
    protected static PNB plugin;
    protected static String pluginPath;
    static int logLevel;
    static boolean restartOnUpdate;
    static boolean sendPluginWelcome;
    public static int costPerItem;
    public static int windowResMult;
    public static boolean freeForAdmin;
    public static boolean freeForCreative;
    static boolean flagRestart;

    static {
        short[] sArray = new short[11];
        sArray[0] = 3;
        sArray[1] = 11;
        sArray[2] = 1;
        sArray[6] = 4;
        sArray[7] = 9;
        sArray[8] = 8;
        sArray[9] = 15;
        sArray[10] = 16;
        resourceVar = sArray;
        short[] sArray2 = new short[201];
        sArray2[12] = 1;
        sArray2[13] = 1;
        sArray2[14] = 1;
        sArray2[15] = 1;
        sArray2[28] = 2;
        sArray2[29] = 2;
        sArray2[30] = 2;
        sArray2[31] = 2;
        sArray2[40] = 3;
        sArray2[41] = 3;
        sArray2[42] = 3;
        sArray2[43] = 3;
        sArray2[44] = 3;
        sArray2[45] = 3;
        sArray2[46] = 3;
        sArray2[47] = 3;
        sArray2[48] = 3;
        sArray2[49] = 3;
        sArray2[50] = 3;
        sArray2[51] = 3;
        sArray2[52] = 3;
        sArray2[53] = 3;
        sArray2[54] = 3;
        sArray2[55] = 3;
        sArray2[56] = 3;
        sArray2[57] = 3;
        sArray2[58] = 3;
        sArray2[59] = 3;
        sArray2[64] = 3;
        sArray2[65] = 3;
        sArray2[66] = 3;
        sArray2[67] = 3;
        sArray2[68] = 3;
        sArray2[69] = 3;
        sArray2[70] = 3;
        sArray2[71] = 3;
        sArray2[72] = 3;
        sArray2[73] = 3;
        sArray2[74] = 3;
        sArray2[75] = 3;
        sArray2[76] = 3;
        sArray2[77] = 3;
        sArray2[78] = 3;
        sArray2[79] = 3;
        sArray2[150] = 4;
        sArray2[151] = 4;
        sArray2[152] = 4;
        sArray2[153] = 4;
        sArray2[154] = 5;
        sArray2[155] = 5;
        sArray2[156] = 5;
        sArray2[157] = 5;
        sArray2[158] = 5;
        sArray2[159] = 5;
        sArray2[160] = 5;
        sArray2[161] = 5;
        sArray2[162] = 5;
        sArray2[163] = 5;
        sArray2[164] = 5;
        sArray2[165] = 5;
        sArray2[166] = 5;
        sArray2[167] = 5;
        sArray2[168] = 5;
        sArray2[169] = 5;
        sArray2[170] = 5;
        sArray2[171] = 5;
        sArray2[172] = 5;
        sArray2[173] = 5;
        sArray2[174] = 5;
        sArray2[175] = 5;
        sArray2[176] = 5;
        sArray2[177] = 5;
        sArray2[192] = 2;
        sArray2[193] = 2;
        sArray2[195] = 6;
        sArray2[196] = 2;
        sArray2[197] = 7;
        sArray2[198] = 8;
        sArray2[199] = 9;
        sArray2[200] = 10;
        resourcePerVariation = sArray2;
        logLevel = 0;
        restartOnUpdate = true;
        sendPluginWelcome = false;
        costPerItem = 1;
        windowResMult = 5;
        freeForAdmin = false;
        freeForCreative = false;
        flagRestart = false;
    }

    public void onEnable() {
        t = t != null ? t : new I18n((Plugin)this);
        this.registerEventListener(this);
        this.initSettings();
        pluginPath = this.getPath();
        plugin = this;
        try {
            File f = new File(this.getPath());
            PluginChangeWatcher.registerFileChangeListener((FileChangeListener)this, (File)f);
        }
        catch (Exception ex) {
            log.out(ex.toString(), 911);
        }
        log.out("Planks 'n Beams Plugin is enabled", 10);
    }

    public void onDisable() {
        log.out("Planks 'n Beams Plugin is disabled", 10);
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        if (sendPluginWelcome) {
            Player player = event.getPlayer();
            String lang = player.getSystemLanguage();
            player.sendTextMessage(t.get("MSG_PLUGIN_WELCOME", lang));
        }
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Server server = this.getServer();
        if (flagRestart) {
            int playersLeft = server.getPlayerCount() - 1;
            if (playersLeft == 0) {
                log.out("Last player left the server, shutdown now due to flagRestart is set", 100);
                server.shutdown();
            } else if (playersLeft > 1) {
                this.broadcastMessage("BC_PLAYER_REMAIN", playersLeft);
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        block14: {
            String option;
            Player player = event.getPlayer();
            String command = event.getCommand();
            String lang = event.getPlayer().getSystemLanguage();
            String[] cmd = command.split(" ");
            if (!cmd[0].equals("/pnb")) break block14;
            if (cmd.length < 2) {
                this.mainGui(event.getPlayer());
                return;
            }
            switch (option = cmd[1]) {
                case "info": {
                    String infoMessage = t.get("CMD_INFO", lang);
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + infoMessage);
                    break;
                }
                case "help": {
                    String string = t.get("CMD_HELP", lang);
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" help");
                    c.getClass();
                    String string2 = string.replace("PH_CMD_HELP", stringBuilder.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder2 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" info");
                    c.getClass();
                    String string3 = string2.replace("PH_CMD_INFO", stringBuilder2.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder3 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" status");
                    c.getClass();
                    String string4 = string3.replace("PH_CMD_STATUS", stringBuilder3.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder4 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD);
                    c.getClass();
                    String helpMessage = string4.replace("PH_CMD_GUI", stringBuilder4.append("[#EEEEEE]").toString());
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + helpMessage);
                    break;
                }
                case "status": {
                    String string = t.get("CMD_STATUS", lang);
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#00FF00]")).append(pluginVersion);
                    c.getClass();
                    String string5 = string.replace("PH_VERSION", stringBuilder.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder5 = new StringBuilder(String.valueOf("[#478c59]")).append(player.getLanguage()).append(" / ").append(player.getSystemLanguage());
                    c.getClass();
                    String string6 = string5.replace("PH_LANGUAGE", stringBuilder5.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder6 = new StringBuilder(String.valueOf("[#0099ff]")).append(t.getLanguageUsed(lang));
                    c.getClass();
                    String string7 = string6.replace("PH_USEDLANG", stringBuilder6.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder7 = new StringBuilder(String.valueOf("[#00FF00]")).append(t.getLanguageAvailable());
                    c.getClass();
                    String statusMessage = string7.replace("PH_LANG_AVAILABLE", stringBuilder7.append("[#EEEEEE]").toString());
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + statusMessage);
                    break;
                }
                default: {
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":> ");
                    c.getClass();
                    player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_CMD_ERR_UNKNOWN_OPTION", lang).replace("PH_OPTION", option)).toString());
                }
            }
        }
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(new InputStreamReader((InputStream)in, "UTF8"));
            in.close();
            logLevel = Integer.parseInt(settings.getProperty("logLevel", "0"));
            sendPluginWelcome = settings.getProperty("sendPluginWelcome", "false").contentEquals("true");
            costPerItem = Integer.parseInt(settings.getProperty("costPerItem", "1"));
            freeForAdmin = settings.getProperty("freeForAdmin", "false").contentEquals("true");
            freeForCreative = settings.getProperty("freeForCreative", "false").contentEquals("true");
            restartOnUpdate = settings.getProperty("restartOnUpdate").contentEquals("true");
            log.out("Planks 'n Beams Plugin settings loaded", 10);
        }
        catch (Exception ex) {
            log.out("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    public void mainGui(Player player) {
        PNBGui gui = new PNBGui(this, player, player.getSystemLanguage());
        gui.show(player);
    }

    public int countResources(Player player, int itemId, int itemVar) {
        Inventory inv = player.getInventory();
        int resources = 0;
        Boolean freeCreative = (Boolean)player.getPermissionValue("creative_freecrafting");
        if (player.isAdmin() && freeForAdmin || player.isCreativeModeEnabled() && freeCreative.booleanValue() && freeForCreative) {
            return 64;
        }
        int invType = 0;
        while (invType < slotTypeValues.length) {
            Inventory.SlotType slotType = slotTypeValues[invType];
            int j = 0;
            while (j < inv.getSlotCount(slotType)) {
                Item item = inv.getItem(j, slotType);
                if (item != null && item.getTypeID() == itemId && item.getVariation() == itemVar) {
                    resources += item.getStacksize();
                }
                ++j;
            }
            ++invType;
        }
        return resources;
    }

    public int buy(Player player, int type, int variation, int quantity) {
        Item item;
        if (variation < 21 || variation > 221) {
            return -1;
        }
        short resIndex = resourcePerVariation[variation - 21];
        short itemId = resourceId[resIndex];
        short itemVar = resourceVar[resIndex];
        Boolean freeCreative = (Boolean)player.getPermissionValue("creative_freecrafting");
        int cost = player.isAdmin() && freeForAdmin || player.isCreativeModeEnabled() && freeCreative != false && freeForCreative ? 0 : quantity * costPerItem;
        Inventory inv = player.getInventory();
        int resources = 0;
        ArrayList<Integer> sourceSlots = new ArrayList<Integer>();
        if (cost > 0) {
            int invType = 0;
            while (invType < slotTypeValues.length) {
                Inventory.SlotType slotType = slotTypeValues[invType];
                int j = 0;
                while (j < inv.getSlotCount(slotType)) {
                    item = inv.getItem(j, slotType);
                    if (item != null && item.getTypeID() == itemId && item.getVariation() == itemVar) {
                        resources += item.getStacksize();
                        sourceSlots.add((invType << 16) + j);
                    }
                    ++j;
                }
                ++invType;
            }
        }
        if (resources < cost) {
            return -2;
        }
        item = inv.insertNewItem((short)type, variation, quantity);
        if (item == null) {
            return -3;
        }
        for (Integer i : sourceSlots) {
            item = inv.getItem(i & 0xFFFF, slotTypeValues[i >> 16]);
            int size = item.getStacksize();
            if (size <= cost) {
                inv.removeItem(i & 0xFFFF, slotTypeValues[i >> 16]);
                cost -= size;
            } else {
                inv.removeItem(i & 0xFFFF, slotTypeValues[i >> 16], cost);
                cost = 0;
            }
            if (cost <= 0) break;
        }
        return 0;
    }

    private void broadcastMessage(String i18nIndex, int playerCount) {
        this.getServer().getAllPlayers().forEach(player -> {
            try {
                String lang = player.getSystemLanguage();
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#808000]")).append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get(i18nIndex, lang).replace("PH_PLAYERS", String.valueOf(playerCount))).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void onFileChangeEvent(Path file) {
        if (file.toString().endsWith("jar")) {
            if (restartOnUpdate) {
                Server server = this.getServer();
                if (server.getPlayerCount() > 0) {
                    flagRestart = true;
                    this.broadcastMessage("BC_UPDATE_FLAG", server.getPlayerCount());
                } else {
                    log.out("onFileCreateEvent: <" + file + "> changed, restarting now (no players online)", 100);
                }
            } else {
                log.out("onFileCreateEvent: <" + file + "> changed but restartOnUpdate is false", 1);
            }
        } else {
            log.out("onFileCreateEvent: <" + file + ">", 0);
        }
    }

    public void onFileCreateEvent(Path file) {
        if (file.toString().endsWith("settings.properties")) {
            this.initSettings();
        } else {
            log.out(String.valueOf(file.toString()) + " was changed", 0);
        }
    }
}

