/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import de.omegazirkel.risingworld.ChatMessage;
import de.omegazirkel.risingworld.GlobalIntercomPlayer;
import de.omegazirkel.risingworld.PlayerCloseChannelMessage;
import de.omegazirkel.risingworld.PlayerCreateChannelMessage;
import de.omegazirkel.risingworld.PlayerJoinChannelMessage;
import de.omegazirkel.risingworld.PlayerLeaveChannelMessage;
import de.omegazirkel.risingworld.PlayerOfflineMessage;
import de.omegazirkel.risingworld.PlayerOnlineMessage;
import de.omegazirkel.risingworld.PlayerOverrideChangeMessage;
import de.omegazirkel.risingworld.PlayerRegisterMessage;
import de.omegazirkel.risingworld.PlayerUnregisterMessage;
import de.omegazirkel.risingworld.WSMessage;
import de.omegazirkel.risingworld.tools.Colors;
import de.omegazirkel.risingworld.tools.FileChangeListener;
import de.omegazirkel.risingworld.tools.I18n;
import de.omegazirkel.risingworld.tools.Logger;
import de.omegazirkel.risingworld.tools.PluginChangeWatcher;
import de.omegazirkel.risingworld.tools.WSClientEndpoint;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChatEvent;
import net.risingworld.api.events.player.PlayerCommandEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerDisconnectEvent;
import net.risingworld.api.events.player.PlayerSpawnEvent;
import net.risingworld.api.objects.Player;

public class GlobalIntercom
extends Plugin
implements Listener,
WSClientEndpoint.MessageHandler,
FileChangeListener {
    static final String pluginVersion = "0.11.0";
    static final String pluginName = "GlobalIntercom";
    static final String pluginCMD = "gi";
    static final Logger log = new Logger("[OZ.GI]");
    static final Colors c = Colors.getInstance();
    private static I18n t = null;
    static int logLevel = 0;
    static boolean restartOnUpdate = true;
    static boolean sendPluginWelcome = false;
    static boolean joinDefault = false;
    static URI webSocketURI;
    static String defaultChannel;
    static String colorOther;
    static String colorSelf;
    static String colorLocal;
    static boolean allowScreenshots;
    static int maxScreenWidth;
    static boolean flagRestart;
    static WSClientEndpoint ws;
    static final Map<String, GlobalIntercomPlayer> playerMap;

    static {
        defaultChannel = "global";
        colorOther = "[#3881f7]";
        colorSelf = "[#37f7da]";
        colorLocal = "[#FFFFFF]";
        allowScreenshots = true;
        maxScreenWidth = 1920;
        flagRestart = false;
        playerMap = new HashMap<String, GlobalIntercomPlayer>();
    }

    public void onEnable() {
        t = t != null ? t : new I18n((Plugin)this);
        this.registerEventListener(this);
        this.initSettings();
        this.initWebSocketClient();
        try {
            File f = new File(this.getPath());
            PluginChangeWatcher.registerFileChangeListener((FileChangeListener)this, (File)f);
        }
        catch (Exception ex) {
            log.out(ex.toString(), 911);
        }
        log.out("GlobalIntercom Plugin is enabled", 10);
    }

    private void transmitMessageWS(Player player, WSMessage<?> wsmsg) {
        GsonBuilder gsb = new GsonBuilder();
        Gson gson = gsb.create();
        String lang = player.getSystemLanguage();
        try {
            if (GlobalIntercom.ws.isConnected) {
                String msg = gson.toJson(wsmsg);
                ws.sendMessage(msg);
            } else {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_WS_OFFLINE", lang)).toString());
            }
        }
        catch (Exception e) {
            c.getClass();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
            c.getClass();
            player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(" ").append(e.getMessage()).toString());
            this.initWebSocketClient();
        }
    }

    public void onDisable() {
        try {
            if (ws != null) {
                GlobalIntercom.ws.session.close();
                ws = null;
            }
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(GlobalIntercom.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        this.sendPlayerOnlineNotification(player);
    }

    @EventMethod
    public void onPlayerDisconnect(PlayerDisconnectEvent event) {
        Server server = this.getServer();
        Player player = event.getPlayer();
        PlayerOfflineMessage msg = new PlayerOfflineMessage(player);
        WSMessage<PlayerOfflineMessage> wsmsg = new WSMessage<PlayerOfflineMessage>("playerOffline", msg);
        this.transmitMessageWS(player, wsmsg);
        if (flagRestart) {
            int playersLeft = server.getPlayerCount() - 1;
            if (playersLeft == 0) {
                log.out("Last player left the server, shutdown now due to flagRestart is set", 100);
                server.shutdown();
            } else if (playersLeft > 1) {
                this.broadcastMessage("BC_PLAYER_REMAIN", playersLeft);
            }
        }
    }

    @EventMethod
    public void onPlayerCommand(PlayerCommandEvent event) {
        block45: {
            String option;
            Player player = event.getPlayer();
            String command = event.getCommand();
            String lang = event.getPlayer().getSystemLanguage();
            GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
            String[] cmd = command.split(" ");
            if (!cmd[0].equals("/gi")) break block45;
            if (cmd.length < 2) {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#EEEEEE]");
                String string = t.get("MSG_CMD_ERR_ARGUMENTS", lang);
                c.getClass();
                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf("[#FF0000]")).append(command);
                c.getClass();
                String string2 = string.replace("PH_CMD", stringBuilder3.append("[#EEEEEE]").toString());
                c.getClass();
                StringBuilder stringBuilder4 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" help\n");
                c.getClass();
                player.sendTextMessage(stringBuilder2.append(string2.replace("PH_COMMAND_HELP", stringBuilder4.append("[#EEEEEE]").toString())).toString());
                return;
            }
            switch (option = cmd[1]) {
                case "save": {
                    if (cmd.length > 2) {
                        if (cmd[2].toLowerCase().contentEquals("true")) {
                            WSMessage<PlayerRegisterMessage> wsmsg = new WSMessage<PlayerRegisterMessage>("registerPlayer", new PlayerRegisterMessage(player));
                            this.transmitMessageWS(player, wsmsg);
                            break;
                        }
                        WSMessage<PlayerUnregisterMessage> wsmsg = new WSMessage<PlayerUnregisterMessage>("unregisterPlayer", new PlayerUnregisterMessage(player));
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                    c.getClass();
                    StringBuilder stringBuilder5 = stringBuilder.append("[#EEEEEE]");
                    String string = t.get("MSG_CMD_ERR_ARGUMENTS", lang);
                    c.getClass();
                    StringBuilder stringBuilder6 = new StringBuilder(String.valueOf("[#FF0000]")).append(command);
                    c.getClass();
                    String string3 = string.replace("PH_CMD", stringBuilder6.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder7 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" save true|false\n");
                    c.getClass();
                    player.sendTextMessage(stringBuilder5.append(string3.replace("PH_COMMAND_HELP", stringBuilder7.append("[#EEEEEE]").toString())).toString());
                    break;
                }
                case "create": {
                    if (cmd.length > 2) {
                        PlayerCreateChannelMessage msg = new PlayerCreateChannelMessage(player);
                        msg.channel = cmd[2].toLowerCase();
                        if (cmd.length > 3) {
                            msg.password = cmd[3];
                        }
                        WSMessage<PlayerCreateChannelMessage> wsmsg = new WSMessage<PlayerCreateChannelMessage>("playerCreateChannel", msg);
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                    c.getClass();
                    StringBuilder stringBuilder8 = stringBuilder.append("[#EEEEEE]");
                    String string = t.get("MSG_CMD_ERR_ARGUMENTS", lang);
                    c.getClass();
                    StringBuilder stringBuilder9 = new StringBuilder(String.valueOf("[#FF0000]")).append(command);
                    c.getClass();
                    String string4 = string.replace("PH_CMD", stringBuilder9.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder10 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" create channelname [password]\n");
                    c.getClass();
                    player.sendTextMessage(stringBuilder8.append(string4.replace("PH_COMMAND_HELP", stringBuilder10.append("[#EEEEEE]").toString())).toString());
                    break;
                }
                case "close": {
                    if (cmd.length > 2) {
                        PlayerCloseChannelMessage msg = new PlayerCloseChannelMessage(player);
                        msg.channel = cmd[2].toLowerCase();
                        WSMessage<PlayerCloseChannelMessage> wsmsg = new WSMessage<PlayerCloseChannelMessage>("playerCloseChannel", msg);
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                    c.getClass();
                    StringBuilder stringBuilder11 = stringBuilder.append("[#EEEEEE]");
                    String string = t.get("MSG_CMD_ERR_ARGUMENTS", lang);
                    c.getClass();
                    StringBuilder stringBuilder12 = new StringBuilder(String.valueOf("[#FF0000]")).append(command);
                    c.getClass();
                    String string5 = string.replace("PH_CMD", stringBuilder12.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder13 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" close channelname\n");
                    c.getClass();
                    player.sendTextMessage(stringBuilder11.append(string5.replace("PH_COMMAND_HELP", stringBuilder13.append("[#EEEEEE]").toString())).toString());
                    break;
                }
                case "join": {
                    PlayerJoinChannelMessage msg = new PlayerJoinChannelMessage(player);
                    msg.channel = cmd.length > 2 ? cmd[2].toLowerCase() : defaultChannel;
                    if (cmd.length > 3) {
                        msg.password = cmd[3];
                    }
                    WSMessage<PlayerJoinChannelMessage> wsmsg = new WSMessage<PlayerJoinChannelMessage>("playerJoinChannel", msg);
                    this.transmitMessageWS(player, wsmsg);
                    break;
                }
                case "leave": {
                    PlayerLeaveChannelMessage msg = new PlayerLeaveChannelMessage(player);
                    msg.channel = cmd.length > 2 ? cmd[2].toLowerCase() : defaultChannel;
                    WSMessage<PlayerLeaveChannelMessage> wsmsg = new WSMessage<PlayerLeaveChannelMessage>("playerLeaveChannel", msg);
                    this.transmitMessageWS(player, wsmsg);
                    break;
                }
                case "info": {
                    String infoMessage = t.get("CMD_INFO", lang);
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + infoMessage);
                    break;
                }
                case "help": {
                    String string = t.get("CMD_HELP", lang);
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" join channelname [password]");
                    c.getClass();
                    String string6 = string.replace("PH_CMD_JOIN", stringBuilder.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder14 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" leave channelname");
                    c.getClass();
                    String string7 = string6.replace("PH_CMD_LEAVE", stringBuilder14.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder15 = new StringBuilder(String.valueOf("[#997d4a]")).append("#HelloWorld");
                    c.getClass();
                    String string8 = string7.replace("PH_CMD_CHAT_DEFAULT", stringBuilder15.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder16 = new StringBuilder(String.valueOf("[#997d4a]")).append("##other HelloWorld");
                    c.getClass();
                    String string9 = string8.replace("PH_CMD_CHAT_OTHER", stringBuilder16.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder17 = new StringBuilder(String.valueOf("[#997d4a]")).append("#%local HelloWorld");
                    c.getClass();
                    String string10 = string9.replace("PH_CMD_CHAT_LOCAL", stringBuilder17.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder18 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" override true|false");
                    c.getClass();
                    String string11 = string10.replace("PH_CMD_OVERRIDE", stringBuilder18.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder19 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" help");
                    c.getClass();
                    String string12 = string11.replace("PH_CMD_HELP", stringBuilder19.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder20 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" info");
                    c.getClass();
                    String string13 = string12.replace("PH_CMD_INFO", stringBuilder20.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder21 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" status");
                    c.getClass();
                    String string14 = string13.replace("PH_CMD_STATUS", stringBuilder21.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder22 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" create channelname [password]");
                    c.getClass();
                    String string15 = string14.replace("PH_CMD_CREATE", stringBuilder22.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder23 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" close channelname");
                    c.getClass();
                    String string16 = string15.replace("PH_CMD_CLOSE", stringBuilder23.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder24 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" save true|false");
                    c.getClass();
                    String helpMessage = string16.replace("PH_CMD_SAVE", stringBuilder24.append("[#EEEEEE]").toString());
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + helpMessage);
                    break;
                }
                case "status": {
                    String lastCH = "lokal";
                    if (player.hasAttribute("gilastch")) {
                        lastCH = (String)player.getAttribute("gilastch");
                    }
                    c.getClass();
                    String wsStatus = String.valueOf("[#FF0000]") + t.get("STATE_DISCONNECTED", lang);
                    if (GlobalIntercom.ws.isConnected) {
                        c.getClass();
                        wsStatus = String.valueOf("[#00FF00]") + t.get("STATE_CONNECTED", lang);
                    }
                    c.getClass();
                    String saveStatus = String.valueOf("[#FF0000]") + t.get("STATE_INACTIVE", lang);
                    if (giPlayer != null && giPlayer.saveSettings) {
                        c.getClass();
                        saveStatus = String.valueOf("[#00FF00]") + t.get("STATE_ACTIVE", lang);
                    }
                    String overrideStatus = "";
                    if (giPlayer != null && giPlayer.override) {
                        c.getClass();
                        overrideStatus = String.valueOf("[#00FF00]") + t.get("STATE_ON", lang);
                    } else {
                        c.getClass();
                        overrideStatus = String.valueOf("[#FF0000]") + t.get("STATE_OFF", lang);
                    }
                    String playerChannelList = "";
                    if (giPlayer != null) {
                        playerChannelList = giPlayer.getChannelList();
                    }
                    String string = t.get("CMD_STATUS", lang);
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#00FF00]")).append(pluginVersion);
                    c.getClass();
                    String string17 = string.replace("PH_VERSION", stringBuilder.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder25 = new StringBuilder(String.valueOf(colorSelf)).append(player.getLanguage()).append(" / ").append(player.getSystemLanguage());
                    c.getClass();
                    String string18 = string17.replace("PH_LANGUAGE", stringBuilder25.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder26 = new StringBuilder(String.valueOf(colorOther)).append(t.getLanguageUsed(lang));
                    c.getClass();
                    String string19 = string18.replace("PH_USEDLANG", stringBuilder26.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder27 = new StringBuilder(String.valueOf("[#00FF00]")).append(t.getLanguageAvailable());
                    c.getClass();
                    String string20 = string19.replace("PH_LANG_AVAILABLE", stringBuilder27.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder28 = new StringBuilder(String.valueOf(wsStatus));
                    c.getClass();
                    String string21 = string20.replace("PH_STATE_WS", stringBuilder28.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder29 = new StringBuilder(String.valueOf("[#997d4a]")).append(lastCH);
                    c.getClass();
                    String string22 = string21.replace("PH_STATE_CH", stringBuilder29.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder30 = new StringBuilder(String.valueOf(saveStatus));
                    c.getClass();
                    String string23 = string22.replace("PH_STATE_SAVE", stringBuilder30.append("[#EEEEEE]").toString());
                    StringBuilder stringBuilder31 = new StringBuilder(String.valueOf(overrideStatus));
                    c.getClass();
                    String string24 = string23.replace("PH_STATE_OR", stringBuilder31.append("[#EEEEEE]").toString());
                    c.getClass();
                    StringBuilder stringBuilder32 = new StringBuilder(String.valueOf("[#997d4a]")).append(playerChannelList);
                    c.getClass();
                    String statusMessage = string24.replace("PH_CHLIST", stringBuilder32.append("[#EEEEEE]").toString());
                    c.getClass();
                    player.sendTextMessage(String.valueOf("[#00FF00]") + pluginName + ":> " + statusMessage);
                    break;
                }
                case "override": {
                    if (cmd.length > 2) {
                        PlayerOverrideChangeMessage msg = new PlayerOverrideChangeMessage(player);
                        msg.override = cmd[2].toLowerCase().contentEquals("true");
                        WSMessage<PlayerOverrideChangeMessage> wsmsg = new WSMessage<PlayerOverrideChangeMessage>("playerOverrideChange", msg);
                        this.transmitMessageWS(player, wsmsg);
                        break;
                    }
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#00FF00]")).append(pluginName).append(":> ");
                    c.getClass();
                    StringBuilder stringBuilder33 = stringBuilder.append("[#EEEEEE]");
                    String string = t.get("MSG_CMD_OVERRIDE_NOTSET", lang);
                    c.getClass();
                    StringBuilder stringBuilder34 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" override [true|false] ");
                    c.getClass();
                    String message = stringBuilder33.append(string.replace("PH_CMD", stringBuilder34.append("[#EEEEEE]").toString())).toString();
                    player.sendTextMessage(message);
                    break;
                }
                default: {
                    c.getClass();
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":> ");
                    c.getClass();
                    player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_CMD_ERR_UNKNOWN_OPTION", lang).replace("PH_OPTION", option)).toString());
                }
            }
        }
    }

    public boolean isGIMessage(PlayerChatEvent event) {
        boolean isValidLastChannel;
        Player player = event.getPlayer();
        String message = event.getChatMessage();
        String noColorText = message.replaceFirst("\\[[#0-9a-fA-F\\[\\]]+\\]#", "#");
        GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
        boolean override = giPlayer != null && giPlayer.override;
        boolean bl = isValidLastChannel = override && player.hasAttribute("gilastch") && giPlayer.isInChannel((String)player.getAttribute("gilastch"));
        return noColorText.startsWith("#") || isValidLastChannel && !noColorText.startsWith("#%");
    }

    @EventMethod
    public void onPlayerChat(PlayerChatEvent event) {
        String chatMessage;
        String channel;
        boolean override;
        Player player = event.getPlayer();
        Server server = this.getServer();
        String message = event.getChatMessage();
        String lang = event.getPlayer().getSystemLanguage();
        String noColorText = message.replaceFirst("\\[[#0-9a-fA-F\\[\\]]+\\]#", "#");
        GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
        if (giPlayer == null) {
            if (noColorText.startsWith("#")) {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_ERR_GI_INIT", lang)).toString());
                event.setCancelled(true);
            }
            return;
        }
        boolean bl = override = giPlayer != null && giPlayer.override;
        if (noColorText.startsWith("#%")) {
            player.deleteAttribute("gilastch");
            if (noColorText.substring(2).length() > 0) {
                event.setChatMessage(String.valueOf(colorLocal) + noColorText.substring(2));
            } else {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#00FF00]")).append(pluginName).append(":>");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_INFO_CH_DEFAULT_RESET", lang)).toString());
                event.setCancelled(true);
            }
            return;
        }
        if (noColorText.startsWith("#")) {
            if (noColorText.startsWith("##")) {
                String[] msgParts = noColorText.substring(2).split(" ", 2);
                channel = msgParts[0].toLowerCase();
                chatMessage = msgParts.length > 1 ? msgParts[1] : "";
            } else {
                channel = defaultChannel;
                chatMessage = noColorText.substring(1);
            }
            if (channel.length() > 20) {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_ERR_CH_LENGTH", lang).replace("PH_CHANNEL", channel)).toString());
                event.setCancelled(true);
                return;
            }
            if (channel.length() < 3) {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get("MSG_ERR_CH_LENGTH", lang).replace("PH_CHANNEL", channel)).toString());
                event.setCancelled(true);
                return;
            }
            if (giPlayer == null || !giPlayer.isInChannel(channel)) {
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#FF0000]")).append(pluginName).append(":>");
                c.getClass();
                StringBuilder stringBuilder2 = stringBuilder.append("[#EEEEEE]").append(t.get("MSG_ERR_CH_NOMEMBER", lang).replace("PH_CHANNEL", channel)).append("\n");
                String string = t.get("MSG_INFO_CH_JOIN", lang);
                c.getClass();
                StringBuilder stringBuilder3 = new StringBuilder(String.valueOf("[#997d4a]")).append("/").append(pluginCMD).append(" join ").append(channel);
                c.getClass();
                player.sendTextMessage(stringBuilder2.append(string.replace("PH_CMD_JOIN", stringBuilder3.append("[#EEEEEE]").toString())).toString());
                event.setCancelled(true);
                return;
            }
            if (override) {
                player.setAttribute("gilastch", (Object)channel);
            }
        } else if (player.hasAttribute("gilastch") && override) {
            channel = (String)player.getAttribute("gilastch");
            chatMessage = noColorText;
        } else {
            event.setChatMessage(String.valueOf(colorLocal) + noColorText);
            return;
        }
        if (giPlayer == null || !giPlayer.isInChannel(channel)) {
            player.deleteAttribute("gilastch");
            event.setChatMessage(String.valueOf(colorLocal) + noColorText);
            return;
        }
        event.setCancelled(true);
        ChatMessage cmsg = new ChatMessage(player, server, chatMessage, channel);
        if (chatMessage.contains("+screen")) {
            if (allowScreenshots) {
                int playerResolutionX = player.getScreenResolutionX();
                float sizeFactor = 1.0f;
                if (playerResolutionX > maxScreenWidth) {
                    sizeFactor = (float)maxScreenWidth * 1.0f / (float)playerResolutionX * 1.0f;
                }
                player.createScreenshot(sizeFactor, bimg -> {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)bimg, "jpg", os);
                        chatMessage.attachment = Base64.getEncoder().encodeToString(os.toByteArray());
                    }
                    catch (Exception e) {
                        log.out("Exception on createScreenshot-> " + e.toString());
                    }
                    chatMessage.chatContent = chatMessage.replace("+screen", "[screenshot.jpg]");
                    WSMessage<ChatMessage> wsbcm = new WSMessage<ChatMessage>("broadcastMessage", cmsg);
                    this.transmitMessageWS(player, wsbcm);
                });
            } else {
                cmsg.chatContent = chatMessage.replace("+screen", "[noimage.jpg]");
                player.sendTextMessage(t.get("MSG_SCREEN_NOTALLOWED", lang));
                WSMessage<ChatMessage> wsbcm = new WSMessage<ChatMessage>("broadcastMessage", cmsg);
                this.transmitMessageWS(player, wsbcm);
            }
        } else {
            WSMessage<ChatMessage> wsbcm = new WSMessage<ChatMessage>("broadcastMessage", cmsg);
            this.transmitMessageWS(player, wsbcm);
        }
    }

    @EventMethod
    public void onPlayerSpawn(PlayerSpawnEvent event) {
        Player player = event.getPlayer();
        if (sendPluginWelcome) {
            String lang = player.getSystemLanguage();
            player.sendTextMessage(t.get("MSG_PLUGIN_WELCOME", lang));
        }
        if (this.getServer().getType() == Server.Type.Singleplayer) {
            this.sendPlayerOnlineNotification(player);
        }
    }

    public void sendPlayerOnlineNotification(Player player) {
        PlayerOnlineMessage msg = new PlayerOnlineMessage(player);
        WSMessage<PlayerOnlineMessage> wsmsg = new WSMessage<PlayerOnlineMessage>("playerOnline", msg);
        this.transmitMessageWS(player, wsmsg);
    }

    private void initWebSocketClient() {
        try {
            ws = new WSClientEndpoint(webSocketURI);
            ws.setMessageHandler((WSClientEndpoint.MessageHandler)this);
        }
        catch (Exception e) {
            log.out(e.getMessage(), 911);
            e.printStackTrace();
        }
    }

    private void initSettings() {
        Properties settings = new Properties();
        try {
            FileInputStream in = new FileInputStream(String.valueOf(this.getPath()) + "/settings.properties");
            settings.load(new InputStreamReader((InputStream)in, "UTF8"));
            in.close();
            logLevel = Integer.parseInt(settings.getProperty("logLevel", "1"));
            webSocketURI = new URI(settings.getProperty("webSocketURI", "wss://rw.gi.omega-zirkel.de/ws"));
            defaultChannel = settings.getProperty("defaultChannel", "global");
            joinDefault = settings.getProperty("joinDefault", "true").contentEquals("true");
            colorOther = settings.getProperty("colorOther", "[#3881f7]");
            colorSelf = settings.getProperty("colorSelf", "[#37f7da]");
            colorLocal = settings.getProperty("colorLocal", "[#FFFFFF]");
            sendPluginWelcome = settings.getProperty("sendPluginWelcome", "true").contentEquals("true");
            allowScreenshots = settings.getProperty("allowScreenshots", "true").contentEquals("true");
            maxScreenWidth = Integer.parseInt(settings.getProperty("maxScreenWidth", "1920"));
            restartOnUpdate = settings.getProperty("restartOnUpdate", "false").contentEquals("true");
            log.out("GlobalIntercom Plugin settings loaded", 10);
        }
        catch (IOException ex) {
            log.out("IOException on initSettings: " + ex.getMessage(), 100);
        }
        catch (NumberFormatException ex) {
            log.out("NumberFormatException on initSettings: " + ex.getMessage(), 100);
        }
        catch (URISyntaxException ex) {
            log.out("Exception on initSettings: " + ex.getMessage(), 100);
        }
    }

    private void broadcastMessage(ChatMessage cmsg) {
        this.getServer().getAllPlayers().forEach(player -> {
            if (!playerMap.containsKey(String.valueOf(player.getUID()))) {
                return;
            }
            GlobalIntercomPlayer giPlayer = playerMap.get(String.valueOf(player.getUID()));
            if (giPlayer != null && giPlayer.isInChannel(chatMessage.chatChannel)) {
                String color = colorOther;
                if (String.valueOf(player.getUID()).contentEquals(chatMessage.playerUID)) {
                    color = colorSelf;
                }
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(color)).append("[").append(chatMessage.chatChannel.toUpperCase()).append("] ").append(chatMessage.playerName).append(": ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(chatMessage.chatContent).toString());
            }
        });
    }

    /*
     * Exception decompiling
     */
    public void handleMessage(String message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[14] lbl304 : CaseStatement: default:\u000a, @NONE, blocks:[14] lbl304 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void broadcastMessage(String i18nIndex, int playerCount) {
        this.getServer().getAllPlayers().forEach(player -> {
            try {
                String lang = player.getSystemLanguage();
                c.getClass();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf("[#808000]")).append(pluginName).append(":> ");
                c.getClass();
                player.sendTextMessage(stringBuilder.append("[#EEEEEE]").append(t.get(i18nIndex, lang).replace("PH_PLAYERS", String.valueOf(playerCount))).toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void onFileChangeEvent(Path file) {
        if (file.toString().endsWith("jar")) {
            if (restartOnUpdate) {
                Server server = this.getServer();
                if (server.getPlayerCount() > 0) {
                    flagRestart = true;
                    this.broadcastMessage("BC_UPDATE_FLAG", server.getPlayerCount());
                } else {
                    log.out("onFileCreateEvent: <" + file + "> changed, restarting now (no players online)", 100);
                }
            } else {
                log.out("onFileCreateEvent: <" + file + "> changed but restartOnUpdate is false", 0);
            }
        } else {
            log.out("onFileCreateEvent: <" + file + ">", 0);
        }
    }

    public void onFileCreateEvent(Path file) {
        if (file.toString().endsWith("settings.properties")) {
            this.initSettings();
        } else {
            log.out(String.valueOf(file.toString()) + " was changed", 0);
        }
    }

    public void handleBinaryMessage(byte[] arg0) {
    }
}

