/*
 * Decompiled with CFR 0.152.
 */
package animalFarming;

import net.risingworld.api.Plugin;
import net.risingworld.api.Server;
import net.risingworld.api.World;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerNpcInteractionEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.utils.Vector3f;

public class AnimalFarming
extends Plugin
implements Listener {
    World world;
    Server server;
    int[] supportedAnimals = new int[]{1, 2, 3, 4, 8, 9, 10, 19, 22, 28, 29};
    int lureItemID = 497;
    int breedItemID = 494;
    int breedItemCost = 64;

    public void onEnable() {
        this.registerEventListener(this);
        this.world = this.getWorld();
        this.server = this.getServer();
    }

    @EventMethod
    public void onPlayerNpcInteraction(PlayerNpcInteractionEvent event) {
        Npc npc = event.getNpc();
        Player player = event.getPlayer();
        if (player.getEquippedItem() != null && npc.getType() == Npc.Type.Animal) {
            Boolean isAnimalSupported = false;
            int animalID = npc.getTypeID();
            short equippedItemID = player.getEquippedItem().getTypeID();
            for (int i = 0; i < this.supportedAnimals.length; ++i) {
                if (this.supportedAnimals[i] != animalID) continue;
                isAnimalSupported = true;
            }
            if (isAnimalSupported.booleanValue()) {
                if (equippedItemID == this.lureItemID) {
                    npc.setGroupID(-1);
                    npc.moveTo(player.getPosition());
                }
                if (equippedItemID == this.breedItemID) {
                    Item item;
                    int i;
                    int breedItemsInInventoryCount = 0;
                    Inventory inventory = player.getInventory();
                    for (i = 0; i < 5; ++i) {
                        item = inventory.getItem(i, Inventory.SlotType.Quickslot);
                        if (item == null || item.getTypeID() != this.breedItemID) continue;
                        breedItemsInInventoryCount += item.getStacksize();
                    }
                    for (i = 0; i < 32; ++i) {
                        item = inventory.getItem(i, Inventory.SlotType.Inventory);
                        if (item == null || item.getTypeID() != this.breedItemID) continue;
                        breedItemsInInventoryCount += item.getStacksize();
                    }
                    if (breedItemsInInventoryCount >= this.breedItemCost) {
                        Item item2;
                        int i2;
                        int breedItemCostLeft = this.breedItemCost;
                        for (i2 = 0; i2 < 32 && breedItemCostLeft > 0; ++i2) {
                            item2 = inventory.getItem(i2, Inventory.SlotType.Inventory);
                            if (item2 == null || item2.getTypeID() != this.breedItemID) continue;
                            if (item2.getStacksize() > breedItemCostLeft) {
                                breedItemCostLeft -= breedItemCostLeft - breedItemCostLeft;
                                inventory.removeItem(i2, Inventory.SlotType.Inventory, breedItemCostLeft);
                                continue;
                            }
                            breedItemCostLeft -= item2.getStacksize();
                            inventory.removeItem(i2, Inventory.SlotType.Inventory, item2.getStacksize());
                        }
                        for (i2 = 0; i2 < 5 && breedItemCostLeft > 0; ++i2) {
                            item2 = inventory.getItem(i2, Inventory.SlotType.Quickslot);
                            if (item2 == null || item2.getTypeID() != this.breedItemID) continue;
                            if (item2.getStacksize() > breedItemCostLeft) {
                                breedItemCostLeft -= breedItemCostLeft;
                                inventory.removeItem(i2, Inventory.SlotType.Quickslot, breedItemCostLeft);
                                continue;
                            }
                            breedItemCostLeft -= item2.getStacksize();
                            inventory.removeItem(i2, Inventory.SlotType.Quickslot, item2.getStacksize());
                        }
                        if (breedItemCostLeft <= 0) {
                            Vector3f spawnPosition = new Vector3f(npc.getPosition().x, npc.getPosition().y, npc.getPosition().z);
                            this.world.spawnNpc((short)npc.getTypeID(), (byte)0, spawnPosition, npc.getRotation());
                        }
                    }
                }
            }
        }
    }

    public void onDisable() {
    }
}

