/*
 * Decompiled with CFR 0.152.
 */
package mod.allielexie.meloncannon;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeEquippedItemEvent;
import net.risingworld.api.objects.Inventory;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Npc;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.CollisionType;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class MelonCannon
extends Plugin
implements Listener {
    public final String MELONCANNON_ID = "mod.allielexie.meloncannon.meloncannon";
    public final String MELONCANNON_NAME = "meloncannon";
    public final String MELON_TIMER = "mod.allielexie.meloncannon.melontimer";
    public final String FIREMELON_ID = "mod.allielexie.meloncannon.firemelon";
    public final String FIREMELON_NAME = "firemelon";
    public final String AMMO_TYPE = "mod.allielexie.meloncannon.ammotype";
    public final String AMMO_WATERMELON = "watermelon";
    public final String AMMO_FIREMELON = "firemelon";
    public final float MELON_VELOCITY = 32.0f;
    private final int COLLISION_BITMASK = CollisionType.getBitmask((int[])new int[]{1, 8, 16, 128});
    private final int DEFAULT_FIREMELON = 3;
    private final int FM_HARD = 1;
    private final int FM_SOFT = 2;
    private final int FM_SHOW = 3;
    private final int FM_WORK = 4;
    private final float FM_SOFT_RADIUS = 10.0f;
    private final float FM_SOFT_DAMAGE = 100.0f;
    private String prefsFileName;
    private int fireMelonType;
    private float fireMelonRadius;
    private float fireMelonDamage;

    public void onDisable() {
    }

    public void onEnable() {
        this.prefsFileName = String.valueOf(this.getPath()) + "/prefs.txt";
        this.loadPreferences(this.prefsFileName);
        CustomItem cannon = new CustomItem("mod.allielexie.meloncannon.meloncannon", "meloncannon");
        ModelInformation cannonModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/meloncannon.obj");
        ImageInformation cannonTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/mctexture.png");
        ImageInformation cannonIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/mcicon.png");
        cannon.setModel(cannonModel, cannonTexture, 1.0f);
        cannon.setIcon(cannonIcon);
        cannon.setMaxStacksize(1);
        cannon.setPlayerIdleAnimation(Animation.M14Aim);
        cannon.setItemPosition(0.03131289f, 0.3350466f, 0.49497944f);
        cannon.setItemRotation(0.23054627f, -0.43278024f, -0.5497708f, 0.6762362f);
        cannon.setFPBodyPosition(-0.5887006f, -0.5547194f, 0.261761f);
        cannon.setFPBodyRotation(-0.0469843f, 0.018426938f, -0.06686103f, 0.9964851f);
        cannon.setLocalizedNames(new String[]{"en=Melon Cannon", "de=Melonekanone"});
        cannon.setPrimaryAction(Animation.M14Fire, 0.2f, (player, collision) -> {
            Item.CustomItemAttribute cannonAttr;
            boolean hasAmmo = false;
            int ammoSlot = 0;
            String type = "watermelon";
            Item cannonItem = player.getEquippedItem();
            if (cannonItem != null && cannonItem.getAttribute() instanceof Item.CustomItemAttribute && (cannonAttr = (Item.CustomItemAttribute)cannonItem.getAttribute()).hasAttribute("mod.allielexie.meloncannon.ammotype")) {
                type = cannonAttr.getAttribute("mod.allielexie.meloncannon.ammotype");
                int s = 0;
                while (s < player.getInventory().getSlotCount(Inventory.SlotType.Inventory)) {
                    Item i = player.getInventory().getItem(s, Inventory.SlotType.Inventory);
                    if (i != null && i.getAttribute() instanceof Item.CustomItemAttribute) {
                        Item.CustomItemAttribute attr = (Item.CustomItemAttribute)i.getAttribute();
                        if (attr.getUUID().equals("mod.allielexie.meloncannon.firemelon") && type.equals("firemelon")) {
                            hasAmmo = true;
                            ammoSlot = s;
                        }
                    } else if (i != null && i.getDefinition().equals(Definitions.getItemDefinition((String)"watermelon")) && type.equals("watermelon")) {
                        hasAmmo = true;
                        ammoSlot = s;
                    }
                    ++s;
                }
            }
            if (hasAmmo) {
                this.launchMelon(player, type);
                player.getInventory().removeItem(ammoSlot, Inventory.SlotType.Inventory, 1);
            } else {
                player.sendYellMessage("No Ammo!");
            }
        });
        cannon.setSecondaryAction(Animation.M14Reload, 0.1f, (player, collision) -> {
            Item item = player.getEquippedItem();
            if (item != null && item.getAttribute() instanceof Item.CustomItemAttribute) {
                Item.CustomItemAttribute cannonItem = (Item.CustomItemAttribute)item.getAttribute();
                if (cannonItem.getAttribute("mod.allielexie.meloncannon.ammotype").equals("watermelon")) {
                    cannonItem.setAttribute("mod.allielexie.meloncannon.ammotype", "firemelon");
                    player.sendYellMessage("Melon Cannon Ammo : Firemelons");
                } else {
                    cannonItem.setAttribute("mod.allielexie.meloncannon.ammotype", "watermelon");
                    player.sendYellMessage("Melon Cannon Ammo: Watermelons");
                }
            }
        });
        this.getServer().registerCustomItem(cannon);
        CustomRecipe cannonRecipe = new CustomRecipe("mod.allielexie.meloncannon.meloncannon", CustomRecipe.Type.CustomItem, 0, "Weapons", new String[]{"workbench"});
        cannonRecipe.setPreviewSize(cannon.getModelSize() * 0.75f);
        cannonRecipe.setIngredients(new String[]{"32x ironplate", "32x goldplate"});
        cannonRecipe.setLocalizedNames(cannon.getLocalizedNames());
        cannonRecipe.setLocalizedDescriptions(new String[]{"Shoots Water or Fire Melons!"});
        this.getServer().registerCustomRecipe(cannonRecipe);
        CustomItem firemelon = new CustomItem("mod.allielexie.meloncannon.firemelon", "firemelon");
        ModelInformation fireMelonModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/melon.obj");
        ImageInformation fireMelonTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/fmtexture.png");
        ImageInformation fireMelonIcon = new ImageInformation(String.valueOf(this.getPath()) + "/assets/fmicon.png");
        firemelon.setModel(fireMelonModel, fireMelonTexture, 0.5f);
        firemelon.setIcon(fireMelonIcon);
        firemelon.setMaxStacksize(1);
        firemelon.setPlayerIdleAnimation(null);
        firemelon.setHand(CustomItem.Hand.None);
        firemelon.setLocalizedNames(new String[]{"en=Firemelon", "de=FeuerMelone"});
        this.getServer().registerCustomItem(firemelon);
        CustomRecipe melonRecipe = new CustomRecipe("mod.allielexie.meloncannon.firemelon", CustomRecipe.Type.CustomItem, 0, "Weapons", new String[]{"workbench"});
        melonRecipe.setPreviewSize(firemelon.getModelSize());
        if (this.fireMelonType == 4) {
            melonRecipe.setIngredients(new String[]{"1x watermelon", "1x fireworkrocket"});
        } else {
            melonRecipe.setIngredients(new String[]{"1x watermelon", "1x tnt"});
        }
        melonRecipe.setLocalizedNames(firemelon.getLocalizedNames());
        melonRecipe.setLocalizedDescriptions(new String[]{"A melon, but with a surprise inside!"});
        this.getServer().registerCustomRecipe(melonRecipe);
        this.registerEventListener(this);
    }

    @EventMethod
    public void onPlayerChangeItem(PlayerChangeEquippedItemEvent event) {
        Item.CustomItemAttribute citem;
        Item item = event.getItem();
        if (item != null && item.getAttribute() instanceof Item.CustomItemAttribute && (citem = (Item.CustomItemAttribute)item.getAttribute()).getUUID().equals("mod.allielexie.meloncannon.meloncannon") && !citem.hasAttribute("mod.allielexie.meloncannon.ammotype")) {
            citem.setAttribute("mod.allielexie.meloncannon.ammotype", "watermelon");
        }
    }

    private void launchMelon(Player player, String type) {
        Vector3f weaponPosition = new Vector3f(-0.25f, 0.0f, 1.0f);
        Vector3f shootingDirection = new Vector3f(0.0f, 0.15f, 0.85f).normalizeLocal();
        player.getRotation().multLocal(weaponPosition);
        player.getRotation().multLocal(shootingDirection);
        weaponPosition.addLocal(player.getPosition()).addLocal(0.0f, 1.35f, 0.0f);
        Quaternion ammoRotation = new Quaternion().lookAt(shootingDirection);
        if (type.equals("watermelon")) {
            ammoRotation.multLocal(new Quaternion().fromAngles(0.0f, 1.5707964f, 0.0f));
            WorldItem melon = this.tossMelon(weaponPosition, ammoRotation, shootingDirection);
            this.attachDespawnTimer(melon, 15.0f);
        } else if (type.equals("firemelon")) {
            player.raycast(this.COLLISION_BITMASK, result -> {
                if (result != null && result.hasCollision()) {
                    ModelInformation melonModel = new ModelInformation(String.valueOf(this.getPath()) + "/assets/melon.obj");
                    ImageInformation melonTexture = new ImageInformation(String.valueOf(this.getPath()) + "/assets/fmtexture.png");
                    World3DModel melon = new World3DModel(melonModel, melonTexture, weaponPosition, ammoRotation);
                    melon.setListenForCollisions(true);
                    melon.setScale(0.3f);
                    for (Player p : this.getServer().getAllPlayers()) {
                        p.addWorldElement((WorldElement)melon);
                    }
                    Vector3f impact = result.getCollisionPoint();
                    float dist = impact.distance(weaponPosition);
                    float speed = 32.0f;
                    float time = dist / speed;
                    melon.moveTo(impact, speed);
                    this.attachExplosionTimer(melon, time);
                } else {
                    WorldItem melon = this.tossMelon(weaponPosition, ammoRotation, shootingDirection);
                    this.attachExplosionTimer(melon, 5.0f);
                }
            });
        } else {
            throw new RuntimeException("Unknown Ammo Type");
        }
        player.playGameSound("hit_pumpkin", weaponPosition);
    }

    private WorldItem tossMelon(Vector3f position, Quaternion ammoRotation, Vector3f shootingDirection) {
        Definitions.ItemDefinition itemDef = Definitions.getItemDefinition((String)"watermelon");
        WorldItem projectile = this.getWorld().spawnItem(itemDef.getID(), 0, 1, position, ammoRotation, true);
        projectile.applyPhysicalImpulse(shootingDirection.mult(32.0f));
        return projectile;
    }

    private void attachExplosionTimer(World3DModel melon, float time) {
        Timer timer = new Timer(time, 0.0f, 0, () -> {
            Vector3f exPoint = melon.getPosition();
            melon.destroy();
            this.explodeMelon(exPoint);
        });
        timer.start();
    }

    private void attachExplosionTimer(WorldItem melon, float time) {
        Timer timer = new Timer(time, 0.0f, 0, () -> {
            Vector3f exPoint = melon.getPosition();
            melon.destroy();
            this.explodeMelon(exPoint);
        });
        timer.start();
    }

    private void attachDespawnTimer(WorldItem melon, float time) {
        Timer timer = new Timer(time, 0.0f, 0, () -> melon.destroy());
        timer.start();
    }

    private void explodeMelon(Vector3f pos) {
        if (this.fireMelonType == 4) {
            this.getWorld().triggerFirework(pos, 0.5f + (float)Math.random(), 0x22FF22AA, -872415062, 0x2200FF, true);
        } else {
            this.getWorld().triggerExplosion(pos, this.fireMelonType == 1, true);
        }
        if (this.fireMelonType == 2) {
            float dist;
            for (Player p : this.getServer().getAllPlayers()) {
                dist = p.getPosition().distance(pos);
                if (!(dist < this.fireMelonRadius)) continue;
                float armor = p.getArmor();
                float maxArmor = p.getMaxArmor();
                float damageFactor = 1.0f - armor / maxArmor;
                float distFactor = 1.0f - dist / this.fireMelonRadius;
                int damage = Math.round(this.fireMelonDamage * damageFactor * distFactor);
                p.setHealth(p.getHealth() - damage);
            }
            for (Npc n : this.getWorld().getAllNpcs(null)) {
                dist = n.getPosition().distance(pos);
                if (!(dist < this.fireMelonRadius)) continue;
                n.setHealth(n.getHealth() - Math.round(this.fireMelonDamage * (dist / this.fireMelonRadius)));
                n.setAlerted(true);
            }
        }
    }

    private void loadPreferences(String fileName) {
        boolean readError = false;
        this.fireMelonType = 0;
        this.fireMelonRadius = 0.0f;
        this.fireMelonDamage = 0.0f;
        try {
            File f = new File(fileName);
            Scanner sc = new Scanner(f);
            while (sc.hasNextLine()) {
                String line = sc.nextLine();
                line = this.stripComment(line);
                if ((line = line.trim()).equals("firemelonsHard")) {
                    this.fireMelonType = 1;
                }
                if (line.equals("firemelonsSoft")) {
                    this.fireMelonType = 2;
                }
                if (line.equals("firemelonsShow")) {
                    this.fireMelonType = 3;
                }
                if (line.equals("firemelonsFireworks")) {
                    this.fireMelonType = 4;
                }
                if (line.contains("softmelonRadius")) {
                    try {
                        this.fireMelonRadius = Integer.decode(line.split("=")[1]).intValue();
                    }
                    catch (Exception e) {
                        System.out.println("Melon Cannon: Error reading prefs.txt line: " + line);
                        readError = true;
                    }
                }
                if (!line.contains("softmelonDamage")) continue;
                try {
                    this.fireMelonDamage = Integer.decode(line.split("=")[1]).intValue();
                }
                catch (Exception e) {
                    System.out.println("Melon Cannon: Error readint prefs.txt line: " + line);
                    readError = true;
                }
            }
            sc.close();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                System.out.println("Melon Cannon: prefs.txt file not found!");
            } else {
                e.printStackTrace();
            }
            readError = true;
        }
        if (readError) {
            System.out.println("Melon Cannon: Error loading preferences - setting missing preferences to defaults");
            if (this.fireMelonType == 0) {
                this.fireMelonType = 3;
            }
            if (this.fireMelonRadius == 0.0f) {
                this.fireMelonRadius = 10.0f;
            }
            if (this.fireMelonDamage == 0.0f) {
                this.fireMelonDamage = 100.0f;
            }
        } else {
            System.out.println("Melon Cannon: prefs.txt loaded successfully");
        }
    }

    private String stripComment(String cmd) {
        if (cmd.contains("#")) {
            cmd = cmd.substring(0, cmd.indexOf("#"));
        }
        return cmd;
    }
}

