/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.staticmodels;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import net.risingworld.api.Plugin;
import net.risingworld.api.Timer;
import net.risingworld.api.database.Database;
import net.risingworld.api.events.EventMethod;
import net.risingworld.api.events.Listener;
import net.risingworld.api.events.player.PlayerChangeEquippedItemEvent;
import net.risingworld.api.events.player.PlayerConnectEvent;
import net.risingworld.api.events.player.PlayerCraftItemEvent;
import net.risingworld.api.events.player.PlayerElementHitEvent;
import net.risingworld.api.events.player.PlayerKeyEvent;
import net.risingworld.api.events.player.gui.PlayerSelectFileEvent;
import net.risingworld.api.gui.Font;
import net.risingworld.api.gui.GuiElement;
import net.risingworld.api.gui.GuiFileBrowser;
import net.risingworld.api.gui.GuiLabel;
import net.risingworld.api.gui.GuiPanel;
import net.risingworld.api.gui.PivotPosition;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.BoundingInformation;
import net.risingworld.api.utils.CollisionShape;
import net.risingworld.api.utils.CollisionType;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Utils;
import net.risingworld.api.utils.Vector3f;
import net.risingworld.api.worldelements.World3DModel;
import net.risingworld.api.worldelements.WorldElement;

public class StaticModelLoader
extends Plugin
implements Listener {
    private Database database;
    private ArrayList<World3DModel> world3DModels = new ArrayList();
    private final String ATTRIBUTE_TIMER = "example.staticmodelloader.timer";
    private final String ATTRIBUTE_MODELPREVIEW = "example.staticmodelloader.modelpreview";
    private final String ATTRIBUTE_STRENGTH = "example.staticmodelloader.strength";
    private final String ATTRIBUTE_FILEBROWSER = "example.staticmodelloader.player.filebrowser";
    private final String ATTRIBUTE_FILEBROWSER_BACKGROUND = "example.staticmodelloader.player.filebrowser.background";
    private final String ATTRIBUTE_FILEBROWSER_HEADLINE = "example.staticmodelloader.player.filebrowser.header";
    private final String ATTRIBUTE_PENDING_MODEL = "example.staticmodelloader.player.upload.pendingmodel";
    private final String ATTRIBUTE_PENDING_TEXTURE = "example.staticmodelloader.player.upload.pendingtexture";
    public final String CUSTOMITEM_UUID = "net.risingworld.api.example.staticmodels.3dmodelblueprint";
    private final int DEFAULT_ELEMENT_STRENGTH = 500;
    private final int COLLISION_BITMASK = CollisionType.getBitmask((int[])new int[]{1, 8, 16, 128});

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onEnable() {
        this.database = this.getSQLiteConnection(this.getWorld().getWorldFolder() + "/WorldModels.db");
        this.database.execute("CREATE TABLE IF NOT EXISTS `models` (`ID` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `model` VARCHAR(255), `texture` VARCHAR(255), `playeruid` BIGINT, `position` VARCHAR(255), `rotation` VARCHAR(255), `size` REAL, `collision` TINYINT)");
        try (ResultSet result = this.database.executeQuery("SELECT * FROM `models`");){
            while (result.next()) {
                try {
                    String path = this.getPath() + "/Models/" + result.getLong("playeruid") + "/";
                    File modelFile = new File(path + result.getString("model"));
                    File imageFile = new File(path + result.getString("texture"));
                    if (!modelFile.exists() || !imageFile.exists()) continue;
                    ModelInformation model = new ModelInformation(path + result.getString("model"));
                    ImageInformation texture = new ImageInformation(path + result.getString("texture"));
                    Vector3f position = new Vector3f().fromString(result.getString("position"));
                    Quaternion rotation = new Quaternion().fromString(result.getString("rotation"));
                    World3DModel world3DModel = this.createNewWorld3DModel(model, texture, result.getFloat("size"), position, rotation, result.getBoolean("collision"));
                    this.world3DModels.add(world3DModel);
                }
                catch (Exception path) {}
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        CustomItem item = new CustomItem("net.risingworld.api.example.staticmodels.3dmodelblueprint", "modelblueprint");
        ModelInformation model = new ModelInformation((Plugin)this, "/resources/item.j3o");
        ImageInformation texture = new ImageInformation((Plugin)this, "/resources/item_texture.dds");
        ImageInformation icon = new ImageInformation((Plugin)this, "/resources/item_icon.dds");
        item.setModel(model, texture, 0.01f);
        item.setIcon(icon);
        item.setHand(CustomItem.Hand.None);
        item.setMaxStacksize(1);
        item.setPlayerIdleAnimation(Animation.Idle1);
        item.setLocalizedNames(new String[]{"en=3D-Model Blueprint", "de=3D-Modell Bauplan"});
        item.setSecondaryAction(Animation.Idle1, 0.0f, (player, collision) -> {
            if (player.hasAttribute("example.staticmodelloader.modelpreview")) {
                this.placeElement(player);
            } else {
                this.showUploadDialog(player);
            }
        });
        this.getServer().registerCustomItem(item);
        CustomRecipe recipe = new CustomRecipe("net.risingworld.api.example.staticmodels.3dmodelblueprint", CustomRecipe.Type.CustomItem, 0, "Miscellaneous", new String[]{"workbench"});
        recipe.setPreviewSize(0.0225f);
        recipe.setIngredients(new String[]{"16x goldingot"});
        recipe.setLocalizedNames(item.getLocalizedNames());
        recipe.setLocalizedDescriptions(new String[]{"en=This item allows you to upload \na custom 3D model from your hard drive \nand place it in the world!", "de=Erm\u00f6glicht dir, ein 3D Modell \nvon deiner Festplatte hochzuladen und \nin der Welt zu platzieren!"});
        this.getServer().registerCustomRecipe(recipe);
        this.registerEventListener(this);
    }

    private World3DModel createNewWorld3DModel(ModelInformation model, ImageInformation texture, float size, Vector3f position, Quaternion rotation, boolean collision) {
        World3DModel world3DModel = new World3DModel(model, texture, position, rotation);
        world3DModel.setScale(size);
        world3DModel.setLightingEnabled(true);
        world3DModel.setNpcCollisionEnabled(collision);
        world3DModel.setHittable(collision);
        world3DModel.setCollisionShape((CollisionShape)(collision ? CollisionShape.createHullCollisionShape() : null));
        world3DModel.setAttribute("example.staticmodelloader.strength", (Object)500);
        return world3DModel;
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.close();
        }
    }

    @EventMethod
    public void onPlayerConnect(PlayerConnectEvent event) {
        Player player = event.getPlayer();
        player.setListenForKeyInput(true);
        player.registerKeys(new int[]{200, 208, 203, 205, 201, 209, 78, 74, 1});
        for (World3DModel model : this.world3DModels) {
            player.addWorldElement((WorldElement)model);
        }
        GuiPanel background = new GuiPanel(0.5f, 0.5f, true, 1000.0f, 650.0f, false);
        background.setPivot(PivotPosition.Center);
        background.setColor(0.0f, 0.0f, 0.0f, 0.5f);
        background.setBorderThickness(10.0f, false);
        background.setBorderColor(0.0f, 0.0f, 0.0f, 0.7f);
        background.setVisible(false);
        player.addGuiElement((GuiElement)background);
        player.setAttribute("example.staticmodelloader.player.filebrowser.background", (Object)background);
        GuiLabel header = new GuiLabel(0.5f, 1.1f, true);
        header.setPivot(PivotPosition.Center);
        header.setFontSize(48);
        header.setFont(Font.Default_Bold);
        header.setFontColor(1.0f, 1.0f, 1.0f, 1.0f);
        background.addChild((GuiElement)header);
        player.addGuiElement((GuiElement)header);
        player.setAttribute("example.staticmodelloader.player.filebrowser.header", (Object)header);
        GuiFileBrowser fb = new GuiFileBrowser(14, 0.5f, 0.5f, true, 950.0f, 600.0f, false);
        fb.setPivot(PivotPosition.Center);
        fb.setPreviewImageEnabled(false);
        fb.setPreviewImageDimension(256);
        fb.setPreviewImagePosition(800.0f, 350.0f, false);
        background.addChild((GuiElement)fb);
        player.addGuiElement((GuiElement)fb);
        player.setAttribute("example.staticmodelloader.player.filebrowser", (Object)fb);
    }

    @EventMethod
    public void onPlayerChangeItem(PlayerChangeEquippedItemEvent event) {
        Player player = event.getPlayer();
        if (player.hasAttribute("example.staticmodelloader.timer") && player.hasAttribute("example.staticmodelloader.modelpreview")) {
            this.abortPlacement(player);
        }
    }

    @EventMethod
    public void onPlayerSelectFileForUpload(PlayerSelectFileEvent event) {
        Player player = event.getPlayer();
        this.hideUploadDialog(player);
        String filename = event.getFilename();
        File targetFile = new File(this.getPath() + "/Models/" + player.getUID() + "/" + filename);
        if (!targetFile.exists()) {
            event.requestFileUpload(this.getPath() + "/Models/" + player.getUID(), file -> this.finalizeUpload(player, (File)file));
        } else {
            this.finalizeUpload(player, targetFile);
        }
    }

    private void showUploadDialog(Player player) {
        if (player.hasAttribute("example.staticmodelloader.player.upload.pendingmodel")) {
            if (!player.hasAttribute("example.staticmodelloader.player.upload.pendingtexture")) {
                GuiLabel header = (GuiLabel)player.getAttribute("example.staticmodelloader.player.filebrowser.header");
                header.setText("-TEXTURE- SELECTION");
                GuiFileBrowser fb = (GuiFileBrowser)player.getAttribute("example.staticmodelloader.player.filebrowser");
                fb.setFileExtensionFilter(new String[]{"jpg", "png", "dds"});
                fb.setPreviewImageEnabled(true);
                GuiPanel background = (GuiPanel)player.getAttribute("example.staticmodelloader.player.filebrowser.background");
                background.setVisible(true);
                player.setMouseCursorVisible(true);
            }
        } else {
            GuiLabel header = (GuiLabel)player.getAttribute("example.staticmodelloader.player.filebrowser.header");
            header.setText("-MODEL- SELECTION");
            GuiFileBrowser fb = (GuiFileBrowser)player.getAttribute("example.staticmodelloader.player.filebrowser");
            fb.setFileExtensionFilter(new String[]{"obj", "fbx", "blend", "j3o"});
            fb.setPreviewImageEnabled(false);
            GuiPanel background = (GuiPanel)player.getAttribute("example.staticmodelloader.player.filebrowser.background");
            background.setVisible(true);
            player.setMouseCursorVisible(true);
        }
    }

    private void hideUploadDialog(Player player) {
        GuiPanel background = (GuiPanel)player.getAttribute("example.staticmodelloader.player.filebrowser.background");
        background.setVisible(false);
        player.setMouseCursorVisible(false);
    }

    private void finalizeUpload(Player player, File file) {
        try {
            String filename = file.getName().toLowerCase();
            if (filename.endsWith("obj") || filename.endsWith("fbx") || filename.endsWith("j3o") || filename.endsWith("blend")) {
                ModelInformation model = new ModelInformation(file);
                player.setAttribute("example.staticmodelloader.player.upload.pendingmodel", (Object)model);
            } else if (filename.endsWith("jpg") || filename.endsWith("png") || filename.endsWith("dds")) {
                ImageInformation image = new ImageInformation(file);
                player.setAttribute("example.staticmodelloader.player.upload.pendingtexture", (Object)image);
            }
            if (player.hasAttribute("example.staticmodelloader.player.upload.pendingmodel") && player.hasAttribute("example.staticmodelloader.player.upload.pendingtexture")) {
                this.onUploadCompleted(player);
                this.hideUploadDialog(player);
            } else {
                this.showUploadDialog(player);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            player.deleteAttribute("example.staticmodelloader.player.upload.pendingmodel");
            player.deleteAttribute("example.staticmodelloader.player.upload.pendingtexture");
            this.hideUploadDialog(player);
        }
    }

    private void onUploadCompleted(Player player) {
        ModelInformation model = (ModelInformation)player.getAttribute("example.staticmodelloader.player.upload.pendingmodel");
        ImageInformation texture = (ImageInformation)player.getAttribute("example.staticmodelloader.player.upload.pendingtexture");
        player.deleteAttribute("example.staticmodelloader.player.upload.pendingmodel");
        player.deleteAttribute("example.staticmodelloader.player.upload.pendingtexture");
        Vector3f position = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)2.0f);
        Quaternion rotation = new Quaternion();
        World3DModel world3DModel = this.createNewWorld3DModel(model, texture, 1.0f, position, rotation, false);
        world3DModel.setAlpha(0.9f);
        world3DModel.setTransparencyEnabled(true);
        player.addWorldElement((WorldElement)world3DModel);
        BoundingInformation boundingInfo = model.getBoundingInformation();
        if (boundingInfo != null) {
            float max;
            float x = boundingInfo.getXExtent();
            float y = boundingInfo.getYExtent();
            float z = boundingInfo.getZExtent();
            if (x > y) {
                max = x > z ? x : z;
            } else {
                float f = max = y > z ? y : z;
            }
            if (max > 0.0f) {
                world3DModel.setScale(2.0f / max);
            }
        }
        Timer timer = new Timer(0.05f, 0.5f, -1, () -> player.raycast(this.COLLISION_BITMASK, result -> {
            Vector3f targetPosition;
            if (result != null && result.hasCollision() && result.getDistance() <= 6.0f) {
                targetPosition = result.getCollisionPoint();
            } else {
                targetPosition = Utils.VectorUtils.getXYZInFrontOfPlayer((Player)player, (float)6.0f);
                targetPosition.y = world3DModel.getPosition().y;
            }
            world3DModel.moveTo(targetPosition, 9.0f);
        }));
        timer.start();
        player.setAttribute("example.staticmodelloader.timer", (Object)timer);
        player.setAttribute("example.staticmodelloader.modelpreview", (Object)world3DModel);
    }

    private void placeElement(Player player) {
        Timer timer = (Timer)player.getAttribute("example.staticmodelloader.timer");
        World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
        timer.kill();
        preview.setAlpha(1.0f);
        preview.setTransparencyEnabled(false);
        preview.setNpcCollisionEnabled(true);
        preview.setHittable(true);
        preview.setCollisionShape(CollisionShape.createHullCollisionShape());
        for (Player p : this.getServer().getAllPlayers()) {
            if (p.getID() != player.getID()) {
                p.addWorldElement((WorldElement)preview);
            }
            p.playGameSound("place_block", preview.getPosition());
        }
        this.world3DModels.add(preview);
        player.showStatusMessage("Model '" + preview.getModel().getFilename() + "' placed!", 2);
        String modelFilename = preview.getModel().getFilename() + "." + preview.getModel().getExtension();
        String textureFilename = preview.getTexture().getFilename() + "." + preview.getTexture().getExtension();
        this.database.executeUpdate("INSERT INTO `models` (`model`, `texture`, `playeruid`, `position`, `rotation`, `size`, `collision`) VALUES ('" + modelFilename + "', '" + textureFilename + "', '" + player.getUID() + "', '" + preview.getPosition().toString() + "', '" + preview.getRotation().toString() + "', '" + preview.getScale().y + "', '" + (byte)(preview.hasCollisionShape() ? 1 : 0) + "')");
        player.deleteAttribute("example.staticmodelloader.timer");
        player.deleteAttribute("example.staticmodelloader.modelpreview");
    }

    private void abortPlacement(Player player) {
        Timer timer = (Timer)player.getAttribute("example.staticmodelloader.timer");
        World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
        timer.kill();
        player.removeWorldElement((WorldElement)preview);
        player.deleteAttribute("example.staticmodelloader.timer");
        player.deleteAttribute("example.staticmodelloader.modelpreview");
    }

    @EventMethod
    public void onPlayerKeyInput(PlayerKeyEvent event) {
        Player player = event.getPlayer();
        if (event.isPressed()) {
            if (player.hasAttribute("example.staticmodelloader.timer") && player.hasAttribute("example.staticmodelloader.modelpreview")) {
                float ROTATION_STEP = 0.19634955f;
                if (event.getKeyCode() == 203) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    Quaternion rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.19634955f, 0.0f));
                    preview.setRotation(rot);
                } else if (event.getKeyCode() == 205) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    Quaternion rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, -0.19634955f, 0.0f));
                    preview.setRotation(rot);
                } else if (event.getKeyCode() == 200) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    Quaternion rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.19634955f, 0.0f, 0.0f));
                    preview.setRotation(rot);
                } else if (event.getKeyCode() == 208) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    Quaternion rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(-0.19634955f, 0.0f, 0.0f));
                    preview.setRotation(rot);
                } else if (event.getKeyCode() == 201) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    Quaternion rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, 0.19634955f));
                    preview.setRotation(rot);
                } else if (event.getKeyCode() == 209) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    Quaternion rot = new Quaternion(preview.getRotation()).multLocal(new Quaternion().fromAngles(0.0f, 0.0f, -0.19634955f));
                    preview.setRotation(rot);
                } else if (event.getKeyCode() == 78) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    preview.setScale(preview.getScale().x * 1.1f);
                } else if (event.getKeyCode() == 74) {
                    World3DModel preview = (World3DModel)player.getAttribute("example.staticmodelloader.modelpreview");
                    preview.setScale(preview.getScale().x * 0.9f);
                } else if (event.getKeyCode() == 1) {
                    this.abortPlacement(player);
                }
            } else if (event.getKeyCode() == 1) {
                this.hideUploadDialog(player);
            }
        }
    }

    @EventMethod
    public void onPlayerHitWorldElement(PlayerElementHitEvent event) {
        WorldElement model;
        Definitions.HitDamageDefinition damageDef;
        Player player = event.getPlayer();
        Item equippedItem = player.getEquippedItem();
        if (equippedItem != null && (damageDef = Definitions.getHitDamageDefinition((String)equippedItem.getName())) != null && damageDef.getObjectDamage() > 0 && (model = event.getWorldElement()).hasAttribute("example.staticmodelloader.strength")) {
            int strength = (Integer)model.getAttribute("example.staticmodelloader.strength");
            model.setAttribute("example.staticmodelloader.strength", (Object)(strength -= damageDef.getObjectDamage()));
            if (strength <= 0) {
                for (Player p : this.getServer().getAllPlayers()) {
                    p.removeWorldElement(model);
                    p.playGameSound("item_break_stone_medium", model.getPosition());
                }
                this.database.executeUpdate("DELETE FROM `models` WHERE `position` = '" + model.getPosition().toString() + "'");
                this.world3DModels.remove((World3DModel)model);
            }
        }
    }

    @EventMethod
    public void onItemCraft(PlayerCraftItemEvent event) {
        Item.CustomItemAttribute attribute;
        Player player = event.getPlayer();
        Item item = event.getItem();
        if (item != null && item.getAttribute() instanceof Item.CustomItemAttribute && (attribute = (Item.CustomItemAttribute)item.getAttribute()).getUUID().equals("net.risingworld.api.example.staticmodels.3dmodelblueprint") && !player.isAdmin()) {
            event.setCancelled(true);
            player.showStatusMessage("You are not allowed to craft this item!", 4);
        }
    }
}

