/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.customitem.gun;

import net.risingworld.api.Plugin;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.WorldItem;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.Definitions;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Quaternion;
import net.risingworld.api.utils.Vector3f;

public class PotatoCannon
extends Plugin {
    public final String GUN_UUID = "net.risingworld.api.example.customitem.potatocannon";

    public void onEnable() {
        CustomItem item = new CustomItem("net.risingworld.api.example.customitem.potatocannon", "potatocannon");
        ModelInformation model = new ModelInformation(this.getPath() + "/assets/potatocannon.obj");
        ImageInformation texture = new ImageInformation(this.getPath() + "/assets/potatocannon.dds");
        ImageInformation icon = new ImageInformation(this.getPath() + "/assets/potatocannon_icon.png");
        item.setModel(model, texture, 2.15f);
        item.setIcon(icon);
        item.setMaxStacksize(1);
        item.setPlayerIdleAnimation(Animation.M14Aim);
        item.setItemPosition(-0.2210794f, 0.09963215f, 0.30302262f);
        item.setItemRotation(0.23054627f, -0.43278024f, -0.5497708f, 0.6762362f);
        item.setFPBodyPosition(-0.39670023f, -0.5547194f, 0.261761f);
        item.setFPBodyRotation(-0.04698471f, 0.018427098f, -0.066861615f, 0.99649376f);
        item.setLocalizedNames(new String[]{"en=Potato Cannon", "de=Kartoffelkanone"});
        item.setPrimaryAction(Animation.M14Fire, 0.1f, (player, collision) -> this.shootProjectile(player));
        this.getServer().registerCustomItem(item);
        CustomRecipe recipe = new CustomRecipe("net.risingworld.api.example.customitem.potatocannon", CustomRecipe.Type.CustomItem, 0, "Miscellaneous", new String[]{"workbench"});
        recipe.setPreviewSize(item.getModelSize() * 0.9f);
        recipe.setIngredients(new String[]{"16x ironplate", "16x goldplate"});
        recipe.setLocalizedNames(item.getLocalizedNames());
        recipe.setLocalizedDescriptions(new String[]{"..."});
        this.getServer().registerCustomRecipe(recipe);
    }

    public void onDisable() {
    }

    private void shootProjectile(Player player) {
        Vector3f weaponPosition = new Vector3f(-0.25f, 0.0f, 1.0f);
        Vector3f shootingDirection = new Vector3f(0.0f, 0.15f, 0.85f).normalizeLocal();
        player.getRotation().multLocal(weaponPosition);
        player.getRotation().multLocal(shootingDirection);
        weaponPosition.addLocal(player.getPosition()).addLocal(0.0f, 1.35f, 0.0f);
        Quaternion potatoRotation = new Quaternion().lookAt(shootingDirection);
        potatoRotation.multLocal(new Quaternion().fromAngles(0.0f, 1.5707964f, 0.0f));
        Definitions.ItemDefinition itemDef = Definitions.getItemDefinition((String)"potato");
        WorldItem projectile = this.getWorld().spawnItem(itemDef.getID(), 0, 1, weaponPosition, potatoRotation, true);
        projectile.applyPhysicalImpulse(shootingDirection.mult(15.0f));
        player.playGameSound("hit_pumpkin", weaponPosition);
    }
}

