/*
 * Decompiled with CFR 0.152.
 */
package net.risingworld.api.example.backpack;

import net.risingworld.api.Plugin;
import net.risingworld.api.objects.Item;
import net.risingworld.api.objects.Player;
import net.risingworld.api.objects.Storage;
import net.risingworld.api.objects.custom.CustomItem;
import net.risingworld.api.objects.custom.CustomRecipe;
import net.risingworld.api.utils.Animation;
import net.risingworld.api.utils.ImageInformation;
import net.risingworld.api.utils.ModelInformation;
import net.risingworld.api.utils.Utils;

public class Backpack
extends Plugin {
    public final String BACKPACK_UUID = "net.risingworld.api.example.backpacks.custombackpack";
    public final int BACKPACK_SLOTS = 48;

    public void onEnable() {
        CustomItem item = new CustomItem("net.risingworld.api.example.backpacks.custombackpack", "backpack");
        ModelInformation model = new ModelInformation(this.getPath() + "/assets/backpack.obj");
        ImageInformation texture = new ImageInformation(this.getPath() + "/assets/backpack.dds");
        ImageInformation icon = new ImageInformation(this.getPath() + "/assets/backpack_icon.png");
        item.setModel(model, texture, 2.46f);
        item.setIcon(icon);
        item.setMaxStacksize(1);
        item.setPlayerIdleAnimation(Animation.HoldPelt1);
        item.setItemPosition(-0.1937611f, -0.32028213f, 0.08882258f);
        item.setItemRotation(0.5116603f, -0.7077507f, -0.2687852f, 0.406277f);
        item.setFPBodyPosition(-0.8087011f, -0.43947953f, 0.76546186f);
        item.setFPBodyRotation(-0.1111441f, -0.033417337f, -0.083279766f, 0.9897447f);
        item.setLocalizedNames(new String[]{"en=Backpack", "de=Rucksack"});
        item.setSecondaryAction(Animation.HoldPelt1, 0.0f, (player, collision) -> this.openBackpack(player, player.getEquippedItem()));
        item.setVariation(1, new ImageInformation(this.getPath() + "/assets/backpack_red.dds"), new ImageInformation(this.getPath() + "/assets/backpack_red_icon.png"));
        item.setVariation(2, new ImageInformation(this.getPath() + "/assets/backpack_green.dds"), new ImageInformation(this.getPath() + "/assets/backpack_green_icon.png"));
        item.setVariation(3, new ImageInformation(this.getPath() + "/assets/backpack_yellow.dds"), new ImageInformation(this.getPath() + "/assets/backpack_yellow_icon.png"));
        item.setVariation(4, new ImageInformation(this.getPath() + "/assets/backpack_purple.dds"), new ImageInformation(this.getPath() + "/assets/backpack_purple_icon.png"));
        this.getServer().registerCustomItem(item);
        CustomRecipe recipe = new CustomRecipe("net.risingworld.api.example.backpacks.custombackpack", CustomRecipe.Type.CustomItem, 0, "Backpacks", new String[]{"workbench"});
        recipe.setPreviewSize(2.75f);
        recipe.setIngredients(new String[]{"16x stick", "16x cloth", "8x threadreel"});
        recipe.setLocalizedNames(item.getLocalizedNames());
        recipe.setLocalizedCategories(new String[]{"en=Backpacks", "de=Rucks\u00e4cke"});
        recipe.setLocalizedDescriptions(new String[]{"en=A basic backpack. \nHas room for 48 items.", "de=Ein einfacher Rucksack. Bietet Platz f\u00fcr 48 Items."});
        this.getServer().registerCustomRecipe(recipe);
    }

    public void onDisable() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void openBackpack(Player player, Item backpack) {
        if (backpack == null) {
            return;
        }
        if (backpack.getAttribute() instanceof Item.CustomItemAttribute) {
            int storageID;
            Item.CustomItemAttribute attribute = (Item.CustomItemAttribute)backpack.getAttribute();
            if (attribute.hasAttribute("backpack_id")) {
                String backpack_id = attribute.getAttribute("backpack_id");
                if (!Utils.StringUtils.isInteger((String)backpack_id)) {
                    player.showStatusMessage("This backpack is broken!", 2);
                    return;
                }
                storageID = Integer.parseInt(backpack_id);
            } else {
                Storage storage = this.getWorld().createNewStorage(48);
                attribute.setAttribute("backpack_id", String.valueOf(storage.getID()));
                storageID = storage.getID();
            }
            player.showStorage(storageID);
            player.playGameSound("donkey_panniers");
        }
    }
}

