/*
 * Decompiled with CFR 0.152.
 */
package de.omegazirkel.risingworld.tools.db;

import de.omegazirkel.risingworld.tools.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import net.risingworld.api.Plugin;
import net.risingworld.api.database.Database;

public class SQLite {
    private Plugin plugin = null;
    private Logger log = null;
    private Database db = null;

    public SQLite(Plugin plugin) {
        this.plugin = plugin;
        this.log = new Logger("[OZ.SQLite]", 0);
        this.initDatabase();
    }

    public SQLite(Plugin plugin, int logLevel) {
        this.plugin = plugin;
        this.log = new Logger("[OZ.SQLite]", logLevel);
        this.initDatabase();
    }

    private void initDatabase() {
        if (this.db == null) {
            String path = String.valueOf(this.plugin.getPath()) + "/" + this.plugin.getWorld().getName() + ".db";
            this.db = this.plugin.getSQLiteConnection(path);
            this.log.out("Connected to " + path, 0);
        }
    }

    public ResultSet executeQuery(String query) throws SQLException {
        this.initDatabase();
        return this.db.executeQuery(query);
    }

    public void executeUpdate(String query) {
        this.initDatabase();
        this.db.executeUpdate(query);
    }

    public void execute(String query) {
        this.initDatabase();
        this.db.execute(query);
    }

    public void destroy() {
        this.db.close();
        this.db = null;
    }
}

